/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.border;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.Icon;
import javax.swing.border.MatteBorder;

public class MatteBorderExt
extends MatteBorder {
    protected Icon[] tileIcons = null;
    private Icon defaultIcon = null;

    public MatteBorderExt(int top, int left, int bottom, int right, Icon[] tileIcons) {
        super(top, left, bottom, right, tileIcons == null || tileIcons.length == 0 ? null : tileIcons[0]);
        this.tileIcons = tileIcons;
    }

    public MatteBorderExt(int top, int left, int bottom, int right, Color matteColor) {
        super(top, left, bottom, right, matteColor);
    }

    public MatteBorderExt(Insets borderInsets, Color matteColor) {
        super(borderInsets, matteColor);
    }

    public MatteBorderExt(int top, int left, int bottom, int right, Icon tileIcon) {
        super(top, left, bottom, right, tileIcon);
    }

    public MatteBorderExt(Insets borderInsets, Icon tileIcon) {
        super(borderInsets, tileIcon);
    }

    public MatteBorderExt(Icon tileIcon) {
        super(tileIcon);
    }

    public Icon[] getTileIcons() {
        return this.tileIcons;
    }

    @Override
    public void paintBorder(Component c2, Graphics g2, int x2, int y2, int width, int height) {
        if (this.tileIcons == null || this.tileIcons.length < 2) {
            super.paintBorder(c2, g2, x2, y2, width, height);
            return;
        }
        Insets insets = this.getBorderInsets(c2);
        int clipWidth = Math.min(width, insets.left);
        int clipHeight = Math.min(height, insets.top);
        if (clipWidth <= 0 || clipHeight <= 0) {
            return;
        }
        Color oldColor = g2.getColor();
        g2.translate(x2, y2);
        for (int i2 = 0; i2 < this.tileIcons.length; ++i2) {
            if (this.tileIcons[i2] != null) continue;
            this.tileIcons[i2] = this.getDefaultIcon();
        }
        this.paintTopLeft(c2, g2, 0, 0, insets.left, insets.top);
        this.paintTop(c2, g2, insets.left, 0, width - insets.left - insets.right, insets.top);
        this.paintTopRight(c2, g2, width - insets.right, 0, insets.right, insets.top);
        this.paintRight(c2, g2, width - insets.right, insets.top, insets.right, height - insets.top - insets.bottom);
        this.paintBottomRight(c2, g2, width - insets.right, height - insets.bottom, insets.right, insets.bottom);
        this.paintBottom(c2, g2, insets.left, height - insets.bottom, width - insets.left - insets.right, insets.bottom);
        this.paintBottomLeft(c2, g2, 0, height - insets.bottom, insets.left, insets.bottom);
        this.paintLeft(c2, g2, 0, insets.top, insets.left, height - insets.top - insets.bottom);
        g2.translate(-x2, -y2);
        g2.setColor(oldColor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paint(Icon icon, Component c2, Graphics g2, int x2, int y2, int width, int height) {
        Graphics cg2 = g2.create();
        try {
            cg2.setClip(x2, y2, width, height);
            int tileW = icon.getIconWidth();
            int tileH = icon.getIconHeight();
            int ypos = 0;
            while (height - ypos > 0) {
                int xpos = 0;
                while (width - xpos > 0) {
                    icon.paintIcon(c2, cg2, x2 + xpos, y2 + ypos);
                    xpos += tileW;
                }
                ypos += tileH;
            }
        }
        finally {
            cg2.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintTopLeft(Component c2, Graphics g2, int x2, int y2, int width, int height) {
        Graphics cg2 = g2.create();
        try {
            cg2.setClip(x2, y2, width, height);
            this.tileIcons[0].paintIcon(c2, cg2, x2, y2);
        }
        finally {
            cg2.dispose();
        }
    }

    protected void paintTop(Component c2, Graphics g2, int x2, int y2, int width, int height) {
        this.paint(this.tileIcons[1], c2, g2, x2, y2, width, height);
    }

    protected void paintTopRight(Component c2, Graphics g2, int x2, int y2, int width, int height) {
        if (this.tileIcons.length == 8) {
            this.paint(this.tileIcons[2], c2, g2, x2, y2, width, height);
        } else {
            Icon icon = this.tileIcons[0];
        }
    }

    protected void paintRight(Component c2, Graphics g2, int x2, int y2, int width, int height) {
        if (this.tileIcons.length == 8) {
            this.paint(this.tileIcons[3], c2, g2, x2, y2, width, height);
        } else {
            Icon icon = this.tileIcons[1];
        }
    }

    protected void paintBottomRight(Component c2, Graphics g2, int x2, int y2, int width, int height) {
        if (this.tileIcons.length == 8) {
            this.paint(this.tileIcons[4], c2, g2, x2, y2, width, height);
        } else {
            Icon icon = this.tileIcons[0];
        }
    }

    protected void paintBottom(Component c2, Graphics g2, int x2, int y2, int width, int height) {
        if (this.tileIcons.length == 8) {
            this.paint(this.tileIcons[5], c2, g2, x2, y2, width, height);
        } else {
            Icon icon = this.tileIcons[1];
        }
    }

    protected void paintBottomLeft(Component c2, Graphics g2, int x2, int y2, int width, int height) {
        if (this.tileIcons.length == 8) {
            this.paint(this.tileIcons[6], c2, g2, x2, y2, width, height);
        } else {
            Icon icon = this.tileIcons[0];
        }
    }

    protected void paintLeft(Component c2, Graphics g2, int x2, int y2, int width, int height) {
        if (this.tileIcons.length == 8) {
            this.paint(this.tileIcons[7], c2, g2, x2, y2, width, height);
        } else {
            Icon icon = this.tileIcons[1];
        }
    }

    protected Icon getDefaultIcon() {
        if (this.defaultIcon == null) {
            this.defaultIcon = new Icon(){
                private int width = 3;
                private int height = 3;

                @Override
                public int getIconWidth() {
                    return this.width;
                }

                @Override
                public int getIconHeight() {
                    return this.height;
                }

                @Override
                public void paintIcon(Component c2, Graphics g2, int x2, int y2) {
                    g2.setColor(c2.getBackground().darker().darker());
                    g2.fillRect(x2, y2, this.width, this.height);
                }
            };
        }
        return this.defaultIcon;
    }
}

