/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.calendar;

import java.util.Date;

public class DateSpan {
    private long _start;
    private long _end;

    public DateSpan(long start, long end) {
        this._start = start;
        this._end = end;
        if (this._start > this._end) {
            throw new IllegalArgumentException("Start date must be before end date");
        }
    }

    public DateSpan(Date start, Date end) {
        this(start.getTime(), end.getTime());
    }

    public long getStart() {
        return this._start;
    }

    public long getEnd() {
        return this._end;
    }

    public Date getStartAsDate() {
        return new Date(this.getStart());
    }

    public Date getEndAsDate() {
        return new Date(this.getEnd());
    }

    public boolean contains(DateSpan span2) {
        return this.contains(span2.getStart()) && this.contains(span2.getEnd());
    }

    public boolean contains(long time2) {
        return time2 >= this.getStart() && time2 <= this.getEnd();
    }

    public boolean contains(long start, long end) {
        return start >= this.getStart() && end <= this.getEnd();
    }

    public boolean intersects(long start, long end) {
        return start <= this.getEnd() && end >= this.getStart();
    }

    public boolean intersects(DateSpan span2) {
        return this.intersects(span2.getStart(), span2.getEnd());
    }

    public DateSpan add(DateSpan span2) {
        return this.add(span2.getStart(), span2.getEnd());
    }

    public DateSpan add(long start, long end) {
        return new DateSpan(Math.min(start, this.getStart()), Math.max(end, this.getEnd()));
    }

    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (o2 instanceof DateSpan) {
            DateSpan ds = (DateSpan)o2;
            return this._start == ds.getStart() && this._end == ds.getEnd();
        }
        return false;
    }

    public int hashCode() {
        int result2 = 17;
        result2 = 37 * result2 + (int)(this._start ^ this._start >>> 32);
        result2 = 37 * result2 + (int)(this._end ^ this._end >>> 32);
        return result2;
    }

    public String toString() {
        return "DateSpan [" + this.getStartAsDate() + "-" + this.getEndAsDate() + "]";
    }
}

