/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.combobox;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.jdesktop.swingx.combobox.ListComboBoxModel;

public class EnumComboBoxModel<E extends Enum<E>>
extends ListComboBoxModel<E> {
    private static final long serialVersionUID = 2176566393195371004L;
    private final Map<String, E> valueMap = new HashMap<String, E>();
    private final Class<E> enumClass;

    public EnumComboBoxModel(Class<E> en) {
        super(new ArrayList<E>(EnumSet.allOf(en)));
        this.enumClass = en;
        for (Enum element : this.data) {
            String s2 = element.toString();
            if (this.valueMap.containsKey(s2)) {
                throw new IllegalArgumentException("multiple constants map to one string value");
            }
            this.valueMap.put(s2, element);
        }
    }

    @Override
    public void setSelectedItem(Object anItem) {
        Enum input2 = null;
        input2 = this.enumClass.isInstance(anItem) ? (Enum)anItem : (Enum)this.valueMap.get(anItem);
        if (input2 != null || anItem == null) {
            this.selected = input2;
        }
        this.fireContentsChanged(this, 0, this.getSize());
    }
}

