/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.event;

import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import org.jdesktop.beans.AbstractBean;
import org.jdesktop.swingx.SwingXUtilities;
import org.jdesktop.swingx.util.Contract;

public class CompoundFocusListener
extends AbstractBean {
    private JComponent root;
    private PropertyChangeListener managerListener;
    private boolean focused;

    public CompoundFocusListener(JComponent root) {
        this.root = Contract.asNotNull(root, "root must not be null");
        KeyboardFocusManager manager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        this.addManagerListener(manager);
        this.permanentFocusOwnerChanged(manager.getPermanentFocusOwner());
    }

    public boolean isFocused() {
        return this.focused;
    }

    public void release() {
        this.removeManagerListener(KeyboardFocusManager.getCurrentKeyboardFocusManager());
        this.removeAllListeners();
        this.root = null;
    }

    private void removeAllListeners() {
        for (PropertyChangeListener l2 : this.getPropertyChangeListeners()) {
            this.removePropertyChangeListener(l2);
        }
    }

    protected void permanentFocusOwnerChanged(Component focusOwner) {
        if (focusOwner == null) {
            return;
        }
        this.setFocused(SwingXUtilities.isDescendingFrom(focusOwner, this.root));
    }

    private void setFocused(boolean focused) {
        boolean old = this.isFocused();
        this.focused = focused;
        this.firePropertyChange("focused", old, this.isFocused());
    }

    private void addManagerListener(KeyboardFocusManager manager) {
        manager.addPropertyChangeListener("permanentFocusOwner", this.getManagerListener());
    }

    private void removeManagerListener(KeyboardFocusManager manager) {
        manager.removePropertyChangeListener("permanentFocusOwner", this.getManagerListener());
    }

    private PropertyChangeListener getManagerListener() {
        if (this.managerListener == null) {
            this.managerListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if ("permanentFocusOwner".equals(evt.getPropertyName())) {
                        CompoundFocusListener.this.permanentFocusOwnerChanged((Component)evt.getNewValue());
                    }
                }
            };
        }
        return this.managerListener;
    }
}

