/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.geom;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class Star2D
implements Shape {
    private Shape starShape;
    private double x;
    private double y;
    private double innerRadius;
    private double outerRadius;
    private int branchesCount;

    public Star2D(double x2, double y2, double innerRadius, double outerRadius, int branchesCount) {
        if (branchesCount < 3) {
            throw new IllegalArgumentException("The number of branches must be >= 3.");
        }
        if (innerRadius >= outerRadius) {
            throw new IllegalArgumentException("The inner radius must be < outer radius.");
        }
        this.x = x2;
        this.y = y2;
        this.innerRadius = innerRadius;
        this.outerRadius = outerRadius;
        this.branchesCount = branchesCount;
        this.starShape = Star2D.generateStar(x2, y2, innerRadius, outerRadius, branchesCount);
    }

    private static Shape generateStar(double x2, double y2, double innerRadius, double outerRadius, int branchesCount) {
        GeneralPath path = new GeneralPath();
        double outerAngleIncrement = Math.PI * 2 / (double)branchesCount;
        double outerAngle = branchesCount % 2 == 0 ? 0.0 : -1.5707963267948966;
        double innerAngle = outerAngleIncrement / 2.0 + outerAngle;
        float x1 = (float)(Math.cos(outerAngle) * outerRadius + x2);
        float y1 = (float)(Math.sin(outerAngle) * outerRadius + y2);
        float x22 = (float)(Math.cos(innerAngle) * innerRadius + x2);
        float y22 = (float)(Math.sin(innerAngle) * innerRadius + y2);
        path.moveTo(x1, y1);
        path.lineTo(x22, y22);
        outerAngle += outerAngleIncrement;
        innerAngle += outerAngleIncrement;
        for (int i2 = 1; i2 < branchesCount; ++i2) {
            x1 = (float)(Math.cos(outerAngle) * outerRadius + x2);
            y1 = (float)(Math.sin(outerAngle) * outerRadius + y2);
            path.lineTo(x1, y1);
            x22 = (float)(Math.cos(innerAngle) * innerRadius + x2);
            y22 = (float)(Math.sin(innerAngle) * innerRadius + y2);
            path.lineTo(x22, y22);
            outerAngle += outerAngleIncrement;
            innerAngle += outerAngleIncrement;
        }
        path.closePath();
        return path;
    }

    public void setInnerRadius(double innerRadius) {
        if (innerRadius >= this.outerRadius) {
            throw new IllegalArgumentException("The inner radius must be < outer radius.");
        }
        this.innerRadius = innerRadius;
        this.starShape = Star2D.generateStar(this.getX(), this.getY(), innerRadius, this.getOuterRadius(), this.getBranchesCount());
    }

    public void setX(double x2) {
        this.x = x2;
        this.starShape = Star2D.generateStar(x2, this.getY(), this.getInnerRadius(), this.getOuterRadius(), this.getBranchesCount());
    }

    public void setY(double y2) {
        this.y = y2;
        this.starShape = Star2D.generateStar(this.getX(), y2, this.getInnerRadius(), this.getOuterRadius(), this.getBranchesCount());
    }

    public void setOuterRadius(double outerRadius) {
        if (this.innerRadius >= outerRadius) {
            throw new IllegalArgumentException("The outer radius must be > inner radius.");
        }
        this.outerRadius = outerRadius;
        this.starShape = Star2D.generateStar(this.getX(), this.getY(), this.getInnerRadius(), outerRadius, this.getBranchesCount());
    }

    public void setBranchesCount(int branchesCount) {
        if (branchesCount <= 2) {
            throw new IllegalArgumentException("The number of branches must be >= 3.");
        }
        this.branchesCount = branchesCount;
        this.starShape = Star2D.generateStar(this.getX(), this.getY(), this.getInnerRadius(), this.getOuterRadius(), branchesCount);
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getInnerRadius() {
        return this.innerRadius;
    }

    public double getOuterRadius() {
        return this.outerRadius;
    }

    public int getBranchesCount() {
        return this.branchesCount;
    }

    @Override
    public Rectangle getBounds() {
        return this.starShape.getBounds();
    }

    @Override
    public Rectangle2D getBounds2D() {
        return this.starShape.getBounds2D();
    }

    @Override
    public boolean contains(double x2, double y2) {
        return this.starShape.contains(x2, y2);
    }

    @Override
    public boolean contains(Point2D p2) {
        return this.starShape.contains(p2);
    }

    @Override
    public boolean intersects(double x2, double y2, double w2, double h7) {
        return this.starShape.intersects(x2, y2, w2, h7);
    }

    @Override
    public boolean intersects(Rectangle2D r2) {
        return this.starShape.intersects(r2);
    }

    @Override
    public boolean contains(double x2, double y2, double w2, double h7) {
        return this.starShape.contains(x2, y2, w2, h7);
    }

    @Override
    public boolean contains(Rectangle2D r2) {
        return this.starShape.contains(r2);
    }

    @Override
    public PathIterator getPathIterator(AffineTransform at2) {
        return this.starShape.getPathIterator(at2);
    }

    @Override
    public PathIterator getPathIterator(AffineTransform at2, double flatness) {
        return this.starShape.getPathIterator(at2, flatness);
    }
}

