/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.painter;

import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.TexturePaint;
import java.awt.geom.Area;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import org.jdesktop.swingx.painter.AbstractAreaPainter;
import org.jdesktop.swingx.painter.AbstractLayoutPainter;
import org.jdesktop.swingx.painter.effects.AreaEffect;

public class ImagePainter
extends AbstractAreaPainter<Object> {
    private static final Logger LOG = Logger.getLogger(ImagePainter.class.getName());
    private transient BufferedImage img;
    private boolean horizontalRepeat;
    private boolean verticalRepeat;
    private boolean scaleToFit = false;
    private ScaleType scaleType = ScaleType.InsideFit;
    private double imageScale = 1.0;
    private Logger log = Logger.getLogger(ImagePainter.class.getName());
    private String imageString;

    public ImagePainter() {
        this((BufferedImage)null);
    }

    public ImagePainter(BufferedImage image) {
        this(image, AbstractLayoutPainter.HorizontalAlignment.CENTER, AbstractLayoutPainter.VerticalAlignment.CENTER);
    }

    public ImagePainter(BufferedImage image, AbstractLayoutPainter.HorizontalAlignment horizontal, AbstractLayoutPainter.VerticalAlignment vertical) {
        this.setCacheable(true);
        this.img = image;
        this.setVerticalAlignment(vertical);
        this.setHorizontalAlignment(horizontal);
        this.setFillPaint(null);
        this.setBorderPaint(null);
    }

    @Deprecated
    public ImagePainter(URL url) throws IOException {
        this(ImageIO.read(url));
    }

    @Deprecated
    public ImagePainter(URL url, AbstractLayoutPainter.HorizontalAlignment horizontal, AbstractLayoutPainter.VerticalAlignment vertical) throws IOException {
        this(ImageIO.read(url), horizontal, vertical);
    }

    public void setImage(BufferedImage image) {
        if (image != this.img) {
            BufferedImage oldImage = this.img;
            this.img = image;
            this.setDirty(true);
            this.firePropertyChange("image", oldImage, this.img);
        }
    }

    public BufferedImage getImage() {
        return this.img;
    }

    @Override
    protected void doPaint(Graphics2D g2, Object component, int width, int height) {
        Shape shape = this.provideShape(g2, component, width, height);
        switch (this.getStyle()) {
            case BOTH: {
                this.drawBackground(g2, shape, width, height);
                this.drawBorder(g2, shape, width, height);
                break;
            }
            case FILLED: {
                this.drawBackground(g2, shape, width, height);
                break;
            }
            case OUTLINE: {
                this.drawBorder(g2, shape, width, height);
                break;
            }
        }
    }

    private void drawBackground(Graphics2D g2, Shape shape, int width, int height) {
        Paint p2 = this.getFillPaint();
        if (p2 != null) {
            if (this.isPaintStretched()) {
                p2 = this.calculateSnappedPaint(p2, width, height);
            }
            g2.setPaint(p2);
            g2.fill(shape);
        }
        if (this.getAreaEffects() != null) {
            for (AreaEffect ef : this.getAreaEffects()) {
                ef.apply(g2, shape, width, height);
            }
        }
        if (this.img != null) {
            int imgWidth = this.img.getWidth(null);
            int imgHeight = this.img.getHeight(null);
            if (imgWidth != -1 && imgHeight != -1) {
                Rectangle rect = shape.getBounds();
                if (this.verticalRepeat || this.horizontalRepeat) {
                    Shape oldClip = g2.getClip();
                    Shape clip = g2.getClip();
                    if (clip == null) {
                        clip = new Rectangle(0, 0, width, height);
                    }
                    Area area2 = new Area(clip);
                    Insets insets = this.getInsets();
                    area2.intersect(new Area(new Rectangle(insets.left, insets.top, width - insets.left - insets.right, height - insets.top - insets.bottom)));
                    if (this.verticalRepeat && this.horizontalRepeat) {
                        area2.intersect(new Area(new Rectangle(0, 0, width, height)));
                        g2.setClip(area2);
                    } else if (this.verticalRepeat) {
                        area2.intersect(new Area(new Rectangle(rect.x, 0, rect.width, height)));
                        g2.setClip(area2);
                    } else {
                        area2.intersect(new Area(new Rectangle(0, rect.y, width, rect.height)));
                        g2.setClip(area2);
                    }
                    TexturePaint tp = new TexturePaint(this.img, rect);
                    g2.setPaint(tp);
                    g2.fillRect(0, 0, width, height);
                    g2.setClip(oldClip);
                } else if (this.scaleToFit) {
                    float scale;
                    int sw = imgWidth;
                    int sh = imgHeight;
                    if (this.scaleType == ScaleType.InsideFit) {
                        if (sw > width) {
                            scale = (float)width / (float)sw;
                            sw = (int)((float)sw * scale);
                            sh = (int)((float)sh * scale);
                        }
                        if (sh > height) {
                            scale = (float)height / (float)sh;
                            sw = (int)((float)sw * scale);
                            sh = (int)((float)sh * scale);
                        }
                    }
                    if (this.scaleType == ScaleType.OutsideFit) {
                        if (sw > width) {
                            scale = (float)width / (float)sw;
                            sw = (int)((float)sw * scale);
                            sh = (int)((float)sh * scale);
                        }
                        if (sh < height) {
                            scale = (float)height / (float)sh;
                            sw = (int)((float)sw * scale);
                            sh = (int)((float)sh * scale);
                        }
                    }
                    if (this.scaleType == ScaleType.Distort) {
                        sw = width;
                        sh = height;
                    }
                    int x2 = 0;
                    int y2 = 0;
                    switch (this.getHorizontalAlignment()) {
                        case CENTER: {
                            x2 = width / 2 - sw / 2;
                            break;
                        }
                        case RIGHT: {
                            x2 = width - sw;
                        }
                    }
                    switch (this.getVerticalAlignment()) {
                        case CENTER: {
                            y2 = height / 2 - sh / 2;
                            break;
                        }
                        case BOTTOM: {
                            y2 = height - sh;
                        }
                    }
                    g2.drawImage(this.img, x2, y2, sw, sh, null);
                } else {
                    int sw = rect.width;
                    int sh = rect.height;
                    if (this.imageScale != 1.0) {
                        sw = (int)((double)sw * this.imageScale);
                        sh = (int)((double)sh * this.imageScale);
                    }
                    g2.drawImage(this.img, rect.x, rect.y, sw, sh, null);
                }
            }
        }
    }

    private void drawBorder(Graphics2D g2, Shape shape, int width, int height) {
        if (this.getBorderPaint() != null) {
            g2.setPaint(this.getBorderPaint());
            g2.setStroke(new BasicStroke(this.getBorderWidth()));
            g2.draw(shape);
        }
    }

    public void setScaleToFit(boolean scaleToFit) {
        boolean old = this.isScaleToFit();
        this.scaleToFit = scaleToFit;
        this.setDirty(true);
        this.firePropertyChange("scaleToFit", old, this.isScaleToFit());
    }

    public boolean isScaleToFit() {
        return this.scaleToFit;
    }

    public void setImageScale(double imageScale) {
        double old = this.getImageScale();
        this.imageScale = imageScale;
        this.setDirty(true);
        this.firePropertyChange("imageScale", old, this.imageScale);
    }

    public double getImageScale() {
        return this.imageScale;
    }

    @Deprecated
    private void loadImage() {
        try {
            String img2 = this.getImageString();
            if (img2 != null) {
                URL url = new URL(img2);
                this.setImage(ImageIO.read(url));
            }
        }
        catch (IOException ex2) {
            this.log.severe("ex: " + ex2.getMessage());
            ex2.printStackTrace();
        }
    }

    @Deprecated
    public String getImageString() {
        return this.imageString;
    }

    @Deprecated
    public void setImageString(String imageString) {
        this.log.fine("setting image string to: " + imageString);
        String old = this.getImageString();
        this.imageString = imageString;
        this.loadImage();
        this.setDirty(true);
        this.firePropertyChange("imageString", old, imageString);
    }

    public boolean isHorizontalRepeat() {
        return this.horizontalRepeat;
    }

    public void setHorizontalRepeat(boolean horizontalRepeat) {
        boolean old = this.isHorizontalRepeat();
        this.horizontalRepeat = horizontalRepeat;
        this.setDirty(true);
        this.firePropertyChange("horizontalRepeat", old, this.horizontalRepeat);
    }

    public boolean isVerticalRepeat() {
        return this.verticalRepeat;
    }

    public void setVerticalRepeat(boolean verticalRepeat) {
        boolean old = this.isVerticalRepeat();
        this.verticalRepeat = verticalRepeat;
        this.setDirty(true);
        this.firePropertyChange("verticalRepeat", old, this.verticalRepeat);
    }

    @Override
    protected Shape provideShape(Graphics2D g2, Object comp, int width, int height) {
        if (this.getImage() != null) {
            BufferedImage img2 = this.getImage();
            int imgWidth = img2.getWidth();
            int imgHeight = img2.getHeight();
            return this.calculateLayout(imgWidth, imgHeight, width, height);
        }
        return new Rectangle(0, 0, 0, 0);
    }

    public ScaleType getScaleType() {
        return this.scaleType;
    }

    public void setScaleType(ScaleType scaleType) {
        ScaleType old = this.getScaleType();
        this.scaleType = scaleType;
        this.setDirty(true);
        this.firePropertyChange("scaleType", (Object)old, (Object)this.getScaleType());
    }

    public static enum ScaleType {
        InsideFit,
        OutsideFit,
        Distort;

    }
}

