/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.plaf.basic;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import org.jdesktop.swingx.JXCollapsiblePane;
import org.jdesktop.swingx.JXHyperlink;
import org.jdesktop.swingx.JXTaskPane;
import org.jdesktop.swingx.SwingXUtilities;
import org.jdesktop.swingx.icon.EmptyIcon;
import org.jdesktop.swingx.plaf.TaskPaneUI;

public class BasicTaskPaneUI
extends TaskPaneUI {
    private static FocusListener focusListener = new RepaintOnFocus();
    protected int titleHeight = 25;
    protected int roundHeight = 5;
    protected JXTaskPane group;
    protected boolean mouseOver;
    protected MouseInputListener mouseListener;
    protected PropertyChangeListener propertyListener;

    public static ComponentUI createUI(JComponent c2) {
        return new BasicTaskPaneUI();
    }

    @Override
    public void installUI(JComponent c2) {
        super.installUI(c2);
        this.group = (JXTaskPane)c2;
        this.installDefaults();
        this.installListeners();
        this.installKeyboardActions();
    }

    protected void installDefaults() {
        LookAndFeel.installProperty(this.group, "opaque", true);
        this.group.setBorder(this.createPaneBorder());
        ((JComponent)this.group.getContentPane()).setBorder(this.createContentPaneBorder());
        LookAndFeel.installColorsAndFont(this.group, "TaskPane.background", "TaskPane.foreground", "TaskPane.font");
        LookAndFeel.installColorsAndFont((JComponent)this.group.getContentPane(), "TaskPane.background", "TaskPane.foreground", "TaskPane.font");
    }

    protected void installListeners() {
        this.mouseListener = this.createMouseInputListener();
        this.group.addMouseMotionListener(this.mouseListener);
        this.group.addMouseListener(this.mouseListener);
        this.group.addFocusListener(focusListener);
        this.propertyListener = this.createPropertyListener();
        this.group.addPropertyChangeListener(this.propertyListener);
    }

    protected void installKeyboardActions() {
        ActionMap map2;
        InputMap inputMap = (InputMap)UIManager.get("TaskPane.focusInputMap");
        if (inputMap != null) {
            SwingUtilities.replaceUIInputMap(this.group, 0, inputMap);
        }
        if ((map2 = this.getActionMap()) != null) {
            SwingUtilities.replaceUIActionMap(this.group, map2);
        }
    }

    ActionMap getActionMap() {
        ActionMapUIResource map2 = new ActionMapUIResource();
        map2.put("toggleCollapsed", new ToggleCollapsedAction());
        return map2;
    }

    @Override
    public void uninstallUI(JComponent c2) {
        this.uninstallListeners();
        super.uninstallUI(c2);
    }

    protected void uninstallListeners() {
        this.group.removeMouseListener(this.mouseListener);
        this.group.removeMouseMotionListener(this.mouseListener);
        this.group.removeFocusListener(focusListener);
        this.group.removePropertyChangeListener(this.propertyListener);
    }

    protected MouseInputListener createMouseInputListener() {
        return new ToggleListener();
    }

    protected PropertyChangeListener createPropertyListener() {
        return new ChangeListener();
    }

    protected boolean isInBorder(MouseEvent event) {
        return event.getY() < this.getTitleHeight(event.getComponent());
    }

    protected int getTitleHeight(Component c2) {
        if (c2 instanceof JXTaskPane) {
            Icon icon;
            JXTaskPane taskPane = (JXTaskPane)c2;
            Font font = taskPane.getFont();
            int height = this.titleHeight;
            if (font != null && !(font instanceof FontUIResource)) {
                height = Math.max(height, taskPane.getFontMetrics(font).getHeight());
            }
            if ((icon = taskPane.getIcon()) != null) {
                height = Math.max(height, icon.getIconHeight() + 4);
            }
            return height;
        }
        return this.titleHeight;
    }

    protected Border createPaneBorder() {
        return new PaneBorder();
    }

    @Override
    public Dimension getPreferredSize(JComponent c2) {
        Component component = this.group.getComponent(0);
        if (!(component instanceof JXCollapsiblePane)) {
            return super.getPreferredSize(c2);
        }
        JXCollapsiblePane collapsible = (JXCollapsiblePane)component;
        Dimension dim = collapsible.getPreferredSize();
        Border groupBorder = this.group.getBorder();
        if (groupBorder instanceof PaneBorder) {
            ((PaneBorder)groupBorder).label.setDisplayedMnemonic(this.group.getMnemonic());
            Dimension border = ((PaneBorder)groupBorder).getPreferredSize(this.group);
            dim.width = Math.max(dim.width, border.width);
            dim.height += border.height;
        } else {
            dim.height += this.getTitleHeight(c2);
        }
        return dim;
    }

    protected Border createContentPaneBorder() {
        Color borderColor = UIManager.getColor("TaskPane.borderColor");
        return new CompoundBorder(new ContentPaneBorder(borderColor), BorderFactory.createEmptyBorder(10, 10, 10, 10));
    }

    @Override
    public Component createAction(Action action) {
        JXHyperlink link2 = new JXHyperlink(action){

            @Override
            public void updateUI() {
                super.updateUI();
                BasicTaskPaneUI.this.configure(this);
            }
        };
        this.configure(link2);
        return link2;
    }

    protected void configure(JXHyperlink link2) {
        link2.setOpaque(false);
        link2.setBorderPainted(false);
        link2.setFocusPainted(true);
        link2.setForeground(UIManager.getColor("TaskPane.titleForeground"));
    }

    protected void ensureVisible() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                BasicTaskPaneUI.this.group.scrollRectToVisible(new Rectangle(BasicTaskPaneUI.this.group.getWidth(), BasicTaskPaneUI.this.group.getHeight()));
            }
        });
    }

    protected int getRoundHeight() {
        return this.roundHeight;
    }

    protected class PaneBorder
    implements Border,
    UIResource {
        protected Color borderColor = UIManager.getColor("TaskPane.borderColor");
        protected Color titleForeground = UIManager.getColor("TaskPane.titleForeground");
        protected Color specialTitleBackground = UIManager.getColor("TaskPane.specialTitleBackground");
        protected Color specialTitleForeground = UIManager.getColor("TaskPane.specialTitleForeground");
        protected Color titleBackgroundGradientStart = UIManager.getColor("TaskPane.titleBackgroundGradientStart");
        protected Color titleBackgroundGradientEnd = UIManager.getColor("TaskPane.titleBackgroundGradientEnd");
        protected Color titleOver = UIManager.getColor("TaskPane.titleOver");
        protected Color specialTitleOver;
        protected JLabel label;

        public PaneBorder() {
            if (this.titleOver == null) {
                this.titleOver = this.specialTitleBackground.brighter();
            }
            this.specialTitleOver = UIManager.getColor("TaskPane.specialTitleOver");
            if (this.specialTitleOver == null) {
                this.specialTitleOver = this.specialTitleBackground.brighter();
            }
            this.label = new JLabel();
            this.label.setOpaque(false);
            this.label.setIconTextGap(8);
        }

        @Override
        public Insets getBorderInsets(Component c2) {
            return new Insets(BasicTaskPaneUI.this.getTitleHeight(c2), 0, 0, 0);
        }

        @Override
        public boolean isBorderOpaque() {
            return true;
        }

        public Dimension getPreferredSize(JXTaskPane group) {
            this.configureLabel(group);
            Dimension dim = this.label.getPreferredSize();
            dim.width += 3;
            dim.width += BasicTaskPaneUI.this.getTitleHeight(group);
            dim.width += 3;
            dim.height = BasicTaskPaneUI.this.getTitleHeight(group);
            return dim;
        }

        protected void paintTitleBackground(JXTaskPane group, Graphics g2) {
            if (group.isSpecial()) {
                g2.setColor(this.specialTitleBackground);
            } else {
                g2.setColor(this.titleBackgroundGradientStart);
            }
            g2.fillRect(0, 0, group.getWidth(), BasicTaskPaneUI.this.getTitleHeight(group) - 1);
        }

        protected void paintTitle(JXTaskPane group, Graphics g2, Color textColor, int x2, int y2, int width, int height) {
            this.configureLabel(group);
            this.label.setForeground(textColor);
            if (group.getFont() != null && !(group.getFont() instanceof FontUIResource)) {
                this.label.setFont(group.getFont());
            }
            g2.translate(x2, y2);
            this.label.setBounds(0, 0, width, height);
            this.label.paint(g2);
            g2.translate(-x2, -y2);
        }

        protected void configureLabel(JXTaskPane group) {
            this.label.applyComponentOrientation(group.getComponentOrientation());
            this.label.setFont(group.getFont());
            this.label.setText(group.getTitle());
            this.label.setIcon(group.getIcon() == null ? new EmptyIcon() : group.getIcon());
        }

        protected void paintExpandedControls(JXTaskPane group, Graphics g2, int x2, int y2, int width, int height) {
        }

        protected Color getPaintColor(JXTaskPane group) {
            Color paintColor = this.isMouseOverBorder() ? (BasicTaskPaneUI.this.mouseOver ? (group.isSpecial() ? this.specialTitleOver : this.titleOver) : (group.isSpecial() ? this.specialTitleForeground : (group.getForeground() == null || group.getForeground() instanceof ColorUIResource ? this.titleForeground : group.getForeground()))) : (group.isSpecial() ? this.specialTitleForeground : (group.getForeground() == null || group.getForeground() instanceof ColorUIResource ? this.titleForeground : group.getForeground()));
            return paintColor;
        }

        @Override
        public void paintBorder(Component c2, Graphics g2, int x2, int y2, int width, int height) {
            JXTaskPane group = (JXTaskPane)c2;
            int controlWidth = BasicTaskPaneUI.this.getTitleHeight(group) - 2 * BasicTaskPaneUI.this.getRoundHeight();
            int controlX = group.getWidth() - BasicTaskPaneUI.this.getTitleHeight(group);
            int controlY = BasicTaskPaneUI.this.getRoundHeight() - 1;
            int titleX = 3;
            int titleY = 0;
            int titleWidth = group.getWidth() - BasicTaskPaneUI.this.getTitleHeight(group) - 3;
            int titleHeight = BasicTaskPaneUI.this.getTitleHeight(group);
            if (!group.getComponentOrientation().isLeftToRight()) {
                controlX = group.getWidth() - controlX - controlWidth;
                titleX = group.getWidth() - titleX - titleWidth;
            }
            this.paintTitleBackground(group, g2);
            this.paintExpandedControls(group, g2, controlX, controlY, controlWidth, controlWidth);
            Color paintColor = this.getPaintColor(group);
            if (group.hasFocus()) {
                this.paintFocus(g2, paintColor, 3, 3, width - 6, BasicTaskPaneUI.this.getTitleHeight(group) - 6);
            }
            this.paintTitle(group, g2, paintColor, titleX, titleY, titleWidth, titleHeight);
        }

        protected void paintRectAroundControls(JXTaskPane group, Graphics g2, int x2, int y2, int width, int height, Color highColor, Color lowColor) {
            if (BasicTaskPaneUI.this.mouseOver) {
                int x22 = x2 + width;
                int y22 = y2 + height;
                g2.setColor(highColor);
                g2.drawLine(x2, y2, x22, y2);
                g2.drawLine(x2, y2, x2, y22);
                g2.setColor(lowColor);
                g2.drawLine(x22, y2, x22, y22);
                g2.drawLine(x2, y22, x22, y22);
            }
        }

        protected void paintOvalAroundControls(JXTaskPane group, Graphics g2, int x2, int y2, int width, int height) {
            if (group.isSpecial()) {
                g2.setColor(this.specialTitleBackground.brighter());
                g2.drawOval(x2, y2, width, height);
            } else {
                g2.setColor(this.titleBackgroundGradientStart);
                g2.fillOval(x2, y2, width, height);
                g2.setColor(this.titleBackgroundGradientEnd.darker());
                g2.drawOval(x2, y2, width, width);
            }
        }

        protected void paintChevronControls(JXTaskPane group, Graphics g2, int x2, int y2, int width, int height) {
            ChevronIcon chevron = group.isCollapsed() ? new ChevronIcon(false) : new ChevronIcon(true);
            int chevronX = x2 + width / 2 - chevron.getIconWidth() / 2;
            int chevronY = y2 + (height / 2 - chevron.getIconHeight());
            chevron.paintIcon(group, g2, chevronX, chevronY);
            chevron.paintIcon(group, g2, chevronX, chevronY + chevron.getIconHeight() + 1);
        }

        protected void paintFocus(Graphics g2, Color paintColor, int x2, int y2, int width, int height) {
            g2.setColor(paintColor);
            BasicGraphicsUtils.drawDashedRect(g2, x2, y2, width, height);
        }

        protected boolean isMouseOverBorder() {
            return false;
        }
    }

    protected static class ContentPaneBorder
    implements Border,
    UIResource {
        Color color;

        public ContentPaneBorder(Color color) {
            this.color = color;
        }

        @Override
        public Insets getBorderInsets(Component c2) {
            return new Insets(0, 1, 1, 1);
        }

        @Override
        public boolean isBorderOpaque() {
            return true;
        }

        @Override
        public void paintBorder(Component c2, Graphics g2, int x2, int y2, int width, int height) {
            g2.setColor(this.color);
            g2.drawLine(x2, y2, x2, y2 + height - 1);
            g2.drawLine(x2, y2 + height - 1, x2 + width - 1, y2 + height - 1);
            g2.drawLine(x2 + width - 1, y2, x2 + width - 1, y2 + height - 1);
        }
    }

    protected static class ChevronIcon
    implements Icon {
        boolean up = true;

        public ChevronIcon(boolean up) {
            this.up = up;
        }

        @Override
        public int getIconHeight() {
            return 3;
        }

        @Override
        public int getIconWidth() {
            return 6;
        }

        @Override
        public void paintIcon(Component c2, Graphics g2, int x2, int y2) {
            if (this.up) {
                g2.drawLine(x2 + 3, y2, x2, y2 + 3);
                g2.drawLine(x2 + 3, y2, x2 + 6, y2 + 3);
            } else {
                g2.drawLine(x2, y2, x2 + 3, y2 + 3);
                g2.drawLine(x2 + 3, y2 + 3, x2 + 6, y2);
            }
        }
    }

    class ToggleCollapsedAction
    extends AbstractAction {
        private static final long serialVersionUID = 5676859881615358815L;

        public ToggleCollapsedAction() {
            super("toggleCollapsed");
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            BasicTaskPaneUI.this.group.setCollapsed(!BasicTaskPaneUI.this.group.isCollapsed());
        }

        @Override
        public boolean isEnabled() {
            return BasicTaskPaneUI.this.group.isVisible();
        }
    }

    class ToggleListener
    extends MouseInputAdapter {
        ToggleListener() {
        }

        @Override
        public void mouseEntered(MouseEvent e2) {
            if (BasicTaskPaneUI.this.isInBorder(e2)) {
                e2.getComponent().setCursor(Cursor.getPredefinedCursor(12));
            } else {
                BasicTaskPaneUI.this.mouseOver = false;
                BasicTaskPaneUI.this.group.repaint(0, 0, BasicTaskPaneUI.this.group.getWidth(), BasicTaskPaneUI.this.getTitleHeight(BasicTaskPaneUI.this.group));
            }
        }

        @Override
        public void mouseExited(MouseEvent e2) {
            e2.getComponent().setCursor(null);
            BasicTaskPaneUI.this.mouseOver = false;
            BasicTaskPaneUI.this.group.repaint(0, 0, BasicTaskPaneUI.this.group.getWidth(), BasicTaskPaneUI.this.getTitleHeight(BasicTaskPaneUI.this.group));
        }

        @Override
        public void mouseMoved(MouseEvent e2) {
            if (BasicTaskPaneUI.this.isInBorder(e2)) {
                e2.getComponent().setCursor(Cursor.getPredefinedCursor(12));
                BasicTaskPaneUI.this.mouseOver = true;
            } else {
                e2.getComponent().setCursor(null);
                BasicTaskPaneUI.this.mouseOver = false;
            }
            BasicTaskPaneUI.this.group.repaint(0, 0, BasicTaskPaneUI.this.group.getWidth(), BasicTaskPaneUI.this.getTitleHeight(BasicTaskPaneUI.this.group));
        }

        @Override
        public void mouseReleased(MouseEvent e2) {
            if (SwingUtilities.isLeftMouseButton(e2) && BasicTaskPaneUI.this.isInBorder(e2)) {
                BasicTaskPaneUI.this.group.setCollapsed(!BasicTaskPaneUI.this.group.isCollapsed());
            }
        }
    }

    class ChangeListener
    implements PropertyChangeListener {
        ChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("collapsed".equals(evt.getPropertyName()) && Boolean.TRUE.equals(evt.getNewValue()) && !BasicTaskPaneUI.this.group.isAnimated() || "animationState".equals(evt.getPropertyName()) && "expanded".equals(evt.getNewValue())) {
                if (BasicTaskPaneUI.this.group.isScrollOnExpand()) {
                    BasicTaskPaneUI.this.ensureVisible();
                }
            } else if ("icon".equals(evt.getPropertyName()) || "title".equals(evt.getPropertyName()) || "special".equals(evt.getPropertyName())) {
                BasicTaskPaneUI.this.group.repaint();
            } else if ("mnemonic".equals(evt.getPropertyName())) {
                SwingXUtilities.updateMnemonicBinding(BasicTaskPaneUI.this.group, "toggleCollapsed");
                Border b2 = BasicTaskPaneUI.this.group.getBorder();
                if (b2 instanceof PaneBorder) {
                    int key = (Integer)evt.getNewValue();
                    ((PaneBorder)b2).label.setDisplayedMnemonic(key);
                }
            }
        }
    }

    static class RepaintOnFocus
    implements FocusListener {
        RepaintOnFocus() {
        }

        @Override
        public void focusGained(FocusEvent e2) {
            e2.getComponent().repaint();
        }

        @Override
        public void focusLost(FocusEvent e2) {
            e2.getComponent().repaint();
        }
    }
}

