/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.plaf.basic.core;

import java.awt.dnd.DragSource;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import org.jdesktop.swingx.SwingXUtilities;

public class DragRecognitionSupport {
    private int motionThreshold;
    private MouseEvent dndArmedEvent;
    private JComponent component;

    private static DragRecognitionSupport getDragRecognitionSupport() {
        DragRecognitionSupport support = (DragRecognitionSupport)UIManager.get("sharedInstance.dragRecognitionSupport");
        if (support == null) {
            support = new DragRecognitionSupport();
            UIManager.put("sharedInstance.dragRecognitionSupport", support);
        }
        return support;
    }

    public static boolean mousePressed(MouseEvent me) {
        return DragRecognitionSupport.getDragRecognitionSupport().mousePressedImpl(me);
    }

    public static MouseEvent mouseReleased(MouseEvent me) {
        return DragRecognitionSupport.getDragRecognitionSupport().mouseReleasedImpl(me);
    }

    public static boolean mouseDragged(MouseEvent me, BeforeDrag bd2) {
        return DragRecognitionSupport.getDragRecognitionSupport().mouseDraggedImpl(me, bd2);
    }

    private void clearState() {
        this.dndArmedEvent = null;
        this.component = null;
    }

    private int mapDragOperationFromModifiers(MouseEvent me, TransferHandler th2) {
        if (th2 == null || !SwingUtilities.isLeftMouseButton(me)) {
            return 0;
        }
        return SwingXUtilities.convertModifiersToDropAction(me.getModifiersEx(), th2.getSourceActions(this.component));
    }

    private boolean mousePressedImpl(MouseEvent me) {
        this.component = (JComponent)me.getSource();
        if (this.mapDragOperationFromModifiers(me, this.component.getTransferHandler()) != 0) {
            this.motionThreshold = DragSource.getDragThreshold();
            this.dndArmedEvent = me;
            return true;
        }
        this.clearState();
        return false;
    }

    private MouseEvent mouseReleasedImpl(MouseEvent me) {
        if (this.dndArmedEvent == null) {
            return null;
        }
        MouseEvent retEvent = null;
        if (me.getSource() == this.component) {
            retEvent = this.dndArmedEvent;
        }
        this.clearState();
        return retEvent;
    }

    private boolean mouseDraggedImpl(MouseEvent me, BeforeDrag bd2) {
        TransferHandler th2;
        int action;
        if (this.dndArmedEvent == null) {
            return false;
        }
        if (me.getSource() != this.component) {
            this.clearState();
            return false;
        }
        int dx = Math.abs(me.getX() - this.dndArmedEvent.getX());
        int dy = Math.abs(me.getY() - this.dndArmedEvent.getY());
        if ((dx > this.motionThreshold || dy > this.motionThreshold) && (action = this.mapDragOperationFromModifiers(me, th2 = this.component.getTransferHandler())) != 0) {
            if (bd2 != null) {
                bd2.dragStarting(this.dndArmedEvent);
            }
            th2.exportAsDrag(this.component, this.dndArmedEvent, action);
            this.clearState();
        }
        return true;
    }

    public static interface BeforeDrag {
        public void dragStarting(MouseEvent var1);
    }
}

