/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.renderer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Font;
import java.awt.Rectangle;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.border.Border;
import org.jdesktop.swingx.JXPanel;
import org.jdesktop.swingx.painter.Painter;
import org.jdesktop.swingx.renderer.JRendererLabel;
import org.jdesktop.swingx.renderer.PainterAware;

public class WrappingIconPanel
extends JXPanel
implements PainterAware {
    protected JComponent delegate;
    JLabel iconLabel;
    String labelPosition = "Center";
    int iconLabelGap;
    private Border ltorBorder;
    private Border rtolBorder;
    private boolean dropHackEnabled;

    public WrappingIconPanel() {
        this(true);
    }

    public WrappingIconPanel(boolean dropHackEnabled) {
        this.setOpaque(false);
        this.iconLabel = new JRendererLabel();
        this.iconLabelGap = this.iconLabel.getIconTextGap();
        this.iconLabel.setOpaque(false);
        this.updateIconBorder();
        this.setBorder(null);
        this.setLayout(new BorderLayout());
        this.add((Component)this.iconLabel, "Before");
        this.setDropHackEnabled(dropHackEnabled);
    }

    @Override
    public void setComponentOrientation(ComponentOrientation o2) {
        super.setComponentOrientation(o2);
        this.updateIconBorder();
    }

    private void updateIconBorder() {
        if (this.ltorBorder == null) {
            this.ltorBorder = BorderFactory.createEmptyBorder(0, 0, 0, this.iconLabelGap);
            this.rtolBorder = BorderFactory.createEmptyBorder(0, this.iconLabelGap, 0, 0);
        }
        if (this.getComponentOrientation().isLeftToRight()) {
            this.iconLabel.setBorder(this.ltorBorder);
        } else {
            this.iconLabel.setBorder(this.rtolBorder);
        }
    }

    public void setIcon(Icon icon) {
        this.iconLabel.setIcon(icon);
        this.iconLabel.setText(null);
        this.validate();
    }

    public Icon getIcon() {
        return this.iconLabel.getIcon();
    }

    public void setComponent(JComponent comp) {
        JComponent old = this.getComponent();
        if (this.delegate != null) {
            this.remove(this.delegate);
        }
        this.delegate = comp;
        this.add((Component)this.delegate, this.labelPosition);
        this.validate();
        this.firePropertyChange("component", old, this.getComponent());
    }

    public JComponent getComponent() {
        return this.delegate;
    }

    @Override
    public void setBackground(Color bg2) {
        super.setBackground(bg2);
        if (this.iconLabel != null) {
            this.iconLabel.setBackground(bg2);
        }
        if (this.delegate != null) {
            this.delegate.setBackground(bg2);
        }
    }

    @Override
    public void setForeground(Color bg2) {
        super.setForeground(bg2);
        if (this.iconLabel != null) {
            this.iconLabel.setForeground(bg2);
        }
        if (this.delegate != null) {
            this.delegate.setForeground(bg2);
        }
    }

    @Override
    public void setFont(Font font) {
        if (this.delegate != null) {
            this.delegate.setFont(font);
        }
        super.setFont(font);
    }

    @Override
    public boolean isVisible() {
        return this.dropHackEnabled ? false : super.isVisible();
    }

    @Override
    public Painter<?> getPainter() {
        if (this.delegate instanceof PainterAware) {
            return ((PainterAware)((Object)this.delegate)).getPainter();
        }
        return null;
    }

    @Override
    public void setPainter(Painter<?> painter) {
        if (this.delegate instanceof PainterAware) {
            ((PainterAware)((Object)this.delegate)).setPainter(painter);
        }
    }

    public Rectangle getDelegateBounds() {
        if (this.delegate == null) {
            return null;
        }
        return this.delegate.getBounds();
    }

    public void setDropHackEnabled(boolean dropHackEnabled) {
        this.dropHackEnabled = dropHackEnabled;
    }
}

