/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.table;

import java.awt.Component;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.table.TableColumnExt;

public class ColumnFactory {
    private static ColumnFactory columnFactory;
    private int packMargin = 4;

    public static synchronized ColumnFactory getInstance() {
        if (columnFactory == null) {
            columnFactory = new ColumnFactory();
        }
        return columnFactory;
    }

    public static synchronized void setInstance(ColumnFactory factory2) {
        columnFactory = factory2;
    }

    public TableColumnExt createAndConfigureTableColumn(TableModel model, int modelIndex) {
        TableColumnExt column2 = this.createTableColumn(modelIndex);
        if (column2 != null) {
            this.configureTableColumn(model, column2);
        }
        return column2;
    }

    public TableColumnExt createTableColumn(int modelIndex) {
        return new TableColumnExt(modelIndex);
    }

    public void configureTableColumn(TableModel model, TableColumnExt columnExt) {
        if (columnExt.getModelIndex() < 0 || columnExt.getModelIndex() >= model.getColumnCount()) {
            throw new IllegalStateException("column must have valid modelIndex");
        }
        columnExt.setHeaderValue(model.getColumnName(columnExt.getModelIndex()));
    }

    public void configureColumnWidths(JXTable table2, TableColumnExt columnExt) {
        int prefWidth = 75 - table2.getColumnMargin();
        int prototypeWidth = this.calcPrototypeWidth(table2, columnExt);
        if (prototypeWidth > 0) {
            prefWidth = prototypeWidth;
        }
        int headerWidth = this.calcHeaderWidth(table2, columnExt);
        prefWidth = Math.max(prefWidth, headerWidth);
        columnExt.setPreferredWidth(prefWidth += table2.getColumnModel().getColumnMargin());
    }

    public int getPreferredScrollableViewportWidth(JXTable table2) {
        int w2 = 0;
        int count = table2.getVisibleColumnCount() < 0 ? table2.getColumnCount() : Math.min(table2.getColumnCount(), table2.getVisibleColumnCount());
        for (int i2 = 0; i2 < count; ++i2) {
            w2 += table2.getColumn(i2).getPreferredWidth();
        }
        if (count < table2.getVisibleColumnCount()) {
            w2 += (table2.getVisibleColumnCount() - count) * 75;
        }
        return w2;
    }

    protected int calcHeaderWidth(JXTable table2, TableColumnExt columnExt) {
        int prototypeWidth = -1;
        TableCellRenderer renderer = this.getHeaderRenderer(table2, columnExt);
        if (renderer != null) {
            Component comp = renderer.getTableCellRendererComponent(table2, columnExt.getHeaderValue(), false, false, -1, -1);
            prototypeWidth = comp.getPreferredSize().width;
        }
        return prototypeWidth;
    }

    protected int calcPrototypeWidth(JXTable table2, TableColumnExt columnExt) {
        int prototypeWidth = -1;
        Object prototypeValue = columnExt.getPrototypeValue();
        if (prototypeValue != null) {
            TableCellRenderer cellRenderer = this.getCellRenderer(table2, columnExt);
            Component comp = cellRenderer.getTableCellRendererComponent(table2, prototypeValue, false, false, 0, -1);
            prototypeWidth = comp.getPreferredSize().width;
        }
        return prototypeWidth;
    }

    protected TableCellRenderer getCellRenderer(JXTable table2, TableColumnExt columnExt) {
        int viewIndex = table2.convertColumnIndexToView(columnExt.getModelIndex());
        if (viewIndex >= 0) {
            return table2.getCellRenderer(0, viewIndex);
        }
        TableCellRenderer renderer = columnExt.getCellRenderer();
        if (renderer == null) {
            renderer = table2.getDefaultRenderer(table2.getModel().getColumnClass(columnExt.getModelIndex()));
        }
        return renderer;
    }

    protected TableCellRenderer getHeaderRenderer(JXTable table2, TableColumnExt columnExt) {
        JTableHeader header2;
        TableCellRenderer renderer = columnExt.getHeaderRenderer();
        if (renderer == null && (header2 = table2.getTableHeader()) != null) {
            renderer = header2.getDefaultRenderer();
        }
        return renderer;
    }

    public void packColumn(JXTable table2, TableColumnExt columnExt, int margin, int max) {
        if (!columnExt.isVisible()) {
            throw new IllegalStateException("column must be visible to pack");
        }
        int column2 = table2.convertColumnIndexToView(columnExt.getModelIndex());
        int width = 0;
        TableCellRenderer headerRenderer = this.getHeaderRenderer(table2, columnExt);
        if (headerRenderer != null) {
            Component comp = headerRenderer.getTableCellRendererComponent(table2, columnExt.getHeaderValue(), false, false, 0, column2);
            width = comp.getPreferredSize().width;
        }
        TableCellRenderer renderer = this.getCellRenderer(table2, columnExt);
        for (int r2 = 0; r2 < this.getRowCount(table2); ++r2) {
            Component comp = table2.prepareRenderer(renderer, r2, column2);
            width = Math.max(width, comp.getPreferredSize().width);
        }
        if (margin < 0) {
            margin = this.getDefaultPackMargin();
        }
        if (max != -1 && (width += 2 * margin) > max) {
            width = max;
        }
        columnExt.setPreferredWidth(width);
    }

    protected int getRowCount(JXTable table2) {
        return table2.getRowCount();
    }

    public int getDefaultPackMargin() {
        return this.packMargin;
    }

    public void setDefaultPackMargin(int margin) {
        this.packMargin = margin;
    }
}

