/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.treetable;

import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import java.util.logging.Logger;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.tree.TreeCellRenderer;

public class TreeTableCellEditor
extends DefaultCellEditor {
    private static final Logger LOG = Logger.getLogger(TreeTableCellEditor.class.getName());
    private final JTree tree;

    public TreeTableCellEditor(JTree tree) {
        super(new TreeTableTextField());
        if (tree == null) {
            throw new IllegalArgumentException("null tree");
        }
        this.tree = tree;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table2, Object value, boolean isSelected, int row, int column2) {
        Component component = super.getTableCellEditorComponent(table2, value, isSelected, row, column2);
        this.initEditorOffset(table2, row, column2, isSelected);
        return component;
    }

    protected void initEditorOffset(JTable table2, int row, int column2, boolean isSelected) {
        if (this.tree == null) {
            return;
        }
        Object node = this.tree.getPathForRow(row).getLastPathComponent();
        boolean leaf = this.tree.getModel().isLeaf(node);
        boolean expanded = this.tree.isExpanded(row);
        TreeCellRenderer tcr = this.tree.getCellRenderer();
        Component editorComponent = tcr.getTreeCellRendererComponent(this.tree, node, isSelected, expanded, leaf, row, false);
        ((TreeTableTextField)this.getComponent()).init(row, column2, table2, this.tree, editorComponent);
    }

    @Override
    public boolean isCellEditable(EventObject e2) {
        if (e2 instanceof MouseEvent) {
            return ((MouseEvent)e2).getClickCount() >= this.clickCountToStart;
        }
        return true;
    }

    static class TreeTableTextField
    extends JTextField {
        private int iconWidth;
        private int column;
        private int row;
        private JTable table;
        private JTree tree;

        TreeTableTextField() {
        }

        void init(int row, int column2, JTable table2, JTree tree, Component editorComponent) {
            this.column = column2;
            this.row = row;
            this.table = table2;
            this.tree = tree;
            this.updateIconWidth(editorComponent);
            this.setComponentOrientation(table2.getComponentOrientation());
        }

        private void updateIconWidth(Component treeComponent) {
            this.iconWidth = 0;
            if (!(treeComponent instanceof JLabel)) {
                return;
            }
            Icon icon = ((JLabel)treeComponent).getIcon();
            if (icon != null) {
                this.iconWidth = icon.getIconWidth() + ((JLabel)treeComponent).getIconTextGap();
            }
        }

        @Override
        public void reshape(int x2, int y2, int width, int height) {
            Rectangle cellRect = this.table.getCellRect(0, this.column, false);
            Rectangle nodeRect = this.tree.getRowBounds(this.row);
            nodeRect.width -= this.iconWidth;
            if (this.table.getComponentOrientation().isLeftToRight()) {
                int nodeStart = cellRect.x + nodeRect.x + this.iconWidth;
                int nodeEnd = cellRect.x + cellRect.width;
                super.reshape(nodeStart, y2, nodeEnd - nodeStart, height);
            } else {
                int nodeRightX = nodeRect.x + nodeRect.width;
                nodeRect.x = 0;
                width = nodeRightX - nodeRect.x;
                super.reshape(cellRect.x + nodeRect.x, y2, width, height);
            }
        }
    }
}

