/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.helper;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpHeaders;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import org.jsoup.Connection;
import org.jsoup.helper.AuthenticationHandler;
import org.jsoup.helper.CookieUtil;
import org.jsoup.helper.HttpClientExecutor;
import org.jsoup.helper.HttpConnection;
import org.jsoup.helper.RequestAuthenticator;
import org.jsoup.helper.RequestExecutor;
import org.jspecify.annotations.Nullable;

/*
 * Exception performing whole class analysis ignored.
 */
class HttpClientExecutor
extends RequestExecutor {
    static ThreadLocal<Proxy> perRequestProxy = new ThreadLocal();
    @Nullable HttpResponse<InputStream> hRes;

    public HttpClientExecutor(HttpConnection.Request request, @Nullable HttpConnection.Response previousResponse) {
        super(request, previousResponse);
    }

    HttpClient client() {
        if (this.req.connection.client != null) {
            HttpClient client2 = (HttpClient)this.req.connection.client;
            boolean reuse = true;
            RequestAuthenticator prevAuth = this.req.connection.lastAuth;
            this.req.connection.lastAuth = this.req.authenticator;
            if (prevAuth != this.req.authenticator) {
                reuse = false;
            }
            if (this.req.sslContext != null && client2.sslContext() != this.req.sslContext) {
                reuse = false;
            }
            if (reuse) {
                return client2;
            }
        }
        HttpClient.Builder builder = HttpClient.newBuilder();
        builder.followRedirects(HttpClient.Redirect.NEVER);
        builder.proxy((ProxySelector)new ProxyWrap());
        if (this.req.authenticator != null) {
            builder.authenticator(new AuthenticationHandler(this.req.authenticator));
        }
        if (this.req.sslContext != null) {
            builder.sslContext(this.req.sslContext);
        }
        HttpClient client3 = builder.build();
        this.req.connection.client = client3;
        return client3;
    }

    @Override
    HttpConnection.Response execute() throws IOException {
        try {
            HttpRequest.Builder reqBuilder = HttpRequest.newBuilder(this.req.url.toURI()).method(this.req.method.name(), HttpClientExecutor.requestBody((HttpConnection.Request)this.req));
            if (this.req.timeout() > 0) {
                reqBuilder.timeout(Duration.ofMillis(this.req.timeout()));
            }
            CookieUtil.applyCookiesToRequest(this.req, reqBuilder::header);
            this.req.multiHeaders().forEach((key, values) -> values.forEach(value -> reqBuilder.header((String)key, (String)value)));
            if (this.req.proxy() != null) {
                perRequestProxy.set(this.req.proxy());
            }
            HttpRequest hReq = reqBuilder.build();
            HttpClient client2 = this.client();
            this.hRes = client2.send(hReq, HttpResponse.BodyHandlers.ofInputStream());
            HttpHeaders headers2 = this.hRes.headers();
            HttpConnection.Response res2 = new HttpConnection.Response(this.req);
            res2.executor = this;
            res2.method = Connection.Method.valueOf(this.hRes.request().method());
            res2.url = this.hRes.uri().toURL();
            res2.statusCode = this.hRes.statusCode();
            res2.statusMessage = HttpClientExecutor.StatusMessage((int)res2.statusCode);
            res2.contentType = headers2.firstValue("content-type").orElse("");
            long length = headers2.firstValueAsLong("content-length").orElse(-1L);
            res2.contentLength = length < Integer.MAX_VALUE ? (int)length : -1;
            res2.prepareResponse(headers2.map(), this.prevRes);
            HttpConnection.Response response = res2;
            return response;
        }
        catch (IOException e2) {
            this.safeClose();
            throw e2;
        }
        catch (InterruptedException e3) {
            this.safeClose();
            Thread.currentThread().interrupt();
            throw new IOException(e3);
        }
        catch (URISyntaxException e4) {
            throw new IllegalArgumentException("Malformed URL: " + String.valueOf(this.req.url), e4);
        }
        finally {
            perRequestProxy.remove();
        }
    }

    static String StatusMessage(int statusCode) {
        if (statusCode < 400) {
            return "OK";
        }
        if (statusCode == 404) {
            return "Not Found";
        }
        return "Error " + statusCode;
    }

    @Override
    InputStream responseBody() throws IOException {
        if (this.hRes == null) {
            throw new IllegalStateException("Not yet executed");
        }
        return (InputStream)this.hRes.body();
    }

    @Override
    void safeClose() {
        if (this.hRes != null) {
            InputStream body2 = (InputStream)this.hRes.body();
            if (body2 != null) {
                try {
                    body2.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.hRes = null;
        }
    }

    static HttpRequest.BodyPublisher requestBody(HttpConnection.Request req) throws IOException {
        if (req.method.hasBody()) {
            ByteArrayOutputStream buf = new ByteArrayOutputStream();
            HttpConnection.Response.writePost(req, buf);
            return HttpRequest.BodyPublishers.ofByteArray(buf.toByteArray());
        }
        return HttpRequest.BodyPublishers.noBody();
    }
}

