/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.nodes;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import org.jsoup.helper.Validate;
import org.jsoup.internal.Normalizer;
import org.jsoup.internal.QuietAppendable;
import org.jsoup.internal.StringUtil;
import org.jsoup.nodes.Attributes;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Entities;
import org.jsoup.nodes.Range;
import org.jspecify.annotations.Nullable;

public class Attribute
implements Map.Entry<String, String>,
Cloneable {
    private static final String[] booleanAttributes = new String[]{"allowfullscreen", "async", "autofocus", "checked", "compact", "declare", "default", "defer", "disabled", "formnovalidate", "hidden", "inert", "ismap", "itemscope", "multiple", "muted", "nohref", "noresize", "noshade", "novalidate", "nowrap", "open", "readonly", "required", "reversed", "seamless", "selected", "sortable", "truespeed", "typemustmatch"};
    private String key;
    private @Nullable String val;
    @Nullable Attributes parent;
    private static final Pattern xmlKeyReplace = Pattern.compile("[^-a-zA-Z0-9_:.]+");
    private static final Pattern htmlKeyReplace = Pattern.compile("[\\x00-\\x1f\\x7f-\\x9f \"'/=]+");

    public Attribute(String key, @Nullable String value) {
        this(key, value, null);
    }

    public Attribute(String key, @Nullable String val, @Nullable Attributes parent) {
        Validate.notNull(key);
        key = key.trim();
        Validate.notEmpty(key);
        this.key = key;
        this.val = val;
        this.parent = parent;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        int i2;
        Validate.notNull(key);
        key = key.trim();
        Validate.notEmpty(key);
        if (this.parent != null && (i2 = this.parent.indexOfKey(this.key)) != -1) {
            String oldKey = this.parent.keys[i2];
            this.parent.keys[i2] = key;
            Map<String, Range.AttributeRange> ranges = this.parent.getRanges();
            if (ranges != null) {
                Range.AttributeRange range = ranges.remove(oldKey);
                ranges.put(key, range);
            }
        }
        this.key = key;
    }

    @Override
    public String getValue() {
        return Attributes.checkNotNull(this.val);
    }

    public boolean hasDeclaredValue() {
        return this.val != null;
    }

    @Override
    public String setValue(@Nullable String val) {
        int i2;
        String oldVal = this.val;
        if (this.parent != null && (i2 = this.parent.indexOfKey(this.key)) != -1) {
            oldVal = this.parent.get(this.key);
            this.parent.vals[i2] = val;
        }
        this.val = val;
        return Attributes.checkNotNull(oldVal);
    }

    public String prefix() {
        int pos = this.key.indexOf(58);
        if (pos == -1) {
            return "";
        }
        return this.key.substring(0, pos);
    }

    public String localName() {
        int pos = this.key.indexOf(58);
        if (pos == -1) {
            return this.key;
        }
        return this.key.substring(pos + 1);
    }

    public String namespace() {
        String ns;
        if (this.parent != null && (ns = (String)this.parent.userData("jsoup.xmlns-" + this.prefix())) != null) {
            return ns;
        }
        return "";
    }

    public String html() {
        StringBuilder sb = StringUtil.borrowBuilder();
        this.html(QuietAppendable.wrap(sb), new Document.OutputSettings());
        return StringUtil.releaseBuilder(sb);
    }

    public Range.AttributeRange sourceRange() {
        if (this.parent == null) {
            return Range.AttributeRange.UntrackedAttr;
        }
        return this.parent.sourceRange(this.key);
    }

    void html(QuietAppendable accum, Document.OutputSettings out) {
        Attribute.html(this.key, this.val, accum, out);
    }

    static void html(String key, @Nullable String val, QuietAppendable accum, Document.OutputSettings out) {
        if ((key = Attribute.getValidKey(key, out.syntax())) == null) {
            return;
        }
        Attribute.htmlNoValidate(key, val, accum, out);
    }

    @Deprecated
    protected void html(Appendable accum, Document.OutputSettings out) throws IOException {
        Attribute.html(this.key, this.val, accum, out);
    }

    @Deprecated
    protected static void html(String key, @Nullable String val, Appendable accum, Document.OutputSettings out) throws IOException {
        Attribute.html(key, val, QuietAppendable.wrap(accum), out);
    }

    static void htmlNoValidate(String key, @Nullable String val, QuietAppendable accum, Document.OutputSettings out) {
        accum.append(key);
        if (!Attribute.shouldCollapseAttribute(key, val, out)) {
            accum.append("=\"");
            Entities.escape(accum, Attributes.checkNotNull(val), out, 2);
            accum.append('\"');
        }
    }

    public static @Nullable String getValidKey(String key, Document.OutputSettings.Syntax syntax) {
        if (syntax == Document.OutputSettings.Syntax.xml && !Attribute.isValidXmlKey(key)) {
            return Attribute.isValidXmlKey(key = xmlKeyReplace.matcher(key).replaceAll("_")) ? key : null;
        }
        if (syntax == Document.OutputSettings.Syntax.html && !Attribute.isValidHtmlKey(key)) {
            return Attribute.isValidHtmlKey(key = htmlKeyReplace.matcher(key).replaceAll("_")) ? key : null;
        }
        return key;
    }

    private static boolean isValidXmlKey(String key) {
        int length = key.length();
        if (length == 0) {
            return false;
        }
        char c2 = key.charAt(0);
        if (!(c2 >= 'a' && c2 <= 'z' || c2 >= 'A' && c2 <= 'Z' || c2 == '_' || c2 == ':')) {
            return false;
        }
        for (int i2 = 1; i2 < length; ++i2) {
            c2 = key.charAt(i2);
            if (c2 >= 'a' && c2 <= 'z' || c2 >= 'A' && c2 <= 'Z' || c2 >= '0' && c2 <= '9' || c2 == '-' || c2 == '_' || c2 == ':' || c2 == '.') continue;
            return false;
        }
        return true;
    }

    private static boolean isValidHtmlKey(String key) {
        int length = key.length();
        if (length == 0) {
            return false;
        }
        for (int i2 = 0; i2 < length; ++i2) {
            char c2 = key.charAt(i2);
            if (c2 > '\u001f' && (c2 < '\u007f' || c2 > '\u009f') && c2 != ' ' && c2 != '\"' && c2 != '\'' && c2 != '/' && c2 != '=') continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return this.html();
    }

    public static Attribute createFromEncoded(String unencodedKey, String encodedValue) {
        String value = Entities.unescape(encodedValue, true);
        return new Attribute(unencodedKey, value, null);
    }

    protected boolean isDataAttribute() {
        return Attribute.isDataAttribute(this.key);
    }

    protected static boolean isDataAttribute(String key) {
        return key.startsWith("data-") && key.length() > "data-".length();
    }

    @Deprecated
    protected final boolean shouldCollapseAttribute(Document.OutputSettings out) {
        return Attribute.shouldCollapseAttribute(this.key, this.val, out);
    }

    protected static boolean shouldCollapseAttribute(String key, @Nullable String val, Document.OutputSettings out) {
        return out.syntax() == Document.OutputSettings.Syntax.html && (val == null || (val.isEmpty() || val.equalsIgnoreCase(key)) && Attribute.isBooleanAttribute(key));
    }

    public static boolean isBooleanAttribute(String key) {
        return Arrays.binarySearch(booleanAttributes, Normalizer.lowerCase(key)) >= 0;
    }

    @Override
    public boolean equals(@Nullable Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        Attribute attribute = (Attribute)o2;
        return Objects.equals(this.key, attribute.key) && Objects.equals(this.val, attribute.val);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.key, this.val);
    }

    public Attribute clone() {
        try {
            return (Attribute)super.clone();
        }
        catch (CloneNotSupportedException e2) {
            throw new RuntimeException(e2);
        }
    }
}

