/*
 * Decompiled with CFR 0.152.
 */
package org.snakeyaml.engine.v2.api;

import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import org.snakeyaml.engine.v2.api.DumpSettings;
import org.snakeyaml.engine.v2.api.StreamDataWriter;
import org.snakeyaml.engine.v2.api.StreamToStringWriter;
import org.snakeyaml.engine.v2.emitter.Emitter;
import org.snakeyaml.engine.v2.nodes.Node;
import org.snakeyaml.engine.v2.representer.BaseRepresenter;
import org.snakeyaml.engine.v2.representer.StandardRepresenter;
import org.snakeyaml.engine.v2.serializer.Serializer;

public class Dump {
    protected DumpSettings settings;
    protected BaseRepresenter representer;

    public Dump(DumpSettings settings2) {
        this(settings2, new StandardRepresenter(settings2));
    }

    public Dump(DumpSettings settings2, BaseRepresenter representer) {
        Objects.requireNonNull(settings2, "DumpSettings cannot be null");
        Objects.requireNonNull(representer, "Representer cannot be null");
        this.settings = settings2;
        this.representer = representer;
    }

    public void dumpAll(Iterator<? extends Object> instancesIterator, StreamDataWriter streamDataWriter) {
        Objects.requireNonNull(instancesIterator, "Iterator cannot be null");
        Objects.requireNonNull(streamDataWriter, "StreamDataWriter cannot be null");
        Serializer serializer2 = new Serializer(this.settings, new Emitter(this.settings, streamDataWriter));
        serializer2.emitStreamStart();
        while (instancesIterator.hasNext()) {
            Object instance = instancesIterator.next();
            Node node = this.representer.represent(instance);
            serializer2.serializeDocument(node);
        }
        serializer2.emitStreamEnd();
    }

    public void dump(Object yaml, StreamDataWriter streamDataWriter) {
        Iterator<Object> iter = Collections.singleton(yaml).iterator();
        this.dumpAll(iter, streamDataWriter);
    }

    public String dumpAllToString(Iterator<? extends Object> instancesIterator) {
        StreamToStringWriter writer = new StreamToStringWriter();
        this.dumpAll(instancesIterator, writer);
        return writer.toString();
    }

    public String dumpToString(Object yaml) {
        StreamToStringWriter writer = new StreamToStringWriter();
        this.dump(yaml, writer);
        return writer.toString();
    }

    public void dumpNode(Node node, StreamDataWriter streamDataWriter) {
        Objects.requireNonNull(node, "Node cannot be null");
        Objects.requireNonNull(streamDataWriter, "StreamDataWriter cannot be null");
        Serializer serializer2 = new Serializer(this.settings, new Emitter(this.settings, streamDataWriter));
        serializer2.emitStreamStart();
        serializer2.serializeDocument(node);
        serializer2.emitStreamEnd();
    }
}

