/*
 * Decompiled with CFR 0.152.
 */
package org.snakeyaml.engine.v2.constructor.core;

import java.math.BigInteger;
import org.snakeyaml.engine.v2.constructor.ConstructScalar;
import org.snakeyaml.engine.v2.exceptions.ConstructorException;
import org.snakeyaml.engine.v2.nodes.Node;

public class ConstructYamlCoreInt
extends ConstructScalar {
    private static final int[][] RADIX_MAX;

    private static int maxLen(int max, int radix2) {
        return Integer.toString(max, radix2).length();
    }

    private static int maxLen(long max, int radix2) {
        return Long.toString(max, radix2).length();
    }

    protected static Number createLongOrBigInteger(String number, int radix2) {
        try {
            return Long.valueOf(number, radix2);
        }
        catch (NumberFormatException e1) {
            return new BigInteger(number, radix2);
        }
    }

    @Override
    public Object construct(Node node) {
        String value = this.constructScalar(node);
        if (value.isEmpty()) {
            throw new ConstructorException("while constructing an int", node.getStartMark(), "found empty value", node.getStartMark());
        }
        return this.createIntNumber(value);
    }

    public Object createIntNumber(String value) {
        int base2;
        int sign2 = 1;
        char first2 = value.charAt(0);
        if (first2 == '-') {
            sign2 = -1;
            value = value.substring(1);
        } else if (first2 == '+') {
            value = value.substring(1);
        }
        if ("0".equals(value)) {
            return 0;
        }
        if (value.startsWith("0x")) {
            value = value.substring(2);
            base2 = 16;
        } else if (value.startsWith("0o")) {
            value = value.substring(2);
            base2 = 8;
        } else {
            return this.createNumber(sign2, value, 10);
        }
        return this.createNumber(sign2, value, base2);
    }

    private Number createNumber(int sign2, String number, int radix2) {
        Number result2;
        int[] maxArr;
        int len;
        int n2 = len = number != null ? number.length() : 0;
        if (sign2 < 0) {
            number = "-" + number;
        }
        int[] nArray = maxArr = radix2 < RADIX_MAX.length ? RADIX_MAX[radix2] : null;
        if (maxArr != null) {
            boolean gtInt;
            boolean bl2 = gtInt = len > maxArr[0];
            if (gtInt) {
                if (len > maxArr[1]) {
                    return new BigInteger(number, radix2);
                }
                return ConstructYamlCoreInt.createLongOrBigInteger(number, radix2);
            }
        }
        try {
            result2 = Integer.valueOf(number, radix2);
        }
        catch (NumberFormatException e2) {
            result2 = ConstructYamlCoreInt.createLongOrBigInteger(number, radix2);
        }
        return result2;
    }

    static {
        int[] radixList;
        RADIX_MAX = new int[17][2];
        for (int radix2 : radixList = new int[]{8, 10, 16}) {
            ConstructYamlCoreInt.RADIX_MAX[radix2] = new int[]{ConstructYamlCoreInt.maxLen(Integer.MAX_VALUE, radix2), ConstructYamlCoreInt.maxLen(Long.MAX_VALUE, radix2)};
        }
    }
}

