/*
 * Decompiled with CFR 0.152.
 */
package org.snakeyaml.engine.v2.resolver;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.snakeyaml.engine.v2.nodes.Tag;
import org.snakeyaml.engine.v2.resolver.ResolverTuple;
import org.snakeyaml.engine.v2.resolver.ScalarResolver;

public abstract class BaseScalarResolver
implements ScalarResolver {
    public static final Pattern EMPTY = Pattern.compile("^$");
    public static final Pattern ENV_FORMAT = Pattern.compile("^\\$\\{\\s*(?:(\\w+)(?:(:?[-?])(\\w+)?)?)\\s*\\}$");
    protected Map<Character, List<ResolverTuple>> yamlImplicitResolvers = new HashMap<Character, List<ResolverTuple>>();

    public BaseScalarResolver() {
        this.addImplicitResolvers();
    }

    public void addImplicitResolver(Tag tag, Pattern regexp, String first2) {
        if (first2 == null) {
            List curr = this.yamlImplicitResolvers.computeIfAbsent(null, c2 -> new ArrayList());
            curr.add(new ResolverTuple(tag, regexp));
        } else {
            char[] chrs = first2.toCharArray();
            int j2 = chrs.length;
            for (int i2 = 0; i2 < j2; ++i2) {
                List<ResolverTuple> curr;
                Character theC = Character.valueOf(chrs[i2]);
                if (theC.charValue() == '\u0000') {
                    theC = null;
                }
                if ((curr = this.yamlImplicitResolvers.get(theC)) == null) {
                    curr = new ArrayList<ResolverTuple>();
                    this.yamlImplicitResolvers.put(theC, curr);
                }
                curr.add(new ResolverTuple(tag, regexp));
            }
        }
    }

    abstract void addImplicitResolvers();

    @Override
    public Tag resolve(String value, Boolean implicit) {
        Pattern regexp;
        Tag tag;
        if (!implicit.booleanValue()) {
            return Tag.STR;
        }
        List<ResolverTuple> resolvers = value.isEmpty() ? this.yamlImplicitResolvers.get(Character.valueOf('\u0000')) : this.yamlImplicitResolvers.get(Character.valueOf(value.charAt(0)));
        if (resolvers != null) {
            for (ResolverTuple v2 : resolvers) {
                tag = v2.getTag();
                regexp = v2.getRegexp();
                if (!regexp.matcher(value).matches()) continue;
                return tag;
            }
        }
        if (this.yamlImplicitResolvers.containsKey(null)) {
            for (ResolverTuple v2 : this.yamlImplicitResolvers.get(null)) {
                tag = v2.getTag();
                regexp = v2.getRegexp();
                if (!regexp.matcher(value).matches()) continue;
                return tag;
            }
        }
        return Tag.STR;
    }
}

