/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.sshAgentProxy;

import com.intellij.community.wintools.ErrorToolsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.codeWithMe.model.SshRequesterProcessInfo;
import com.jetbrains.rdserver.actions.ActionTimestamp;
import com.jetbrains.rdserver.portForwarding.utils.ProcessInfoUtil;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpc;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpcService;
import com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.win32.W32APIOptions;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 '2\u00020\u0001:\u0005&'()*B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J\b\u0010#\u001a\u00020\u0012H\u0002J\b\u0010$\u001a\u00020\u0012H\u0016J\b\u0010%\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0016R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\u00020\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u0006+"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc;", "pipePath", "", "WindowsNamedPipeAgentIpc", "(Ljava/lang/String;)V", "key", "getKey", "()Ljava/lang/String;", "hPipe", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lock", "", "connectionThread", "Ljava/lang/Thread;", "state", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "assertConnectionThread", "", "open", "isOpen", "", "()Z", "accept", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc$Streams;", "getRequesterPid", "", "isSshProcess", "process", "Lcom/jetbrains/rdserver/portForwarding/utils/ProcessInfoUtil$ProcessInfo;", "requestorProcessValue", "Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "requesterProcessInfo", "getRequesterProcessInfo", "()Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "disconnect", "close", "cleanup", "NamedPipeState", "Companion", "Kernel32Ex", "PipeReadableByteChannel", "PipeWritableByteChannel", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n1#2:392\n23#3:393\n23#3:394\n23#3:395\n23#3:396\n23#3:397\n23#3:398\n23#3:399\n23#3:400\n23#3:401\n23#3:402\n23#3:403\n23#3:404\n23#3:405\n23#3:406\n23#3:407\n23#3:408\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n*L\n131#1:393\n142#1:394\n151#1:395\n161#1:396\n179#1:397\n203#1:398\n208#1:399\n228#1:400\n236#1:401\n238#1:402\n249#1:403\n264#1:404\n274#1:405\n284#1:406\n288#1:407\n290#1:408\n*E\n"})
public final class WindowsNamedPipeAgentIpc
extends SshAgentIpc {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final String pipePath;
    @NotNull
    private final String key;
    @NotNull
    private WinNT.HANDLE hPipe;
    @NotNull
    private final Object lock;
    @Nullable
    private Thread connectionThread;
    @NotNull
    private NamedPipeState state;
    @NotNull
    private SshRequesterProcessInfo requestorProcessValue;
    private static final String[] c;
    private static final String[] d;

    public WindowsNamedPipeAgentIpc(@NotNull String pipePath) {
        long l2 = 82852850079676L;
        Intrinsics.checkNotNullParameter((Object)pipePath, (String)WindowsNamedPipeAgentIpc.b(1364045490 - 31579, 1364045490 - (char)-24026, (int)l2));
        this.key = this.pipePath = pipePath;
        WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
        Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(1364045490 - 31580, -1364045490 - -((char)-30507), (int)l2));
        this.hPipe = hANDLE;
        this.lock = new Object();
        this.state = NamedPipeState.Initial;
        this.requestorProcessValue = SshAgentIpc.Companion.getMissingProcessInfo();
    }

    @Override
    @NotNull
    public String getKey() {
        return this.key;
    }

    private final void assertConnectionThread() {
        block3: {
            boolean bl;
            Thread thread;
            long l2;
            block2: {
                l2 = 66004838138960L;
                thread = Thread.currentThread();
                ActionTimestamp[] actionTimestampArray = SshAgentIpcService.d();
                try {
                    bl = Intrinsics.areEqual((Object)thread, (Object)this.connectionThread);
                    if (actionTimestampArray != null) break block2;
                    if (bl) break block3;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                bl = false;
            }
            boolean bl2 = bl;
            Thread thread2 = thread;
            Thread thread3 = this.connectionThread;
            String string = this.pipePath;
            String string2 = WindowsNamedPipeAgentIpc.b(219280110 - 4661, -219280110 - -26059, (int)l2) + string + WindowsNamedPipeAgentIpc.b(219280110 - 4662, -219280110 - -20289, (int)l2) + thread3 + WindowsNamedPipeAgentIpc.b(219280110 - 4655, -219280110 - -3262, (int)l2) + thread2;
            throw new IllegalArgumentException(string2.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() {
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        long l2;
        block14: {
            block15: {
                ActionTimestamp[] actionTimestampArray;
                l2 = 36025854601048L;
                Object object = this.lock;
                synchronized (object) {
                    boolean bl;
                    actionTimestampArray = SshAgentIpcService.d();
                    boolean bl2 = false;
                    try {
                        bl = this.connectionThread == null;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl3 = false;
                        String string = WindowsNamedPipeAgentIpc.b(331082820 - 26766, 331082820 - 23481, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(331082820 - 26767, -331082820 - -15473, (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.connectionThread = Thread.currentThread();
                    Unit unit = Unit.INSTANCE;
                }
                try {
                    try {
                        WinNT.HANDLE hANDLE = Kernel32.INSTANCE.CreateNamedPipe(this.pipePath, 3, 0, 1, 16384, 16384, 0, null);
                        Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(331082820 - 26768, 331082820 - 16768, (int)l2));
                        this.hPipe = hANDLE;
                        windowsNamedPipeAgentIpc = this;
                        if (actionTimestampArray != null) break block14;
                        if (Intrinsics.areEqual((Object)windowsNamedPipeAgentIpc.hPipe, (Object)WinNT.INVALID_HANDLE_VALUE)) {
                        }
                        break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    throw new RuntimeException(WindowsNamedPipeAgentIpc.b(331082820 - 26761, 331082820 - 11209, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(331082820 - 26762, 331082820 - 10446, (int)l2) + ErrorToolsKt.kernel32LastError());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            this.state = NamedPipeState.Open;
            windowsNamedPipeAgentIpc = this;
        }
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = windowsNamedPipeAgentIpc;
        boolean bl = false;
        try {
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(331082820 - 26763, 331082820 - 13663, (int)l2));
            logger.info(WindowsNamedPipeAgentIpc.b(331082820 - 26761, 331082820 - 11209, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(331082820 - 26764, -331082820 + -1228, (int)l2));
            if (ActionTimestamp.c() != 0) {
                SshAgentIpcService.d(new ActionTimestamp[4]);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
        }
    }

    @Override
    public boolean isOpen() {
        int n2;
        block8: {
            block7: {
                ActionTimestamp[] actionTimestampArray;
                block6: {
                    long l2 = 13728100214597L;
                    actionTimestampArray = SshAgentIpcService.d();
                    try {
                        try {
                            n2 = this.state.compareTo((Enum)NamedPipeState.Open);
                            if (actionTimestampArray != null) break block6;
                            if (n2 < 0) break block7;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = this.state.compareTo((Enum)NamedPipeState.Disconnecting);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                try {
                    if (actionTimestampArray != null) break block8;
                    if (n2 > 0) break block7;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                n2 = 1;
                break block8;
            }
            n2 = 0;
        }
        return n2 != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    @NotNull
    public SshAgentIpc.Streams accept() {
        Object object;
        Object object2;
        ActionTimestamp[] actionTimestampArray;
        long l2;
        block25: {
            block26: {
                l2 = 25415760296726L;
                ActionTimestamp[] actionTimestampArray2 = SshAgentIpcService.d();
                this.assertConnectionThread();
                actionTimestampArray = actionTimestampArray2;
                Object object3 = this.lock;
                synchronized (object3) {
                    boolean bl;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block23: {
                        block24: {
                            boolean bl2 = false;
                            try {
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Closing;
                                if (actionTimestampArray != null) break block23;
                                if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block24;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                            boolean bl3 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1856213340 - (char)-3733, -1856213340 - -((char)-8814), (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(1856213340 - (char)-3737, 1856213340 - (char)-19161, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1856213340 - (char)-3732, -1856213340 - -((char)-1564), (int)l2) + this.state);
                            throw new ClosedChannelException();
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Open;
                    }
                    try {
                        bl = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl4 = false;
                        String string = WindowsNamedPipeAgentIpc.b(1856213340 - (char)-3737, 1856213340 - (char)-19161, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1856213340 - (char)-3735, 1856082270 + (char)-2132, (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.state = NamedPipeState.Connecting;
                    Unit unit = Unit.INSTANCE;
                }
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                boolean bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1856213340 - (char)-3733, -1856213340 - -((char)-8814), (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(1856213340 - (char)-3737, 1856213340 - (char)-19161, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1856213340 - (char)-3734, -1856213340 - -((char)-16300), (int)l2));
                    object2 = Kernel32.INSTANCE;
                    if (actionTimestampArray != null) break block25;
                    if (object2.ConnectNamedPipe(this.hPipe, null)) break block26;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                int n2 = Kernel32.INSTANCE.GetLastError();
                if (n2 == 535) {
                    WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                    boolean bl5 = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1856213340 - (char)-3733, -1856213340 - -((char)-8814), (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(1856213340 - (char)-3737, 1856213340 - (char)-19161, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1856213340 - (char)-3729, 1856213340 - (char)-9111, (int)l2));
                } else {
                    throw new IllegalStateException((WindowsNamedPipeAgentIpc.b(1856213340 - (char)-3737, 1856213340 - (char)-19161, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1856213340 - (char)-3728, 1856213340 - (char)-17352, (int)l2) + ErrorToolsKt.prettyHRESULT((int)n2)).toString());
                }
            }
            object2 = this.lock;
        }
        Kernel32 kernel32 = object2;
        synchronized (kernel32) {
            boolean bl;
            NamedPipeState namedPipeState;
            NamedPipeState namedPipeState3;
            block27: {
                block28: {
                    boolean bl6 = false;
                    namedPipeState3 = this.state;
                    namedPipeState = NamedPipeState.Closing;
                    if (actionTimestampArray != null) break block27;
                    try {
                        block29: {
                            if (namedPipeState3.compareTo((Enum)namedPipeState) < 0) break block28;
                            break block29;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                namedPipeState3 = this.state;
                namedPipeState = NamedPipeState.Connecting;
            }
            try {
                bl = namedPipeState3 == namedPipeState;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
            }
            if (!bl) {
                boolean bl7 = false;
                String string = WindowsNamedPipeAgentIpc.b(1856213340 - (char)-3737, 1856213340 - (char)-19161, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1856213340 - (char)-3735, 1856082270 + (char)-2132, (int)l2) + this.state;
                throw new IllegalArgumentException(string.toString());
            }
            this.state = NamedPipeState.Connected;
            object = Unit.INSTANCE;
        }
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
        boolean bl = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1856213340 - (char)-3733, -1856213340 - -((char)-8814), (int)l2));
        logger.info(WindowsNamedPipeAgentIpc.b(1856213340 - (char)-3737, 1856213340 - (char)-19161, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1856213340 - (char)-3731, -1856213340 - -((char)-2499), (int)l2));
        long l3 = this.getRequesterPid();
        this.requestorProcessValue = this.calcRequesterProcessInfo(l3);
        object = new PipeReadableByteChannel(this);
        PipeWritableByteChannel pipeWritableByteChannel = new PipeWritableByteChannel(this);
        SshAgentIpc.Streams streams = new SshAgentIpc.Streams((PipeReadableByteChannel)object, pipeWritableByteChannel, this){
            final /* synthetic */ PipeReadableByteChannel $read;
            final /* synthetic */ PipeWritableByteChannel $write;
            final /* synthetic */ WindowsNamedPipeAgentIpc this$0;
            private static final String[] a;
            private static final String[] b;
            {
                this.$read = $read;
                this.$write = $write;
                this.this$0 = $receiver;
            }

            public InputStream getInputStream() {
                long l2 = 121702976508955L;
                InputStream inputStream = Channels.newInputStream(this.$read);
                Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)accept.3.a(783143250 + (char)-12744, -783143250 + -((char)-20723), (int)l2));
                return inputStream;
            }

            public OutputStream getOutputStream() {
                long l2 = 111074970002970L;
                OutputStream outputStream = Channels.newOutputStream(this.$write);
                Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)accept.3.a(-1474275360 - -((char)-10838), -1474144290 + -((char)-6529), (int)l2));
                return outputStream;
            }

            public void close() {
                WindowsNamedPipeAgentIpc.access$disconnect(this.this$0);
            }

            /*
             * Unable to fully structure code
             */
            static {
                block13: {
                    var5 = new String[2];
                    var3_1 = 0;
                    var2_2 = "\u00b3\u00b6\u00ae'\u0091\u00ba\u00c6\u00ca\u00ee\u00db\u00e7W\u00efl\u000f\u00dd\u00ee\u000f\u00ac\u0014s\u0097\u00b6\u0005\u0089<\u00b8\u009f\u00a3w\u008b\u0016\u00a0\u00bd'l\u0006\u00ff\u00b6s";
                    var4_3 = "\u00b3\u00b6\u00ae'\u0091\u00ba\u00c6\u00ca\u00ee\u00db\u00e7W\u00efl\u000f\u00dd\u00ee\u000f\u00ac\u0014s\u0097\u00b6\u0005\u0089<\u00b8\u009f\u00a3w\u008b\u0016\u00a0\u00bd'l\u0006\u00ff\u00b6s".length();
                    var1_4 = 19;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        continue;
                        break;
                    }
lbl9:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = new String(v0).intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block13;
                        break;
                    }
                    v1 = ++var0_5;
                    v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                    v3 = v2.length;
                    var6_6 = 0;
                    v4 = 30;
                    v5 = v2;
                    v6 = v3;
                    if (v3 > 1) ** GOTO lbl67
                    do {
                        v7 = v4;
                        v5 = v5;
                        v8 = v5;
                        v9 = v4;
                        v10 = var6_6;
                        while (true) {
                            switch (var6_6 % 7) {
                                case 0: {
                                    v11 = 12;
                                    break;
                                }
                                case 1: {
                                    v11 = 13;
                                    break;
                                }
                                case 2: {
                                    v11 = 80;
                                    break;
                                }
                                case 3: {
                                    v11 = 13;
                                    break;
                                }
                                case 4: {
                                    v11 = 100;
                                    break;
                                }
                                case 5: {
                                    v11 = 50;
                                    break;
                                }
                                default: {
                                    v11 = 115;
                                }
                            }
                            v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                            ++var6_6;
                            v4 = v7;
                            if (v7 != 0) break;
                            v7 = v4;
                            v5 = v5;
                            v10 = v4;
                            v8 = v5;
                            v9 = v4;
                        }
lbl67:
                        // 2 sources

                        v0 = v5;
                        v6 = v6;
                    } while (v6 > var6_6);
                    ** while (true)
                }
                accept.3.a = var5;
                accept.3.b = new String[2];
            }

            private static String a(int n2, int n3, int n4) {
                int n5 = (n2 ^ n4 ^ 0x4B91) & 0xFFFF;
                if (b[n5] == null) {
                    int n6;
                    char[] cArray = a[n5].toCharArray();
                    int n7 = switch (cArray[0] & 0xFF) {
                        case 0 -> 140;
                        case 1 -> 71;
                        case 2 -> 32;
                        case 3 -> 150;
                        case 4 -> 102;
                        case 5 -> 180;
                        case 6 -> 79;
                        case 7 -> 116;
                        case 8 -> 202;
                        case 9 -> 141;
                        case 10 -> 255;
                        case 11 -> 91;
                        case 12 -> 168;
                        case 13 -> 130;
                        case 14 -> 206;
                        case 15 -> 26;
                        case 16 -> 95;
                        case 17 -> 129;
                        case 18 -> 244;
                        case 19 -> 105;
                        case 20 -> 238;
                        case 21 -> 153;
                        case 22 -> 212;
                        case 23 -> 111;
                        case 24 -> 18;
                        case 25 -> 6;
                        case 26 -> 49;
                        case 27 -> 209;
                        case 28 -> 226;
                        case 29 -> 217;
                        case 30 -> 120;
                        case 31 -> 52;
                        case 32 -> 146;
                        case 33 -> 139;
                        case 34 -> 252;
                        case 35 -> 131;
                        case 36 -> 101;
                        case 37 -> 56;
                        case 38 -> 20;
                        case 39 -> 155;
                        case 40 -> 154;
                        case 41 -> 104;
                        case 42 -> 109;
                        case 43 -> 160;
                        case 44 -> 193;
                        case 45 -> 248;
                        case 46 -> 106;
                        case 47 -> 249;
                        case 48 -> 122;
                        case 49 -> 237;
                        case 50 -> 80;
                        case 51 -> 118;
                        case 52 -> 24;
                        case 53 -> 16;
                        case 54 -> 92;
                        case 55 -> 147;
                        case 56 -> 177;
                        case 57 -> 97;
                        case 58 -> 67;
                        case 59 -> 245;
                        case 60 -> 136;
                        case 61 -> 85;
                        case 62 -> 190;
                        case 63 -> 31;
                        case 64 -> 51;
                        case 65 -> 110;
                        case 66 -> 189;
                        case 67 -> 204;
                        case 68 -> 224;
                        case 69 -> 1;
                        case 70 -> 125;
                        case 71 -> 65;
                        case 72 -> 64;
                        case 73 -> 171;
                        case 74 -> 113;
                        case 75 -> 142;
                        case 76 -> 12;
                        case 77 -> 75;
                        case 78 -> 208;
                        case 79 -> 3;
                        case 80 -> 78;
                        case 81 -> 228;
                        case 82 -> 247;
                        case 83 -> 127;
                        case 84 -> 230;
                        case 85 -> 195;
                        case 86 -> 161;
                        case 87 -> 163;
                        case 88 -> 11;
                        case 89 -> 99;
                        case 90 -> 182;
                        case 91 -> 27;
                        case 92 -> 211;
                        case 93 -> 47;
                        case 94 -> 58;
                        case 95 -> 167;
                        case 96 -> 124;
                        case 97 -> 54;
                        case 98 -> 60;
                        case 99 -> 4;
                        case 100 -> 15;
                        case 101 -> 8;
                        case 102 -> 231;
                        case 103 -> 48;
                        case 104 -> 185;
                        case 105 -> 234;
                        case 106 -> 200;
                        case 107 -> 253;
                        case 108 -> 164;
                        case 109 -> 117;
                        case 110 -> 126;
                        case 111 -> 69;
                        case 112 -> 94;
                        case 113 -> 40;
                        case 114 -> 37;
                        case 115 -> 169;
                        case 116 -> 143;
                        case 117 -> 72;
                        case 118 -> 199;
                        case 119 -> 7;
                        case 120 -> 22;
                        case 121 -> 218;
                        case 122 -> 242;
                        case 123 -> 14;
                        case 124 -> 44;
                        case 125 -> 93;
                        case 126 -> 19;
                        case 127 -> 232;
                        case 128 -> 220;
                        case 129 -> 215;
                        case 130 -> 151;
                        case 131 -> 89;
                        case 132 -> 41;
                        case 133 -> 148;
                        case 134 -> 9;
                        case 135 -> 222;
                        case 136 -> 57;
                        case 137 -> 119;
                        case 138 -> 156;
                        case 139 -> 59;
                        case 140 -> 137;
                        case 141 -> 74;
                        case 142 -> 229;
                        case 143 -> 128;
                        case 144 -> 36;
                        case 145 -> 165;
                        case 146 -> 30;
                        case 147 -> 17;
                        case 148 -> 34;
                        case 149 -> 55;
                        case 150 -> 174;
                        case 151 -> 239;
                        case 152 -> 221;
                        case 153 -> 63;
                        case 154 -> 10;
                        case 155 -> 181;
                        case 156 -> 251;
                        case 157 -> 86;
                        case 158 -> 42;
                        case 159 -> 0;
                        case 160 -> 197;
                        case 161 -> 235;
                        case 162 -> 103;
                        case 163 -> 133;
                        case 164 -> 145;
                        case 165 -> 68;
                        case 166 -> 21;
                        case 167 -> 176;
                        case 168 -> 96;
                        case 169 -> 28;
                        case 170 -> 205;
                        case 171 -> 25;
                        case 172 -> 149;
                        case 173 -> 132;
                        case 174 -> 62;
                        case 175 -> 33;
                        case 176 -> 35;
                        case 177 -> 152;
                        case 178 -> 219;
                        case 179 -> 192;
                        case 180 -> 157;
                        case 181 -> 66;
                        case 182 -> 246;
                        case 183 -> 39;
                        case 184 -> 135;
                        case 185 -> 201;
                        case 186 -> 73;
                        case 187 -> 173;
                        case 188 -> 50;
                        case 189 -> 23;
                        case 190 -> 216;
                        case 191 -> 225;
                        case 192 -> 175;
                        case 193 -> 134;
                        case 194 -> 223;
                        case 195 -> 233;
                        case 196 -> 123;
                        case 197 -> 198;
                        case 198 -> 187;
                        case 199 -> 158;
                        case 200 -> 166;
                        case 201 -> 138;
                        case 202 -> 178;
                        case 203 -> 81;
                        case 204 -> 82;
                        case 205 -> 112;
                        case 206 -> 240;
                        case 207 -> 115;
                        case 208 -> 172;
                        case 209 -> 107;
                        case 210 -> 207;
                        case 211 -> 170;
                        case 212 -> 5;
                        case 213 -> 236;
                        case 214 -> 159;
                        case 215 -> 241;
                        case 216 -> 179;
                        case 217 -> 250;
                        case 218 -> 214;
                        case 219 -> 76;
                        case 220 -> 29;
                        case 221 -> 183;
                        case 222 -> 98;
                        case 223 -> 108;
                        case 224 -> 61;
                        case 225 -> 70;
                        case 226 -> 203;
                        case 227 -> 45;
                        case 228 -> 243;
                        case 229 -> 53;
                        case 230 -> 121;
                        case 231 -> 88;
                        case 232 -> 77;
                        case 233 -> 191;
                        case 234 -> 43;
                        case 235 -> 87;
                        case 236 -> 213;
                        case 237 -> 196;
                        case 238 -> 188;
                        case 239 -> 227;
                        case 240 -> 210;
                        case 241 -> 114;
                        case 242 -> 84;
                        case 243 -> 162;
                        case 244 -> 184;
                        case 245 -> 194;
                        case 246 -> 46;
                        case 247 -> 90;
                        case 248 -> 38;
                        case 249 -> 100;
                        case 250 -> 186;
                        case 251 -> 144;
                        case 252 -> 254;
                        case 253 -> 83;
                        case 254 -> 2;
                        default -> 13;
                    };
                    int n8 = ((n3 ^= n4) & 0xFF) - n7;
                    if (n8 < 0) {
                        n8 += 256;
                    }
                    if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                        n6 += 256;
                    }
                    int n9 = 0;
                    while (n9 < cArray.length) {
                        int n10 = n9 % 2;
                        int n11 = n9;
                        char[] cArray2 = cArray;
                        char c2 = cArray[n11];
                        if (n10 == 0) {
                            cArray2[n11] = (char)(c2 ^ n8);
                            n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                        } else {
                            cArray2[n11] = (char)(c2 ^ n6);
                            n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                        }
                        ++n9;
                    }
                    accept.3.b[n5] = new String(cArray).intern();
                }
                return b[n5];
            }
        };
        if (actionTimestampArray != null) {
            int n3 = ActionTimestamp.d();
            ActionTimestamp.d(++n3);
        }
        return streams;
    }

    public final long getRequesterPid() {
        long l2;
        block4: {
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            int n2;
            long l3;
            block2: {
                block3: {
                    l3 = 65482919361937L;
                    WinDef.ULONGByReference uLONGByReference = new WinDef.ULONGByReference();
                    ActionTimestamp[] actionTimestampArray = SshAgentIpcService.d();
                    try {
                        n2 = Kernel32.INSTANCE.GetNamedPipeClientProcessId(this.hPipe, uLONGByReference);
                        if (actionTimestampArray != null) break block2;
                        if (n2 == 0) break block3;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    WinDef.ULONG uLONG = uLONGByReference.getValue();
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1847955930 + -21680, 1847955930 + 14551, (int)l3));
                    logger.info(WindowsNamedPipeAgentIpc.b(-1847955930 + -21684, -1847955930 + -4980, (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1847955930 + -21693, 1847955930 + 23729, (int)l3) + uLONG);
                    l2 = uLONGByReference.getValue().longValue();
                    break block4;
                }
                n2 = Kernel32.INSTANCE.GetLastError();
            }
            int n3 = n2;
            windowsNamedPipeAgentIpc = this;
            bl = false;
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1847955930 + -21680, 1847955930 + 14551, (int)l3));
            logger.warn(WindowsNamedPipeAgentIpc.b(-1847955930 + -21684, -1847955930 + -4980, (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1847955930 + -21688, -1847955930 + -10520, (int)l3) + ErrorToolsKt.prettyHRESULT((int)n3));
            l2 = -1L;
        }
        long l4 = l2;
        return l4;
    }

    @Override
    protected boolean isSshProcess(@NotNull ProcessInfoUtil.ProcessInfo process2) {
        boolean bl;
        block14: {
            block12: {
                block15: {
                    String string;
                    Object object;
                    ActionTimestamp[] actionTimestampArray;
                    block13: {
                        long l2 = 84853558004016L;
                        ActionTimestamp[] actionTimestampArray2 = SshAgentIpcService.d();
                        Intrinsics.checkNotNullParameter((Object)process2, (String)WindowsNamedPipeAgentIpc.b(2110882350 - 5216, 2110882350 - 11319, (int)l2));
                        actionTimestampArray = actionTimestampArray2;
                        try {
                            try {
                                try {
                                    try {
                                        if (actionTimestampArray != null || (object = process2.getExecutable()) == null) break block12;
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                    if ((object = object.getFileName()) == null) break block12;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                String string2 = object.toString();
                                string = string2;
                                object = string2;
                                if (actionTimestampArray != null) break block13;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            if (string == null) break block12;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        string = WindowsNamedPipeAgentIpc.b(2110882350 - 5217, 2110882350 - 21715, (int)l2);
                    }
                    try {
                        try {
                            bl = StringsKt.equals((String)object, (String)string, (boolean)true);
                            if (actionTimestampArray != null) break block14;
                            if (!bl) break block15;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        bl = true;
                        break block14;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                bl = false;
                break block14;
            }
            bl = false;
        }
        return bl;
    }

    @Override
    @NotNull
    public SshRequesterProcessInfo getRequesterProcessInfo() {
        return this.requestorProcessValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private final void disconnect() {
        Object object;
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        ActionTimestamp[] actionTimestampArray;
        long l2;
        block25: {
            block26: {
                l2 = 33792182150938L;
                ActionTimestamp[] actionTimestampArray2 = SshAgentIpcService.d();
                this.assertConnectionThread();
                Object object2 = this.lock;
                synchronized (object2) {
                    boolean bl;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block23: {
                        block24: {
                            block21: {
                                block22: {
                                    actionTimestampArray = actionTimestampArray2;
                                    boolean bl2 = false;
                                    namedPipeState2 = this.state;
                                    namedPipeState = NamedPipeState.Closing;
                                    if (actionTimestampArray != null) break block21;
                                    try {
                                        block29: {
                                            if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block22;
                                            break block29;
                                            catch (IllegalArgumentException illegalArgumentException) {
                                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                            }
                                        }
                                        throw new ClosedChannelException();
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                }
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Open;
                            }
                            try {
                                if (actionTimestampArray != null) break block23;
                                if (namedPipeState2 != namedPipeState) break block24;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                            boolean bl3 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(620485380 + (char)-5895, -620616450 - -((char)-5316), (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(620485380 + (char)-5899, 620485380 + (char)-23243, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(620485380 + (char)-5918, -620485380 + -((char)-16879), (int)l2));
                            return;
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Connected;
                    }
                    try {
                        bl = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl4 = false;
                        String string = WindowsNamedPipeAgentIpc.b(620485380 + (char)-5899, 620485380 + (char)-23243, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(620485380 + (char)-5893, 620485380 + (char)-1534, (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.state = NamedPipeState.Disconnecting;
                    Unit unit = Unit.INSTANCE;
                }
                windowsNamedPipeAgentIpc = this;
                boolean bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(620485380 + (char)-5895, -620616450 - -((char)-5316), (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(620485380 + (char)-5899, 620485380 + (char)-23243, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(620485380 + (char)-5915, 620485380 + (char)-13887, (int)l2));
                    object = Kernel32.INSTANCE;
                    if (actionTimestampArray != null) break block25;
                    if (object.DisconnectNamedPipe(this.hPipe)) break block26;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(620485380 + (char)-5895, -620616450 - -((char)-5316), (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(620485380 + (char)-5899, 620485380 + (char)-23243, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(620485380 + (char)-5916, 620616450 - (char)-1023, (int)l2) + ErrorToolsKt.kernel32LastError());
                return;
            }
            object = this.lock;
        }
        Kernel32 kernel32 = object;
        synchronized (kernel32) {
            block27: {
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3;
                block28: {
                    boolean bl = false;
                    windowsNamedPipeAgentIpc3 = this;
                    if (actionTimestampArray != null) break block27;
                    try {
                        block30: {
                            if (windowsNamedPipeAgentIpc3.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block28;
                            break block30;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                windowsNamedPipeAgentIpc3 = this;
            }
            windowsNamedPipeAgentIpc3.state = NamedPipeState.Open;
            Unit unit = Unit.INSTANCE;
        }
        windowsNamedPipeAgentIpc = this;
        boolean bl = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(620485380 + (char)-5895, -620616450 - -((char)-5316), (int)l2));
        logger.info(WindowsNamedPipeAgentIpc.b(620485380 + (char)-5899, 620485380 + (char)-23243, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(620485380 + (char)-5913, 620485380 + (char)-18484, (int)l2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        block17: {
            int n2;
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            long l2;
            block15: {
                ActionTimestamp[] actionTimestampArray;
                block16: {
                    l2 = 59053694026392L;
                    Object object = this.lock;
                    synchronized (object) {
                        block13: {
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2;
                            block14: {
                                actionTimestampArray = SshAgentIpcService.d();
                                boolean bl2 = false;
                                try {
                                    windowsNamedPipeAgentIpc2 = this;
                                    if (actionTimestampArray != null) break block13;
                                    if (windowsNamedPipeAgentIpc2.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block14;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3 = this;
                                boolean bl3 = false;
                                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(2106294900 - 23541, -2106294900 - -30764, (int)l2));
                                logger.info(WindowsNamedPipeAgentIpc.b(2106294900 - 23545, 2106294900 - 7353, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(2106294900 - 23564, -2106294900 - -6570, (int)l2) + this.state + WindowsNamedPipeAgentIpc.b(2106294900 - 23557, -2106294900 - -17357, (int)l2));
                                return;
                            }
                            windowsNamedPipeAgentIpc2 = this;
                        }
                        windowsNamedPipeAgentIpc2.state = NamedPipeState.Closing;
                        Unit unit = Unit.INSTANCE;
                    }
                    WindowsNamedPipeAgentIpc.Companion.connectToPipe(this.pipePath);
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    try {
                        try {
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(2106294900 - 23541, -2106294900 - -30764, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(2106294900 - 23545, 2106294900 - 7353, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(2106294900 - 23558, -2106294900 - -26730, (int)l2));
                            n2 = Kernel32Ex.Companion.getINSTANCE().CancelIoEx(this.hPipe, null);
                            if (actionTimestampArray != null) break block15;
                            if (n2 != 0) break block16;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = Kernel32.INSTANCE.GetLastError();
                        if (actionTimestampArray != null) break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    int n3 = n2;
                    if (n3 != 1168) {
                        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc4 = this;
                        boolean bl4 = false;
                        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(2106294900 - 23541, -2106294900 - -30764, (int)l2));
                        logger.info(WindowsNamedPipeAgentIpc.b(2106294900 - 23545, 2106294900 - 7353, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(2106294900 - 23559, -2106294900 - -11149, (int)l2) + ErrorToolsKt.prettyHRESULT((int)n3));
                    }
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(2106294900 - 23541, -2106294900 - -30764, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(2106294900 - 23545, 2106294900 - 7353, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(2106294900 - 23560, -2106294900 - -30159, (int)l2));
                    if (actionTimestampArray != null) break block17;
                    n2 = Kernel32.INSTANCE.CloseHandle(this.hPipe) ? 1 : 0;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            if (n2 == 0) {
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(2106294900 - 23541, -2106294900 - -30764, (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(2106294900 - 23545, 2106294900 - 7353, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(2106294900 - 23585, -2106294900 - -20099, (int)l2) + ErrorToolsKt.kernel32LastError());
            }
            WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
            Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(2106294900 - 23586, 2106294900 - 26650, (int)l2));
            this.hPipe = hANDLE;
            this.state = NamedPipeState.Closed;
        }
    }

    @Override
    public void cleanup() {
    }

    public static final /* synthetic */ String access$getPipePath$p(WindowsNamedPipeAgentIpc $this) {
        return $this.pipePath;
    }

    /*
     * Unable to fully structure code
     */
    static {
        block20: {
            block19: {
                var5 = new String[34];
                var3_1 = 0;
                var2_2 = "\u00dd\"\u00fd\u001d\u008e\u00e4N\u000b\u0014\u0081\u00a7NJ\u0006\u0086\u00f0]<\u0016\u00f0\u00f0:&o\u00d9P\u0093)\u001d\u0006\u009d\u00a0\u00f5M\u00e5\u00af\u0018U\u009a\u00b4\u00dd\u00db\u00b1I{\u00c3\u00af\u0000\u00b7B12\u00b9R\u00f6G,\u00e4]\u00a4\u0017\t<\u00ae\u0007\u00ea\u00c6\u00c8\u00f2\u001c\u0088\u0005U#\u00ec=\u00dc\b\fg\u00c7\u00c4\u009b\u00f9\u00eaJ\u0014\u00f0\u0081\u0018\u0015\u00a1e1\u00b6j\u00b6\u0091P\\\u0091\u0018\u00c2\u00ac#OI\u00050\u001e@\u009aI\u001e\b\u0097R\u00cf\u00967B\u00d1\u0007\u00ee\u00d3\u0018t\u00e4Vg?\u00bc8\u0091\u00a7\u00c5\u00c0\u00c98\u00aew7\u0012\u00ff\u0010+&\u00d2<\u00d1{\\\u00a1\u00b9R\u0089r9\u00fcP\u00fb\t{\u00959\u009cR!F\u00be\u00f0\u0010K\u0081\u00de\u00c8P\u00e5lr\u00bf(I=!\u0015S\u00c6?\"\u00fe\u001f\u00e22\u009bS(T\u0000\u00fc>.\u00d6 \u001846$\u0005\u00aa\u0005\u001a\u00b7s\u0089\u0013g\u00a9\u00a3\u00faZ\u00e2\u00fb\u00a5\u00ad\u0080\u0016\u001b\u00fe\u0003\u00c5\u0018[*0\u0096>\u00c1\u00ee\u00d9\u00bb)\u0017w\u0003\u0086^\u00c8\u00cf\u0088>g\b~\u00bd\u0089\u009fR\u0092\u00d3'\f\u00dfo\u00ad\u00de\u00cb\u00d8\u000ei\u00da\u0003\u00b7\\F\u00a4g\u00c2\u00df&\u00f8\u00b3mm\u008fK\tN83\u00e3\u00aa.\u00f7\u00a9\u00c2\u00c2\u0014}\u0084\u00fb\u001e\"\u00b7\"\u0003V\u00e1\u00cc\u0007j\u000e\u00a3a\u008c\u00df\u009e\b\u00cb\u00f6\u00a7Y\u00b1\u00df\u00e7|0r\u00f0\n\u00e4\u00b6\u00d6Xb\u00a9\u00e2\u001f\u0004mlL\u0013L\u00f2\u001f\u00da\u00ff\b\u00c2\u00dd\u0096+\u00e5*hv\u00c8\u00c0\u00e3\u00cb6\u00f7~\\\u0003\u00e0\u0017\u00ff8\u00be@\u00b0&\u00f7,\t\u000b\u00b4\u00b5\u00c0\u0085f\u00b3\u00bb\u0004l\u00a2k\u0015\u00b3\u0085 \u0080}{4`\u00a3\u00ceZ\u00d7\u00fb\u00ac\u00b1\u0089C\u001d\u0017\u0016\u00bf)w\u00f9\u00bd\u0002k\u008e\u00fd\u00e6\u00f0\b-\u00c4\u00afh\u00b8B\u00c6x\u00a1d\u00af\u0083\u00d0\u00b24X6]\b\u00b7t\u00da\u00f1\u00f8ca\u009c\u00df\u00b8\u00aaG\u0007\u00b9\u00b3nQ5\u00b9\u00ad\u0007\u00ad'\u0088\u00af\u000e\u0089\u00dc(\u00b4\u009e\u0089\u00cf]]\u00cd\u00bb\u0086t\u00c9}\u0010\u00de\r\u0017w\u007f9\u00c7\u00dd\u00c9\u00f10\u0080\u00b4\u0016\u00bb;\u000b\u00c9T\u00bdBt\u009b\u00c4\u00fd \u001d\u000f\u008e\u00db\u0080N\u0094\u0001Q\u00f3`\u00f0\u00b4\u00bc\u001f\u00b2r\"\u00fe2\u008c{M\u00a19\u0003h\u00b4>S\u00ce\u0096\u00f0S$swG\u009f\u00e7vns\u0097\u0013z\u0088a\u00c6\u0007\u0089\u00b0\u000e\u00be\u0080\u0086%TlI^cE\u00d4\n\u001fn\u001b\u0099ie\u001d\u00d3\u00de,T\u0098\u0083&\u00d3\u0011c-\u00fb7\u00cc\u00a8,_\u00be\u001d\u00e3UK\u0082\nn\u0093_E\u00801\u0095\u0083\u0004\u001b\u0018\u0081\u00d3fG\u00b2)!\u00f4'^\u0013\u00f7\u000e\u00b42 \u00a3\u00b6\u00ed\u001a\u008f3\\\u0001)!\u00e2wa2\u00e2\u00d6k\u0095\u00b9\u0081\u00f2>\u00a7\u0015\u00c0\r]\u0007\u0005A\u00bfD9\u00d3\u00bbW\u00cdw\u00f9 \u0082^-COF>\u00e3\u0096,\t\u00fa\u00c1\t\b^|\u0091N\u00b7";
                var4_3 = "\u00dd\"\u00fd\u001d\u008e\u00e4N\u000b\u0014\u0081\u00a7NJ\u0006\u0086\u00f0]<\u0016\u00f0\u00f0:&o\u00d9P\u0093)\u001d\u0006\u009d\u00a0\u00f5M\u00e5\u00af\u0018U\u009a\u00b4\u00dd\u00db\u00b1I{\u00c3\u00af\u0000\u00b7B12\u00b9R\u00f6G,\u00e4]\u00a4\u0017\t<\u00ae\u0007\u00ea\u00c6\u00c8\u00f2\u001c\u0088\u0005U#\u00ec=\u00dc\b\fg\u00c7\u00c4\u009b\u00f9\u00eaJ\u0014\u00f0\u0081\u0018\u0015\u00a1e1\u00b6j\u00b6\u0091P\\\u0091\u0018\u00c2\u00ac#OI\u00050\u001e@\u009aI\u001e\b\u0097R\u00cf\u00967B\u00d1\u0007\u00ee\u00d3\u0018t\u00e4Vg?\u00bc8\u0091\u00a7\u00c5\u00c0\u00c98\u00aew7\u0012\u00ff\u0010+&\u00d2<\u00d1{\\\u00a1\u00b9R\u0089r9\u00fcP\u00fb\t{\u00959\u009cR!F\u00be\u00f0\u0010K\u0081\u00de\u00c8P\u00e5lr\u00bf(I=!\u0015S\u00c6?\"\u00fe\u001f\u00e22\u009bS(T\u0000\u00fc>.\u00d6 \u001846$\u0005\u00aa\u0005\u001a\u00b7s\u0089\u0013g\u00a9\u00a3\u00faZ\u00e2\u00fb\u00a5\u00ad\u0080\u0016\u001b\u00fe\u0003\u00c5\u0018[*0\u0096>\u00c1\u00ee\u00d9\u00bb)\u0017w\u0003\u0086^\u00c8\u00cf\u0088>g\b~\u00bd\u0089\u009fR\u0092\u00d3'\f\u00dfo\u00ad\u00de\u00cb\u00d8\u000ei\u00da\u0003\u00b7\\F\u00a4g\u00c2\u00df&\u00f8\u00b3mm\u008fK\tN83\u00e3\u00aa.\u00f7\u00a9\u00c2\u00c2\u0014}\u0084\u00fb\u001e\"\u00b7\"\u0003V\u00e1\u00cc\u0007j\u000e\u00a3a\u008c\u00df\u009e\b\u00cb\u00f6\u00a7Y\u00b1\u00df\u00e7|0r\u00f0\n\u00e4\u00b6\u00d6Xb\u00a9\u00e2\u001f\u0004mlL\u0013L\u00f2\u001f\u00da\u00ff\b\u00c2\u00dd\u0096+\u00e5*hv\u00c8\u00c0\u00e3\u00cb6\u00f7~\\\u0003\u00e0\u0017\u00ff8\u00be@\u00b0&\u00f7,\t\u000b\u00b4\u00b5\u00c0\u0085f\u00b3\u00bb\u0004l\u00a2k\u0015\u00b3\u0085 \u0080}{4`\u00a3\u00ceZ\u00d7\u00fb\u00ac\u00b1\u0089C\u001d\u0017\u0016\u00bf)w\u00f9\u00bd\u0002k\u008e\u00fd\u00e6\u00f0\b-\u00c4\u00afh\u00b8B\u00c6x\u00a1d\u00af\u0083\u00d0\u00b24X6]\b\u00b7t\u00da\u00f1\u00f8ca\u009c\u00df\u00b8\u00aaG\u0007\u00b9\u00b3nQ5\u00b9\u00ad\u0007\u00ad'\u0088\u00af\u000e\u0089\u00dc(\u00b4\u009e\u0089\u00cf]]\u00cd\u00bb\u0086t\u00c9}\u0010\u00de\r\u0017w\u007f9\u00c7\u00dd\u00c9\u00f10\u0080\u00b4\u0016\u00bb;\u000b\u00c9T\u00bdBt\u009b\u00c4\u00fd \u001d\u000f\u008e\u00db\u0080N\u0094\u0001Q\u00f3`\u00f0\u00b4\u00bc\u001f\u00b2r\"\u00fe2\u008c{M\u00a19\u0003h\u00b4>S\u00ce\u0096\u00f0S$swG\u009f\u00e7vns\u0097\u0013z\u0088a\u00c6\u0007\u0089\u00b0\u000e\u00be\u0080\u0086%TlI^cE\u00d4\n\u001fn\u001b\u0099ie\u001d\u00d3\u00de,T\u0098\u0083&\u00d3\u0011c-\u00fb7\u00cc\u00a8,_\u00be\u001d\u00e3UK\u0082\nn\u0093_E\u00801\u0095\u0083\u0004\u001b\u0018\u0081\u00d3fG\u00b2)!\u00f4'^\u0013\u00f7\u000e\u00b42 \u00a3\u00b6\u00ed\u001a\u008f3\\\u0001)!\u00e2wa2\u00e2\u00d6k\u0095\u00b9\u0081\u00f2>\u00a7\u0015\u00c0\r]\u0007\u0005A\u00bfD9\u00d3\u00bbW\u00cdw\u00f9 \u0082^-COF>\u00e3\u0096,\t\u00fa\u00c1\t\b^|\u0091N\u00b7".length();
                var1_4 = 8;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    v0 = 112;
                    v1 = ++var0_5;
                    v2 = var2_2.substring(v1, v1 + var1_4);
                    v3 = -1;
                    break block19;
                    break;
                }
lbl13:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    var2_2 = "_\u00e9\u00be\u0006\r\b70\u00af\u00d4\u00c0Y\u0010\u00d4\u00d6\u00a8sZ\u009eg!\u00ca\u00bdOAo\u0092\u0014Y\u0014ikU\u00d5csZ\u00e5o\u0007\u009c\u00d4\u00b1\u00a4\u0018\u008f\u00b8_2\u0082";
                    var4_3 = "_\u00e9\u00be\u0006\r\b70\u00af\u00d4\u00c0Y\u0010\u00d4\u00d6\u00a8sZ\u009eg!\u00ca\u00bdOAo\u0092\u0014Y\u0014ikU\u00d5csZ\u00e5o\u0007\u009c\u00d4\u00b1\u00a4\u0018\u008f\u00b8_2\u0082".length();
                    var1_4 = 29;
                    var0_5 = -1;
lbl22:
                    // 2 sources

                    while (true) {
                        v0 = 27;
                        v5 = ++var0_5;
                        v2 = var2_2.substring(v5, v5 + var1_4);
                        v3 = 0;
                        break block19;
                        break;
                    }
                    break;
                }
lbl28:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block20;
                    break;
                }
            }
            v6 = v2.toCharArray();
            v7 = v6.length;
            var6_6 = 0;
            v8 = v0;
            v9 = v6;
            v10 = v7;
            if (v7 > 1) ** GOTO lbl85
            do {
                v11 = v8;
                v9 = v9;
                v12 = v9;
                v13 = v8;
                v14 = var6_6;
                while (true) {
                    switch (var6_6 % 7) {
                        case 0: {
                            v15 = 106;
                            break;
                        }
                        case 1: {
                            v15 = 25;
                            break;
                        }
                        case 2: {
                            v15 = 123;
                            break;
                        }
                        case 3: {
                            v15 = 37;
                            break;
                        }
                        case 4: {
                            v15 = 14;
                            break;
                        }
                        case 5: {
                            v15 = 53;
                            break;
                        }
                        default: {
                            v15 = 14;
                        }
                    }
                    v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                    ++var6_6;
                    v8 = v11;
                    if (v11 != 0) break;
                    v11 = v8;
                    v9 = v9;
                    v14 = v8;
                    v12 = v9;
                    v13 = v8;
                }
lbl85:
                // 2 sources

                v16 = v9;
                v10 = v10;
            } while (v10 > var6_6);
            v4 = new String(v16);
            switch (v3) {
                default: {
                    ** continue;
                }
                ** case 0:
lbl95:
                // 1 sources

                ** continue;
            }
        }
        WindowsNamedPipeAgentIpc.c = var5;
        WindowsNamedPipeAgentIpc.d = new String[34];
        WindowsNamedPipeAgentIpc.Companion = new Companion(null);
    }

    private static IllegalArgumentException a(IllegalArgumentException illegalArgumentException) {
        return illegalArgumentException;
    }

    private static String b(int n2, int n3, int n4) {
        int n5 = (n2 ^ n4 ^ 0xFFFFA4EB) & 0xFFFF;
        if (d[n5] == null) {
            int n6;
            char[] cArray = c[n5].toCharArray();
            int n7 = switch (cArray[0] & 0xFF) {
                case 0 -> 34;
                case 1 -> 246;
                case 2 -> 106;
                case 3 -> 17;
                case 4 -> 89;
                case 5 -> 254;
                case 6 -> 221;
                case 7 -> 53;
                case 8 -> 172;
                case 9 -> 247;
                case 10 -> 140;
                case 11 -> 176;
                case 12 -> 183;
                case 13 -> 41;
                case 14 -> 134;
                case 15 -> 3;
                case 16 -> 195;
                case 17 -> 58;
                case 18 -> 6;
                case 19 -> 248;
                case 20 -> 51;
                case 21 -> 189;
                case 22 -> 73;
                case 23 -> 212;
                case 24 -> 113;
                case 25 -> 54;
                case 26 -> 198;
                case 27 -> 162;
                case 28 -> 60;
                case 29 -> 116;
                case 30 -> 37;
                case 31 -> 67;
                case 32 -> 109;
                case 33 -> 76;
                case 34 -> 25;
                case 35 -> 194;
                case 36 -> 120;
                case 37 -> 171;
                case 38 -> 118;
                case 39 -> 7;
                case 40 -> 45;
                case 41 -> 230;
                case 42 -> 201;
                case 43 -> 192;
                case 44 -> 81;
                case 45 -> 232;
                case 46 -> 131;
                case 47 -> 143;
                case 48 -> 101;
                case 49 -> 103;
                case 50 -> 227;
                case 51 -> 28;
                case 52 -> 174;
                case 53 -> 251;
                case 54 -> 199;
                case 55 -> 38;
                case 56 -> 156;
                case 57 -> 96;
                case 58 -> 154;
                case 59 -> 128;
                case 60 -> 83;
                case 61 -> 0;
                case 62 -> 170;
                case 63 -> 241;
                case 64 -> 210;
                case 65 -> 175;
                case 66 -> 191;
                case 67 -> 207;
                case 68 -> 8;
                case 69 -> 163;
                case 70 -> 63;
                case 71 -> 177;
                case 72 -> 236;
                case 73 -> 94;
                case 74 -> 231;
                case 75 -> 91;
                case 76 -> 40;
                case 77 -> 223;
                case 78 -> 107;
                case 79 -> 148;
                case 80 -> 112;
                case 81 -> 234;
                case 82 -> 1;
                case 83 -> 93;
                case 84 -> 228;
                case 85 -> 196;
                case 86 -> 222;
                case 87 -> 57;
                case 88 -> 39;
                case 89 -> 185;
                case 90 -> 123;
                case 91 -> 46;
                case 92 -> 115;
                case 93 -> 173;
                case 94 -> 36;
                case 95 -> 35;
                case 96 -> 29;
                case 97 -> 77;
                case 98 -> 159;
                case 99 -> 23;
                case 100 -> 190;
                case 101 -> 12;
                case 102 -> 197;
                case 103 -> 64;
                case 104 -> 249;
                case 105 -> 151;
                case 106 -> 84;
                case 107 -> 62;
                case 108 -> 136;
                case 109 -> 72;
                case 110 -> 142;
                case 111 -> 219;
                case 112 -> 126;
                case 113 -> 18;
                case 114 -> 100;
                case 115 -> 160;
                case 116 -> 105;
                case 117 -> 9;
                case 118 -> 153;
                case 119 -> 157;
                case 120 -> 66;
                case 121 -> 187;
                case 122 -> 184;
                case 123 -> 164;
                case 124 -> 22;
                case 125 -> 147;
                case 126 -> 33;
                case 127 -> 88;
                case 128 -> 145;
                case 129 -> 138;
                case 130 -> 158;
                case 131 -> 245;
                case 132 -> 124;
                case 133 -> 242;
                case 134 -> 69;
                case 135 -> 150;
                case 136 -> 203;
                case 137 -> 211;
                case 138 -> 102;
                case 139 -> 238;
                case 140 -> 90;
                case 141 -> 74;
                case 142 -> 78;
                case 143 -> 127;
                case 144 -> 55;
                case 145 -> 186;
                case 146 -> 70;
                case 147 -> 52;
                case 148 -> 49;
                case 149 -> 206;
                case 150 -> 237;
                case 151 -> 129;
                case 152 -> 146;
                case 153 -> 216;
                case 154 -> 178;
                case 155 -> 205;
                case 156 -> 110;
                case 157 -> 152;
                case 158 -> 204;
                case 159 -> 95;
                case 160 -> 137;
                case 161 -> 26;
                case 162 -> 15;
                case 163 -> 244;
                case 164 -> 44;
                case 165 -> 50;
                case 166 -> 208;
                case 167 -> 180;
                case 168 -> 14;
                case 169 -> 135;
                case 170 -> 188;
                case 171 -> 139;
                case 172 -> 161;
                case 173 -> 71;
                case 174 -> 99;
                case 175 -> 43;
                case 176 -> 4;
                case 177 -> 149;
                case 178 -> 32;
                case 179 -> 130;
                case 180 -> 215;
                case 181 -> 82;
                case 182 -> 132;
                case 183 -> 167;
                case 184 -> 19;
                case 185 -> 220;
                case 186 -> 252;
                case 187 -> 193;
                case 188 -> 214;
                case 189 -> 11;
                case 190 -> 97;
                case 191 -> 75;
                case 192 -> 56;
                case 193 -> 21;
                case 194 -> 111;
                case 195 -> 16;
                case 196 -> 133;
                case 197 -> 239;
                case 198 -> 200;
                case 199 -> 121;
                case 200 -> 80;
                case 201 -> 166;
                case 202 -> 13;
                case 203 -> 108;
                case 204 -> 155;
                case 205 -> 182;
                case 206 -> 179;
                case 207 -> 122;
                case 208 -> 87;
                case 209 -> 217;
                case 210 -> 85;
                case 211 -> 144;
                case 212 -> 98;
                case 213 -> 31;
                case 214 -> 141;
                case 215 -> 2;
                case 216 -> 92;
                case 217 -> 181;
                case 218 -> 59;
                case 219 -> 169;
                case 220 -> 209;
                case 221 -> 226;
                case 222 -> 79;
                case 223 -> 48;
                case 224 -> 233;
                case 225 -> 202;
                case 226 -> 86;
                case 227 -> 47;
                case 228 -> 61;
                case 229 -> 24;
                case 230 -> 165;
                case 231 -> 68;
                case 232 -> 65;
                case 233 -> 253;
                case 234 -> 243;
                case 235 -> 42;
                case 236 -> 213;
                case 237 -> 218;
                case 238 -> 20;
                case 239 -> 168;
                case 240 -> 255;
                case 241 -> 225;
                case 242 -> 119;
                case 243 -> 235;
                case 244 -> 229;
                case 245 -> 30;
                case 246 -> 104;
                case 247 -> 224;
                case 248 -> 125;
                case 249 -> 240;
                case 250 -> 10;
                case 251 -> 5;
                case 252 -> 117;
                case 253 -> 27;
                case 254 -> 114;
                default -> 250;
            };
            int n8 = ((n3 ^= n4) & 0xFF) - n7;
            if (n8 < 0) {
                n8 += 256;
            }
            if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                n6 += 256;
            }
            int n9 = 0;
            while (n9 < cArray.length) {
                int n10 = n9 % 2;
                int n11 = n9;
                char[] cArray2 = cArray;
                char c2 = cArray[n11];
                if (n10 == 0) {
                    cArray2[n11] = (char)(c2 ^ n8);
                    n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                } else {
                    cArray2[n11] = (char)(c2 ^ n6);
                    n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                }
                ++n9;
            }
            WindowsNamedPipeAgentIpc.d[n5] = new String(cArray).intern();
        }
        return d[n5];
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion;", "", "WindowsNamedPipeAgentIpc$Companion", "()V", "connectToPipeTest", "", "pipePath", "", "connectToPipe", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n23#2:392\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n*L\n84#1:392\n*E\n"})
    public static final class Companion {
        private static final String[] a;
        private static final String[] b;

        private Companion() {
        }

        @TestOnly
        public final void connectToPipeTest(@NotNull String pipePath) {
            long l2 = 64763963716733L;
            Intrinsics.checkNotNullParameter((Object)pipePath, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(151910130 - (char)-18254, -151910130 - -((char)-23710), (int)l2));
            this.connectToPipe(pipePath);
        }

        private final void connectToPipe(String pipePath) {
            block6: {
                boolean bl;
                WinNT.HANDLE hANDLE;
                block7: {
                    long l2;
                    block5: {
                        WinNT.HANDLE hANDLE2;
                        ActionTimestamp[] actionTimestampArray;
                        block4: {
                            l2 = 96285444670863L;
                            hANDLE = Kernel32.INSTANCE.CreateFile(pipePath, -1073741824, 0, null, 3, 0, null);
                            actionTimestampArray = SshAgentIpcService.d();
                            try {
                                hANDLE2 = hANDLE;
                                if (actionTimestampArray != null) break block4;
                                if (hANDLE2 == null) break block5;
                            }
                            catch (RuntimeException runtimeException) {
                                throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                            }
                            hANDLE2 = WinNT.INVALID_HANDLE_VALUE;
                        }
                        try {
                            bl = Intrinsics.areEqual((Object)hANDLE2, (Object)hANDLE);
                            if (actionTimestampArray != null) break block6;
                            if (!bl) break block7;
                        }
                        catch (RuntimeException runtimeException) {
                            throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                        }
                    }
                    Companion companion = this;
                    boolean bl2 = false;
                    Logger logger = Logger.getInstance(Companion.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(867814470 + 17261, 867814470 + (char)-19977, (int)l2));
                    logger.info(com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(867814470 + 17258, -867814470 + -((char)-26167), (int)l2) + pipePath + com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(867814470 + 17259, 867814470 + (char)-26847, (int)l2));
                }
                bl = Kernel32.INSTANCE.CloseHandle(hANDLE);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[4];
                    var3_1 = 0;
                    var2_2 = "\u00fb\"[\u00f5\u00c4\u00e2i<\u0010?927S\u0001b\u0019\u00f5'\u00e8B\u000e\u0094A}";
                    var4_3 = "\u00fb\"[\u00f5\u00c4\u00e2i<\u0010?927S\u0001b\u0019\u00f5'\u00e8B\u000e\u0094A}".length();
                    var1_4 = 8;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 47;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "\u0080\u00f2\u00baa\u00065G\u008eU\u0082)\u0000\u00bb\u001c7\u00b2\u00ac\u00be\u00ffo\u00f4\u0006\\Z\u00ae\u008c\u0007\u00c8\u0006\u00b6\u00f7\u0016\t^\u0003\u00b1\u00929\u0003\u00be}=[\u00c2B\u001f\r67\u00c8v\u00cf\u00ff\u00c6\u00b8~\u00e0`-";
                        var4_3 = "\u0080\u00f2\u00baa\u00065G\u008eU\u0082)\u0000\u00bb\u001c7\u00b2\u00ac\u00be\u00ffo\u00f4\u0006\\Z\u00ae\u008c\u0007\u00c8\u0006\u00b6\u00f7\u0016\t^\u0003\u00b1\u00929\u0003\u00be}=[\u00c2B\u001f\r67\u00c8v\u00cf\u00ff\u00c6\u00b8~\u00e0`-".length();
                        var1_4 = 5;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 105;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 5;
                                break;
                            }
                            case 1: {
                                v15 = 72;
                                break;
                            }
                            case 2: {
                                v15 = 64;
                                break;
                            }
                            case 3: {
                                v15 = 83;
                                break;
                            }
                            case 4: {
                                v15 = 67;
                                break;
                            }
                            case 5: {
                                v15 = 84;
                                break;
                            }
                            default: {
                                v15 = 125;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a = var5;
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b = new String[4];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0xA3D) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 242;
                    case 1 -> 230;
                    case 2 -> 186;
                    case 3 -> 118;
                    case 4 -> 133;
                    case 5 -> 4;
                    case 6 -> 110;
                    case 7 -> 243;
                    case 8 -> 6;
                    case 9 -> 143;
                    case 10 -> 221;
                    case 11 -> 145;
                    case 12 -> 39;
                    case 13 -> 62;
                    case 14 -> 49;
                    case 15 -> 83;
                    case 16 -> 92;
                    case 17 -> 103;
                    case 18 -> 80;
                    case 19 -> 57;
                    case 20 -> 252;
                    case 21 -> 64;
                    case 22 -> 213;
                    case 23 -> 208;
                    case 24 -> 58;
                    case 25 -> 18;
                    case 26 -> 38;
                    case 27 -> 180;
                    case 28 -> 29;
                    case 29 -> 191;
                    case 30 -> 148;
                    case 31 -> 150;
                    case 32 -> 19;
                    case 33 -> 20;
                    case 34 -> 93;
                    case 35 -> 239;
                    case 36 -> 96;
                    case 37 -> 202;
                    case 38 -> 107;
                    case 39 -> 99;
                    case 40 -> 201;
                    case 41 -> 9;
                    case 42 -> 218;
                    case 43 -> 215;
                    case 44 -> 232;
                    case 45 -> 140;
                    case 46 -> 116;
                    case 47 -> 73;
                    case 48 -> 249;
                    case 49 -> 114;
                    case 50 -> 98;
                    case 51 -> 128;
                    case 52 -> 135;
                    case 53 -> 26;
                    case 54 -> 55;
                    case 55 -> 188;
                    case 56 -> 40;
                    case 57 -> 52;
                    case 58 -> 2;
                    case 59 -> 157;
                    case 60 -> 225;
                    case 61 -> 15;
                    case 62 -> 47;
                    case 63 -> 162;
                    case 64 -> 187;
                    case 65 -> 144;
                    case 66 -> 90;
                    case 67 -> 123;
                    case 68 -> 166;
                    case 69 -> 154;
                    case 70 -> 13;
                    case 71 -> 244;
                    case 72 -> 35;
                    case 73 -> 183;
                    case 74 -> 16;
                    case 75 -> 51;
                    case 76 -> 174;
                    case 77 -> 234;
                    case 78 -> 17;
                    case 79 -> 12;
                    case 80 -> 198;
                    case 81 -> 122;
                    case 82 -> 255;
                    case 83 -> 147;
                    case 84 -> 159;
                    case 85 -> 68;
                    case 86 -> 61;
                    case 87 -> 37;
                    case 88 -> 79;
                    case 89 -> 124;
                    case 90 -> 146;
                    case 91 -> 212;
                    case 92 -> 175;
                    case 93 -> 248;
                    case 94 -> 236;
                    case 95 -> 199;
                    case 96 -> 204;
                    case 97 -> 250;
                    case 98 -> 235;
                    case 99 -> 210;
                    case 100 -> 46;
                    case 101 -> 89;
                    case 102 -> 251;
                    case 103 -> 138;
                    case 104 -> 22;
                    case 105 -> 109;
                    case 106 -> 129;
                    case 107 -> 36;
                    case 108 -> 100;
                    case 109 -> 207;
                    case 110 -> 141;
                    case 111 -> 253;
                    case 112 -> 168;
                    case 113 -> 149;
                    case 114 -> 185;
                    case 115 -> 63;
                    case 116 -> 32;
                    case 117 -> 211;
                    case 118 -> 76;
                    case 119 -> 139;
                    case 120 -> 173;
                    case 121 -> 240;
                    case 122 -> 119;
                    case 123 -> 125;
                    case 124 -> 156;
                    case 125 -> 178;
                    case 126 -> 28;
                    case 127 -> 245;
                    case 128 -> 228;
                    case 129 -> 238;
                    case 130 -> 33;
                    case 131 -> 56;
                    case 132 -> 158;
                    case 133 -> 0;
                    case 134 -> 193;
                    case 135 -> 192;
                    case 136 -> 220;
                    case 137 -> 117;
                    case 138 -> 91;
                    case 139 -> 101;
                    case 140 -> 69;
                    case 141 -> 112;
                    case 142 -> 54;
                    case 143 -> 104;
                    case 144 -> 203;
                    case 145 -> 132;
                    case 146 -> 11;
                    case 147 -> 247;
                    case 148 -> 169;
                    case 149 -> 113;
                    case 150 -> 131;
                    case 151 -> 163;
                    case 152 -> 115;
                    case 153 -> 65;
                    case 154 -> 152;
                    case 155 -> 75;
                    case 156 -> 44;
                    case 157 -> 165;
                    case 158 -> 142;
                    case 159 -> 184;
                    case 160 -> 23;
                    case 161 -> 151;
                    case 162 -> 10;
                    case 163 -> 88;
                    case 164 -> 176;
                    case 165 -> 127;
                    case 166 -> 45;
                    case 167 -> 5;
                    case 168 -> 77;
                    case 169 -> 171;
                    case 170 -> 3;
                    case 171 -> 48;
                    case 172 -> 84;
                    case 173 -> 106;
                    case 174 -> 102;
                    case 175 -> 229;
                    case 176 -> 216;
                    case 177 -> 167;
                    case 178 -> 223;
                    case 179 -> 71;
                    case 180 -> 205;
                    case 181 -> 30;
                    case 182 -> 254;
                    case 183 -> 214;
                    case 184 -> 70;
                    case 185 -> 27;
                    case 186 -> 209;
                    case 187 -> 164;
                    case 188 -> 206;
                    case 189 -> 50;
                    case 190 -> 224;
                    case 191 -> 24;
                    case 192 -> 179;
                    case 193 -> 53;
                    case 194 -> 155;
                    case 195 -> 120;
                    case 196 -> 233;
                    case 197 -> 182;
                    case 198 -> 85;
                    case 199 -> 87;
                    case 200 -> 231;
                    case 201 -> 189;
                    case 202 -> 126;
                    case 203 -> 170;
                    case 204 -> 196;
                    case 205 -> 197;
                    case 206 -> 59;
                    case 207 -> 134;
                    case 208 -> 74;
                    case 209 -> 108;
                    case 210 -> 7;
                    case 211 -> 194;
                    case 212 -> 237;
                    case 213 -> 97;
                    case 214 -> 67;
                    case 215 -> 81;
                    case 216 -> 34;
                    case 217 -> 190;
                    case 218 -> 222;
                    case 219 -> 82;
                    case 220 -> 43;
                    case 221 -> 25;
                    case 222 -> 153;
                    case 223 -> 31;
                    case 224 -> 41;
                    case 225 -> 105;
                    case 226 -> 195;
                    case 227 -> 1;
                    case 228 -> 246;
                    case 229 -> 111;
                    case 230 -> 160;
                    case 231 -> 172;
                    case 232 -> 177;
                    case 233 -> 136;
                    case 234 -> 8;
                    case 235 -> 219;
                    case 236 -> 226;
                    case 237 -> 200;
                    case 238 -> 181;
                    case 239 -> 121;
                    case 240 -> 94;
                    case 241 -> 130;
                    case 242 -> 21;
                    case 243 -> 14;
                    case 244 -> 95;
                    case 245 -> 60;
                    case 246 -> 66;
                    case 247 -> 78;
                    case 248 -> 137;
                    case 249 -> 241;
                    case 250 -> 42;
                    case 251 -> 161;
                    case 252 -> 227;
                    case 253 -> 86;
                    case 254 -> 72;
                    default -> 217;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000 \b2\u00020\u0001:\u0001\bJ\u001c\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\t\u00c0\u0006\u0001"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "Lcom/sun/jna/platform/win32/Kernel32;", "CancelIoEx", "", "hFile", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lpOverlapped", "Lcom/sun/jna/Pointer;", "Companion", "intellij.platform.backend.split"})
    public static interface Kernel32Ex
    extends Kernel32 {
        @NotNull
        public static final Companion Companion = Companion.$$INSTANCE;

        public boolean CancelIoEx(@Nullable WinNT.HANDLE var1, @Nullable Pointer var2);

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex$Companion;", "", "WindowsNamedPipeAgentIpc$Kernel32Ex$Companion", "()V", "INSTANCE", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "getINSTANCE", "()Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "intellij.platform.backend.split"})
        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;
            @NotNull
            private static final Kernel32Ex INSTANCE;

            private Companion() {
            }

            @NotNull
            public final Kernel32Ex getINSTANCE() {
                return INSTANCE;
            }

            /*
             * Unable to fully structure code
             */
            static {
                block13: {
                    var7 = 29590512912398L;
                    var0_1 = new String[2];
                    var4_2 = 0;
                    var3_3 = "\u000fo\u007f\u001e`H[V\t\bel\u0014-\nFJ#";
                    var5_4 = "\u000fo\u007f\u001e`H[V\t\bel\u0014-\nFJ#".length();
                    var2_5 = 8;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        continue;
                        break;
                    }
lbl10:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = new String(v0).intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block13;
                        break;
                    }
                    v1 = ++var1_6;
                    v2 = var3_3.substring(v1, v1 + var2_5).toCharArray();
                    v3 = v2.length;
                    var6_7 = 0;
                    v4 = 77;
                    v5 = v2;
                    v6 = v3;
                    if (v3 > 1) ** GOTO lbl68
                    do {
                        v7 = v4;
                        v5 = v5;
                        v8 = v5;
                        v9 = v4;
                        v10 = var6_7;
                        while (true) {
                            switch (var6_7 % 7) {
                                case 0: {
                                    v11 = 41;
                                    break;
                                }
                                case 1: {
                                    v11 = 71;
                                    break;
                                }
                                case 2: {
                                    v11 = 64;
                                    break;
                                }
                                case 3: {
                                    v11 = 61;
                                    break;
                                }
                                case 4: {
                                    v11 = 72;
                                    break;
                                }
                                case 5: {
                                    v11 = 105;
                                    break;
                                }
                                default: {
                                    v11 = 37;
                                }
                            }
                            v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                            ++var6_7;
                            v4 = v7;
                            if (v7 != 0) break;
                            v7 = v4;
                            v5 = v5;
                            v10 = v4;
                            v8 = v5;
                            v9 = v4;
                        }
lbl68:
                        // 2 sources

                        v0 = v5;
                        v6 = v6;
                    } while (v6 > var6_7);
                    ** while (true)
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.$$INSTANCE = new Companion();
                v12 = Native.load((String)var0_1[0], Kernel32Ex.class, (Map)W32APIOptions.DEFAULT_OPTIONS);
                Intrinsics.checkNotNullExpressionValue((Object)v12, (String)var0_1[1]);
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.INSTANCE = (Kernel32Ex)v12;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\n\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "", "WindowsNamedPipeAgentIpc$NamedPipeState", "(Ljava/lang/String;I)V", "Initial", "Open", "Connecting", "Connected", "Disconnecting", "Closing", "Closed", "intellij.platform.backend.split"})
    public static final class NamedPipeState
    extends Enum<NamedPipeState> {
        public static final /* enum */ NamedPipeState Initial;
        public static final /* enum */ NamedPipeState Open;
        public static final /* enum */ NamedPipeState Connecting;
        public static final /* enum */ NamedPipeState Connected;
        public static final /* enum */ NamedPipeState Disconnecting;
        public static final /* enum */ NamedPipeState Closing;
        public static final /* enum */ NamedPipeState Closed;
        private static final /* synthetic */ NamedPipeState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static NamedPipeState[] values() {
            return (NamedPipeState[])$VALUES.clone();
        }

        public static NamedPipeState valueOf(String value) {
            return Enum.valueOf(NamedPipeState.class, value);
        }

        @NotNull
        public static EnumEntries<NamedPipeState> getEntries() {
            return $ENTRIES;
        }

        private static final /* synthetic */ NamedPipeState[] $values() {
            NamedPipeState[] namedPipeStateArray = new NamedPipeState[]{Initial, Open, Connecting, Connected, Disconnecting, Closing, Closed};
            return namedPipeStateArray;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var7 = 72383988572050L;
                    var0_1 = new String[7];
                    var4_2 = 0;
                    var3_3 = "sXL\u0005IGp\u0004uF@\u001f\nyYK\u001fEEhSXB\tyYK\u001fEEh_R\r~_V\u0012OHr_UQ\u0018NA";
                    var5_4 = "sXL\u0005IGp\u0004uF@\u001f\nyYK\u001fEEhSXB\tyYK\u001fEEh_R\r~_V\u0012OHr_UQ\u0018NA".length();
                    var2_5 = 7;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        v0 = 36;
                        v1 = ++var1_6;
                        v2 = var3_3.substring(v1, v1 + var2_5);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl14:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        var3_3 = "#\u0000\u0010X\u0013\u0012!\u0006#\u0000\u0010X\u001f\u0018";
                        var5_4 = "#\u0000\u0010X\u0013\u0012!\u0006#\u0000\u0010X\u001f\u0018".length();
                        var2_5 = 7;
                        var1_6 = -1;
lbl23:
                        // 2 sources

                        while (true) {
                            v0 = 126;
                            v5 = ++var1_6;
                            v2 = var3_3.substring(v5, v5 + var2_5);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl29:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_7 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl86
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_7;
                    while (true) {
                        switch (var6_7 % 7) {
                            case 0: {
                                v15 = 30;
                                break;
                            }
                            case 1: {
                                v15 = 18;
                                break;
                            }
                            case 2: {
                                v15 = 1;
                                break;
                            }
                            case 3: {
                                v15 = 85;
                                break;
                            }
                            case 4: {
                                v15 = 4;
                                break;
                            }
                            case 5: {
                                v15 = 2;
                                break;
                            }
                            default: {
                                v15 = 56;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_7;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl86:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_7);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl96:
                    // 1 sources

                    ** continue;
                }
            }
            NamedPipeState.Initial = new NamedPipeState();
            NamedPipeState.Open = new NamedPipeState();
            NamedPipeState.Connecting = new NamedPipeState();
            NamedPipeState.Connected = new NamedPipeState();
            NamedPipeState.Disconnecting = new NamedPipeState();
            NamedPipeState.Closing = new NamedPipeState();
            NamedPipeState.Closed = new NamedPipeState();
            NamedPipeState.$VALUES = NamedPipeState.$values();
            NamedPipeState.$ENTRIES = EnumEntriesKt.enumEntries((Enum[])NamedPipeState.$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel;", "Ljava/nio/channels/ReadableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeReadableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "read", "", "dst", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n23#2:392\n23#2:393\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n*L\n315#1:392\n320#1:393\n*E\n"})
    private static final class PipeReadableByteChannel
    implements ReadableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeReadableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 100354017712735L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeReadableByteChannel.a(-2106819180 + -3677, -2106819180 + -31956, (int)l2));
            this.agent = agent;
        }

        /*
         * Exception decompiling
         */
        @Override
        public int read(@NotNull ByteBuffer dst) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 5[SWITCH]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 139612510899708L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeReadableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[9];
                    var3_1 = 0;
                    var2_2 = "B\u00da\u00ad#\u00bd\u0003\u00dc\u0093\u00ca\u0005\u00afv6r-\r\u00e1\u00f7\u00c9\b'Na\u008c&\u00f6|\u0001G\u0010\u00fc \u00ad\u0019\u0094\u00f9<GD\u000b\u00d3\u00f3T\u0004K\u0015\u0005Y\u001d\u00e8\u001f\u00f63\u008ea\u0003\u00e7\u0094b\f ?\u001a7\u00f8\u000e4,\f\u001e\u0083+\u00048\u0010sL\u0011l\u008fo\u00a2\u00d7\u00f0+4\u00e9Ss\u0090 \b\u00f3j\u00d9\u0005\u00f3(Y\u00e0\u008d\u00fa\u00e8\u00ac";
                    var4_3 = "B\u00da\u00ad#\u00bd\u0003\u00dc\u0093\u00ca\u0005\u00afv6r-\r\u00e1\u00f7\u00c9\b'Na\u008c&\u00f6|\u0001G\u0010\u00fc \u00ad\u0019\u0094\u00f9<GD\u000b\u00d3\u00f3T\u0004K\u0015\u0005Y\u001d\u00e8\u001f\u00f63\u008ea\u0003\u00e7\u0094b\f ?\u001a7\u00f8\u000e4,\f\u001e\u0083+\u00048\u0010sL\u0011l\u008fo\u00a2\u00d7\u00f0+4\u00e9Ss\u0090 \b\u00f3j\u00d9\u0005\u00f3(Y\u00e0\u008d\u00fa\u00e8\u00ac".length();
                    var1_4 = 5;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 21;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "\u00d8\u009e@\u00a7@G\u00cf\u00f9S\u00b5XML\u00ba!\u00abL6+j\u00db/\u0000L\u007f\u00aa\u00f6\u00cb\u009c0\u000e=DP2t\u00ad\u00d2(m\u0080\u0098w\u00f2\u00a3\u009en\u00f1\u001amH`2\u00ad\u00bf\u00fc\u000f\u00ab\u00d2\u009b\u0086\u0087@\u00b7\u00ff\u008b\u00fb\u0003D\u00d1\u00f2\u00d8\u00ec\u00a8\u00ef.L\u00a3y\u000b\u00dd\u0002\u00bb\u00d7K\u00d9\u000fV\u00b4\u00d2\u0013)\u001e";
                        var4_3 = "\u00d8\u009e@\u00a7@G\u00cf\u00f9S\u00b5XML\u00ba!\u00abL6+j\u00db/\u0000L\u007f\u00aa\u00f6\u00cb\u009c0\u000e=DP2t\u00ad\u00d2(m\u0080\u0098w\u00f2\u00a3\u009en\u00f1\u001amH`2\u00ad\u00bf\u00fc\u000f\u00ab\u00d2\u009b\u0086\u0087@\u00b7\u00ff\u008b\u00fb\u0003D\u00d1\u00f2\u00d8\u00ec\u00a8\u00ef.L\u00a3y\u000b\u00dd\u0002\u00bb\u00d7K\u00d9\u000fV\u00b4\u00d2\u0013)\u001e".length();
                        var1_4 = 16;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 84;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 80;
                                break;
                            }
                            case 1: {
                                v15 = 9;
                                break;
                            }
                            case 2: {
                                v15 = 112;
                                break;
                            }
                            case 3: {
                                v15 = 11;
                                break;
                            }
                            case 4: {
                                v15 = 12;
                                break;
                            }
                            case 5: {
                                v15 = 31;
                                break;
                            }
                            default: {
                                v15 = 79;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            PipeReadableByteChannel.a = var5;
            PipeReadableByteChannel.b = new String[9];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0xFFFFB568) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 96;
                    case 1 -> 81;
                    case 2 -> 38;
                    case 3 -> 73;
                    case 4 -> 7;
                    case 5 -> 15;
                    case 6 -> 11;
                    case 7 -> 57;
                    case 8 -> 87;
                    case 9 -> 29;
                    case 10 -> 75;
                    case 11 -> 251;
                    case 12 -> 216;
                    case 13 -> 112;
                    case 14 -> 151;
                    case 15 -> 215;
                    case 16 -> 37;
                    case 17 -> 188;
                    case 18 -> 181;
                    case 19 -> 228;
                    case 20 -> 25;
                    case 21 -> 103;
                    case 22 -> 129;
                    case 23 -> 124;
                    case 24 -> 49;
                    case 25 -> 158;
                    case 26 -> 33;
                    case 27 -> 191;
                    case 28 -> 203;
                    case 29 -> 17;
                    case 30 -> 163;
                    case 31 -> 243;
                    case 32 -> 138;
                    case 33 -> 186;
                    case 34 -> 92;
                    case 35 -> 48;
                    case 36 -> 89;
                    case 37 -> 88;
                    case 38 -> 10;
                    case 39 -> 82;
                    case 40 -> 85;
                    case 41 -> 36;
                    case 42 -> 176;
                    case 43 -> 155;
                    case 44 -> 114;
                    case 45 -> 99;
                    case 46 -> 52;
                    case 47 -> 19;
                    case 48 -> 166;
                    case 49 -> 238;
                    case 50 -> 93;
                    case 51 -> 44;
                    case 52 -> 187;
                    case 53 -> 185;
                    case 54 -> 235;
                    case 55 -> 123;
                    case 56 -> 77;
                    case 57 -> 83;
                    case 58 -> 157;
                    case 59 -> 122;
                    case 60 -> 100;
                    case 61 -> 12;
                    case 62 -> 67;
                    case 63 -> 164;
                    case 64 -> 248;
                    case 65 -> 95;
                    case 66 -> 121;
                    case 67 -> 252;
                    case 68 -> 71;
                    case 69 -> 173;
                    case 70 -> 207;
                    case 71 -> 211;
                    case 72 -> 141;
                    case 73 -> 40;
                    case 74 -> 236;
                    case 75 -> 35;
                    case 76 -> 225;
                    case 77 -> 132;
                    case 78 -> 101;
                    case 79 -> 134;
                    case 80 -> 218;
                    case 81 -> 8;
                    case 82 -> 126;
                    case 83 -> 91;
                    case 84 -> 229;
                    case 85 -> 13;
                    case 86 -> 119;
                    case 87 -> 165;
                    case 88 -> 58;
                    case 89 -> 190;
                    case 90 -> 242;
                    case 91 -> 0;
                    case 92 -> 23;
                    case 93 -> 39;
                    case 94 -> 104;
                    case 95 -> 69;
                    case 96 -> 109;
                    case 97 -> 108;
                    case 98 -> 149;
                    case 99 -> 53;
                    case 100 -> 160;
                    case 101 -> 131;
                    case 102 -> 146;
                    case 103 -> 168;
                    case 104 -> 249;
                    case 105 -> 22;
                    case 106 -> 200;
                    case 107 -> 159;
                    case 108 -> 66;
                    case 109 -> 245;
                    case 110 -> 234;
                    case 111 -> 32;
                    case 112 -> 4;
                    case 113 -> 51;
                    case 114 -> 227;
                    case 115 -> 174;
                    case 116 -> 42;
                    case 117 -> 50;
                    case 118 -> 111;
                    case 119 -> 202;
                    case 120 -> 172;
                    case 121 -> 45;
                    case 122 -> 6;
                    case 123 -> 205;
                    case 124 -> 199;
                    case 125 -> 61;
                    case 126 -> 47;
                    case 127 -> 65;
                    case 128 -> 115;
                    case 129 -> 110;
                    case 130 -> 162;
                    case 131 -> 106;
                    case 132 -> 26;
                    case 133 -> 224;
                    case 134 -> 3;
                    case 135 -> 192;
                    case 136 -> 46;
                    case 137 -> 177;
                    case 138 -> 189;
                    case 139 -> 217;
                    case 140 -> 64;
                    case 141 -> 1;
                    case 142 -> 255;
                    case 143 -> 135;
                    case 144 -> 154;
                    case 145 -> 72;
                    case 146 -> 237;
                    case 147 -> 102;
                    case 148 -> 27;
                    case 149 -> 156;
                    case 150 -> 182;
                    case 151 -> 220;
                    case 152 -> 239;
                    case 153 -> 18;
                    case 154 -> 240;
                    case 155 -> 62;
                    case 156 -> 201;
                    case 157 -> 253;
                    case 158 -> 60;
                    case 159 -> 171;
                    case 160 -> 233;
                    case 161 -> 78;
                    case 162 -> 143;
                    case 163 -> 105;
                    case 164 -> 196;
                    case 165 -> 68;
                    case 166 -> 170;
                    case 167 -> 175;
                    case 168 -> 184;
                    case 169 -> 142;
                    case 170 -> 247;
                    case 171 -> 86;
                    case 172 -> 28;
                    case 173 -> 213;
                    case 174 -> 84;
                    case 175 -> 204;
                    case 176 -> 31;
                    case 177 -> 152;
                    case 178 -> 232;
                    case 179 -> 148;
                    case 180 -> 20;
                    case 181 -> 43;
                    case 182 -> 98;
                    case 183 -> 21;
                    case 184 -> 150;
                    case 185 -> 80;
                    case 186 -> 55;
                    case 187 -> 107;
                    case 188 -> 209;
                    case 189 -> 79;
                    case 190 -> 136;
                    case 191 -> 130;
                    case 192 -> 2;
                    case 193 -> 246;
                    case 194 -> 183;
                    case 195 -> 193;
                    case 196 -> 5;
                    case 197 -> 128;
                    case 198 -> 56;
                    case 199 -> 180;
                    case 200 -> 133;
                    case 201 -> 169;
                    case 202 -> 147;
                    case 203 -> 118;
                    case 204 -> 178;
                    case 205 -> 198;
                    case 206 -> 208;
                    case 207 -> 34;
                    case 208 -> 9;
                    case 209 -> 161;
                    case 210 -> 76;
                    case 211 -> 145;
                    case 212 -> 116;
                    case 213 -> 219;
                    case 214 -> 41;
                    case 215 -> 74;
                    case 216 -> 59;
                    case 217 -> 94;
                    case 218 -> 14;
                    case 219 -> 117;
                    case 220 -> 125;
                    case 221 -> 16;
                    case 222 -> 244;
                    case 223 -> 54;
                    case 224 -> 113;
                    case 225 -> 206;
                    case 226 -> 226;
                    case 227 -> 254;
                    case 228 -> 127;
                    case 229 -> 223;
                    case 230 -> 167;
                    case 231 -> 144;
                    case 232 -> 212;
                    case 233 -> 231;
                    case 234 -> 221;
                    case 235 -> 194;
                    case 236 -> 70;
                    case 237 -> 210;
                    case 238 -> 90;
                    case 239 -> 222;
                    case 240 -> 179;
                    case 241 -> 140;
                    case 242 -> 230;
                    case 243 -> 241;
                    case 244 -> 137;
                    case 245 -> 97;
                    case 246 -> 195;
                    case 247 -> 63;
                    case 248 -> 250;
                    case 249 -> 139;
                    case 250 -> 30;
                    case 251 -> 214;
                    case 252 -> 24;
                    case 253 -> 197;
                    case 254 -> 153;
                    default -> 120;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeReadableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeWritableByteChannel;", "Ljava/nio/channels/WritableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeWritableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "write", "", "src", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    private static final class PipeWritableByteChannel
    implements WritableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeWritableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 12026953808704L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeWritableByteChannel.a(-1045414320 - -19226, 1045414320 - (char)-23539, (int)l2));
            this.agent = agent;
        }

        @Override
        public int write(@NotNull ByteBuffer src) {
            int n2;
            block7: {
                IntByReference intByReference;
                block8: {
                    long l2 = 39575757331196L;
                    ActionTimestamp[] actionTimestampArray = SshAgentIpcService.d();
                    Intrinsics.checkNotNullParameter((Object)src, (String)PipeWritableByteChannel.a(-1928695050 - -13793, -1928695050 - -6661, (int)l2));
                    ActionTimestamp[] actionTimestampArray2 = actionTimestampArray;
                    try {
                        if (!this.agent.isOpen()) {
                            throw new ClosedChannelException();
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                    intByReference = new IntByReference();
                    byte[] byArray = new byte[src.remaining()];
                    try {
                        try {
                            src.get(byArray);
                            n2 = Kernel32.INSTANCE.WriteFile(this.agent.hPipe, byArray, byArray.length, intByReference, null);
                            if (actionTimestampArray2 != null) break block7;
                            if (n2 != 0) break block8;
                        }
                        catch (RuntimeException runtimeException) {
                            throw PipeWritableByteChannel.a(runtimeException);
                        }
                        return -1;
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                }
                n2 = intByReference.getValue();
            }
            return n2;
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 139151595222179L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeWritableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block13: {
                var5 = new String[2];
                var3_1 = 0;
                var2_2 = "9\u00b8d\u00b5\r\u0003\u001b\u00c9v";
                var4_3 = "9\u00b8d\u00b5\r\u0003\u001b\u00c9v".length();
                var1_4 = 5;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    continue;
                    break;
                }
lbl9:
                // 1 sources

                while (true) {
                    var5[var3_1++] = new String(v0).intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block13;
                    break;
                }
                v1 = ++var0_5;
                v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                v3 = v2.length;
                var6_6 = 0;
                v4 = 79;
                v5 = v2;
                v6 = v3;
                if (v3 > 1) ** GOTO lbl67
                do {
                    v7 = v4;
                    v5 = v5;
                    v8 = v5;
                    v9 = v4;
                    v10 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v11 = 78;
                                break;
                            }
                            case 1: {
                                v11 = 12;
                                break;
                            }
                            case 2: {
                                v11 = 4;
                                break;
                            }
                            case 3: {
                                v11 = 96;
                                break;
                            }
                            case 4: {
                                v11 = 26;
                                break;
                            }
                            case 5: {
                                v11 = 5;
                                break;
                            }
                            default: {
                                v11 = 88;
                            }
                        }
                        v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                        ++var6_6;
                        v4 = v7;
                        if (v7 != 0) break;
                        v7 = v4;
                        v5 = v5;
                        v10 = v4;
                        v8 = v5;
                        v9 = v4;
                    }
lbl67:
                    // 2 sources

                    v0 = v5;
                    v6 = v6;
                } while (v6 > var6_6);
                ** while (true)
            }
            PipeWritableByteChannel.a = var5;
            PipeWritableByteChannel.b = new String[2];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0xFFFFB22A) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 26;
                    case 1 -> 216;
                    case 2 -> 244;
                    case 3 -> 90;
                    case 4 -> 103;
                    case 5 -> 202;
                    case 6 -> 11;
                    case 7 -> 98;
                    case 8 -> 21;
                    case 9 -> 252;
                    case 10 -> 7;
                    case 11 -> 83;
                    case 12 -> 157;
                    case 13 -> 254;
                    case 14 -> 102;
                    case 15 -> 176;
                    case 16 -> 225;
                    case 17 -> 58;
                    case 18 -> 4;
                    case 19 -> 180;
                    case 20 -> 192;
                    case 21 -> 229;
                    case 22 -> 175;
                    case 23 -> 6;
                    case 24 -> 217;
                    case 25 -> 76;
                    case 26 -> 158;
                    case 27 -> 3;
                    case 28 -> 96;
                    case 29 -> 240;
                    case 30 -> 59;
                    case 31 -> 145;
                    case 32 -> 30;
                    case 33 -> 183;
                    case 34 -> 33;
                    case 35 -> 184;
                    case 36 -> 53;
                    case 37 -> 182;
                    case 38 -> 81;
                    case 39 -> 149;
                    case 40 -> 16;
                    case 41 -> 132;
                    case 42 -> 204;
                    case 43 -> 25;
                    case 44 -> 105;
                    case 45 -> 220;
                    case 46 -> 238;
                    case 47 -> 91;
                    case 48 -> 40;
                    case 49 -> 39;
                    case 50 -> 32;
                    case 51 -> 242;
                    case 52 -> 44;
                    case 53 -> 178;
                    case 54 -> 112;
                    case 55 -> 154;
                    case 56 -> 138;
                    case 57 -> 155;
                    case 58 -> 10;
                    case 59 -> 31;
                    case 60 -> 188;
                    case 61 -> 12;
                    case 62 -> 209;
                    case 63 -> 166;
                    case 64 -> 34;
                    case 65 -> 85;
                    case 66 -> 47;
                    case 67 -> 14;
                    case 68 -> 169;
                    case 69 -> 118;
                    case 70 -> 179;
                    case 71 -> 55;
                    case 72 -> 195;
                    case 73 -> 167;
                    case 74 -> 97;
                    case 75 -> 173;
                    case 76 -> 37;
                    case 77 -> 159;
                    case 78 -> 28;
                    case 79 -> 60;
                    case 80 -> 24;
                    case 81 -> 116;
                    case 82 -> 63;
                    case 83 -> 54;
                    case 84 -> 190;
                    case 85 -> 35;
                    case 86 -> 139;
                    case 87 -> 208;
                    case 88 -> 80;
                    case 89 -> 128;
                    case 90 -> 57;
                    case 91 -> 199;
                    case 92 -> 247;
                    case 93 -> 71;
                    case 94 -> 125;
                    case 95 -> 241;
                    case 96 -> 110;
                    case 97 -> 147;
                    case 98 -> 233;
                    case 99 -> 95;
                    case 100 -> 197;
                    case 101 -> 109;
                    case 102 -> 130;
                    case 103 -> 101;
                    case 104 -> 137;
                    case 105 -> 56;
                    case 106 -> 196;
                    case 107 -> 201;
                    case 108 -> 67;
                    case 109 -> 170;
                    case 110 -> 87;
                    case 111 -> 23;
                    case 112 -> 73;
                    case 113 -> 133;
                    case 114 -> 70;
                    case 115 -> 50;
                    case 116 -> 228;
                    case 117 -> 18;
                    case 118 -> 234;
                    case 119 -> 1;
                    case 120 -> 143;
                    case 121 -> 250;
                    case 122 -> 164;
                    case 123 -> 115;
                    case 124 -> 239;
                    case 125 -> 246;
                    case 126 -> 13;
                    case 127 -> 189;
                    case 128 -> 249;
                    case 129 -> 171;
                    case 130 -> 140;
                    case 131 -> 2;
                    case 132 -> 181;
                    case 133 -> 38;
                    case 134 -> 227;
                    case 135 -> 210;
                    case 136 -> 156;
                    case 137 -> 106;
                    case 138 -> 253;
                    case 139 -> 160;
                    case 140 -> 107;
                    case 141 -> 223;
                    case 142 -> 142;
                    case 143 -> 193;
                    case 144 -> 255;
                    case 145 -> 211;
                    case 146 -> 144;
                    case 147 -> 198;
                    case 148 -> 61;
                    case 149 -> 29;
                    case 150 -> 42;
                    case 151 -> 215;
                    case 152 -> 0;
                    case 153 -> 68;
                    case 154 -> 94;
                    case 155 -> 99;
                    case 156 -> 129;
                    case 157 -> 72;
                    case 158 -> 66;
                    case 159 -> 177;
                    case 160 -> 20;
                    case 161 -> 186;
                    case 162 -> 135;
                    case 163 -> 136;
                    case 164 -> 187;
                    case 165 -> 153;
                    case 166 -> 222;
                    case 167 -> 5;
                    case 168 -> 163;
                    case 169 -> 245;
                    case 170 -> 75;
                    case 171 -> 86;
                    case 172 -> 8;
                    case 173 -> 226;
                    case 174 -> 231;
                    case 175 -> 82;
                    case 176 -> 92;
                    case 177 -> 251;
                    case 178 -> 148;
                    case 179 -> 224;
                    case 180 -> 100;
                    case 181 -> 36;
                    case 182 -> 214;
                    case 183 -> 200;
                    case 184 -> 114;
                    case 185 -> 152;
                    case 186 -> 161;
                    case 187 -> 46;
                    case 188 -> 126;
                    case 189 -> 213;
                    case 190 -> 206;
                    case 191 -> 104;
                    case 192 -> 79;
                    case 193 -> 117;
                    case 194 -> 62;
                    case 195 -> 207;
                    case 196 -> 124;
                    case 197 -> 49;
                    case 198 -> 248;
                    case 199 -> 230;
                    case 200 -> 113;
                    case 201 -> 221;
                    case 202 -> 150;
                    case 203 -> 77;
                    case 204 -> 205;
                    case 205 -> 41;
                    case 206 -> 43;
                    case 207 -> 203;
                    case 208 -> 218;
                    case 209 -> 243;
                    case 210 -> 27;
                    case 211 -> 168;
                    case 212 -> 64;
                    case 213 -> 212;
                    case 214 -> 17;
                    case 215 -> 84;
                    case 216 -> 93;
                    case 217 -> 52;
                    case 218 -> 69;
                    case 219 -> 65;
                    case 220 -> 48;
                    case 221 -> 191;
                    case 222 -> 121;
                    case 223 -> 51;
                    case 224 -> 174;
                    case 225 -> 194;
                    case 226 -> 9;
                    case 227 -> 141;
                    case 228 -> 162;
                    case 229 -> 236;
                    case 230 -> 88;
                    case 231 -> 15;
                    case 232 -> 219;
                    case 233 -> 151;
                    case 234 -> 146;
                    case 235 -> 22;
                    case 236 -> 19;
                    case 237 -> 237;
                    case 238 -> 108;
                    case 239 -> 122;
                    case 240 -> 235;
                    case 241 -> 185;
                    case 242 -> 119;
                    case 243 -> 172;
                    case 244 -> 78;
                    case 245 -> 45;
                    case 246 -> 120;
                    case 247 -> 89;
                    case 248 -> 165;
                    case 249 -> 123;
                    case 250 -> 131;
                    case 251 -> 111;
                    case 252 -> 134;
                    case 253 -> 127;
                    case 254 -> 74;
                    default -> 232;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeWritableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }
}

