/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.vuejs.lang.html.parser;

import com.intellij.lang.PsiBuilder;
import com.intellij.lang.html.HtmlParsing;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.openapi.util.KeyWithDefaultValue;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlElementType;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.ThreeState;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.vuejs.VueBundle;
import org.jetbrains.vuejs.codeInsight.attributes.VueAttributeNameParser;
import org.jetbrains.vuejs.lang.LangMode;
import org.jetbrains.vuejs.lang.VueScriptLangs;
import org.jetbrains.vuejs.lang.expr.parser.VueJSEmbeddedExprTokenType;
import org.jetbrains.vuejs.lang.html.lexer.VueLangModeMarkerElementType;
import org.jetbrains.vuejs.lang.html.lexer.VueLexer;
import org.jetbrains.vuejs.lang.html.lexer.VueTokenTypes;
import org.jetbrains.vuejs.lang.html.parser.VueElementTypes;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 .2\u00020\u0001:\u0002-.B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\n\u001a\u00020\tH\u0014J\b\u0010\u000b\u001a\u00020\tH\u0014J\b\u0010\f\u001a\u00020\tH\u0014J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0014\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0010H\u0014J\u0010\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0014H\u0014J\u0014\u0010\u0015\u001a\u0004\u0018\u00010\u00102\b\u0010\u0016\u001a\u0004\u0018\u00010\u0010H\u0014J\b\u0010\u0017\u001a\u00020\u000eH\u0014J\u0018\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0014J\u001c\u0010\u001d\u001a\u00060\u001eR\u00020\u00012\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0010H\u0014J\u0010\u0010\"\u001a\u00020\t2\u0006\u0010#\u001a\u00020\u001aH\u0014J\u0010\u0010$\u001a\u00020\t2\u0006\u0010#\u001a\u00020\u001aH\u0014J\u0018\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u001a2\u0006\u0010(\u001a\u00020\u001aH\u0014J\u0018\u0010)\u001a\u00020\t2\u0006\u0010'\u001a\u00020\u001a2\u0006\u0010*\u001a\u00020 H\u0014J\b\u0010+\u001a\u00020\tH\u0002J\b\u0010,\u001a\u00020\tH\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lorg/jetbrains/vuejs/lang/html/parser/VueParsing;", "Lcom/intellij/lang/html/HtmlParsing;", "builder", "Lcom/intellij/lang/PsiBuilder;", "<init>", "(Lcom/intellij/lang/PsiBuilder;)V", "langMode", "Lorg/jetbrains/vuejs/lang/LangMode;", "htmlCompatMode", "", "hasCustomTagContent", "hasCustomTopLevelContent", "shouldContinueMainLoop", "parseDocument", "", "parseCustomTagContent", "Lcom/intellij/lang/PsiBuilder$Marker;", "xmlText", "maybeRemapCurrentToken", "tokenType", "Lcom/intellij/psi/tree/IElementType;", "parseCustomTopLevelContent", "error", "parseAttribute", "getHtmlTagElementType", "info", "Lcom/intellij/lang/html/HtmlParsing$HtmlTagInfo;", "tagLevel", "", "createHtmlTagInfo", "Lcom/intellij/lang/html/HtmlParsing$HtmlTagInfoImpl;", "originalTagName", "", "startMarker", "isSingleTag", "tagInfo", "isEndTagRequired", "canOpeningTagAutoClose", "Lcom/intellij/util/ThreeState;", "tagToClose", "openingTag", "canClosingTagAutoClose", "closingTag", "inVPreContext", "inScriptSetup", "VueHtmlTagInfo", "Companion", "intellij.vuejs"})
public final class VueParsing
extends HtmlParsing {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LangMode langMode;
    private final boolean htmlCompatMode;
    @NotNull
    private static final List<String> ALWAYS_STUBBED_TAGS;
    @NotNull
    private static final List<String> TOP_LEVEL_TAGS;
    @NotNull
    private static final KeyWithDefaultValue<Boolean> HTML_COMPAT_MODE;

    public VueParsing(@NotNull PsiBuilder builder2) {
        Intrinsics.checkNotNullParameter((Object)builder2, (String)"builder");
        super(builder2);
        LangMode langMode = (LangMode)((Object)builder2.getUserData(VueScriptLangs.INSTANCE.getLANG_MODE$intellij_vuejs()));
        if (langMode == null) {
            langMode = LangMode.Companion.getDEFAULT();
        }
        this.langMode = langMode;
        Object object = HTML_COMPAT_MODE.get((UserDataHolder)builder2);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        this.htmlCompatMode = (Boolean)object;
    }

    protected boolean hasCustomTagContent() {
        return this.token() == VueTokenTypes.INTERPOLATION_START;
    }

    protected boolean hasCustomTopLevelContent() {
        return this.token() == VueTokenTypes.INTERPOLATION_START;
    }

    protected boolean shouldContinueMainLoop() {
        return super.shouldContinueMainLoop() && !(this.token() instanceof VueLangModeMarkerElementType);
    }

    public void parseDocument() {
        super.parseDocument();
        if (this.token() instanceof VueLangModeMarkerElementType) {
            this.advance();
        }
    }

    @Nullable
    protected PsiBuilder.Marker parseCustomTagContent(@Nullable PsiBuilder.Marker xmlText) {
        PsiBuilder.Marker result = xmlText;
        IElementType tt = this.token();
        if (tt == VueTokenTypes.INTERPOLATION_START) {
            result = !this.inVPreContext() ? HtmlParsing.terminateText((PsiBuilder.Marker)result) : this.startText(result);
            PsiBuilder.Marker interpolation = this.mark();
            this.advance();
            if (this.token() instanceof VueJSEmbeddedExprTokenType) {
                IElementType iElementType = this.token();
                Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"token(...)");
                this.maybeRemapCurrentToken(iElementType);
                this.advance();
            }
            if (!this.inVPreContext()) {
                if (this.token() == VueTokenTypes.INTERPOLATION_END) {
                    this.advance();
                    interpolation.drop();
                } else {
                    interpolation.error(VueBundle.message((String)"vue.parser.message.unterminated.interpolation", (Object[])new Object[0]));
                }
            } else {
                if (this.token() == VueTokenTypes.INTERPOLATION_END) {
                    this.advance();
                }
                interpolation.collapse(XmlTokenType.XML_DATA_CHARACTERS);
            }
        }
        return result;
    }

    protected void maybeRemapCurrentToken(@NotNull IElementType tokenType) {
        Intrinsics.checkNotNullParameter((Object)tokenType, (String)"tokenType");
        IElementType iElementType = tokenType;
        if (iElementType instanceof VueJSEmbeddedExprTokenType) {
            if (this.inVPreContext()) {
                this.getBuilder().remapCurrentToken(XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN);
            } else {
                this.getBuilder().remapCurrentToken((IElementType)((VueJSEmbeddedExprTokenType)tokenType).copyWithLanguage(this.langMode));
            }
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)JSElementTypes.MOD_TS_EMBEDDED_CONTENT)) {
            if (this.inScriptSetup()) {
                this.getBuilder().remapCurrentToken((IElementType)VueElementTypes.INSTANCE.getSCRIPT_SETUP_TS_EMBEDDED_CONTENT());
            }
        } else if ((Intrinsics.areEqual((Object)iElementType, (Object)JSElementTypes.MOD_ES6_EMBEDDED_CONTENT) || Intrinsics.areEqual((Object)iElementType, (Object)JSElementTypes.MOD_EMBEDDED_CONTENT)) && this.inScriptSetup()) {
            this.getBuilder().remapCurrentToken((IElementType)VueElementTypes.INSTANCE.getSCRIPT_SETUP_JS_EMBEDDED_CONTENT());
        }
    }

    @Nullable
    protected PsiBuilder.Marker parseCustomTopLevelContent(@Nullable PsiBuilder.Marker error) {
        PsiBuilder.Marker result = HtmlParsing.flushError((PsiBuilder.Marker)error);
        HtmlParsing.terminateText((PsiBuilder.Marker)this.parseCustomTagContent(null));
        return result;
    }

    protected void parseAttribute() {
        boolean bl;
        boolean bl2 = bl = this.token() == XmlTokenType.XML_NAME;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        PsiBuilder.Marker attr = this.mark();
        String string = this.peekTagInfo().getNormalizedName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getNormalizedName(...)");
        String tagName = string;
        String string2 = this.getBuilder().getTokenText();
        Intrinsics.checkNotNull((Object)string2);
        VueAttributeNameParser.VueAttributeInfo attributeInfo = VueAttributeNameParser.Companion.parse(string2, tagName, this.stackSize() == 1);
        this.advance();
        if (attributeInfo instanceof VueAttributeNameParser.VueDirectiveInfo && ((VueAttributeNameParser.VueDirectiveInfo)attributeInfo).getDirectiveKind() == VueAttributeNameParser.VueDirectiveKind.PRE) {
            HtmlParsing.HtmlTagInfo htmlTagInfo = this.peekTagInfo();
            Intrinsics.checkNotNull((Object)htmlTagInfo, (String)"null cannot be cast to non-null type org.jetbrains.vuejs.lang.html.parser.VueParsing.VueHtmlTagInfo");
            ((VueHtmlTagInfo)htmlTagInfo).setHasVPre(true);
        } else if (attributeInfo.getKind() == VueAttributeNameParser.VueAttributeKind.SCRIPT_SETUP || attributeInfo.getKind() == VueAttributeNameParser.VueAttributeKind.SCRIPT_VAPOR) {
            HtmlParsing.HtmlTagInfo htmlTagInfo = this.peekTagInfo();
            Intrinsics.checkNotNull((Object)htmlTagInfo, (String)"null cannot be cast to non-null type org.jetbrains.vuejs.lang.html.parser.VueParsing.VueHtmlTagInfo");
            ((VueHtmlTagInfo)htmlTagInfo).setHasScriptSetup(true);
        }
        if (this.token() == XmlTokenType.XML_EQ) {
            this.advance();
            this.parseAttributeValue();
        }
        String string3 = tagName;
        Locale locale = Locale.US;
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
        String string4 = string3.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
        if (Intrinsics.areEqual((Object)string4, (Object)"slot")) {
            attr.done((IElementType)VueElementTypes.INSTANCE.getATTRIBUTE());
        } else {
            switch (WhenMappings.$EnumSwitchMapping$0[attributeInfo.getKind().ordinal()]) {
                case 1: 
                case 2: 
                case 3: {
                    attr.done((IElementType)VueElementTypes.INSTANCE.getSRC_ATTRIBUTE());
                    break;
                }
                case 4: {
                    attr.done((IElementType)VueElementTypes.INSTANCE.getSCRIPT_ID_ATTRIBUTE());
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    attr.done((IElementType)VueElementTypes.INSTANCE.getATTRIBUTE());
                    break;
                }
                case 9: {
                    attr.done((IElementType)VueElementTypes.INSTANCE.getREF_ATTRIBUTE());
                    break;
                }
                default: {
                    attr.done(XmlElementType.XML_ATTRIBUTE);
                }
            }
        }
    }

    @NotNull
    protected IElementType getHtmlTagElementType(@NotNull HtmlParsing.HtmlTagInfo info, int tagLevel) {
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        String string = info.getNormalizedName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getNormalizedName(...)");
        String string2 = string;
        Locale locale = Locale.US;
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
        String string3 = string2.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
        String tagName = string3;
        if (ALWAYS_STUBBED_TAGS.contains(tagName) || tagLevel == 1 && TOP_LEVEL_TAGS.contains(tagName)) {
            return Intrinsics.areEqual((Object)tagName, (Object)"template") ? (IElementType)VueElementTypes.INSTANCE.getTEMPLATE_TAG() : (IElementType)VueElementTypes.INSTANCE.getTAG();
        }
        IElementType iElementType = super.getHtmlTagElementType(info, tagLevel);
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"getHtmlTagElementType(...)");
        return iElementType;
    }

    @NotNull
    protected HtmlParsing.HtmlTagInfoImpl createHtmlTagInfo(@NotNull String originalTagName, @NotNull PsiBuilder.Marker startMarker) {
        Intrinsics.checkNotNullParameter((Object)originalTagName, (String)"originalTagName");
        Intrinsics.checkNotNullParameter((Object)startMarker, (String)"startMarker");
        String string = this.normalizeTagName(originalTagName);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"normalizeTagName(...)");
        return new VueHtmlTagInfo(this, string, originalTagName, startMarker, this.inVPreContext(), false, 16, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean isSingleTag(@NotNull HtmlParsing.HtmlTagInfo tagInfo) {
        Intrinsics.checkNotNullParameter((Object)tagInfo, (String)"tagInfo");
        if (!this.htmlCompatMode) {
            String string = tagInfo.getOriginalName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getOriginalName(...)");
            if (VueLexer.Companion.isPossiblyComponentTag(string)) return false;
        }
        if (!super.isSingleTag(tagInfo)) return false;
        return true;
    }

    protected boolean isEndTagRequired(@NotNull HtmlParsing.HtmlTagInfo tagInfo) {
        Intrinsics.checkNotNullParameter((Object)tagInfo, (String)"tagInfo");
        return this.htmlCompatMode ? super.isEndTagRequired(tagInfo) : true;
    }

    @NotNull
    protected ThreeState canOpeningTagAutoClose(@NotNull HtmlParsing.HtmlTagInfo tagToClose, @NotNull HtmlParsing.HtmlTagInfo openingTag) {
        ThreeState threeState;
        Intrinsics.checkNotNullParameter((Object)tagToClose, (String)"tagToClose");
        Intrinsics.checkNotNullParameter((Object)openingTag, (String)"openingTag");
        if (this.htmlCompatMode) {
            ThreeState threeState2 = super.canOpeningTagAutoClose(tagToClose, openingTag);
            threeState = threeState2;
            Intrinsics.checkNotNullExpressionValue((Object)threeState2, (String)"canOpeningTagAutoClose(...)");
        } else {
            threeState = ThreeState.NO;
        }
        return threeState;
    }

    protected boolean canClosingTagAutoClose(@NotNull HtmlParsing.HtmlTagInfo tagToClose, @NotNull String closingTag) {
        Intrinsics.checkNotNullParameter((Object)tagToClose, (String)"tagToClose");
        Intrinsics.checkNotNullParameter((Object)closingTag, (String)"closingTag");
        return this.htmlCompatMode ? super.canClosingTagAutoClose(tagToClose, closingTag) : false;
    }

    private final boolean inVPreContext() {
        Ref.BooleanRef result = new Ref.BooleanRef();
        this.processStackItems(arg_0 -> VueParsing.inVPreContext$lambda$1(arg_0 -> VueParsing.inVPreContext$lambda$0(result, arg_0), arg_0));
        return result.element;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean inScriptSetup() {
        if (this.stackSize() <= 0) return false;
        HtmlParsing.HtmlTagInfo htmlTagInfo = this.peekTagInfo();
        if (!(htmlTagInfo instanceof VueHtmlTagInfo)) return false;
        VueHtmlTagInfo vueHtmlTagInfo = (VueHtmlTagInfo)htmlTagInfo;
        if (vueHtmlTagInfo == null) return false;
        if (!vueHtmlTagInfo.getHasScriptSetup()) return false;
        return true;
    }

    private static final boolean inVPreContext$lambda$0(Ref.BooleanRef $result, HtmlParsing.HtmlParserStackItem it) {
        boolean bl;
        if (it instanceof VueHtmlTagInfo) {
            $result.element = ((VueHtmlTagInfo)it).getHasVPre();
            bl = false;
        } else {
            bl = true;
        }
        return bl;
    }

    private static final boolean inVPreContext$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    static {
        Object[] objectArray = new String[]{"script", "slot"};
        ALWAYS_STUBBED_TAGS = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"template", "style"};
        TOP_LEVEL_TAGS = CollectionsKt.listOf((Object[])objectArray);
        KeyWithDefaultValue keyWithDefaultValue = KeyWithDefaultValue.create((String)"vue.html.compat.mode", (Object)true);
        Intrinsics.checkNotNullExpressionValue((Object)keyWithDefaultValue, (String)"create(...)");
        HTML_COMPAT_MODE = keyWithDefaultValue;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/vuejs/lang/html/parser/VueParsing$Companion;", "", "<init>", "()V", "ALWAYS_STUBBED_TAGS", "", "", "getALWAYS_STUBBED_TAGS", "()Ljava/util/List;", "TOP_LEVEL_TAGS", "getTOP_LEVEL_TAGS", "HTML_COMPAT_MODE", "Lcom/intellij/openapi/util/KeyWithDefaultValue;", "", "getHTML_COMPAT_MODE", "()Lcom/intellij/openapi/util/KeyWithDefaultValue;", "intellij.vuejs"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<String> getALWAYS_STUBBED_TAGS() {
            return ALWAYS_STUBBED_TAGS;
        }

        @NotNull
        public final List<String> getTOP_LEVEL_TAGS() {
            return TOP_LEVEL_TAGS;
        }

        @NotNull
        public final KeyWithDefaultValue<Boolean> getHTML_COMPAT_MODE() {
            return HTML_COMPAT_MODE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B1\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u000b\u0010\fR\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\n\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u000e\"\u0004\b\u0012\u0010\u0010\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/vuejs/lang/html/parser/VueParsing$VueHtmlTagInfo;", "Lcom/intellij/lang/html/HtmlParsing$HtmlTagInfoImpl;", "Lcom/intellij/lang/html/HtmlParsing;", "normalizedName", "", "originalName", "marker", "Lcom/intellij/lang/PsiBuilder$Marker;", "hasVPre", "", "hasScriptSetup", "<init>", "(Lorg/jetbrains/vuejs/lang/html/parser/VueParsing;Ljava/lang/String;Ljava/lang/String;Lcom/intellij/lang/PsiBuilder$Marker;ZZ)V", "getHasVPre", "()Z", "setHasVPre", "(Z)V", "getHasScriptSetup", "setHasScriptSetup", "intellij.vuejs"})
    private final class VueHtmlTagInfo
    extends HtmlParsing.HtmlTagInfoImpl {
        private boolean hasVPre;
        private boolean hasScriptSetup;
        final /* synthetic */ VueParsing this$0;

        public VueHtmlTagInfo(@NotNull VueParsing this$0, @NotNull String normalizedName, @NotNull String originalName, PsiBuilder.Marker marker, boolean hasVPre, boolean hasScriptSetup) {
            Intrinsics.checkNotNullParameter((Object)normalizedName, (String)"normalizedName");
            Intrinsics.checkNotNullParameter((Object)originalName, (String)"originalName");
            Intrinsics.checkNotNullParameter((Object)marker, (String)"marker");
            this.this$0 = this$0;
            super((HtmlParsing)this$0, normalizedName, originalName, marker);
            this.hasVPre = hasVPre;
            this.hasScriptSetup = hasScriptSetup;
        }

        public /* synthetic */ VueHtmlTagInfo(VueParsing vueParsing, String string, String string2, PsiBuilder.Marker marker, boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 0x10) != 0) {
                bl2 = false;
            }
            this(vueParsing, string, string2, marker, bl, bl2);
        }

        public final boolean getHasVPre() {
            return this.hasVPre;
        }

        public final void setHasVPre(boolean bl) {
            this.hasVPre = bl;
        }

        public final boolean getHasScriptSetup() {
            return this.hasScriptSetup;
        }

        public final void setHasScriptSetup(boolean bl) {
            this.hasScriptSetup = bl;
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[VueAttributeNameParser.VueAttributeKind.values().length];
            try {
                nArray[VueAttributeNameParser.VueAttributeKind.TEMPLATE_SRC.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VueAttributeNameParser.VueAttributeKind.SCRIPT_SRC.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VueAttributeNameParser.VueAttributeKind.STYLE_SRC.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VueAttributeNameParser.VueAttributeKind.SCRIPT_ID.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VueAttributeNameParser.VueAttributeKind.SCRIPT_SETUP.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VueAttributeNameParser.VueAttributeKind.SCRIPT_VAPOR.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VueAttributeNameParser.VueAttributeKind.SCRIPT_GENERIC.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VueAttributeNameParser.VueAttributeKind.STYLE_MODULE.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VueAttributeNameParser.VueAttributeKind.REF.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

