/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.vuejs.libraries.nuxt.actions;

import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterManager;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.modules.InstallNodeModuleQuickFix;
import com.intellij.lang.javascript.modules.PackageInstaller;
import com.intellij.notification.Notification;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.text.SemVer;
import com.intellij.webcore.packaging.PackageManagementService;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.vuejs.libraries.nuxt.NuxtUtilsKt;
import org.jetbrains.vuejs.libraries.nuxt.actions.InstallNuxtTypesAction;
import org.jetbrains.vuejs.libraries.nuxt.model.NuxtApplication;
import org.jetbrains.vuejs.libraries.nuxt.model.NuxtModelManager;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/vuejs/libraries/nuxt/actions/InstallNuxtTypesAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "project", "Lcom/intellij/openapi/project/Project;", "packageJson", "Lcom/intellij/openapi/vfs/VirtualFile;", "notification", "Lcom/intellij/notification/Notification;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/notification/Notification;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getPackageJson", "()Lcom/intellij/openapi/vfs/VirtualFile;", "getNotification", "()Lcom/intellij/notification/Notification;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getMatchingTypesVersion", "", "nuxtVersion", "Lcom/intellij/util/text/SemVer;", "intellij.vuejs"})
public final class InstallNuxtTypesAction
extends DumbAwareAction {
    @NotNull
    private final Project project;
    @NotNull
    private final VirtualFile packageJson;
    @NotNull
    private final Notification notification;

    public InstallNuxtTypesAction(@NotNull Project project, @NotNull VirtualFile packageJson, @NotNull Notification notification) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)packageJson, (String)"packageJson");
        Intrinsics.checkNotNullParameter((Object)notification, (String)"notification");
        Object[] objectArray = new Object[]{"@nuxt/types"};
        super(JavaScriptBundle.message((String)"node.js.quickfix.install.node.module.with.dev.dependencies.text", (Object[])objectArray));
        this.project = project;
        this.packageJson = packageJson;
        this.notification = notification;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final VirtualFile getPackageJson() {
        return this.packageJson;
    }

    @NotNull
    public final Notification getNotification() {
        return this.notification;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        NodeJsInterpreter nodeJsInterpreter = NodeJsInterpreterManager.getInstance((Project)this.project).getInterpreter();
        if (nodeJsInterpreter == null) {
            return;
        }
        NodeJsInterpreter interpreter = nodeJsInterpreter;
        VirtualFile parent = this.packageJson.getParent();
        this.notification.hideBalloon();
        Project project = this.project;
        Object[] objectArray = new Object[]{"@nuxt/types"};
        String string = JavaScriptBundle.message((String)"node.js.quickfix.install.node.module.with.dev.dependencies.text", (Object[])objectArray);
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(this, interpreter, parent, project, string){
            final /* synthetic */ InstallNuxtTypesAction this$0;
            final /* synthetic */ NodeJsInterpreter $interpreter;
            final /* synthetic */ VirtualFile $parent;
            {
                this.this$0 = $receiver;
                this.$interpreter = $interpreter;
                this.$parent = $parent;
                super($super_call_param$1, $super_call_param$2, true);
            }

            public void run(ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                String expectedVersion = (String)ReadAction.compute(() -> actionPerformed.1.run$lambda$0(this, this.this$0));
                String extraOptions = InstallNodeModuleQuickFix.buildExtraOptions((Project)this.getProject(), (boolean)true);
                PackageManagementService.Listener listener = InstallNodeModuleQuickFix.createListener((Project)this.getProject(), (VirtualFile)this.this$0.getPackageJson(), (String)"@nuxt/types");
                Intrinsics.checkNotNullExpressionValue((Object)listener, (String)"createListener(...)");
                PackageManagementService.Listener listener2 = listener;
                new PackageInstaller(this.getProject(), this.$interpreter, "@nuxt/types", expectedVersion, new File(this.$parent.getPath()), listener2, extraOptions).run(indicator);
                VirtualFile[] virtualFileArray = new VirtualFile[]{this.this$0.getPackageJson()};
                VfsUtil.markDirtyAndRefresh((boolean)true, (boolean)false, (boolean)false, (VirtualFile[])virtualFileArray);
            }

            private static final String run$lambda$0(actionPerformed.1 this$0, InstallNuxtTypesAction this$1) {
                String string;
                SemVer semVer;
                Project project = this$0.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                NuxtApplication nuxtApplication = NuxtModelManager.INSTANCE.getApplication(project, this$1.getPackageJson());
                if (nuxtApplication != null && (semVer = nuxtApplication.getNuxtVersion()) != null) {
                    SemVer it = semVer;
                    boolean bl = false;
                    string = InstallNuxtTypesAction.access$getMatchingTypesVersion(this$1, it);
                } else {
                    string = null;
                }
                return string;
            }
        });
    }

    private final String getMatchingTypesVersion(SemVer nuxtVersion) {
        Object object;
        if (nuxtVersion.isGreaterOrEqualThan(NuxtUtilsKt.getNUXT_2_13_0())) {
            object = nuxtVersion.getMajor() + "." + nuxtVersion.getMinor();
        } else {
            switch (nuxtVersion.getMinor()) {
                case 9: {
                    object = "0.2";
                    break;
                }
                case 10: {
                    object = "0.5";
                    break;
                }
                case 11: {
                    object = "0.6";
                    break;
                }
                case 12: {
                    object = "0.7";
                    break;
                }
                default: {
                    return null;
                }
            }
        }
        return "~" + (String)object + ".0";
    }

    public static final /* synthetic */ String access$getMatchingTypesVersion(InstallNuxtTypesAction $this, SemVer nuxtVersion) {
        return $this.getMatchingTypesVersion(nuxtVersion);
    }
}

