/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.vuejs.model.source;

import com.intellij.model.Pointer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointersKt;
import com.intellij.psi.SmartPsiElementPointer;
import java.util.List;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.vuejs.model.VueDirective;
import org.jetbrains.vuejs.model.VueEntitiesContainer;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00000\u0013H\u0016J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0096\u0002J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u0003H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/vuejs/model/source/VueSourceDirective;", "Lorg/jetbrains/vuejs/model/VueDirective;", "name", "", "source", "Lcom/intellij/psi/PsiElement;", "<init>", "(Ljava/lang/String;Lcom/intellij/psi/PsiElement;)V", "getSource", "()Lcom/intellij/psi/PsiElement;", "defaultName", "getDefaultName", "()Ljava/lang/String;", "parents", "", "Lorg/jetbrains/vuejs/model/VueEntitiesContainer;", "getParents", "()Ljava/util/List;", "createPointer", "Lcom/intellij/model/Pointer;", "equals", "", "other", "", "hashCode", "", "toString", "intellij.vuejs"})
public final class VueSourceDirective
implements VueDirective {
    @NotNull
    private final PsiElement source;
    @NotNull
    private final String defaultName;
    @NotNull
    private final List<VueEntitiesContainer> parents;

    public VueSourceDirective(@NotNull String name, @NotNull PsiElement source) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        this.source = source;
        this.defaultName = name;
        this.parents = CollectionsKt.emptyList();
    }

    @Override
    @NotNull
    public PsiElement getSource() {
        return this.source;
    }

    @Override
    @NotNull
    public String getDefaultName() {
        return this.defaultName;
    }

    @Override
    @NotNull
    public List<VueEntitiesContainer> getParents() {
        return this.parents;
    }

    @NotNull
    public Pointer<? extends VueSourceDirective> createPointer() {
        String name = this.getDefaultName();
        SmartPsiElementPointer source = SmartPointersKt.createSmartPointer((PsiElement)this.getSource());
        return () -> VueSourceDirective.createPointer$lambda$0(source, name);
    }

    public boolean equals(@Nullable Object other) {
        return other == this || other instanceof VueSourceDirective && Intrinsics.areEqual((Object)((VueSourceDirective)other).getDefaultName(), (Object)this.getDefaultName()) && Intrinsics.areEqual((Object)((VueSourceDirective)other).getSource(), (Object)this.getSource());
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.getDefaultName(), this.getSource()};
        return Objects.hash(objectArray);
    }

    @NotNull
    public String toString() {
        return "VueSourceDirective(" + this.getDefaultName() + ")";
    }

    private static final VueSourceDirective createPointer$lambda$0(SmartPsiElementPointer $source, String $name) {
        PsiElement psiElement = $source.dereference();
        if (psiElement == null) {
            return null;
        }
        PsiElement newSource = psiElement;
        return new VueSourceDirective($name, newSource);
    }
}

