/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.push;

import com.intellij.diff.util.DiffUtil;
import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.push.CommitLoader;
import com.intellij.dvcs.push.CustomPushOptionsPanelFactory;
import com.intellij.dvcs.push.OutgoingCommitsProvider;
import com.intellij.dvcs.push.OutgoingResult;
import com.intellij.dvcs.push.PrePushHandler;
import com.intellij.dvcs.push.PushInfo;
import com.intellij.dvcs.push.PushSource;
import com.intellij.dvcs.push.PushSpec;
import com.intellij.dvcs.push.PushSupport;
import com.intellij.dvcs.push.PushTarget;
import com.intellij.dvcs.push.PushTargetPanel;
import com.intellij.dvcs.push.Pusher;
import com.intellij.dvcs.push.RepositoryNodeListener;
import com.intellij.dvcs.push.VcsError;
import com.intellij.dvcs.push.VcsPushOptionValue;
import com.intellij.dvcs.push.VcsPushOptionsPanel;
import com.intellij.dvcs.push.ui.CheckBoxModel;
import com.intellij.dvcs.push.ui.CommitNode;
import com.intellij.dvcs.push.ui.PushLog;
import com.intellij.dvcs.push.ui.RepositoryNode;
import com.intellij.dvcs.push.ui.RepositoryWithBranchPanel;
import com.intellij.dvcs.push.ui.SingleRepositoryNode;
import com.intellij.dvcs.push.ui.TextWithLinkNode;
import com.intellij.dvcs.push.ui.VcsLinkListener;
import com.intellij.dvcs.push.ui.VcsLinkedTextComponent;
import com.intellij.dvcs.push.ui.VcsPushDialog;
import com.intellij.dvcs.repo.Repository;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.ui.CheckboxTree;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.util.Function;
import com.intellij.util.concurrency.SequentialTaskExecutor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.progress.StepsProgressIndicator;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.JBValue;
import com.intellij.vcs.commit.PostCommitChecksHandler;
import com.intellij.vcs.log.VcsFullCommitDetails;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public final class PushController
implements Disposable {
    private static final Logger LOG = Logger.getInstance(PushController.class);
    @NotNull
    private final Project myProject;
    @Nullable
    private final PushSource myPushSource;
    @NotNull
    private final Collection<? extends Repository> myAllRepos;
    @NotNull
    private final List<? extends Repository> myPreselectedRepositories;
    @NotNull
    private final List<PushSupport<Repository, PushSource, PushTarget>> myPushSupports;
    @NotNull
    private final PushLog myPushLog;
    @NotNull
    private final VcsPushDialog myDialog;
    @NotNull
    private final ModalityState myModalityState;
    @Nullable
    private final Repository myCurrentlyOpenedRepository;
    private final boolean mySingleRepoProject;
    private static final int DEFAULT_CHILDREN_PRESENTATION_NUMBER = 20;
    @NonNls
    private final ExecutorService myExecutorService;
    private final Map<RepositoryNode, MyRepoModel<Repository, PushSource, PushTarget>> myView2Model;
    @NotNull
    private Map<RepositoryNode, MyRepoModel<?, ?, ?>> myPriorityRepositories;
    @NotNull
    private Map<RepositoryNode, MyRepoModel<?, ?, ?>> myOtherRepositories;
    private boolean myHasCommitWarning;

    public PushController(@NotNull Project project, @NotNull VcsPushDialog dialog, @NotNull Collection<? extends Repository> allRepos, @NotNull List<? extends Repository> preselectedRepositories, @Nullable Repository currentRepo, @Nullable PushSource pushSource) {
        if (project == null) {
            PushController.$$$reportNull$$$0(0);
        }
        if (dialog == null) {
            PushController.$$$reportNull$$$0(1);
        }
        if (allRepos == null) {
            PushController.$$$reportNull$$$0(2);
        }
        if (preselectedRepositories == null) {
            PushController.$$$reportNull$$$0(3);
        }
        this.myExecutorService = SequentialTaskExecutor.createSequentialApplicationPoolExecutor((String)"DVCS Push");
        this.myView2Model = new TreeMap<RepositoryNode, MyRepoModel<Repository, PushSource, PushTarget>>();
        this.myProject = project;
        this.myAllRepos = allRepos;
        this.myPreselectedRepositories = preselectedRepositories;
        this.myCurrentlyOpenedRepository = currentRepo;
        this.myPushSource = pushSource;
        this.myPushSupports = this.getAffectedSupports();
        this.mySingleRepoProject = this.isSingleRepoProject();
        this.myDialog = dialog;
        this.myModalityState = ModalityState.stateForComponent((Component)this.myDialog.getRootPane());
        CheckedTreeNode rootNode = new CheckedTreeNode(null);
        this.createTreeModel(rootNode);
        this.myPushLog = new PushLog(this.myProject, rootNode, this.myModalityState, this.isSyncStrategiesAllowed());
        this.myPushLog.getTree().addPropertyChangeListener("tree.edit.mode", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                PushController.this.myDialog.enableOkActions((Boolean)evt.getNewValue() == false);
            }
        });
        this.processRepositories();
        Disposer.register((Disposable)dialog.getDisposable(), (Disposable)this);
    }

    private boolean isSyncStrategiesAllowed() {
        return !this.mySingleRepoProject && ContainerUtil.and(this.getAffectedSupports(), support -> support.mayChangeTargetsSync());
    }

    private boolean isSingleRepoProject() {
        return this.myAllRepos.size() == 1;
    }

    @NotNull
    private <R extends Repository, S extends PushSource, T extends PushTarget> @Unmodifiable List<PushSupport<R, S, T>> getAffectedSupports() {
        Set vcss = ContainerUtil.map2Set(this.myAllRepos, repository -> repository.getVcs());
        List list = ContainerUtil.map((Collection)vcss, vcs -> DvcsUtil.getPushSupport(vcs));
        if (list == null) {
            PushController.$$$reportNull$$$0(4);
        }
        return list;
    }

    private void processRepositories() {
        Object currentRepoModel;
        LinkedHashMap priorityLoading = new LinkedHashMap();
        LinkedHashMap others = new LinkedHashMap();
        RepositoryNode nodeForCurrentEditor = this.findNodeByRepo(this.myCurrentlyOpenedRepository);
        if (nodeForCurrentEditor != null && (this.isPreChecked((MyRepoModel<?, ?, ?>)(currentRepoModel = this.myView2Model.get(nodeForCurrentEditor))) || this.myPreselectedRepositories.isEmpty())) {
            priorityLoading.put(nodeForCurrentEditor, (MyRepoModel<?, ?, ?>)currentRepoModel);
            ((MyRepoModel)currentRepoModel).setChecked(true);
        }
        for (Map.Entry entry : this.myView2Model.entrySet()) {
            MyRepoModel model = (MyRepoModel)entry.getValue();
            RepositoryNode repoNode = (RepositoryNode)entry.getKey();
            if (this.isPreChecked(model)) {
                priorityLoading.putIfAbsent(repoNode, model);
                model.setChecked(true);
                continue;
            }
            if (!model.getSupport().shouldRequestIncomingChangesForNotCheckedRepositories()) continue;
            others.put(repoNode, model);
        }
        if (this.myPreselectedRepositories.isEmpty()) {
            boolean shouldScrollTo = this.myView2Model.values().stream().noneMatch(MyRepoModel::isSelected);
            this.myPushLog.highlightNodeOrFirst(nodeForCurrentEditor, shouldScrollTo);
        }
        this.myPriorityRepositories = priorityLoading;
        this.myOtherRepositories = others;
    }

    public void startLoadingCommits() {
        this.loadCommitsFromMap(this.myPriorityRepositories);
        this.loadCommitsFromMap(this.myOtherRepositories);
    }

    private boolean isPreChecked(@NotNull MyRepoModel<?, ?, ?> model) {
        if (model == null) {
            PushController.$$$reportNull$$$0(5);
        }
        return AdvancedSettings.getBoolean((String)"vcs.push.all.with.commits") || model.getSupport().getRepositoryManager().isSyncEnabled() || this.preselectByUser((Repository)model.getRepository());
    }

    private RepositoryNode findNodeByRepo(@Nullable Repository repository) {
        if (repository == null) {
            return null;
        }
        Map.Entry entry = (Map.Entry)ContainerUtil.find(this.myView2Model.entrySet(), entry1 -> {
            MyRepoModel model = (MyRepoModel)entry1.getValue();
            return model.getRepository().getRoot().equals(repository.getRoot());
        });
        return entry != null ? (RepositoryNode)entry.getKey() : null;
    }

    private void loadCommitsFromMap(@NotNull Map<RepositoryNode, MyRepoModel<?, ?, ?>> items) {
        if (items == null) {
            PushController.$$$reportNull$$$0(6);
        }
        for (Map.Entry<RepositoryNode, MyRepoModel<?, ?, ?>> entry : items.entrySet()) {
            RepositoryNode node = entry.getKey();
            this.loadCommits(entry.getValue(), node, true);
        }
    }

    private void createTreeModel(@NotNull CheckedTreeNode rootNode) {
        if (rootNode == null) {
            PushController.$$$reportNull$$$0(7);
        }
        for (Repository repository : DvcsUtil.sortRepositories(this.myAllRepos)) {
            PushSource source;
            PushSupport support = this.getPushSupportByRepository(repository);
            if (support == null || (source = this.myPushSource != null ? this.myPushSource : support.getSource(repository)) == null) continue;
            this.createRepoNode(repository, rootNode, source, support);
        }
    }

    @Nullable
    private <R extends Repository, S extends PushSource, T extends PushTarget> PushSupport<R, S, T> getPushSupportByRepository(@NotNull R repository) {
        if (repository == null) {
            PushController.$$$reportNull$$$0(8);
        }
        return (PushSupport)ContainerUtil.find(this.myPushSupports, support -> support.getVcs().equals((Object)repository.getVcs()));
    }

    private <R extends Repository, S extends PushSource, T extends PushTarget> void createRepoNode(@NotNull R repository, @NotNull CheckedTreeNode rootNode, @NotNull S source, @NotNull PushSupport<R, S, T> pushSupport) {
        if (repository == null) {
            PushController.$$$reportNull$$$0(9);
        }
        if (rootNode == null) {
            PushController.$$$reportNull$$$0(10);
        }
        if (source == null) {
            PushController.$$$reportNull$$$0(11);
        }
        if (pushSupport == null) {
            PushController.$$$reportNull$$$0(12);
        }
        PushTarget target = pushSupport.getDefaultTarget(repository, source);
        String repoName = this.getDisplayedRepoName(repository);
        final MyRepoModel<R, S, PushTarget> model = new MyRepoModel<R, S, PushTarget>(repository, pushSupport, this.mySingleRepoProject, source, target);
        if (target == null) {
            model.setError(VcsError.createEmptyTargetError((String)repoName));
        }
        PushTargetPanel pushTargetPanel = pushSupport.createTargetPanel(repository, source, target);
        final RepositoryWithBranchPanel repoPanel = new RepositoryWithBranchPanel(this.myProject, repoName, source.getPresentation(), pushTargetPanel);
        CheckBoxModel checkBoxModel = model.getCheckBoxModel();
        final RepositoryNode repoNode = this.mySingleRepoProject ? new SingleRepositoryNode(repoPanel, checkBoxModel) : new RepositoryNode(repoPanel, checkBoxModel, target != null);
        pushTargetPanel.setFireOnChangeAction(new Runnable(){

            @Override
            public void run() {
                repoPanel.fireOnChange();
                ((DefaultTreeModel)PushController.this.myPushLog.getTree().getModel()).nodeChanged((TreeNode)((Object)repoNode));
            }
        });
        this.myView2Model.put(repoNode, model);
        repoPanel.addRepoNodeListener(new RepositoryNodeListener<T>(){

            @Override
            public void onTargetChanged(T newTarget) {
                repoNode.setChecked(true);
                if (!newTarget.equals(model.getTarget()) || model.hasError() || !model.hasCommitInfo()) {
                    model.setTarget(newTarget);
                    model.clearErrors();
                    PushController.this.loadCommits(model, repoNode, false);
                }
            }

            @Override
            public void onSelectionChanged(boolean isSelected) {
                PushController.this.myDialog.updateOkActions();
                if (isSelected && !model.hasCommitInfo() && !model.getSupport().shouldRequestIncomingChangesForNotCheckedRepositories()) {
                    PushController.this.loadCommits(model, repoNode, false);
                }
            }

            @Override
            public void onTargetInEditMode(@NotNull @Nls String currentValue) {
                if (currentValue == null) {
                    3.$$$reportNull$$$0(0);
                }
                PushController.this.myPushLog.fireEditorUpdated(currentValue);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentValue", "com/intellij/dvcs/push/PushController$3", "onTargetInEditMode"));
            }
        });
        rootNode.add((MutableTreeNode)((Object)repoNode));
    }

    @Nls
    @NotNull
    private String getDisplayedRepoName(@NotNull Repository repository) {
        String name;
        int slash;
        if (repository == null) {
            PushController.$$$reportNull$$$0(13);
        }
        if ((slash = (name = DvcsUtil.getShortRepositoryName(repository)).lastIndexOf(File.separatorChar)) < 0) {
            String string = name;
            if (string == null) {
                PushController.$$$reportNull$$$0(14);
            }
            return string;
        }
        String candidate = name.substring(slash + 1);
        String string = !this.containedInOtherNames(repository, candidate) ? candidate : name;
        if (string == null) {
            PushController.$$$reportNull$$$0(15);
        }
        return string;
    }

    private boolean containedInOtherNames(@NotNull Repository except, String candidate) {
        if (except == null) {
            PushController.$$$reportNull$$$0(16);
        }
        return ContainerUtil.exists(this.myAllRepos, repository -> !repository.equals((Object)except) && repository.getRoot().getName().equals(candidate));
    }

    public boolean isPushAllowed() {
        CheckboxTree tree = this.myPushLog.getTree();
        if (tree.isEditing()) {
            return false;
        }
        return ContainerUtil.exists(this.myView2Model.values(), model -> model.isSelected() && PushController.isPushAllowed(model));
    }

    public boolean hasCommitWarnings() {
        return this.myHasCommitWarning;
    }

    private static boolean isPushAllowed(@NotNull MyRepoModel<Repository, PushSource, PushTarget> model) {
        PushTarget target;
        if (model == null) {
            PushController.$$$reportNull$$$0(17);
        }
        if ((target = model.getTarget()) == null) {
            return false;
        }
        PushSupport<Repository, PushSource, PushTarget> pushSupport = model.getSupport();
        return pushSupport.canBePushed(model.getRepository(), model.getSource(), target);
    }

    private static boolean hasLoadingNodes(@NotNull Collection<? extends RepositoryNode> nodes) {
        if (nodes == null) {
            PushController.$$$reportNull$$$0(18);
        }
        return ContainerUtil.exists(nodes, node -> node.isLoading());
    }

    private <R extends Repository, S extends PushSource, T extends PushTarget> void loadCommits(@NotNull MyRepoModel<R, S, T> model, @NotNull RepositoryNode node, boolean initial) {
        if (model == null) {
            PushController.$$$reportNull$$$0(19);
        }
        if (node == null) {
            PushController.$$$reportNull$$$0(20);
        }
        if (this.myDialog.isDisposed()) {
            return;
        }
        node.cancelLoading();
        node.setEnabled(true);
        T target = model.getTarget();
        if (target == null) {
            node.stopLoading();
            return;
        }
        PushSupport support = model.getSupport();
        AtomicReference result = new AtomicReference();
        Runnable task = () -> {
            Object repository = model.getRepository();
            OutgoingResult outgoing = support.getOutgoingCommitsProvider().getOutgoingCommits(repository, new PushSpec(model.getSource(), model.getTarget()), initial);
            result.compareAndSet(null, outgoing);
            try {
                ApplicationManager.getApplication().invokeAndWait(() -> {
                    boolean shouldBeSelected;
                    if (this.myDialog.isDisposed()) {
                        return;
                    }
                    OutgoingResult outgoing1 = (OutgoingResult)result.get();
                    List errors = outgoing1.getErrors();
                    if (!errors.isEmpty()) {
                        shouldBeSelected = false;
                        model.setLoadedCommits(ContainerUtil.emptyList());
                        this.myPushLog.setChildren((DefaultMutableTreeNode)((Object)node), ContainerUtil.map((Collection)errors, error -> {
                            VcsLinkedTextComponent errorLinkText = new VcsLinkedTextComponent(error.getText(), new VcsLinkListener(){
                                final /* synthetic */ VcsError val$error;
                                final /* synthetic */ RepositoryNode val$node;
                                final /* synthetic */ MyRepoModel val$model;
                                {
                                    this.val$error = vcsError;
                                    this.val$node = repositoryNode;
                                    this.val$model = myRepoModel;
                                }

                                @Override
                                public void hyperlinkActivated(@NotNull DefaultMutableTreeNode sourceNode, @NotNull MouseEvent event) {
                                    if (sourceNode == null) {
                                        4.$$$reportNull$$$0(0);
                                    }
                                    if (event == null) {
                                        4.$$$reportNull$$$0(1);
                                    }
                                    this.val$error.handleError(new CommitLoader(){

                                        public void reloadCommits() {
                                            val$node.setChecked(true);
                                            PushController.this.loadCommits(val$model, val$node, false);
                                        }
                                    });
                                }

                                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                    Object[] objectArray;
                                    Object[] objectArray2 = new Object[3];
                                    switch (n) {
                                        default: {
                                            objectArray = objectArray2;
                                            objectArray2[0] = "sourceNode";
                                            break;
                                        }
                                        case 1: {
                                            objectArray = objectArray2;
                                            objectArray2[0] = "event";
                                            break;
                                        }
                                    }
                                    objectArray[1] = "com/intellij/dvcs/push/PushController$4";
                                    objectArray[2] = "hyperlinkActivated";
                                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                                }
                            });
                            return new TextWithLinkNode(errorLinkText);
                        }));
                        if (node.isChecked()) {
                            node.setChecked(false);
                        }
                    } else {
                        List commits = outgoing1.getCommits();
                        model.setLoadedCommits(commits);
                        shouldBeSelected = this.shouldSelectNodeAfterLoad(model);
                        this.myPushLog.setChildren((DefaultMutableTreeNode)((Object)node), this.getPresentationForCommits(this.myProject, model.getLoadedCommits(), model.getNumberOfShownCommits()));
                        if (!commits.isEmpty() && shouldBeSelected) {
                            this.myPushLog.selectIfNothingSelected((TreeNode)((Object)node));
                        }
                    }
                    node.stopLoading();
                    this.updateLoadingPanel();
                    if (shouldBeSelected) {
                        node.setChecked(true);
                    } else if (initial) {
                        node.setChecked(false);
                    }
                    this.myDialog.updateOkActions();
                }, this.myModalityState);
            }
            catch (ProcessCanceledException processCanceledException) {
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        };
        node.startLoading((JTree)this.myPushLog.getTree(), this.myExecutorService.submit(task, result), initial);
        this.updateLoadingPanel();
    }

    private void updateLoadingPanel() {
        this.myPushLog.setBusyLoading(PushController.hasLoadingNodes(this.myView2Model.keySet()));
    }

    private boolean shouldSelectNodeAfterLoad(@NotNull MyRepoModel<?, ?, ?> model) {
        if (model == null) {
            PushController.$$$reportNull$$$0(21);
        }
        if (this.mySingleRepoProject) {
            return true;
        }
        return model.isSelected() && (PushController.hasCommitsToPush(model) || !model.getSupport().getRepositoryManager().isSyncEnabled() && !AdvancedSettings.getBoolean((String)"vcs.push.all.with.commits"));
    }

    private boolean preselectByUser(@NotNull Repository repository) {
        if (repository == null) {
            PushController.$$$reportNull$$$0(22);
        }
        return this.mySingleRepoProject || this.myPreselectedRepositories.contains(repository);
    }

    private static boolean hasCommitsToPush(@NotNull MyRepoModel<?, ?, ?> model) {
        if (model == null) {
            PushController.$$$reportNull$$$0(23);
        }
        Object target = model.getTarget();
        assert (target != null);
        return !model.getLoadedCommits().isEmpty() || target.hasSomethingToPush();
    }

    public PushLog getPushPanelLog() {
        return this.myPushLog;
    }

    @NotNull
    public PrePushHandler.Result executeHandlers(@NotNull ProgressIndicator indicator) throws ProcessCanceledException, HandlerException {
        List handlers;
        if (indicator == null) {
            PushController.$$$reportNull$$$0(24);
        }
        if ((handlers = PrePushHandler.EP_NAME.getExtensionList()).isEmpty()) {
            PrePushHandler.Result result = PrePushHandler.Result.OK;
            if (result == null) {
                PushController.$$$reportNull$$$0(25);
            }
            return result;
        }
        List<PushInfo> pushDetails = this.preparePushDetails();
        StepsProgressIndicator stepsIndicator = new StepsProgressIndicator(indicator, handlers.size());
        stepsIndicator.setIndeterminate(false);
        stepsIndicator.setFraction(0.0);
        for (int index = 0; index < handlers.size(); ++index) {
            PrePushHandler.Result prePushHandlerResult;
            PrePushHandler handler = (PrePushHandler)handlers.get(index);
            stepsIndicator.checkCanceled();
            stepsIndicator.setText(handler.getPresentableName());
            try {
                prePushHandlerResult = handler.handle(this.myProject, pushDetails, (ProgressIndicator)stepsIndicator);
            }
            catch (Throwable e) {
                List<String> skippedHandlers = handlers.stream().skip(index + 1).map(h -> h.getPresentableName()).collect(Collectors.toList());
                throw new HandlerException(handler.getPresentableName(), skippedHandlers, e);
            }
            if (prePushHandlerResult != PrePushHandler.Result.OK) {
                PrePushHandler.Result result = prePushHandlerResult;
                if (result == null) {
                    PushController.$$$reportNull$$$0(26);
                }
                return result;
            }
            stepsIndicator.setIndeterminate(false);
            stepsIndicator.nextStep();
        }
        PrePushHandler.Result result = PrePushHandler.Result.OK;
        if (result == null) {
            PushController.$$$reportNull$$$0(27);
        }
        return result;
    }

    public void push(boolean force) {
        for (PushSupport<Repository, PushSource, PushTarget> support : this.myPushSupports) {
            this.doPushSynchronously(support, force);
        }
    }

    private <R extends Repository, S extends PushSource, T extends PushTarget> void doPushSynchronously(@NotNull PushSupport<R, S, T> support, boolean force) {
        if (support == null) {
            PushController.$$$reportNull$$$0(28);
        }
        VcsPushOptionValue options = this.myDialog.getAdditionalOptionValue(support);
        Pusher pusher = support.getPusher();
        Map<R, PushSpec<S, T>> specs = this.collectPushSpecsForVcs(support);
        if (!specs.isEmpty()) {
            pusher.push(specs, options, force, this.myDialog.getCustomParams());
        }
    }

    private static <R extends Repository, S extends PushSource, T extends PushTarget> List<? extends VcsFullCommitDetails> loadCommits(@NotNull MyRepoModel<R, S, T> model) {
        if (model == null) {
            PushController.$$$reportNull$$$0(29);
        }
        PushSupport<R, S, T> support = model.getSupport();
        R repository = model.getRepository();
        S source = model.getSource();
        T target = model.getTarget();
        if (target == null) {
            return ContainerUtil.emptyList();
        }
        OutgoingCommitsProvider outgoingCommitsProvider = support.getOutgoingCommitsProvider();
        return outgoingCommitsProvider.getOutgoingCommits(repository, new PushSpec(source, target), true).getCommits();
    }

    @NotNull
    private List<PushInfo> preparePushDetails() {
        ArrayList<PushInfoImpl> allDetails = new ArrayList<PushInfoImpl>();
        for (MyRepoModel<Repository, PushSource, PushTarget> model : this.getSelectedRepoNode()) {
            PushTarget target = Objects.requireNonNull(model.getTarget());
            PushSpec pushSpec = new PushSpec(model.getSource(), target);
            ArrayList<VcsFullCommitDetails> loadedCommits = new ArrayList<VcsFullCommitDetails>(model.getLoadedCommits());
            if (loadedCommits.isEmpty()) {
                loadedCommits.addAll(PushController.loadCommits(model));
            }
            Collections.reverse(loadedCommits);
            PushInfoImpl pushInfo = new PushInfoImpl(model.getRepository(), (PushSpec<PushSource, PushTarget>)pushSpec, loadedCommits);
            allDetails.add(pushInfo);
        }
        List<PushInfo> list = Collections.unmodifiableList(allDetails);
        if (list == null) {
            PushController.$$$reportNull$$$0(30);
        }
        return list;
    }

    @NotNull
    public Map<PushSupport<Repository, PushSource, PushTarget>, Collection<PushInfo>> getSelectedPushSpecs() {
        HashMap<PushSupport<Repository, PushSource, PushTarget>, Collection<PushInfo>> result = new HashMap<PushSupport<Repository, PushSource, PushTarget>, Collection<PushInfo>>();
        for (MyRepoModel<Repository, PushSource, PushTarget> model : this.getSelectedRepoNode()) {
            PushTarget target = Objects.requireNonNull(model.getTarget());
            PushSpec pushSpec = new PushSpec(model.getSource(), target);
            PushInfoImpl pushInfo = new PushInfoImpl(model.getRepository(), (PushSpec<PushSource, PushTarget>)pushSpec, ContainerUtil.emptyList());
            Collection vcsDetails = result.computeIfAbsent(model.mySupport, key -> new ArrayList());
            vcsDetails.add(pushInfo);
        }
        HashMap<PushSupport<Repository, PushSource, PushTarget>, Collection<PushInfo>> hashMap = result;
        if (hashMap == null) {
            PushController.$$$reportNull$$$0(31);
        }
        return hashMap;
    }

    @NotNull
    private <R extends Repository, S extends PushSource, T extends PushTarget> @Unmodifiable Map<R, PushSpec<S, T>> collectPushSpecsForVcs(@NotNull PushSupport<R, S, T> pushSupport) {
        Map<PushSupport<Repository, PushSource, PushTarget>, Collection<PushInfo>> allSpecs;
        Collection<PushInfo> pushInfos;
        if (pushSupport == null) {
            PushController.$$$reportNull$$$0(32);
        }
        Map map = (pushInfos = (allSpecs = this.getSelectedPushSpecs()).get(pushSupport)) != null ? ContainerUtil.map2Map(pushInfos, pushInfo -> {
            PushSpec<PushSource, PushTarget> pushSpec = pushInfo.getPushSpec();
            return new Pair((Object)pushInfo.getRepository(), pushSpec);
        }) : Collections.emptyMap();
        if (map == null) {
            PushController.$$$reportNull$$$0(33);
        }
        return map;
    }

    private @Unmodifiable Collection<MyRepoModel<Repository, PushSource, PushTarget>> getSelectedRepoNode() {
        return ContainerUtil.filter(this.myView2Model.values(), model -> (this.mySingleRepoProject || model.isSelected()) && PushController.isPushAllowed(model));
    }

    public void dispose() {
        Disposer.dispose((Disposable)this.myPushLog);
        this.myExecutorService.shutdownNow();
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            PushController.$$$reportNull$$$0(34);
        }
        return project;
    }

    private void addMoreCommits(RepositoryNode repositoryNode) {
        MyRepoModel<Repository, PushSource, PushTarget> repoModel = this.myView2Model.get(repositoryNode);
        repoModel.increaseShownCommits();
        this.myPushLog.setChildren((DefaultMutableTreeNode)((Object)repositoryNode), this.getPresentationForCommits(this.myProject, repoModel.getLoadedCommits(), repoModel.getNumberOfShownCommits()));
    }

    @NotNull
    private List<DefaultMutableTreeNode> getPresentationForCommits(@NotNull Project project, @NotNull List<? extends VcsFullCommitDetails> commits, int commitsNum) {
        if (project == null) {
            PushController.$$$reportNull$$$0(35);
        }
        if (commits == null) {
            PushController.$$$reportNull$$$0(36);
        }
        Function commitToNode = commit -> new CommitNode(project, (VcsFullCommitDetails)commit);
        ArrayList<DefaultMutableTreeNode> childrenToShown = new ArrayList<DefaultMutableTreeNode>();
        for (int i = 0; i < commits.size(); ++i) {
            if (i >= commitsNum) {
                @NonNls VcsLinkedTextComponent moreCommitsLink = new VcsLinkedTextComponent(HtmlChunk.link((String)"loadMore", (String)"...").toString(), (sourceNode, event) -> {
                    TreeNode parent = sourceNode.getParent();
                    if (parent instanceof RepositoryNode) {
                        this.addMoreCommits((RepositoryNode)((Object)parent));
                    }
                });
                childrenToShown.add(new TextWithLinkNode(moreCommitsLink));
                break;
            }
            childrenToShown.add((DefaultMutableTreeNode)commitToNode.fun((Object)commits.get(i)));
        }
        ArrayList<DefaultMutableTreeNode> arrayList = childrenToShown;
        if (arrayList == null) {
            PushController.$$$reportNull$$$0(37);
        }
        return arrayList;
    }

    @NotNull
    public Map<PushSupport<?, ?, ?>, VcsPushOptionsPanel> createAdditionalPanels() {
        LinkedHashMap result = new LinkedHashMap();
        for (PushSupport<Repository, PushSource, PushTarget> support : this.myPushSupports) {
            ContainerUtil.putIfNotNull(support, (Object)support.createOptionsPanel(), result);
        }
        LinkedHashMap linkedHashMap = result;
        if (linkedHashMap == null) {
            PushController.$$$reportNull$$$0(38);
        }
        return linkedHashMap;
    }

    @ApiStatus.Experimental
    public @Unmodifiable Map<String, VcsPushOptionsPanel> createCustomPanels(Collection<? extends Repository> repos) {
        return ContainerUtil.map2MapNotNull((Collection)CustomPushOptionsPanelFactory.EP_NAME.getExtensionList(), panelProvider -> {
            try {
                VcsPushOptionsPanel panel = panelProvider.createOptionsPanel((Disposable)this, repos);
                return panel != null ? Pair.pair((Object)panelProvider.getId(), (Object)panel) : null;
            }
            catch (Throwable e) {
                LOG.error(e);
                return null;
            }
        });
    }

    @NotNull
    public JComponent createTopPanel() {
        List<JComponent> notifications = new ArrayList();
        if (this.myPushSource == null) {
            Runnable closeDialog = () -> this.myDialog.doCancelAction();
            JComponent commitStatus = PostCommitChecksHandler.getInstance((Project)this.myProject).createPushStatusNotification(closeDialog);
            if (commitStatus != null) {
                this.myHasCommitWarning = true;
                notifications.add(commitStatus);
            }
        }
        notifications = DiffUtil.wrapEditorNotificationBorders(notifications);
        JComponent panel = DiffUtil.createStackedComponents(notifications, (JBValue)DiffUtil.TITLE_GAP);
        if (!notifications.isEmpty()) {
            panel.setBorder(JBUI.Borders.customLineBottom((Color)JBUI.CurrentTheme.CustomFrameDecorations.separatorForeground()));
        }
        JComponent jComponent = panel;
        if (jComponent == null) {
            PushController.$$$reportNull$$$0(39);
        }
        return jComponent;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 14, 15, 25, 26, 27, 30, 31, 33, 34, 37, 38, 39 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialog";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allRepos";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "preselectedRepositories";
                break;
            }
            case 4: 
            case 14: 
            case 15: 
            case 25: 
            case 26: 
            case 27: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 37: 
            case 38: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/dvcs/push/PushController";
                break;
            }
            case 5: 
            case 17: 
            case 19: 
            case 21: 
            case 23: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootNode";
                break;
            }
            case 8: 
            case 9: 
            case 13: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 12: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pushSupport";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "except";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodes";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "support";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commits";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/dvcs/push/PushController";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getAffectedSupports";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayedRepoName";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "executeHandlers";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "preparePushDetails";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedPushSpecs";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "collectPushSpecsForVcs";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentationForCommits";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "createAdditionalPanels";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "createTopPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 14: 
            case 15: 
            case 25: 
            case 26: 
            case 27: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 37: 
            case 38: 
            case 39: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isPreChecked";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "loadCommitsFromMap";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createTreeModel";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getPushSupportByRepository";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createRepoNode";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getDisplayedRepoName";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "containedInOtherNames";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isPushAllowed";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "hasLoadingNodes";
                break;
            }
            case 19: 
            case 20: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "loadCommits";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "shouldSelectNodeAfterLoad";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "preselectByUser";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "hasCommitsToPush";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "executeHandlers";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "doPushSynchronously";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "collectPushSpecsForVcs";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getPresentationForCommits";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 14, 15, 25, 26, 27, 30, 31, 33, 34, 37, 38, 39 -> new IllegalStateException(string);
        };
    }

    private static final class MyRepoModel<Repo extends Repository, S extends PushSource, T extends PushTarget> {
        @NotNull
        private final Repo myRepository;
        @NotNull
        private final PushSupport<Repo, S, T> mySupport;
        @NotNull
        private final S mySource;
        @Nullable
        private T myTarget;
        @Nullable
        VcsError myTargetError;
        int myNumberOfShownCommits;
        @NotNull
        List<? extends VcsFullCommitDetails> myLoadedCommits;
        @NotNull
        private final CheckBoxModel myCheckBoxModel;

        MyRepoModel(@NotNull Repo repository, @NotNull PushSupport<Repo, S, T> supportForRepo, boolean isSelected, @NotNull S source, @Nullable T target) {
            if (repository == null) {
                MyRepoModel.$$$reportNull$$$0(0);
            }
            if (supportForRepo == null) {
                MyRepoModel.$$$reportNull$$$0(1);
            }
            if (source == null) {
                MyRepoModel.$$$reportNull$$$0(2);
            }
            this.myLoadedCommits = Collections.emptyList();
            this.myRepository = repository;
            this.mySupport = supportForRepo;
            this.myCheckBoxModel = new CheckBoxModel(isSelected);
            this.mySource = source;
            this.myTarget = target;
            this.myNumberOfShownCommits = 20;
        }

        @NotNull
        public Repo getRepository() {
            Repo Repo = this.myRepository;
            if (Repo == null) {
                MyRepoModel.$$$reportNull$$$0(3);
            }
            return Repo;
        }

        @NotNull
        public PushSupport<Repo, S, T> getSupport() {
            PushSupport<Repo, S, T> pushSupport = this.mySupport;
            if (pushSupport == null) {
                MyRepoModel.$$$reportNull$$$0(4);
            }
            return pushSupport;
        }

        @NotNull
        public S getSource() {
            S s = this.mySource;
            if (s == null) {
                MyRepoModel.$$$reportNull$$$0(5);
            }
            return s;
        }

        @Nullable
        public T getTarget() {
            return this.myTarget;
        }

        public void setTarget(@Nullable T target) {
            this.myTarget = target;
        }

        public boolean isSelected() {
            return this.myCheckBoxModel.isChecked();
        }

        public void setError(@Nullable VcsError error) {
            this.myTargetError = error;
        }

        public void clearErrors() {
            this.myTargetError = null;
        }

        public boolean hasError() {
            return this.myTargetError != null;
        }

        public int getNumberOfShownCommits() {
            return this.myNumberOfShownCommits;
        }

        public void increaseShownCommits() {
            this.myNumberOfShownCommits *= 2;
        }

        @NotNull
        public List<? extends VcsFullCommitDetails> getLoadedCommits() {
            List<? extends VcsFullCommitDetails> list = this.myLoadedCommits;
            if (list == null) {
                MyRepoModel.$$$reportNull$$$0(6);
            }
            return list;
        }

        public void setLoadedCommits(@NotNull List<? extends VcsFullCommitDetails> loadedCommits) {
            if (loadedCommits == null) {
                MyRepoModel.$$$reportNull$$$0(7);
            }
            this.myLoadedCommits = loadedCommits;
        }

        public boolean hasCommitInfo() {
            return this.myTargetError != null || !this.myLoadedCommits.isEmpty();
        }

        @NotNull
        public CheckBoxModel getCheckBoxModel() {
            CheckBoxModel checkBoxModel = this.myCheckBoxModel;
            if (checkBoxModel == null) {
                MyRepoModel.$$$reportNull$$$0(8);
            }
            return checkBoxModel;
        }

        public void setChecked(boolean checked) {
            this.myCheckBoxModel.setChecked(checked);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4, 5, 6, 8 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "repository";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "supportForRepo";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "source";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/dvcs/push/PushController$MyRepoModel";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "loadedCommits";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/dvcs/push/PushController$MyRepoModel";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRepository";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSupport";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSource";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLoadedCommits";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCheckBoxModel";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 8: {
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "setLoadedCommits";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 4, 5, 6, 8 -> new IllegalStateException(string);
            };
        }
    }

    public static class HandlerException
    extends RuntimeException {
        private final String myFailedHandlerName;
        private final List<String> mySkippedHandlers;

        public HandlerException(@NotNull String failedHandlerName, @NotNull List<String> skippedHandlers, @NotNull Throwable cause) {
            if (failedHandlerName == null) {
                HandlerException.$$$reportNull$$$0(0);
            }
            if (skippedHandlers == null) {
                HandlerException.$$$reportNull$$$0(1);
            }
            if (cause == null) {
                HandlerException.$$$reportNull$$$0(2);
            }
            super(cause);
            this.myFailedHandlerName = failedHandlerName;
            this.mySkippedHandlers = skippedHandlers;
        }

        @NotNull
        public String getFailedHandlerName() {
            String string = this.myFailedHandlerName;
            if (string == null) {
                HandlerException.$$$reportNull$$$0(3);
            }
            return string;
        }

        @NotNull
        public List<String> getSkippedHandlers() {
            List<String> list = this.mySkippedHandlers;
            if (list == null) {
                HandlerException.$$$reportNull$$$0(4);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "failedHandlerName";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "skippedHandlers";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "cause";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/dvcs/push/PushController$HandlerException";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/dvcs/push/PushController$HandlerException";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFailedHandlerName";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSkippedHandlers";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 4 -> new IllegalStateException(string);
            };
        }
    }

    private static final class PushInfoImpl
    implements PushInfo {
        private final Repository myRepository;
        private final PushSpec<PushSource, PushTarget> myPushSpec;
        private final List<VcsFullCommitDetails> myCommits;

        private PushInfoImpl(@NotNull Repository repository, @NotNull PushSpec<PushSource, PushTarget> spec, @NotNull List<VcsFullCommitDetails> commits) {
            if (repository == null) {
                PushInfoImpl.$$$reportNull$$$0(0);
            }
            if (spec == null) {
                PushInfoImpl.$$$reportNull$$$0(1);
            }
            if (commits == null) {
                PushInfoImpl.$$$reportNull$$$0(2);
            }
            this.myRepository = repository;
            this.myPushSpec = spec;
            this.myCommits = commits;
        }

        @Override
        @NotNull
        public Repository getRepository() {
            Repository repository = this.myRepository;
            if (repository == null) {
                PushInfoImpl.$$$reportNull$$$0(3);
            }
            return repository;
        }

        @Override
        @NotNull
        public PushSpec<PushSource, PushTarget> getPushSpec() {
            PushSpec<PushSource, PushTarget> pushSpec = this.myPushSpec;
            if (pushSpec == null) {
                PushInfoImpl.$$$reportNull$$$0(4);
            }
            return pushSpec;
        }

        @Override
        @NotNull
        public List<VcsFullCommitDetails> getCommits() {
            List<VcsFullCommitDetails> list = this.myCommits;
            if (list == null) {
                PushInfoImpl.$$$reportNull$$$0(5);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4, 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "repository";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "spec";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "commits";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/dvcs/push/PushController$PushInfoImpl";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/dvcs/push/PushController$PushInfoImpl";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRepository";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPushSpec";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCommits";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 4, 5 -> new IllegalStateException(string);
            };
        }
    }
}

