/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.gherkin.bddConfiguration;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.target.TargetEnvironment;
import com.intellij.execution.target.TargetEnvironmentRequest;
import com.intellij.execution.target.value.TargetEnvironmentFunctions;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.python.gherkin.bddConfiguration.PyBDDRunConfiguration;
import com.intellij.python.gherkin.bddConfiguration.PyBDDTestCommandLineStateEnvCustomization;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PythonHelper;
import com.jetbrains.python.run.EnvironmentController;
import com.jetbrains.python.run.PlainEnvironmentController;
import com.jetbrains.python.run.TargetEnvironmentController;
import com.jetbrains.python.run.target.HelpersAwareTargetEnvironmentRequest;
import com.jetbrains.python.testing.PythonTestCommandLineStateBase;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public final class PyBDDTestCommandLineState
extends PythonTestCommandLineStateBase<PyBDDRunConfiguration<?>> {
    private static final Pattern SPACE = Pattern.compile("\\s+");
    private static final String PY_STUFF_TO_RUN = "PY_STUFF_TO_RUN";
    private static final String SCENARIOS = "SCENARIOS";
    private static final String DELIMITER = "|";
    @NotNull
    private final PythonHelper myRunner;
    @NotNull
    private final PyBDDRunConfiguration<?> mySimpleConfiguration;

    public PyBDDTestCommandLineState(@NotNull PyBDDRunConfiguration<?> configuration, @NotNull ExecutionEnvironment env, @NotNull PythonHelper runner) {
        if (configuration == null) {
            PyBDDTestCommandLineState.$$$reportNull$$$0(0);
        }
        if (env == null) {
            PyBDDTestCommandLineState.$$$reportNull$$$0(1);
        }
        if (runner == null) {
            PyBDDTestCommandLineState.$$$reportNull$$$0(2);
        }
        super(configuration, env);
        this.myRunner = runner;
        this.mySimpleConfiguration = configuration;
    }

    @NotNull
    protected PythonHelper getRunner() {
        PythonHelper pythonHelper = this.myRunner;
        if (pythonHelper == null) {
            PyBDDTestCommandLineState.$$$reportNull$$$0(3);
        }
        return pythonHelper;
    }

    @NotNull
    public GeneralCommandLine generateCommandLine() {
        GeneralCommandLine line = super.generateCommandLine();
        this.putFeaturesAndScenarios((EnvironmentController)new PlainEnvironmentController(line.getEnvironment()));
        line.setWorkDirectory(this.mySimpleConfiguration.getWorkingDirectorySafe());
        GeneralCommandLine generalCommandLine = line;
        if (generalCommandLine == null) {
            PyBDDTestCommandLineState.$$$reportNull$$$0(4);
        }
        return generalCommandLine;
    }

    public void customizeEnvironmentVars(Map<String, String> envs, boolean passParentEnvs) {
        super.customizeEnvironmentVars(envs, passParentEnvs);
        Module module = ((PyBDDRunConfiguration)this.myConfiguration).getModule();
        if (module != null) {
            PyBDDTestCommandLineStateEnvCustomization.Companion.customizeEnvironmentVars(envs, module);
        }
    }

    protected void customizePythonExecutionEnvironmentVars(@NotNull HelpersAwareTargetEnvironmentRequest helpersAwareTargetRequest, @NotNull Map<String, Function<TargetEnvironment, String>> envs, boolean passParentEnvs) {
        if (helpersAwareTargetRequest == null) {
            PyBDDTestCommandLineState.$$$reportNull$$$0(5);
        }
        if (envs == null) {
            PyBDDTestCommandLineState.$$$reportNull$$$0(6);
        }
        super.customizePythonExecutionEnvironmentVars(helpersAwareTargetRequest, envs, passParentEnvs);
        this.putFeaturesAndScenarios((EnvironmentController)new TargetEnvironmentController(envs, helpersAwareTargetRequest));
        Module module = ((PyBDDRunConfiguration)this.myConfiguration).getModule();
        if (module != null) {
            PyBDDTestCommandLineStateEnvCustomization.Companion.customizePythonExecutionEnvironmentVars(helpersAwareTargetRequest, envs, module);
        }
    }

    private void putFeaturesAndScenarios(@NotNull EnvironmentController environmentController) {
        if (environmentController == null) {
            PyBDDTestCommandLineState.$$$reportNull$$$0(7);
        }
        environmentController.putTargetPathsValue(PY_STUFF_TO_RUN, Arrays.asList(this.mySimpleConfiguration.getWhatRunSafe()));
        environmentController.putFixedValue(SCENARIOS, StringUtil.join((String[])this.mySimpleConfiguration.getScenariosAsString(), (String)DELIMITER));
    }

    @NotNull
    protected List<String> getTestSpecs() {
        ArrayList<String> result = new ArrayList<String>();
        String arguments = this.mySimpleConfiguration.getAdditionalArguments();
        if (!arguments.isEmpty()) {
            result.addAll(Arrays.asList(SPACE.split(arguments)));
        }
        ArrayList<String> arrayList = result;
        if (arrayList == null) {
            PyBDDTestCommandLineState.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    @NotNull
    protected List<Function<TargetEnvironment, String>> getTestSpecs(@NotNull TargetEnvironmentRequest request) {
        String arguments;
        if (request == null) {
            PyBDDTestCommandLineState.$$$reportNull$$$0(9);
        }
        if ((arguments = this.mySimpleConfiguration.getAdditionalArguments()).isEmpty()) {
            List<Function<TargetEnvironment, String>> list = List.of();
            if (list == null) {
                PyBDDTestCommandLineState.$$$reportNull$$$0(10);
            }
            return list;
        }
        List list = ContainerUtil.map((Object[])SPACE.split(arguments), TargetEnvironmentFunctions::constant);
        if (list == null) {
            PyBDDTestCommandLineState.$$$reportNull$$$0(11);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 8, 10, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runner";
                break;
            }
            case 3: 
            case 4: 
            case 8: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/python/gherkin/bddConfiguration/PyBDDTestCommandLineState";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helpersAwareTargetRequest";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "envs";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environmentController";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/python/gherkin/bddConfiguration/PyBDDTestCommandLineState";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRunner";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "generateCommandLine";
                break;
            }
            case 8: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestSpecs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 8: 
            case 10: 
            case 11: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "customizePythonExecutionEnvironmentVars";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "putFeaturesAndScenarios";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getTestSpecs";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 8, 10, 11 -> new IllegalStateException(string);
        };
    }
}

