/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.pro.flask;

import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.python.pro.flask.FlaskUtilsKt;
import com.jetbrains.python.PythonFileType;
import com.jetbrains.python.sdk.PythonSdkUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FlaskFinder {
    private FlaskFinder() {
    }

    @Nullable
    public static VirtualFile findFlaskAppFile(VirtualFile dir) {
        VirtualFile[] children;
        for (VirtualFile child : children = dir.getChildren()) {
            if (!FlaskFinder.isFlaskAppFile(child)) continue;
            return child;
        }
        for (VirtualFile child : children) {
            if (!child.isDirectory() || child.findChild("__init__.py") == null || child.findChild("templates") == null) continue;
            for (VirtualFile file : child.getChildren()) {
                if (!FlaskFinder.isFlaskAppFile(file)) continue;
                return file;
            }
        }
        return null;
    }

    private static boolean isFlaskAppFile(VirtualFile child) {
        CharSequence text;
        return !child.isDirectory() && child.getFileType() instanceof PythonFileType && (text = LoadTextUtil.loadText((VirtualFile)child)).toString().contains("Flask(__name__)");
    }

    public static boolean flaskExtPackageExists(@NotNull PsiElement foothold) {
        Sdk sdk;
        if (foothold == null) {
            FlaskFinder.$$$reportNull$$$0(0);
        }
        if ((sdk = PythonSdkUtil.findPythonSdk((PsiElement)foothold)) == null) {
            return false;
        }
        return FlaskUtilsKt.isFlaskInstalled(sdk, foothold.getProject());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "foothold", "com/intellij/python/pro/flask/FlaskFinder", "flaskExtPackageExists"));
    }
}

