/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.scientific.actions;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileChooser.FileChooserDialog;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.python.scientific.PyScientificBundle;
import com.intellij.python.scientific.figures.base.FigureContentPanelBase;
import com.intellij.python.scientific.figures.base.FigureUtil;
import com.intellij.python.scientific.ui.PyPlotToolWindow;
import com.intellij.ui.tabs.TabInfo;
import com.jetbrains.python.psi.PyUtil;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.TimeZone;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000e"}, d2={"Lcom/intellij/python/scientific/actions/SaveAllPlotsAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "toolWindow", "Lcom/intellij/python/scientific/ui/PyPlotToolWindow;", "<init>", "(Lcom/intellij/python/scientific/ui/PyPlotToolWindow;)V", "getToolWindow", "()Lcom/intellij/python/scientific/ui/PyPlotToolWindow;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "intellij.python.scientific"})
@SourceDebugExtension(value={"SMAP\nSaveAllPlotsAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SaveAllPlotsAction.kt\ncom/intellij/python/scientific/actions/SaveAllPlotsAction\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,76:1\n1617#2,9:77\n1869#2:86\n1870#2:88\n1626#2:89\n1869#2:90\n1870#2:92\n1#3:87\n23#4:91\n*S KotlinDebug\n*F\n+ 1 SaveAllPlotsAction.kt\ncom/intellij/python/scientific/actions/SaveAllPlotsAction\n*L\n29#1:77,9\n29#1:86\n29#1:88\n29#1:89\n43#1:90\n43#1:92\n29#1:87\n68#1:91\n*E\n"})
public final class SaveAllPlotsAction
extends DumbAwareAction {
    @NotNull
    private final PyPlotToolWindow toolWindow;

    public SaveAllPlotsAction(@NotNull PyPlotToolWindow toolWindow) {
        Intrinsics.checkNotNullParameter((Object)toolWindow, (String)"toolWindow");
        super(PyScientificBundle.message("plots.save.all.plots.action", new Object[0]));
        this.toolWindow = toolWindow;
    }

    @NotNull
    public final PyPlotToolWindow getToolWindow() {
        return this.toolWindow;
    }

    /*
     * WARNING - void declaration
     */
    public void actionPerformed(@NotNull AnActionEvent e) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        List list = this.toolWindow.getTabs$intellij_python_scientific().getTabs();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getTabs(...)");
        Iterable $this$mapNotNull$iv = list;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            FigureContentPanelBase it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            TabInfo it = (TabInfo)element$iv$iv;
            boolean bl2 = false;
            if (PyPlotToolWindow.Companion.getTabContent$intellij_python_scientific(project2, it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List contents = (List)destination$iv$iv;
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH-mm-ss");
        String time = Instant.now().atZone(TimeZone.getDefault().toZoneId()).format(formatter);
        String namePrefix = "plot_" + time + "_";
        FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor();
        FileChooserDialog fileChooserDialog = FileChooserFactory.getInstance().createFileChooser(descriptor, project2, null);
        Intrinsics.checkNotNullExpressionValue((Object)fileChooserDialog, (String)"createFileChooser(...)");
        FileChooserDialog chooser = fileChooserDialog;
        VirtualFile[] virtualFileArray = chooser.choose(project2, new VirtualFile[0]);
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"choose(...)");
        VirtualFile virtualFile = (VirtualFile)ArraysKt.firstOrNull((Object[])virtualFileArray);
        if (virtualFile == null) {
            return;
        }
        VirtualFile virtualFile2 = virtualFile;
        PyUtil.runWithProgress((Project)project2, (String)PyScientificBundle.message("python.sci.view.saving.as.file.action", new Object[0]), (boolean)false, (boolean)true, arg_0 -> SaveAllPlotsAction.actionPerformed$lambda$2(arg_0 -> SaveAllPlotsAction.actionPerformed$lambda$1(contents, project2, virtualFile2, namePrefix, this, arg_0), arg_0));
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.EDT;
    }

    private static final Unit actionPerformed$lambda$1(List $contents, Project $project, VirtualFile $virtualFile, String $namePrefix, SaveAllPlotsAction this$0, ProgressIndicator indicator) {
        ProgressIndicator progressIndicator = indicator;
        if (progressIndicator != null) {
            progressIndicator.setIndeterminate(false);
        }
        Iterable $this$forEach$iv = CollectionsKt.withIndex((Iterable)$contents);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IndexedValue indexedValue = (IndexedValue)element$iv;
            boolean bl = false;
            int index = indexedValue.component1();
            FigureContentPanelBase content = (FigureContentPanelBase)indexedValue.component2();
            ProgressIndicator progressIndicator2 = indicator;
            if (progressIndicator2 != null) {
                progressIndicator2.setFraction((double)index / (double)$contents.size());
            }
            try {
                Path path2;
                boolean isHtml;
                boolean bl2 = isHtml = !content.isPngAvailable() && Intrinsics.areEqual((Object)content.getFormat(), (Object)"html");
                if (isHtml) {
                    byte[] html;
                    Document document;
                    VirtualFile htmlFile = content.getEditor().getFile();
                    if ((Document)ActionsKt.invokeAndWaitIfNeeded$default(null, () -> SaveAllPlotsAction.actionPerformed$lambda$1$0$0(htmlFile), (int)1, null) == null) continue;
                    Object object = ReadAction.compute(() -> SaveAllPlotsAction.actionPerformed$lambda$1$0$1(document));
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"compute(...)");
                    String string = (String)object;
                    Charset charset = StandardCharsets.UTF_8;
                    Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
                    Intrinsics.checkNotNullExpressionValue((Object)string.getBytes(charset), (String)"getBytes(...)");
                    String name = $namePrefix + index + ".html";
                    Path file = $virtualFile.toNioPath().resolve(name);
                    path2 = Files.write(file, html, new OpenOption[0]);
                    continue;
                }
                String name = $namePrefix + index + ".png";
                Path file = $virtualFile.toNioPath().resolve(name);
                byte[] bytes = FigureUtil.componentToByteArray(content);
                path2 = Files.write(file, bytes, new OpenOption[0]);
            }
            catch (IOException e) {
                SaveAllPlotsAction $this$thisLogger$iv = this$0;
                boolean $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(SaveAllPlotsAction.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.warn("Failed to save image", (Throwable)e);
            }
        }
        Path path3 = $virtualFile.toNioPath();
        Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"toNioPath(...)");
        PyPlotToolWindow.Companion.notifyFinish$intellij_python_scientific($project, path3);
        return Unit.INSTANCE;
    }

    private static final Document actionPerformed$lambda$1$0$0(VirtualFile $htmlFile) {
        return (Document)ActionsKt.runReadAction(() -> SaveAllPlotsAction.actionPerformed$lambda$1$0$0$0($htmlFile));
    }

    private static final Document actionPerformed$lambda$1$0$0$0(VirtualFile $htmlFile) {
        return FileDocumentManager.getInstance().getDocument($htmlFile);
    }

    private static final String actionPerformed$lambda$1$0$1(Document $document) {
        return $document.getText();
    }

    private static final void actionPerformed$lambda$2(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }
}

