/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.django.model.fieldsAsArguments.fieldReferencesObtainer;

import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.django.codeInsight.DjangoTypeProvider;
import com.jetbrains.django.model.DjangoModel;
import com.jetbrains.django.model.fieldsAsArguments.fieldReferencesObtainer.FieldReference;
import com.jetbrains.django.model.fieldsAsArguments.fieldReferencesObtainer.FieldReferenceWithRelation;
import com.jetbrains.django.model.fieldsAsArguments.fieldReferencesObtainer.FieldReferencesDirections;
import com.jetbrains.django.model.modelApi.DjangoModelClass;
import com.jetbrains.django.model.relationalKeys.DjangoKeyRelationInfo;
import com.jetbrains.django.model.relationalKeys.DjangoRelationType;
import com.jetbrains.django.model.stubs.manager.DjangoManagerIndex;
import com.jetbrains.python.codeInsight.PyCustomMember;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyTypedElement;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyClassTypeImpl;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyTypeUtil;
import com.jetbrains.python.psi.types.PyUnionType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DjangoFieldReferencesObtainer {
    private static final int MAX_LOOKUP_LEVEL = 2;
    private static final int MAX_LOOKUPS_TO_DIG = 500;
    @NotNull
    private final TypeEvalContext myContext;
    @NotNull
    private final FieldReferencesDirections myDirections;

    private DjangoFieldReferencesObtainer(@NotNull TypeEvalContext context, @NotNull FieldReferencesDirections directions) {
        if (context == null) {
            DjangoFieldReferencesObtainer.$$$reportNull$$$0(0);
        }
        if (directions == null) {
            DjangoFieldReferencesObtainer.$$$reportNull$$$0(1);
        }
        this.myContext = context;
        this.myDirections = directions;
    }

    @NotNull
    public static Map<String, Pair<PyType, WeakReference<PsiElement>>> getFieldReferencesForMethod(@NotNull PyReferenceExpression methodReference, @NotNull TypeEvalContext context, @NotNull FieldReferencesDirections directions) {
        PyCallExpression parentCall;
        if (methodReference == null) {
            DjangoFieldReferencesObtainer.$$$reportNull$$$0(2);
        }
        if (context == null) {
            DjangoFieldReferencesObtainer.$$$reportNull$$$0(3);
        }
        if (directions == null) {
            DjangoFieldReferencesObtainer.$$$reportNull$$$0(4);
        }
        PyClass model = null;
        PyReferenceExpression currentMethodReference = methodReference;
        while (currentMethodReference != null && (model = DjangoFieldReferencesObtainer.getModel(currentMethodReference, context)) == null && (parentCall = (PyCallExpression)PyUtil.as((Object)currentMethodReference.getQualifier(), PyCallExpression.class)) != null) {
            currentMethodReference = (PyReferenceExpression)PyUtil.as((Object)parentCall.getCallee(), PyReferenceExpression.class);
        }
        if (model == null) {
            Map<String, Pair<PyType, WeakReference<PsiElement>>> map = Collections.emptyMap();
            if (map == null) {
                DjangoFieldReferencesObtainer.$$$reportNull$$$0(5);
            }
            return map;
        }
        return new DjangoFieldReferencesObtainer(context, directions).getFieldReferencesForModel(model, 0, null);
    }

    @NotNull
    public static Map<String, Pair<PyType, WeakReference<PsiElement>>> getFieldReferencesForModel(@NotNull PyClass model, @NotNull TypeEvalContext context, @NotNull FieldReferencesDirections directions) {
        if (model == null) {
            DjangoFieldReferencesObtainer.$$$reportNull$$$0(6);
        }
        if (context == null) {
            DjangoFieldReferencesObtainer.$$$reportNull$$$0(7);
        }
        if (directions == null) {
            DjangoFieldReferencesObtainer.$$$reportNull$$$0(8);
        }
        return new DjangoFieldReferencesObtainer(context, directions).getFieldReferencesForModel(model, 0, null);
    }

    @NotNull
    private Map<String, Pair<PyType, WeakReference<PsiElement>>> getFieldReferencesForModel(@NotNull PyClass model, int level, @Nullable String bannedRelationName) {
        if (model == null) {
            DjangoFieldReferencesObtainer.$$$reportNull$$$0(9);
        }
        HashMap fieldReferences = new HashMap();
        fieldReferences.putAll(this.getReverseRelations(model, bannedRelationName));
        fieldReferences.putAll(this.getFieldsAndDirectRelations(model, bannedRelationName));
        Map<String, Pair<PyType, WeakReference<PsiElement>>> result = DjangoFieldReferencesObtainer.prepareResult(fieldReferences);
        if (level < 2) {
            result.putAll(this.getSubEntries(level, fieldReferences));
        }
        Map<String, Pair<PyType, WeakReference<PsiElement>>> map = result;
        if (map == null) {
            DjangoFieldReferencesObtainer.$$$reportNull$$$0(10);
        }
        return map;
    }

    @NotNull
    private static Map<String, Pair<PyType, WeakReference<PsiElement>>> prepareResult(@NotNull Map<String, FieldReference<?>> fieldReferences) {
        if (fieldReferences == null) {
            DjangoFieldReferencesObtainer.$$$reportNull$$$0(11);
        }
        HashMap<String, Pair<PyType, WeakReference<PsiElement>>> result = new HashMap<String, Pair<PyType, WeakReference<PsiElement>>>();
        for (Map.Entry<String, FieldReference<?>> lookupEntry : fieldReferences.entrySet()) {
            if (!lookupEntry.getValue().isAddToResult()) continue;
            result.put(lookupEntry.getKey(), (Pair<PyType, WeakReference<PsiElement>>)Pair.create(lookupEntry.getValue().getType(), lookupEntry.getValue().getElement()));
        }
        HashMap<String, Pair<PyType, WeakReference<PsiElement>>> hashMap = result;
        if (hashMap == null) {
            DjangoFieldReferencesObtainer.$$$reportNull$$$0(12);
        }
        return hashMap;
    }

    @NotNull
    private Map<String, Pair<PyType, WeakReference<PsiElement>>> getSubEntries(int level, @NotNull Map<String, FieldReference<?>> fieldReferences) {
        if (fieldReferences == null) {
            DjangoFieldReferencesObtainer.$$$reportNull$$$0(13);
        }
        HashMap<String, Pair<PyType, WeakReference<PsiElement>>> result = new HashMap<String, Pair<PyType, WeakReference<PsiElement>>>();
        for (Map.Entry<String, FieldReference<?>> entry : fieldReferences.entrySet()) {
            FieldReferenceWithRelation lookup = (FieldReferenceWithRelation)PyUtil.as(entry.getValue(), FieldReferenceWithRelation.class);
            if (lookup == null || !lookup.isFollow()) continue;
            Object classType = lookup.getType();
            String name = entry.getKey();
            PyClass modelClass = (PyClass)PyTypeUtil.findData(classType, DjangoTypeProvider.MODEL_CLASS_KEY);
            if (modelClass == null && classType instanceof PyClassType) {
                modelClass = ((PyClassType)classType).getPyClass();
            }
            if (modelClass == null || !DjangoModelClass.isModelClass(modelClass, null) || result.size() >= 500) continue;
            Map<String, Pair<PyType, WeakReference<PsiElement>>> subModels = this.getFieldReferencesForModel(modelClass, level + 1, lookup.getBackRelationNameToBan());
            for (Map.Entry<String, Pair<PyType, WeakReference<PsiElement>>> subEntry : subModels.entrySet()) {
                result.put(name + "__" + subEntry.getKey(), subEntry.getValue());
            }
        }
        HashMap<String, Pair<PyType, WeakReference<PsiElement>>> hashMap = result;
        if (hashMap == null) {
            DjangoFieldReferencesObtainer.$$$reportNull$$$0(14);
        }
        return hashMap;
    }

    @NotNull
    private Map<String, FieldReference<?>> getFieldsAndDirectRelations(@NotNull PyClass model, @Nullable String bannedRelationName) {
        if (model == null) {
            DjangoFieldReferencesObtainer.$$$reportNull$$$0(15);
        }
        HashMap result = new HashMap();
        Set<DjangoRelationType> allowedBranches = this.myDirections.getBranchesToAllow();
        Set<DjangoRelationType> directRelationsToFollow = this.myDirections.getDirectRelationsToFollow();
        for (PyTargetExpression expression : model.getClassAttributesInherited(this.myContext)) {
            boolean branch;
            String name = expression.getName();
            PyType type = DjangoTypeProvider.getReferenceTypeStatic((PsiElement)expression, this.myContext, null);
            if (type == null) {
                PyClassType attributeType = (PyClassType)PyUtil.as((Object)this.myContext.getType((PyTypedElement)expression), PyClassType.class);
                if (attributeType == null || !DjangoModel.isDjangoFieldDescendant(attributeType.getPyClass(), this.myContext)) continue;
                type = PyClassTypeImpl.createTypeByQName((PsiElement)model, (String)"object", (boolean)false);
                assert (type != null) : "No object type";
            }
            DjangoKeyRelationInfo info = DjangoKeyRelationInfo.create(expression, this.myContext);
            type = PyUnionType.toNonWeakType((PyType)type);
            boolean bl = branch = info != null;
            if (branch && type instanceof PyClassType) {
                boolean includeFieldWithIdPostfix;
                DjangoRelationType relationType = info.getRelationType();
                if (name == null || name.equals(bannedRelationName)) continue;
                boolean followRelation = directRelationsToFollow.contains((Object)relationType);
                boolean branchAllowed = allowedBranches.contains((Object)relationType);
                result.put(name, new FieldReferenceWithRelation(type, (PsiElement)expression, branchAllowed, relationType, followRelation, info.getRelatedName()));
                if (!branchAllowed || relationType == DjangoRelationType.MANY_TO_MANY) continue;
                PyClassType intType = PyBuiltinCache.getInstance((PsiElement)model).getIntType();
                boolean bl2 = includeFieldWithIdPostfix = !this.myDirections.isRemoveIdPostfix();
                if (intType == null || !includeFieldWithIdPostfix) continue;
                result.put(name + "_id", new FieldReference<PyClassType>(intType, (PsiElement)expression, true));
                continue;
            }
            if (!this.myDirections.isAllowLeaves() || type == null) continue;
            result.put(name, new FieldReference<PyType>(type, (PsiElement)expression, true));
        }
        HashMap hashMap = result;
        if (hashMap == null) {
            DjangoFieldReferencesObtainer.$$$reportNull$$$0(16);
        }
        return hashMap;
    }

    @NotNull
    private Map<String, FieldReference<?>> getReverseRelations(@NotNull PyClass model, @Nullable String bannedRelationName) {
        if (model == null) {
            DjangoFieldReferencesObtainer.$$$reportNull$$$0(17);
        }
        Set<DjangoRelationType> allowedReverseRelations = this.myDirections.getReverseRelationsToFollow();
        HashMap result = new HashMap();
        if (allowedReverseRelations.isEmpty()) {
            Map<String, FieldReference<?>> map = Collections.emptyMap();
            if (map == null) {
                DjangoFieldReferencesObtainer.$$$reportNull$$$0(18);
            }
            return map;
        }
        PyResolveContext resolveContext = PyResolveContext.defaultContext((TypeEvalContext)this.myContext);
        Collection<PyCustomMember> relations = DjangoModel.getAttributesFromReverseForeignRelations(model, null);
        for (PyCustomMember relation : relations) {
            DjangoRelationType relationType;
            PyTypedElement resolve = (PyTypedElement)PyUtil.as((Object)relation.resolve((PsiElement)model, resolveContext), PyTypedElement.class);
            if (resolve == null) continue;
            PyType type = this.myContext.getType(resolve);
            DjangoModel.RelationInfo relatedInfo = DjangoModel.getRelatedInfo(relation, (PsiElement)model, resolveContext);
            if (relatedInfo == null || type == null || (relationType = DjangoFieldReferencesObtainer.getRelationType(type, this.myContext)) == null || !allowedReverseRelations.contains((Object)relationType)) continue;
            String relationName = !relatedInfo.backNameWasAutogenerated() && this.myDirections.isRemoveSetsFromReverse() ? DjangoModel.getNameNoPostfix(relation.getName()) : relation.getName();
            boolean banned = relationName.equals(bannedRelationName);
            boolean reverseRelationAllowed = this.myDirections.isAllowReverseRelationItself();
            result.put(relationName, new FieldReferenceWithRelation(type, (PsiElement)resolve, !banned && reverseRelationAllowed, relationType, !banned, relatedInfo.backRelationName()));
        }
        HashMap hashMap = result;
        if (hashMap == null) {
            DjangoFieldReferencesObtainer.$$$reportNull$$$0(19);
        }
        return hashMap;
    }

    @Nullable
    private static DjangoRelationType getRelationType(@NotNull PyType type, @Nullable TypeEvalContext context) {
        DjangoModel.RelationInfo relatedInfo;
        if (type == null) {
            DjangoFieldReferencesObtainer.$$$reportNull$$$0(20);
        }
        if ((relatedInfo = DjangoModel.getRelatedInfo(type)) != null) {
            return relatedInfo.relationType();
        }
        PyCallExpression callExpression = (PyCallExpression)PyTypeUtil.findData((PyType)type, DjangoTypeProvider.RELATED_KEY);
        if (callExpression == null) {
            return null;
        }
        return DjangoRelationType.getTypeByInitCall(callExpression, context);
    }

    @Nullable
    public static PyClass getModel(@NotNull PyReferenceExpression classMemberExpression, @NotNull TypeEvalContext context) {
        PyClass possibleModelByKey;
        if (classMemberExpression == null) {
            DjangoFieldReferencesObtainer.$$$reportNull$$$0(21);
        }
        if (context == null) {
            DjangoFieldReferencesObtainer.$$$reportNull$$$0(22);
        }
        if ((possibleModelByKey = DjangoFieldReferencesObtainer.getModelByKey(classMemberExpression, context)) != null) {
            return possibleModelByKey;
        }
        PyClass possibleModelByManagerIndex = DjangoFieldReferencesObtainer.getModelByManagerIndex(classMemberExpression, context);
        if (possibleModelByManagerIndex != null) {
            return possibleModelByManagerIndex;
        }
        return DjangoFieldReferencesObtainer.getModelDirectlyFromClass(classMemberExpression, context);
    }

    @Nullable
    private static PyClass getModelByManagerIndex(@NotNull PyReferenceExpression classMemberExpression, @NotNull TypeEvalContext context) {
        PyClass possibleManager;
        if (classMemberExpression == null) {
            DjangoFieldReferencesObtainer.$$$reportNull$$$0(23);
        }
        if (context == null) {
            DjangoFieldReferencesObtainer.$$$reportNull$$$0(24);
        }
        if ((possibleManager = (PyClass)PsiTreeUtil.getParentOfType((PsiElement)classMemberExpression, PyClass.class)) == null) {
            return null;
        }
        PyClassType managerClassType = (PyClassType)PyUtil.as((Object)context.getType((PyTypedElement)possibleManager), PyClassType.class);
        if (managerClassType == null) {
            return null;
        }
        PyClass manager = managerClassType.getPyClass();
        String name = manager.getName();
        if (name == null) {
            return null;
        }
        Collection<PyTargetExpression> expressions = DjangoManagerIndex.findManagerUsages(classMemberExpression.getProject(), name);
        for (PyTargetExpression expression : expressions) {
            PyClass possibleModel;
            PyClassType classType = (PyClassType)PyUtil.as((Object)context.getType((PyTypedElement)expression), PyClassType.class);
            if (classType == null || !classType.getPyClass().equals((Object)manager) || (possibleModel = expression.getContainingClass()) == null || !DjangoModelClass.isModelClass(possibleModel, null)) continue;
            return possibleModel;
        }
        return null;
    }

    @Nullable
    private static PyClass getModelByKey(@NotNull PyReferenceExpression classMemberExpression, @NotNull TypeEvalContext context) {
        if (classMemberExpression == null) {
            DjangoFieldReferencesObtainer.$$$reportNull$$$0(25);
        }
        if (context == null) {
            DjangoFieldReferencesObtainer.$$$reportNull$$$0(26);
        }
        PyExpression qualifier = classMemberExpression.getQualifier();
        while (qualifier != null) {
            PyClass possibleModel;
            PyType type = context.getType((PyTypedElement)qualifier);
            if (type != null && (possibleModel = (PyClass)PyTypeUtil.findData((PyType)type, DjangoTypeProvider.MODEL_CLASS_KEY)) != null && DjangoModelClass.isModelClass(possibleModel, null)) {
                return possibleModel;
            }
            qualifier = (PyExpression)PsiTreeUtil.getChildOfType((PsiElement)qualifier, PyReferenceExpression.class);
        }
        return null;
    }

    @Nullable
    private static PyClass getModelDirectlyFromClass(@NotNull PyReferenceExpression classMemberExpression, @NotNull TypeEvalContext context) {
        if (classMemberExpression == null) {
            DjangoFieldReferencesObtainer.$$$reportNull$$$0(27);
        }
        if (context == null) {
            DjangoFieldReferencesObtainer.$$$reportNull$$$0(28);
        }
        PyClassType calleeClassType = null;
        PyReferenceExpression callee = classMemberExpression;
        while (calleeClassType == null && callee != null) {
            PyTypedElement typedElement = (PyTypedElement)PyUtil.as((Object)callee.getReference().resolve(), PyTypedElement.class);
            if (typedElement != null && (calleeClassType = (PyClassType)PyUtil.as((Object)context.getType(typedElement), PyClassType.class)) != null && !DjangoModelClass.isModelClass(calleeClassType.getPyClass(), null)) {
                calleeClassType = null;
            }
            if (calleeClassType != null) continue;
            callee = (PyReferenceExpression)PyUtil.as((Object)callee.getQualifier(), PyReferenceExpression.class);
        }
        if (calleeClassType == null || !DjangoModelClass.isModelClass(calleeClassType.getPyClass(), null)) {
            return null;
        }
        return calleeClassType.getPyClass();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 10, 12, 14, 16, 18, 19 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directions";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodReference";
                break;
            }
            case 5: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/django/model/fieldsAsArguments/fieldReferencesObtainer/DjangoFieldReferencesObtainer";
                break;
            }
            case 6: 
            case 9: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldReferences";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 21: 
            case 23: 
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classMemberExpression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/django/model/fieldsAsArguments/fieldReferencesObtainer/DjangoFieldReferencesObtainer";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFieldReferencesForMethod";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getFieldReferencesForModel";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareResult";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubEntries";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getFieldsAndDirectRelations";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getReverseRelations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getFieldReferencesForMethod";
                break;
            }
            case 5: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 19: {
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getFieldReferencesForModel";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "prepareResult";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getSubEntries";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getFieldsAndDirectRelations";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getReverseRelations";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getRelationType";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getModel";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getModelByManagerIndex";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getModelByKey";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getModelDirectlyFromClass";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 10, 12, 14, 16, 18, 19 -> new IllegalStateException(string);
        };
    }
}

