/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.django.model.relationalKeys;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.QualifiedName;
import com.jetbrains.django.model.relationalKeys.DjangoKeyCallInfo;
import com.jetbrains.django.model.relationalKeys.DjangoRelationType;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyTypedElement;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DjangoKeyRelationInfo {
    @NotNull
    private final String myUnqualifiedDestClassName;
    @NotNull
    private final DjangoRelationType myRelationType;
    @NotNull
    private final PyCallExpression myInitCall;

    @Nullable
    public static DjangoKeyRelationInfo create(@NotNull PyTargetExpression targetExpression, @Nullable TypeEvalContext context) {
        PyCallExpression initCall;
        if (targetExpression == null) {
            DjangoKeyRelationInfo.$$$reportNull$$$0(0);
        }
        if ((initCall = (PyCallExpression)PyUtil.as((Object)targetExpression.findAssignedValue(), PyCallExpression.class)) == null) {
            return null;
        }
        DjangoRelationType relationType = DjangoRelationType.getTypeByInitCall(initCall, context);
        return relationType == null ? null : new DjangoKeyRelationInfo(targetExpression, context, initCall, relationType);
    }

    private DjangoKeyRelationInfo(@NotNull PyTargetExpression targetExpression, @Nullable TypeEvalContext context, @NotNull PyCallExpression initCall, @NotNull DjangoRelationType relationType) {
        String destinationName;
        String lastComponent;
        if (targetExpression == null) {
            DjangoKeyRelationInfo.$$$reportNull$$$0(1);
        }
        if (initCall == null) {
            DjangoKeyRelationInfo.$$$reportNull$$$0(2);
        }
        if (relationType == null) {
            DjangoKeyRelationInfo.$$$reportNull$$$0(3);
        }
        boolean indexMode = context == null;
        DjangoKeyCallInfo callInfo = new DjangoKeyCallInfo(initCall, relationType);
        this.myInitCall = initCall;
        this.myRelationType = callInfo.getRelationType();
        @Nullable PyExpression destClassExpression = callInfo.getDestClassExpression();
        QualifiedName className = null;
        if (destClassExpression instanceof PyReferenceExpression) {
            className = indexMode ? PyPsiUtils.asQualifiedName((PyExpression)destClassExpression) : DjangoKeyRelationInfo.getClassFromExpression((PyTypedElement)destClassExpression);
        } else if (destClassExpression instanceof PyStringLiteralExpression) {
            String qualifiedName;
            PyClass containingClass;
            String stringValue = ((PyStringLiteralExpression)destClassExpression).getStringValue();
            if (stringValue.equals("self") && (containingClass = targetExpression.getContainingClass()) != null && !indexMode && (qualifiedName = containingClass.getQualifiedName()) != null) {
                className = QualifiedName.fromDottedString((String)qualifiedName);
            }
            if (className == null && !indexMode) {
                for (PsiReference possibleClassReference : destClassExpression.getReferences()) {
                    PyTypedElement possibleClass = (PyTypedElement)PyUtil.as((Object)possibleClassReference.resolve(), PyTypedElement.class);
                    if (possibleClass == null) continue;
                    className = DjangoKeyRelationInfo.getClassFromExpression(possibleClass);
                }
            }
            if (className == null) {
                className = QualifiedName.fromDottedString((String)stringValue);
            }
        }
        if (className != null && (lastComponent = className.getLastComponent()) != null) {
            this.myUnqualifiedDestClassName = lastComponent;
            return;
        }
        if (destClassExpression != null && (destinationName = destClassExpression.getName()) != null) {
            this.myUnqualifiedDestClassName = destinationName;
            return;
        }
        this.myUnqualifiedDestClassName = "";
    }

    @Nullable
    public String getRelatedName() {
        String relatedName = PyUtil.getKeywordArgumentString((PyCallExpression)this.myInitCall, (String)"related_name");
        if (relatedName != null) {
            return relatedName;
        }
        PyClass parent = (PyClass)PsiTreeUtil.getParentOfType((PsiElement)this.myInitCall, PyClass.class);
        if (parent == null) {
            return null;
        }
        String className = parent.getName();
        if (className == null) {
            return null;
        }
        String classNameLowerCase = className.toLowerCase(Locale.getDefault());
        return switch (this.myRelationType) {
            default -> throw new MatchException(null, null);
            case DjangoRelationType.MANY_TO_MANY, DjangoRelationType.ONE_TO_MANY -> String.format("%ss%s", classNameLowerCase, "_set");
            case DjangoRelationType.ONE_TO_ONE -> classNameLowerCase;
        };
    }

    @NotNull
    public String getUnqualifiedDestClassName() {
        String string = this.myUnqualifiedDestClassName;
        if (string == null) {
            DjangoKeyRelationInfo.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public DjangoRelationType getRelationType() {
        DjangoRelationType djangoRelationType = this.myRelationType;
        if (djangoRelationType == null) {
            DjangoKeyRelationInfo.$$$reportNull$$$0(5);
        }
        return djangoRelationType;
    }

    @NotNull
    public PyCallExpression getInitCall() {
        PyCallExpression pyCallExpression = this.myInitCall;
        if (pyCallExpression == null) {
            DjangoKeyRelationInfo.$$$reportNull$$$0(6);
        }
        return pyCallExpression;
    }

    @Nullable
    private static QualifiedName getClassFromExpression(@NotNull PyTypedElement possibleClass) {
        String qName;
        PyClassType destClass;
        if (possibleClass == null) {
            DjangoKeyRelationInfo.$$$reportNull$$$0(7);
        }
        if ((destClass = (PyClassType)PyUtil.as((Object)TypeEvalContext.deepCodeInsight((Project)possibleClass.getProject()).getType(possibleClass), PyClassType.class)) != null && (qName = destClass.getClassQName()) != null) {
            return QualifiedName.fromDottedString((String)qName);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetExpression";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initCall";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relationType";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/django/model/relationalKeys/DjangoKeyRelationInfo";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "possibleClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/django/model/relationalKeys/DjangoKeyRelationInfo";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnqualifiedDestClassName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getRelationType";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getInitCall";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getClassFromExpression";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6 -> new IllegalStateException(string);
        };
    }
}

