/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.core.impl.actions;

import com.intellij.notebooks.visualization.NotebookCellLines;
import com.intellij.notebooks.visualization.NotebookIntervalPointerFactory;
import com.intellij.notebooks.visualization.NotebookVisualizationUiUtilKt;
import com.intellij.openapi.editor.Document;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\u0004\u001a\u00020\u0005*\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\b\u0010\n\u001a\u0004\u0018\u00010\u000bJ\u001c\u0010\f\u001a\u00020\u0005*\u00020\u00062\u0006\u0010\r\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bJ(\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\b*\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u0013J2\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\t0\b*\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00172\b\b\u0002\u0010\u0018\u001a\u00020\u0019\u00a8\u0006\u001a"}, d2={"Lcom/intellij/jupyter/core/core/impl/actions/NotebookCellLinesDocumentUtils;", "", "<init>", "()V", "removeCells", "", "Lcom/intellij/openapi/editor/Document;", "cells", "", "Lcom/intellij/notebooks/visualization/NotebookCellLines$Interval;", "ptrFactory", "Lcom/intellij/notebooks/visualization/NotebookIntervalPointerFactory;", "removeCell", "cell", "replaceCell", "cellLines", "Lcom/intellij/notebooks/visualization/NotebookCellLines;", "oldCell", "newText", "", "insertCells", "cellsText", "targetOrdinal", "", "shouldKeepEmptyCell", "", "intellij.jupyter.core"})
public final class NotebookCellLinesDocumentUtils {
    @NotNull
    public static final NotebookCellLinesDocumentUtils INSTANCE = new NotebookCellLinesDocumentUtils();

    private NotebookCellLinesDocumentUtils() {
    }

    public final void removeCells(@NotNull Document $this$removeCells, @NotNull List<NotebookCellLines.Interval> cells, @Nullable NotebookIntervalPointerFactory ptrFactory) {
        Intrinsics.checkNotNullParameter((Object)$this$removeCells, (String)"<this>");
        Intrinsics.checkNotNullParameter(cells, (String)"cells");
        for (NotebookCellLines.Interval cell : CollectionsKt.asReversed(cells)) {
            this.removeCell($this$removeCells, cell, ptrFactory);
        }
    }

    public final void removeCell(@NotNull Document $this$removeCell, @NotNull NotebookCellLines.Interval cell, @Nullable NotebookIntervalPointerFactory ptrFactory) {
        Intrinsics.checkNotNullParameter((Object)$this$removeCell, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)cell, (String)"cell");
        if (cell.getLines().getFirst() > 0) {
            $this$removeCell.deleteString($this$removeCell.getLineStartOffset(cell.getLines().getFirst()) - 1, $this$removeCell.getLineEndOffset(cell.getLines().getLast()));
        } else if (cell.getLines().getLast() + 1 == $this$removeCell.getLineCount()) {
            NotebookIntervalPointerFactory notebookIntervalPointerFactory = ptrFactory;
            if (notebookIntervalPointerFactory != null) {
                notebookIntervalPointerFactory.modifyPointers((Iterable)CollectionsKt.listOf((Object)new NotebookIntervalPointerFactory.Invalidate(cell)));
            }
            $this$removeCell.deleteString($this$removeCell.getLineStartOffset(cell.getFirstContentLine()), $this$removeCell.getLineEndOffset(cell.getLastContentLine()));
        } else {
            $this$removeCell.deleteString(0, $this$removeCell.getLineStartOffset(cell.getLines().getLast() + 1));
        }
    }

    @NotNull
    public final List<NotebookCellLines.Interval> replaceCell(@NotNull Document $this$replaceCell, @NotNull NotebookCellLines cellLines, @NotNull NotebookCellLines.Interval oldCell, @NotNull String newText) {
        Intrinsics.checkNotNullParameter((Object)$this$replaceCell, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)cellLines, (String)"cellLines");
        Intrinsics.checkNotNullParameter((Object)oldCell, (String)"oldCell");
        Intrinsics.checkNotNullParameter((Object)newText, (String)"newText");
        int lineCountBefore = $this$replaceCell.getLineCount();
        $this$replaceCell.replaceString($this$replaceCell.getLineStartOffset(oldCell.getLines().getFirst()), $this$replaceCell.getLineEndOffset(oldCell.getLines().getLast()), (CharSequence)newText);
        int lineCountAfter = $this$replaceCell.getLineCount();
        return SequencesKt.toList((Sequence)NotebookVisualizationUiUtilKt.getCells((NotebookCellLines)cellLines, (IntRange)new IntRange(oldCell.getLines().getFirst(), oldCell.getLines().getLast() + lineCountAfter - lineCountBefore)));
    }

    @NotNull
    public final List<NotebookCellLines.Interval> insertCells(@NotNull Document $this$insertCells, @NotNull NotebookCellLines cellLines, @NotNull String cellsText, int targetOrdinal, boolean shouldKeepEmptyCell) {
        int n;
        Intrinsics.checkNotNullParameter((Object)$this$insertCells, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)cellLines, (String)"cellLines");
        Intrinsics.checkNotNullParameter((Object)cellsText, (String)"cellsText");
        int lineCountBefore = $this$insertCells.getLineCount();
        if (lineCountBefore == 0 && !shouldKeepEmptyCell) {
            $this$insertCells.insertString(0, (CharSequence)cellsText);
            return cellLines.getIntervals();
        }
        if (targetOrdinal == 0) {
            $this$insertCells.insertString(0, (CharSequence)(cellsText + "\n"));
            n = 0;
        } else {
            NotebookCellLines.Interval prevCell = (NotebookCellLines.Interval)cellLines.getIntervals().get(targetOrdinal - 1);
            $this$insertCells.insertString($this$insertCells.getLineEndOffset(prevCell.getLines().getLast()), (CharSequence)("\n" + cellsText));
            n = prevCell.getLines().getLast() + 1;
        }
        int firstLine = n;
        int lineCountAfter = $this$insertCells.getLineCount();
        return SequencesKt.toList((Sequence)NotebookVisualizationUiUtilKt.getCells((NotebookCellLines)cellLines, (IntRange)RangesKt.until((int)firstLine, (int)(firstLine + (lineCountAfter - lineCountBefore)))));
    }

    public static /* synthetic */ List insertCells$default(NotebookCellLinesDocumentUtils notebookCellLinesDocumentUtils, Document document, NotebookCellLines notebookCellLines, String string, int n, boolean bl, int n2, Object object) {
        if ((n2 & 8) != 0) {
            bl = false;
        }
        return notebookCellLinesDocumentUtils.insertCells(document, notebookCellLines, string, n, bl);
    }
}

