/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.executor.kernel.session.restore;

import com.intellij.jupyter.core.executor.JupyterExecutionManager;
import com.intellij.jupyter.core.executor.kernel.JupyterKernelCellTask;
import com.intellij.jupyter.core.executor.kernel.session.JupyterRuntimeService;
import com.intellij.jupyter.core.executor.queue.JupyterExecutionQueueStore;
import com.intellij.jupyter.core.executor.queue.JupyterFileExecutionQueue;
import com.intellij.jupyter.core.jupyter.connections.execution.core.JupyterNotebookSession;
import com.intellij.jupyter.core.jupyter.connections.settings.JupyterConnectionParameterSettingsUtils;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectCloseListener;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.platform.ide.progress.TasksKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.TimeoutKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u000e"}, d2={"Lcom/intellij/jupyter/core/executor/kernel/session/restore/JupyterExecutionProjectClosingListener;", "Lcom/intellij/openapi/project/ProjectCloseListener;", "<init>", "()V", "projectClosing", "", "project", "Lcom/intellij/openapi/project/Project;", "sendAllTasksToServer", "executor", "Lcom/intellij/jupyter/core/executor/queue/JupyterFileExecutionQueue;", "probablyShouldSendTasksToServer", "", "Companion", "intellij.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nJupyterExecutionProjectClosingListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterExecutionProjectClosingListener.kt\ncom/intellij/jupyter/core/executor/kernel/session/restore/JupyterExecutionProjectClosingListener\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,72:1\n23#2:73\n808#3,11:74\n*S KotlinDebug\n*F\n+ 1 JupyterExecutionProjectClosingListener.kt\ncom/intellij/jupyter/core/executor/kernel/session/restore/JupyterExecutionProjectClosingListener\n*L\n31#1:73\n46#1:74,11\n*E\n"})
public final class JupyterExecutionProjectClosingListener
implements ProjectCloseListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Key<Unit> JUPYTER_PROJECT_CLOSING_KEY = new Key("JupyterProjectClosingListener");

    public void projectClosing(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        project.putUserData(JUPYTER_PROJECT_CLOSING_KEY, (Object)Unit.INSTANCE);
        JupyterRuntimeService jupyterRuntimeService = JupyterRuntimeService.Companion.getInstance(project);
        Intrinsics.checkNotNull((Object)jupyterRuntimeService);
        Disposer.dispose((Disposable)((Disposable)jupyterRuntimeService));
        Collection<JupyterFileExecutionQueue> allQueues = JupyterExecutionQueueStore.Companion.getInstance(project).getAllQueues();
        for (JupyterFileExecutionQueue executor : allQueues) {
            try {
                this.sendAllTasksToServer(executor);
            }
            catch (Throwable t) {
                JupyterExecutionProjectClosingListener $this$thisLogger$iv = this;
                boolean $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(JupyterExecutionProjectClosingListener.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.warn(t);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void sendAllTasksToServer(JupyterFileExecutionQueue executor) {
        void $this$filterIsInstanceTo$iv$iv;
        Project project = executor.getProject();
        if (!this.probablyShouldSendTasksToServer(executor)) {
            return;
        }
        Iterable $this$filterIsInstance$iv = executor.getRemainingTasks();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof JupyterKernelCellTask)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List tasksToSend = (List)destination$iv$iv;
        JupyterNotebookSession jupyterNotebookSession = JupyterExecutionManager.Companion.getInstance(project, executor.getFile()).getSession();
        if (jupyterNotebookSession == null) {
            return;
        }
        JupyterNotebookSession session = jupyterNotebookSession;
        String string = Reflection.getOrCreateKotlinClass(JupyterFileExecutionQueue.class).getSimpleName();
        Intrinsics.checkNotNull((Object)string);
        TasksKt.runWithModalProgressBlocking((Project)project, (String)string, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>((List<? extends JupyterKernelCellTask>)tasksToSend, session, null){
            int label;
            final /* synthetic */ List<JupyterKernelCellTask> $tasksToSend;
            final /* synthetic */ JupyterNotebookSession $session;
            {
                this.$tasksToSend = $tasksToSend;
                this.$session = $session;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = TimeoutKt.withTimeoutOrNull((long)1000L, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$tasksToSend, this.$session, null){
                            int label;
                            final /* synthetic */ List<JupyterKernelCellTask> $tasksToSend;
                            final /* synthetic */ JupyterNotebookSession $session;
                            {
                                this.$tasksToSend = $tasksToSend;
                                this.$session = $session;
                                super(2, $completion);
                            }

                            public final Object invokeSuspend(Object $result) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        for (JupyterKernelCellTask task : this.$tasksToSend) {
                                            String source = task.getSource();
                                            JupyterNotebookSession.execute$default(this.$session, source, null, null, false, 6, null);
                                        }
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object2 != object) return object2;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return object2;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    private final boolean probablyShouldSendTasksToServer(JupyterFileExecutionQueue executor) {
        Project project = executor.getProject();
        if (!Registry.Companion.is("jupyter.drop.tasks.to.server.on.close.if.remote")) {
            return false;
        }
        return Intrinsics.areEqual((Object)JupyterConnectionParameterSettingsUtils.INSTANCE.isConfiguredServer(project, executor.getFile().getFile()), (Object)true);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\n\u0010\u0007\u001a\u00020\b*\u00020\tR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/jupyter/core/executor/kernel/session/restore/JupyterExecutionProjectClosingListener$Companion;", "", "<init>", "()V", "JUPYTER_PROJECT_CLOSING_KEY", "Lcom/intellij/openapi/util/Key;", "", "isProjectClosing", "", "Lcom/intellij/openapi/project/Project;", "intellij.jupyter.core"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isProjectClosing(@NotNull Project $this$isProjectClosing) {
            Intrinsics.checkNotNullParameter((Object)$this$isProjectClosing, (String)"<this>");
            return $this$isProjectClosing.getUserData(JUPYTER_PROJECT_CLOSING_KEY) != null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

