/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.connections.execution.notebook;

import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.executor.JupyterExecutionManager;
import com.intellij.jupyter.core.jupyter.connections.JupyterConnectionParameters;
import com.intellij.jupyter.core.jupyter.connections.client.JupyterConnectionEvents;
import com.intellij.jupyter.core.jupyter.connections.client.status.JupyterConnectionStatus;
import com.intellij.jupyter.core.jupyter.connections.settings.JupyterConnectionSettingsManager;
import com.intellij.jupyter.core.jupyter.connections.settings.config.JupyterServerConfig;
import com.intellij.jupyter.core.jupyter.editor.outputs.webOutputs.appBasedApi.scriptLoader.utils.JupyterCoroutineKt;
import com.intellij.jupyter.core.jupyter.helper.JupyterEditorExtensionsKt;
import com.intellij.jupyter.core.jupyter.remote.vfs.JupyterRemoteVirtualFile;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0018"}, d2={"Lcom/intellij/jupyter/core/jupyter/connections/execution/notebook/JupyterNotebookConnectionListener;", "Lcom/intellij/jupyter/core/jupyter/connections/client/JupyterConnectionEvents;", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;", "<init>", "(Lcom/intellij/openapi/editor/impl/EditorImpl;Lcom/intellij/openapi/project/Project;Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;)V", "getEditor", "()Lcom/intellij/openapi/editor/impl/EditorImpl;", "getProject", "()Lcom/intellij/openapi/project/Project;", "getFile", "()Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;", "connectionStatusChanged", "", "connectionParameters", "Lcom/intellij/jupyter/core/jupyter/connections/JupyterConnectionParameters;", "newStatus", "Lcom/intellij/jupyter/core/jupyter/connections/client/status/JupyterConnectionStatus;", "updateRemoteFile", "Companion", "intellij.jupyter.core"})
public final class JupyterNotebookConnectionListener
implements JupyterConnectionEvents {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final EditorImpl editor;
    @NotNull
    private final Project project;
    @NotNull
    private final BackedNotebookVirtualFile file;

    public JupyterNotebookConnectionListener(@NotNull EditorImpl editor, @NotNull Project project, @NotNull BackedNotebookVirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.editor = editor;
        this.project = project;
        this.file = file;
    }

    @NotNull
    public final EditorImpl getEditor() {
        return this.editor;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final BackedNotebookVirtualFile getFile() {
        return this.file;
    }

    @Override
    public void connectionStatusChanged(@NotNull JupyterConnectionParameters connectionParameters, @NotNull JupyterConnectionStatus newStatus) {
        Intrinsics.checkNotNullParameter((Object)connectionParameters, (String)"connectionParameters");
        Intrinsics.checkNotNullParameter((Object)newStatus, (String)"newStatus");
        this.updateRemoteFile(newStatus);
        if (newStatus instanceof JupyterConnectionStatus.Success) {
            return;
        }
        JupyterServerConfig jupyterServerConfig = JupyterConnectionSettingsManager.Companion.getInstance().getConfigForVirtualFile(this.file, this.project);
        if (jupyterServerConfig == null) {
            return;
        }
        JupyterServerConfig serverConfig = jupyterServerConfig;
        if (!Intrinsics.areEqual((Object)connectionParameters.getConfigId(), (Object)serverConfig.getId())) {
            return;
        }
        JupyterCoroutineKt.launchBackground((Function2<? super CoroutineScope, ? super Continuation<? super Unit>, ? extends Object>)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ JupyterNotebookConnectionListener this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = JupyterExecutionManager.Companion.getInstance(this.this$0.getProject(), this.this$0.getFile()).killExecution((Continuation<? super Unit>)((Continuation)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    private final void updateRemoteFile(JupyterConnectionStatus newStatus) {
        if (!(this.file.getFile() instanceof JupyterRemoteVirtualFile)) {
            return;
        }
        this.editor.getDocument().setReadOnly(!(newStatus instanceof JupyterConnectionStatus.Success));
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/jupyter/core/jupyter/connections/execution/notebook/JupyterNotebookConnectionListener$Companion;", "", "<init>", "()V", "initFor", "", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "intellij.jupyter.core"})
    public static final class Companion {
        private Companion() {
        }

        public final void initFor(@NotNull EditorImpl editor) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            BackedNotebookVirtualFile backedNotebookVirtualFile = JupyterEditorExtensionsKt.getNotebookFileOrNull((Editor)editor);
            if (backedNotebookVirtualFile == null) {
                return;
            }
            BackedNotebookVirtualFile file = backedNotebookVirtualFile;
            Project project = editor.getProject();
            if (project == null) {
                return;
            }
            Project project2 = project;
            JupyterNotebookConnectionListener listener2 = new JupyterNotebookConnectionListener(editor, project2, file);
            Disposable disposable = editor.getDisposable();
            Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"getDisposable(...)");
            JupyterConnectionEvents.Companion.subscribeOnConnectionStatusChange(disposable, listener2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

