/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.data.input;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.intellij.jupyter.core.jupyter.utils.JupyterPathUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.OSAgnosticPathUtil;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(alphabetic=true)
@JsonIgnoreProperties(ignoreUnknown=true)
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0003\b\u0087\b\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u001f\u0012\n\b\u0001\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0001\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0006\u0010\n\u001a\u00020\u000bJ \u0010\f\u001a\u00020\u00002\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000eJ\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0011\u001a\u00020\u000eJ\u000b\u0010\u0013\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u0014\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J!\u0010\f\u001a\u00020\u00002\n\b\u0003\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0003\u0010\u0004\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u000b2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u0003H\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u001b"}, d2={"Lcom/intellij/jupyter/core/jupyter/data/input/JupyterDataInputCellMetadata;", "", "notebookRelativedFilePath", "", "variableName", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "getNotebookRelativedFilePath", "()Ljava/lang/String;", "getVariableName", "hasFileMetadata", "", "copy", "file", "Ljava/nio/file/Path;", "project", "Lcom/intellij/openapi/project/Project;", "notebookPath", "getFilePath", "component1", "component2", "equals", "other", "hashCode", "", "toString", "Companion", "intellij.jupyter.core"})
public final class JupyterDataInputCellMetadata {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final String notebookRelativedFilePath;
    @Nullable
    private final String variableName;
    @NotNull
    public static final String KEY = "import_data_from_file";
    @NotNull
    private static final JupyterDataInputCellMetadata default = new JupyterDataInputCellMetadata(null, null);

    public JupyterDataInputCellMetadata(@JsonProperty(value="file_name") @Nullable String notebookRelativedFilePath, @JsonProperty(value="variable_name") @Nullable String variableName) {
        this.notebookRelativedFilePath = notebookRelativedFilePath;
        this.variableName = variableName;
    }

    @Nullable
    public final String getNotebookRelativedFilePath() {
        return this.notebookRelativedFilePath;
    }

    @Nullable
    public final String getVariableName() {
        return this.variableName;
    }

    public final boolean hasFileMetadata() {
        CharSequence charSequence = this.notebookRelativedFilePath;
        return !(charSequence == null || StringsKt.isBlank((CharSequence)charSequence));
    }

    @NotNull
    public final JupyterDataInputCellMetadata copy(@Nullable Path file, @NotNull Project project, @NotNull Path notebookPath) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)notebookPath, (String)"notebookPath");
        return Companion.create(file, this.variableName, project, notebookPath);
    }

    @Nullable
    public final Path getFilePath(@NotNull Path notebookPath) {
        Intrinsics.checkNotNullParameter((Object)notebookPath, (String)"notebookPath");
        if (this.notebookRelativedFilePath == null) {
            return null;
        }
        Path filePathObject = Path.of(this.notebookRelativedFilePath, new String[0]);
        if (filePathObject.isAbsolute()) {
            return filePathObject;
        }
        if (StringsKt.startsWith$default((String)this.notebookRelativedFilePath, (String)"~/", (boolean)false, (int)2, null)) {
            String string = OSAgnosticPathUtil.expandUserHome((String)this.notebookRelativedFilePath);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"expandUserHome(...)");
            String expandedPath = string;
            return Path.of(expandedPath, new String[0]);
        }
        return notebookPath.getParent().resolve(this.notebookRelativedFilePath);
    }

    @Nullable
    public final String component1() {
        return this.notebookRelativedFilePath;
    }

    @Nullable
    public final String component2() {
        return this.variableName;
    }

    @NotNull
    public final JupyterDataInputCellMetadata copy(@JsonProperty(value="file_name") @Nullable String notebookRelativedFilePath, @JsonProperty(value="variable_name") @Nullable String variableName) {
        return new JupyterDataInputCellMetadata(notebookRelativedFilePath, variableName);
    }

    public static /* synthetic */ JupyterDataInputCellMetadata copy$default(JupyterDataInputCellMetadata jupyterDataInputCellMetadata, String string, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            string = jupyterDataInputCellMetadata.notebookRelativedFilePath;
        }
        if ((n & 2) != 0) {
            string2 = jupyterDataInputCellMetadata.variableName;
        }
        return jupyterDataInputCellMetadata.copy(string, string2);
    }

    @NotNull
    public String toString() {
        return "JupyterDataInputCellMetadata(notebookRelativedFilePath=" + this.notebookRelativedFilePath + ", variableName=" + this.variableName + ")";
    }

    public int hashCode() {
        int result2 = this.notebookRelativedFilePath == null ? 0 : this.notebookRelativedFilePath.hashCode();
        result2 = result2 * 31 + (this.variableName == null ? 0 : this.variableName.hashCode());
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof JupyterDataInputCellMetadata)) {
            return false;
        }
        JupyterDataInputCellMetadata jupyterDataInputCellMetadata = (JupyterDataInputCellMetadata)other;
        if (!Intrinsics.areEqual((Object)this.notebookRelativedFilePath, (Object)jupyterDataInputCellMetadata.notebookRelativedFilePath)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.variableName, (Object)jupyterDataInputCellMetadata.variableName);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J*\u0010\n\u001a\u00020\u00072\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0011"}, d2={"Lcom/intellij/jupyter/core/jupyter/data/input/JupyterDataInputCellMetadata$Companion;", "", "<init>", "()V", "KEY", "", "default", "Lcom/intellij/jupyter/core/jupyter/data/input/JupyterDataInputCellMetadata;", "getDefault", "()Lcom/intellij/jupyter/core/jupyter/data/input/JupyterDataInputCellMetadata;", "create", "file", "Ljava/nio/file/Path;", "variableName", "project", "Lcom/intellij/openapi/project/Project;", "notebookPath", "intellij.jupyter.core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final JupyterDataInputCellMetadata getDefault() {
            return default;
        }

        @NotNull
        public final JupyterDataInputCellMetadata create(@Nullable Path file, @Nullable String variableName, @NotNull Project project, @NotNull Path notebookPath) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)notebookPath, (String)"notebookPath");
            if (file == null && variableName == null) {
                return this.getDefault();
            }
            if (file == null) {
                return new JupyterDataInputCellMetadata(null, variableName);
            }
            String filePath = JupyterPathUtils.INSTANCE.getFileNotebookRelativedString(file, project, notebookPath);
            return new JupyterDataInputCellMetadata(filePath, variableName);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

