/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.server.ui;

import com.intellij.jupyter.core.jupyter.JupyterBundle;
import com.intellij.jupyter.core.jupyter.connections.JupyterConnectionParameters;
import com.intellij.jupyter.core.jupyter.connections.managed.JupyterRuntimeManagedServerInfo;
import com.intellij.jupyter.core.jupyter.notification.JupyterNotification;
import com.intellij.jupyter.core.jupyter.server.common.JupyterServerExecution;
import com.intellij.jupyter.core.jupyter.server.common.JupyterServerProcessListener;
import com.intellij.notification.BrowseNotificationAction;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.HtmlChunk;
import java.net.URI;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lcom/intellij/jupyter/core/jupyter/server/ui/JupyterServerStateChangeUserNotifier;", "Lcom/intellij/jupyter/core/jupyter/server/common/JupyterServerProcessListener;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "serverStarted", "", "jupyterServerExecution", "Lcom/intellij/jupyter/core/jupyter/server/common/JupyterServerExecution;", "connectionParameters", "Lcom/intellij/jupyter/core/jupyter/connections/JupyterConnectionParameters;", "serverStopped", "config", "Lcom/intellij/jupyter/core/jupyter/connections/managed/JupyterRuntimeManagedServerInfo;", "isDestroyed", "", "intellij.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nJupyterServerStateChangeUserNotifier.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterServerStateChangeUserNotifier.kt\ncom/intellij/jupyter/core/jupyter/server/ui/JupyterServerStateChangeUserNotifier\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,50:1\n1869#2,2:51\n*S KotlinDebug\n*F\n+ 1 JupyterServerStateChangeUserNotifier.kt\ncom/intellij/jupyter/core/jupyter/server/ui/JupyterServerStateChangeUserNotifier\n*L\n45#1:51,2\n*E\n"})
public final class JupyterServerStateChangeUserNotifier
implements JupyterServerProcessListener {
    @NotNull
    private final Project project;

    public JupyterServerStateChangeUserNotifier(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Override
    public void serverStarted(@NotNull JupyterServerExecution jupyterServerExecution, @NotNull JupyterConnectionParameters connectionParameters) {
        Intrinsics.checkNotNullParameter((Object)jupyterServerExecution, (String)"jupyterServerExecution");
        Intrinsics.checkNotNullParameter((Object)connectionParameters, (String)"connectionParameters");
        URI initialUri = connectionParameters.getUri();
        String initialUriString = initialUri.toASCIIString();
        String shareableUri = connectionParameters.getHttpParams().toUrl();
        Object[] objectArray = new Object[1];
        Intrinsics.checkNotNull((Object)initialUriString);
        objectArray[0] = initialUriString;
        String message = JupyterBundle.message("jupyter.server.started.at", objectArray);
        Object[] objectArray2 = new Object[1];
        Intrinsics.checkNotNullExpressionValue((Object)HtmlChunk.tag((String)"a").attr("href", shareableUri).addText(initialUriString).toString(), (String)"toString(...)");
        String messageWithURL = JupyterBundle.message("jupyter.server.started.at", objectArray2);
        JupyterNotification.INSTANCE.getJUPYTER_NOTIFICATION_GROUP().createNotification(messageWithURL, NotificationType.INFORMATION).setDisplayId("jupyter.server.started").setListener(NotificationListener.URL_OPENING_LISTENER).notify(this.project);
        JupyterNotification.INSTANCE.getEVENT_LOG_NOTIFICATION_GROUP().createNotification(message, NotificationType.INFORMATION).setDisplayId("jupyter.server.started").addAction((AnAction)new BrowseNotificationAction(JupyterBundle.message("Jupyter.open.in.browser", new Object[0]), shareableUri)).notify(this.project);
    }

    @Override
    public void serverStopped(@NotNull JupyterRuntimeManagedServerInfo config, boolean isDestroyed) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Pair pair = isDestroyed ? TuplesKt.to((Object)JupyterBundle.message("jupyter.server.stopped", new Object[0]), (Object)"jupyter.server.started") : TuplesKt.to((Object)JupyterBundle.message("jupyter.server.detached", new Object[0]), (Object)"jupyter.server.detached");
        String message = (String)pair.component1();
        String displayId = (String)pair.component2();
        Object[] objectArray = new NotificationGroup[]{JupyterNotification.INSTANCE.getJUPYTER_NOTIFICATION_GROUP(), JupyterNotification.INSTANCE.getEVENT_LOG_NOTIFICATION_GROUP()};
        Iterable $this$forEach$iv = CollectionsKt.listOf((Object[])objectArray);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            NotificationGroup it = (NotificationGroup)element$iv;
            boolean bl = false;
            it.createNotification(message, NotificationType.INFORMATION).setDisplayId(displayId).notify(this.project);
        }
    }
}

