/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grazie;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.grazie.GrazieBundle;
import com.intellij.grazie.GrazieConfig;
import com.intellij.grazie.GrazieDynamic;
import com.intellij.grazie.GraziePluginKt;
import com.intellij.grazie.GrazieScope;
import com.intellij.grazie.ide.msg.GrazieStateLifecycle;
import com.intellij.grazie.jlanguage.Lang;
import com.intellij.grazie.remote.HunspellDescriptor;
import com.intellij.grazie.spellcheck.hunspell.HunspellDictionary;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.spellchecker.SpellCheckerManager;
import com.intellij.spellchecker.dictionary.Dictionary;
import com.intellij.spellchecker.engine.SpellCheckerEngine;
import java.nio.file.Path;
import java.util.Set;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c7\u0002\u0018\u00002\u00020\u0001:\u0002\u0016\u0017B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\fR\u0011\u0010\u000f\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0018"}, d2={"Lcom/intellij/grazie/GraziePlugin;", "", "<init>", "()V", "id", "", "descriptor", "Lcom/intellij/ide/plugins/IdeaPluginDescriptor;", "getDescriptor", "()Lcom/intellij/ide/plugins/IdeaPluginDescriptor;", "group", "getGroup", "()Ljava/lang/String;", "settingsPageName", "getSettingsPageName", "isBundled", "", "()Z", "classLoader", "Ljava/lang/ClassLoader;", "getClassLoader", "()Ljava/lang/ClassLoader;", "LanguageTool", "Hunspell", "intellij.grazie.core"})
@ApiStatus.Internal
public final class GraziePlugin {
    @NotNull
    public static final GraziePlugin INSTANCE = new GraziePlugin();
    @NotNull
    public static final String id = "tanvd.grazi";

    private GraziePlugin() {
    }

    private final IdeaPluginDescriptor getDescriptor() {
        IdeaPluginDescriptor ideaPluginDescriptor = PluginManagerCore.getPlugin((PluginId)PluginId.Companion.getId(id));
        Intrinsics.checkNotNull((Object)ideaPluginDescriptor);
        return ideaPluginDescriptor;
    }

    @NotNull
    public final String getGroup() {
        return GrazieBundle.message("grazie.group.name", new Object[0]);
    }

    @NotNull
    public final String getSettingsPageName() {
        return GrazieBundle.message("grazie.settings.page.name", new Object[0]);
    }

    public final boolean isBundled() {
        return this.getDescriptor().isBundled();
    }

    @NotNull
    public final ClassLoader getClassLoader() {
        ClassLoader classLoader = this.getDescriptor().getClassLoader();
        Intrinsics.checkNotNullExpressionValue((Object)classLoader, (String)"getClassLoader(...)");
        return classLoader;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/grazie/GraziePlugin$Hunspell;", "Lcom/intellij/grazie/ide/msg/GrazieStateLifecycle;", "<init>", "()V", "version", "", "url", "update", "", "prevState", "Lcom/intellij/grazie/GrazieConfig$State;", "newState", "intellij.grazie.core"})
    public static final class Hunspell
    implements GrazieStateLifecycle {
        @NotNull
        public static final Hunspell INSTANCE = new Hunspell();
        @NotNull
        public static final String version = "0.2.315";
        @NotNull
        public static final String url = "https://packages.jetbrains.team/maven/p/grazi/grazie-platform-public/ai/grazie/spell";

        private Hunspell() {
        }

        @Override
        public void update(@NotNull GrazieConfig.State prevState, @NotNull GrazieConfig.State newState) {
            Intrinsics.checkNotNullParameter((Object)prevState, (String)"prevState");
            Intrinsics.checkNotNullParameter((Object)newState, (String)"newState");
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                return;
            }
            BuildersKt.async$default((CoroutineScope)GrazieScope.Companion.coroutineScope(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(newState, prevState, null){
                int label;
                final /* synthetic */ GrazieConfig.State $newState;
                final /* synthetic */ GrazieConfig.State $prevState;
                {
                    this.$newState = $newState;
                    this.$prevState = $prevState;
                    super(2, $completion);
                }

                public final Object invokeSuspend(Object $result) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            Set newLanguages = GraziePluginKt.access$filterHunspell(this.$newState.getEnabledLanguages());
                            Set prevLanguages = GraziePluginKt.access$filterHunspell(this.$prevState.getEnabledLanguages());
                            Project[] projectArray = ProjectManager.getInstance().getOpenProjects();
                            Intrinsics.checkNotNullExpressionValue((Object)projectArray, (String)"getOpenProjects(...)");
                            Object[] $this$forEach$iv = projectArray;
                            boolean $i$f$forEach = false;
                            for (Object element$iv : $this$forEach$iv) {
                                Lang language;
                                Project project = (Project)element$iv;
                                boolean bl = false;
                                Intrinsics.checkNotNull((Object)project);
                                SpellCheckerManager manager = SpellCheckerManager.Companion.getInstance(project);
                                Iterable $this$forEach$iv2 = newLanguages;
                                boolean $i$f$forEach2 = false;
                                for (T element$iv2 : $this$forEach$iv2) {
                                    language = (Lang)((Object)element$iv2);
                                    boolean bl2 = false;
                                    SpellCheckerEngine spellCheckerEngine = manager.getSpellChecker();
                                    Intrinsics.checkNotNull((Object)spellCheckerEngine);
                                    HunspellDictionary hunspellDictionary = language.getDictionary();
                                    Intrinsics.checkNotNull((Object)hunspellDictionary);
                                    spellCheckerEngine.addDictionary((Dictionary)hunspellDictionary);
                                }
                                $this$forEach$iv2 = SetsKt.minus((Set)prevLanguages, (Iterable)newLanguages);
                                $i$f$forEach2 = false;
                                for (T element$iv2 : $this$forEach$iv2) {
                                    language = (Lang)((Object)element$iv2);
                                    boolean bl3 = false;
                                    Path path = GrazieDynamic.INSTANCE.getLangDynamicFolder(language);
                                    HunspellDescriptor hunspellDescriptor = language.getHunspellRemote();
                                    Intrinsics.checkNotNull((Object)hunspellDescriptor);
                                    String dicPath = ((Object)path.resolve(hunspellDescriptor.getFile())).toString();
                                    manager.removeDictionary(dicPath);
                                }
                                if (!project.isInitialized() || !project.isOpen()) continue;
                                DaemonCodeAnalyzer.getInstance((Project)project).restart((Object)"Hunspell.update");
                            }
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/grazie/GraziePlugin$LanguageTool;", "", "<init>", "()V", "version", "", "url", "intellij.grazie.core"})
    public static final class LanguageTool {
        @NotNull
        public static final LanguageTool INSTANCE = new LanguageTool();
        @NotNull
        public static final String version = "6.6.17";
        @NotNull
        public static final String url = "https://resources.jetbrains.com/grazie/model/language-tool";

        private LanguageTool() {
        }
    }
}

