/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grazie.ide.inspection.detection;

import ai.grazie.nlp.langs.Language;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.grazie.GrazieBundle;
import com.intellij.grazie.GrazieConfig;
import com.intellij.grazie.config.DetectionContext;
import com.intellij.grazie.detection.ExtensionsKt;
import com.intellij.grazie.detection.LangDetector;
import com.intellij.grazie.ide.inspection.detection.LanguageDetectionInspectionKt;
import com.intellij.grazie.ide.inspection.detection.problem.LanguageDetectionProblemDescriptor;
import com.intellij.grazie.ide.inspection.grammar.GrazieInspection;
import com.intellij.grazie.jlanguage.Lang;
import com.intellij.grazie.text.TextContent;
import com.intellij.grazie.text.TextExtractor;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.KeyWithDefaultValue;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J \u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\b\u0010\u0017\u001a\u00020\u0018H\u0016R!\u0010\u0004\u001a\u0015\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u0005\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/grazie/ide/inspection/detection/LanguageDetectionInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "<init>", "()V", "key", "Lcom/intellij/openapi/util/KeyWithDefaultValue;", "Lcom/intellij/grazie/config/DetectionContext$Local;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "inspectionStarted", "", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "isOnTheFly", "", "inspectionFinished", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "isAsciiWithoutSpaces", "text", "Lcom/intellij/grazie/text/TextContent;", "getDisplayName", "", "intellij.grazie.core"})
@SourceDebugExtension(value={"SMAP\nLanguageDetectionInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LanguageDetectionInspection.kt\ncom/intellij/grazie/ide/inspection/detection/LanguageDetectionInspection\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,92:1\n1563#2:93\n1634#2,3:94\n1088#3,2:97\n*S KotlinDebug\n*F\n+ 1 LanguageDetectionInspection.kt\ncom/intellij/grazie/ide/inspection/detection/LanguageDetectionInspection\n*L\n38#1:93\n38#1:94,3\n87#1:97,2\n*E\n"})
public final class LanguageDetectionInspection
extends LocalInspectionTool {
    @NotNull
    private final KeyWithDefaultValue<DetectionContext.Local> key;

    public LanguageDetectionInspection() {
        KeyWithDefaultValue keyWithDefaultValue = KeyWithDefaultValue.create((String)"language-detection-inspection-key", (Object)new DetectionContext.Local(null, 1, null));
        Intrinsics.checkNotNullExpressionValue((Object)keyWithDefaultValue, (String)"create(...)");
        this.key = keyWithDefaultValue;
    }

    public void inspectionStarted(@NotNull LocalInspectionToolSession session, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Object object = session.getUserData((Key)this.key);
        Intrinsics.checkNotNull((Object)object);
        ((DetectionContext.Local)object).clear();
    }

    /*
     * WARNING - void declaration
     */
    public void inspectionFinished(@NotNull LocalInspectionToolSession session, @NotNull ProblemsHolder holder) {
        Collection<Language> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        GrazieConfig.State state = GrazieConfig.Companion.get();
        Object object = session.getUserData((Key)this.key);
        Intrinsics.checkNotNull((Object)object);
        DetectionContext.Local context = (DetectionContext.Local)object;
        Iterable iterable = state.getAvailableLanguages();
        Set<Language> set = state.getDetectionContext().getDisabled();
        DetectionContext.Local local = context;
        boolean $i$f$map = false;
        void var8_9 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Lang lang = (Lang)((Object)item$iv$iv);
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(ExtensionsKt.toLanguage((Lang)it));
        }
        collection = (List)destination$iv$iv;
        Set<Language> languages2 = local.getToNotify(CollectionsKt.toSet((Iterable)SetsKt.plus(set, (Iterable)collection)));
        if (languages2.isEmpty()) {
            return;
        }
        ProblemDescriptor descriptor = (ProblemDescriptor)ActionsKt.runReadAction(() -> LanguageDetectionInspection.inspectionFinished$lambda$1(holder, session, languages2));
        if (descriptor != null) {
            holder.registerProblem(descriptor);
        }
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        PsiFile psiFile = holder.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getFile(...)");
        PsiFile file = psiFile;
        if (!isOnTheFly || InjectedLanguageManager.getInstance((Project)holder.getProject()).isInjectedFragment(file) || GrazieInspection.Companion.ignoreGrammarChecking(file) || InspectionProfileManager.hasTooLowSeverity((LocalInspectionToolSession)session, (LocalInspectionTool)this)) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            Intrinsics.checkNotNullExpressionValue((Object)psiElementVisitor, (String)"EMPTY_VISITOR");
            return psiElementVisitor;
        }
        Set<TextContent.TextDomain> domains = GrazieInspection.Companion.checkedDomains();
        Function1<PsiElement, Boolean> areChecksDisabled = GrazieInspection.Companion.getDisabledChecker(file);
        AtomicBoolean earlyBreak = new AtomicBoolean(false);
        return new PsiElementVisitor(earlyBreak, areChecksDisabled, domains, file, session, this){
            final /* synthetic */ AtomicBoolean $earlyBreak;
            final /* synthetic */ Function1<PsiElement, Boolean> $areChecksDisabled;
            final /* synthetic */ Set<TextContent.TextDomain> $domains;
            final /* synthetic */ PsiFile $file;
            final /* synthetic */ LocalInspectionToolSession $session;
            final /* synthetic */ LanguageDetectionInspection this$0;
            {
                this.$earlyBreak = $earlyBreak;
                this.$areChecksDisabled = $areChecksDisabled;
                this.$domains = $domains;
                this.$file = $file;
                this.$session = $session;
                this.this$0 = $receiver;
            }

            public void visitWhiteSpace(PsiWhiteSpace space) {
                Intrinsics.checkNotNullParameter((Object)space, (String)"space");
            }

            /*
             * WARNING - void declaration
             */
            public void visitElement(PsiElement element) {
                void $this$forEach$iv;
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                if (this.$earlyBreak.get() || ((Boolean)this.$areChecksDisabled.invoke((Object)element)).booleanValue()) {
                    return;
                }
                List<TextContent> list = TextExtractor.findUniqueTextsAt(element, this.$domains);
                Intrinsics.checkNotNullExpressionValue(list, (String)"findUniqueTextsAt(...)");
                List<TextContent> texts = list;
                if (texts.isEmpty() || GrazieInspection.Companion.skipCheckingTooLargeTexts(texts)) {
                    return;
                }
                if (GrazieInspection.Companion.skipCheckingTooLargeFiles(this.$file)) {
                    this.$earlyBreak.set(true);
                    return;
                }
                Object object = this.$session.getUserData((Key)LanguageDetectionInspection.access$getKey$p(this.this$0));
                Intrinsics.checkNotNull((Object)object);
                DetectionContext.Local context = (DetectionContext.Local)object;
                Iterable iterable = texts;
                LanguageDetectionInspection languageDetectionInspection = this.this$0;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    TextContent it = (TextContent)element$iv;
                    boolean bl = false;
                    ProgressManager.checkCanceled();
                    Intrinsics.checkNotNull((Object)it);
                    if (LanguageDetectionInspection.access$isAsciiWithoutSpaces(languageDetectionInspection, it)) continue;
                    LangDetector.INSTANCE.updateContext(it, context);
                }
            }
        };
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isAsciiWithoutSpaces(TextContent text) {
        if (!LanguageDetectionInspectionKt.access$getASCII_PATTERN$p().matches((CharSequence)text)) return false;
        CharSequence $this$any$iv = text;
        boolean $i$f$any = false;
        int n = 0;
        while (n < $this$any$iv.length()) {
            char element$iv;
            char it = element$iv = $this$any$iv.charAt(n);
            boolean bl = false;
            if (CharsKt.isWhitespace((char)it)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    @NotNull
    public String getDisplayName() {
        return GrazieBundle.message("grazie.detection.inspection.text", new Object[0]);
    }

    private static final ProblemDescriptor inspectionFinished$lambda$1(ProblemsHolder $holder, LocalInspectionToolSession $session, Set $languages) {
        InspectionManager inspectionManager = $holder.getManager();
        Intrinsics.checkNotNullExpressionValue((Object)inspectionManager, (String)"getManager(...)");
        boolean bl = $holder.isOnTheFly();
        PsiFile psiFile = $session.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getFile(...)");
        return LanguageDetectionProblemDescriptor.INSTANCE.create(inspectionManager, bl, psiFile, $languages);
    }

    public static final /* synthetic */ KeyWithDefaultValue access$getKey$p(LanguageDetectionInspection $this) {
        return $this.key;
    }

    public static final /* synthetic */ boolean access$isAsciiWithoutSpaces(LanguageDetectionInspection $this, TextContent text) {
        return $this.isAsciiWithoutSpaces(text);
    }
}

