/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grazie.utils;

import ai.grazie.gec.model.problem.ProblemHighlighting;
import ai.grazie.nlp.langs.Language;
import ai.grazie.rules.LTRuleInfo;
import ai.grazie.rules.Rule;
import ai.grazie.rules.RuleClient;
import ai.grazie.rules.settings.RuleSetting;
import ai.grazie.rules.settings.Setting;
import ai.grazie.rules.settings.SettingGroup;
import ai.grazie.rules.toolkit.LanguageToolkit;
import ai.grazie.text.TextRange;
import com.intellij.grazie.GrazieConfig;
import com.intellij.grazie.detection.LangDetector;
import com.intellij.grazie.ide.ui.configurable.StyleConfigurable;
import com.intellij.grazie.jlanguage.LangTool;
import com.intellij.grazie.rule.RuleIdeClient;
import com.intellij.grazie.text.TextChecker;
import com.intellij.grazie.text.TextContent;
import com.intellij.grazie.utils.HighlightingUtil;
import com.intellij.grazie.utils.TextStyleDomain;
import com.intellij.util.containers.CollectionFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000n\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\n\u001a\u0004\u0018\u00010\t2\u0006\u0010\u000b\u001a\u00020\u0006\u001a\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\r\u001a\u00020\u0002\u001a\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\r\u001a\u00020\u0002\u001a\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0012\u001a\u00020\u0006\u001a\u001f\u0010\u0013\u001a\u0004\u0018\u00010\u0014*\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017\u00a2\u0006\u0002\u0010\u0019\u001a\n\u0010\u001a\u001a\u00020\u001b*\u00020\u001c\u001a\u0014\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\t0\bH\u0002\u001a\u001a\u0010\"\u001a\u00020#*\u00020\t2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'\"9\u0010\u0000\u001a-\u0012\u000e\u0012\f0\u0002\u00a2\u0006\u0002\b\u0003\u00a2\u0006\u0002\b\u0004\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\b\u0003\u00a2\u0006\u0002\b\u00040\u0001\u00a2\u0006\u0002\b\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0017\u0010\u001d\u001a\u0004\u0018\u00010\u0014*\u00020\u001e8F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 \u00a8\u0006("}, d2={"affectedGlobalRules", "Ljava/util/concurrent/ConcurrentMap;", "Lai/grazie/nlp/langs/Language;", "Lorg/jetbrains/annotations/NotNull;", "Lkotlin/jvm/internal/EnhancedNullability;", "", "", "associatedGrazieRules", "", "Lai/grazie/rules/Rule;", "getAssociatedGrazieRule", "ruleId", "getAffectedGlobalRules", "language", "featuredSettings", "", "Lai/grazie/rules/settings/Setting;", "getLanguageIfAvailable", "text", "coveringIde", "Lcom/intellij/openapi/util/TextRange;", "Lai/grazie/text/TextRange$Companion;", "ranges", "", "Lai/grazie/text/TextRange;", "(Lai/grazie/text/TextRange$Companion;[Lai/grazie/text/TextRange;)Lcom/intellij/openapi/util/TextRange;", "toProofreadingContext", "Lcom/intellij/grazie/text/TextChecker$ProofreadingContext;", "Lcom/intellij/grazie/text/TextContent;", "underline", "Lai/grazie/gec/model/problem/ProblemHighlighting;", "getUnderline", "(Lai/grazie/gec/model/problem/ProblemHighlighting;)Lcom/intellij/openapi/util/TextRange;", "buildAssociatedGrazieMapping", "isEnabledInState", "", "state", "Lcom/intellij/grazie/GrazieConfig$State;", "domain", "Lcom/intellij/grazie/utils/TextStyleDomain;", "intellij.grazie.core"})
@SourceDebugExtension(value={"SMAP\nGrazieUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GrazieUtils.kt\ncom/intellij/grazie/utils/GrazieUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,94:1\n1374#2:95\n1460#2,5:96\n1374#2:101\n1460#2,5:102\n1869#2:108\n808#2,11:109\n1563#2:120\n1634#2,3:121\n1869#2:124\n1869#2,2:125\n1870#2:127\n1870#2:128\n808#2,11:129\n1563#2:140\n1634#2,3:141\n1#3:107\n*S KotlinDebug\n*F\n+ 1 GrazieUtils.kt\ncom/intellij/grazie/utils/GrazieUtilsKt\n*L\n40#1:95\n40#1:96,5\n41#1:101\n41#1:102,5\n73#1:108\n76#1:109,11\n77#1:120\n77#1:121,3\n78#1:124\n79#1:125,2\n78#1:127\n73#1:128\n32#1:129,11\n33#1:140\n33#1:141,3\n*E\n"})
public final class GrazieUtilsKt {
    @NotNull
    private static final ConcurrentMap<Language, Set<String>> affectedGlobalRules;
    @NotNull
    private static final Map<String, Rule> associatedGrazieRules;

    @Nullable
    public static final Rule getAssociatedGrazieRule(@NotNull String ruleId) {
        Intrinsics.checkNotNullParameter((Object)ruleId, (String)"ruleId");
        return associatedGrazieRules.get(ruleId);
    }

    @NotNull
    public static final Set<String> getAffectedGlobalRules(@NotNull Language language) {
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        if (!StyleConfigurable.Companion.getRuleEngineLanguages().contains(language)) {
            return SetsKt.emptySet();
        }
        Set set = affectedGlobalRules.computeIfAbsent(language, arg_0 -> GrazieUtilsKt.getAffectedGlobalRules$lambda$1(arg_0 -> GrazieUtilsKt.getAffectedGlobalRules$lambda$0(language, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"computeIfAbsent(...)");
        return set;
    }

    @NotNull
    public static final List<Setting> featuredSettings(@NotNull Language language) {
        Iterable list$iv$iv;
        Iterable $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        List list = LanguageToolkit.forLanguage((Language)language).getSettings((RuleClient)RuleIdeClient.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getSettings(...)");
        Iterable $this$flatMap$iv = list;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            SettingGroup it = (SettingGroup)element$iv$iv;
            boolean bl = false;
            List list2 = it.settings();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"settings(...)");
            list$iv$iv = list2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv = (List)destination$iv$iv;
        $i$f$flatMap = false;
        $this$flatMapTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            List list3;
            Setting setting = (Setting)element$iv$iv;
            boolean bl = false;
            if (setting instanceof RuleSetting) {
                Collection collection = CollectionsKt.listOf((Object)setting);
                List list4 = ((RuleSetting)setting).getSubSettings();
                Intrinsics.checkNotNullExpressionValue((Object)list4, (String)"getSubSettings(...)");
                list3 = CollectionsKt.plus((Collection)collection, (Iterable)list4);
            } else {
                list3 = CollectionsKt.listOf((Object)setting);
            }
            list$iv$iv = list3;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public static final Language getLanguageIfAvailable(@NotNull String text) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Language language = LangDetector.INSTANCE.getLanguage(text);
        if (language != null) {
            Language language2;
            Language it = language2 = language;
            boolean bl = false;
            object = HighlightingUtil.findInstalledLang(it) != null ? language2 : null;
        } else {
            object = null;
        }
        return object;
    }

    @Nullable
    public static final com.intellij.openapi.util.TextRange coveringIde(@NotNull TextRange.Companion $this$coveringIde, @NotNull TextRange[] ranges) {
        int n;
        Intrinsics.checkNotNullParameter((Object)$this$coveringIde, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)ranges, (String)"ranges");
        if (ranges.length == 0) {
            return null;
        }
        Object[] objectArray = ranges;
        if (objectArray.length == 0) {
            throw new NoSuchElementException();
        }
        TextRange it22 = objectArray[0];
        int n2 = 0;
        int it22 = it22.getStart();
        n2 = 1;
        int n3 = ArraysKt.getLastIndex((Object[])objectArray);
        if (n2 <= n3) {
            while (true) {
                Object it32 = objectArray[n2];
                boolean bl = false;
                int it32 = it32.getStart();
                if (it22 > it32) {
                    it22 = it32;
                }
                if (n2 == n3) break;
                ++n2;
            }
        }
        objectArray = ranges;
        int n4 = it22;
        if (objectArray.length == 0) {
            throw new NoSuchElementException();
        }
        Object it = objectArray[0];
        boolean bl = false;
        int n5 = it.getEndExclusive();
        int n6 = 1;
        n3 = ArraysKt.getLastIndex((Object[])objectArray);
        if (n6 <= n3) {
            while (true) {
                Object it3 = objectArray[n6];
                $i$a$-maxOf-GrazieUtilsKt$coveringIde$2 = false;
                int n7 = it3.getEndExclusive();
                if (n5 < n7) {
                    n5 = n7;
                }
                if (n6 == n3) break;
                ++n6;
            }
        }
        int n8 = n = n5;
        int n9 = n4;
        return new com.intellij.openapi.util.TextRange(n9, n8);
    }

    @NotNull
    public static final TextChecker.ProofreadingContext toProofreadingContext(@NotNull TextContent $this$toProofreadingContext) {
        Intrinsics.checkNotNullParameter((Object)$this$toProofreadingContext, (String)"<this>");
        TextContent content = $this$toProofreadingContext;
        int stripPrefixLength = HighlightingUtil.stripPrefix(content);
        String string = ((Object)content).toString().substring(stripPrefixLength);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        Language language = LangDetector.INSTANCE.getLanguage(string);
        if (language == null) {
            language = Language.UNKNOWN;
        }
        Language language2 = language;
        return new TextChecker.ProofreadingContext(content, language2, stripPrefixLength){
            final /* synthetic */ TextContent $content;
            final /* synthetic */ Language $language;
            final /* synthetic */ int $stripPrefixLength;
            {
                this.$content = $content;
                this.$language = $language;
                this.$stripPrefixLength = $stripPrefixLength;
            }

            public TextContent getText() {
                return this.$content;
            }

            public Language getLanguage() {
                return this.$language;
            }

            public String getStripPrefix() {
                String string = ((Object)this.$content).toString().substring(0, this.$stripPrefixLength);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                return string;
            }
        };
    }

    @Nullable
    public static final com.intellij.openapi.util.TextRange getUnderline(@NotNull ProblemHighlighting $this$underline) {
        Intrinsics.checkNotNullParameter((Object)$this$underline, (String)"<this>");
        return GrazieUtilsKt.coveringIde(TextRange.Companion, $this$underline.getAlways());
    }

    /*
     * WARNING - void declaration
     */
    private static final Map<String, Rule> buildAssociatedGrazieMapping() {
        HashMap associatedGrazieRules = new HashMap();
        Iterable $this$forEach$iv = StyleConfigurable.Companion.getRuleEngineLanguages();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$forEach$iv2;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            void $this$filterIsInstanceTo$iv$iv;
            Iterable $this$filterIsInstance$iv;
            Language language = (Language)element$iv;
            boolean bl = false;
            String ltPrefix = LangTool.INSTANCE.globalIdPrefix$intellij_grazie_core(language);
            Iterable iterable = GrazieUtilsKt.featuredSettings(language);
            boolean $i$f$filterIsInstance = false;
            Iterator iterator = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof RuleSetting)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filterIsInstance$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterIsInstanceTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                RuleSetting ruleSetting = (RuleSetting)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(it.rule);
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Rule grazieRule = (Rule)element$iv2;
                boolean bl3 = false;
                List list = grazieRule.getAssociatedLTRules();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAssociatedLTRules(...)");
                Iterable $this$forEach$iv3 = list;
                boolean $i$f$forEach3 = false;
                for (Object element$iv3 : $this$forEach$iv3) {
                    LTRuleInfo associatedLTRule = (LTRuleInfo)element$iv3;
                    boolean bl4 = false;
                    ((Map)associatedGrazieRules).put(ltPrefix + associatedLTRule.id(), grazieRule);
                }
            }
        }
        return associatedGrazieRules;
    }

    public static final boolean isEnabledInState(@NotNull Rule $this$isEnabledInState, @NotNull GrazieConfig.State state, @NotNull TextStyleDomain domain) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$isEnabledInState, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)((Object)domain), (String)"domain");
        if ($this$isEnabledInState.isRuleEnabledByDefault(state.getTextStyle(domain), (RuleClient)RuleIdeClient.INSTANCE)) {
            String string = $this$isEnabledInState.globalId();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"globalId(...)");
            bl = !state.isRuleDisabled(string, domain);
        } else {
            String string = $this$isEnabledInState.globalId();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"globalId(...)");
            bl = state.isRuleEnabled(string, domain);
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private static final Set getAffectedGlobalRules$lambda$0(Language $language, Language it) {
        void $this$mapTo$iv$iv;
        Iterable $this$filterIsInstanceTo$iv$iv;
        String string = Rule.globalIdPrefix((Language)$language);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"globalIdPrefix(...)");
        String prefix = string;
        Iterable $this$filterIsInstance$iv = GrazieUtilsKt.featuredSettings($language);
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof RuleSetting)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterIsInstanceTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it2;
            RuleSetting ruleSetting = (RuleSetting)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(prefix + it2.rule.id);
        }
        return CollectionsKt.toHashSet((Iterable)((List)destination$iv$iv));
    }

    private static final Set getAffectedGlobalRules$lambda$1(Function1 $tmp0, Object p0) {
        return (Set)$tmp0.invoke(p0);
    }

    static {
        ConcurrentMap concurrentMap = CollectionFactory.createConcurrentSoftValueMap();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"createConcurrentSoftValueMap(...)");
        affectedGlobalRules = concurrentMap;
        associatedGrazieRules = GrazieUtilsKt.buildAssociatedGrazieMapping();
    }
}

