/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.dap;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.util.ProgramParametersConfigurator;
import com.intellij.execution.util.ProgramParametersUtil;
import com.intellij.execution.util.ScriptFileUtil;
import com.intellij.execution.wsl.WslPath;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.platform.dap.DapLaunchArgumentsProvider;
import com.intellij.platform.dap.DapStartRequest;
import com.intellij.platform.dap.DebugAdapterId;
import com.intellij.platform.dap.LaunchRequestArguments;
import com.intellij.python.dap.PythonDapAdapter;
import com.intellij.python.dap.PythonDapBundle;
import com.intellij.python.dap.attach.PythonDapAttachConfiguration;
import com.intellij.python.dap.run.PythonDapRunConfiguration;
import com.intellij.util.PathUtil;
import com.intellij.util.system.OS;
import com.jetbrains.python.sdk.PythonSdkUtil;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J$\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u000fH\u0002J\u0014\u0010\u0011\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0012\u001a\u0004\u0018\u00010\u000fH\u0002J#\u0010\u0013\u001a\u00020\u00052\b\u0010\u0012\u001a\u0004\u0018\u00010\u000fH\u0002\u0082\u0002\u000e\n\f\b\u0000\u0012\u0002\u0018\u0000\u001a\u0004\b\u0003\u0010\u0001\u00a8\u0006\u0014"}, d2={"Lcom/intellij/python/dap/PythonDapLaunchArgumentsProvider;", "Lcom/intellij/platform/dap/DapLaunchArgumentsProvider;", "<init>", "()V", "isApplicable", "", "profile", "Lcom/intellij/execution/configurations/RunProfile;", "getLaunchArguments", "Lcom/intellij/platform/dap/LaunchRequestArguments;", "project", "Lcom/intellij/openapi/project/Project;", "getProgramPath", "Ljava/nio/file/Path;", "programPath", "", "workingDirectory", "convertFromWslPathIfNeeded", "path", "isRunningOnWsl", "intellij.python.dap"})
@SourceDebugExtension(value={"SMAP\nPythonDapLaunchArgumentsProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PythonDapLaunchArgumentsProvider.kt\ncom/intellij/python/dap/PythonDapLaunchArgumentsProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,105:1\n1#2:106\n*E\n"})
public final class PythonDapLaunchArgumentsProvider
implements DapLaunchArgumentsProvider {
    public boolean isApplicable(@NotNull RunProfile profile) {
        Intrinsics.checkNotNullParameter((Object)profile, (String)"profile");
        return profile instanceof PythonDapRunConfiguration || profile instanceof PythonDapAttachConfiguration;
    }

    @NotNull
    public LaunchRequestArguments getLaunchArguments(@NotNull Project project, @NotNull RunProfile profile) {
        LaunchRequestArguments launchRequestArguments;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)profile, (String)"profile");
        RunProfile runProfile = profile;
        if (runProfile instanceof PythonDapRunConfiguration) {
            Map map;
            Sdk sdk = ((PythonDapRunConfiguration)profile).getSdk();
            String string = PathUtil.toSystemDependentName((String)(sdk != null ? sdk.getHomePath() : null));
            if (string == null) {
                throw new ExecutionException(PythonDapBundle.message("pythonDap.run.dialog.noSdk.error", new Object[0]));
            }
            String pythonPath = string;
            if (PythonSdkUtil.isRemote((Sdk)((PythonDapRunConfiguration)profile).getSdk())) {
                throw new ExecutionException(PythonDapBundle.message("pythonDap.run.configuration.remoteSdk.notSupported.error", new Object[0]));
            }
            String programPath = ((Object)this.getProgramPath(project, ((PythonDapRunConfiguration)profile).getProgramPath(), ((PythonDapRunConfiguration)profile).getOptions().getWorkingDirectory())).toString();
            if (this.isRunningOnWsl(programPath)) {
                throw new ExecutionException(PythonDapBundle.message("pythonDap.run.configuration.error.wsl", new Object[0]));
            }
            String transport = OS.CURRENT != OS.Windows || WslPath.Companion.isWslUncPath(programPath) ? "native" : "tcp";
            String targetWorkingDirectory = this.convertFromWslPathIfNeeded(((PythonDapRunConfiguration)profile).getOptions().getWorkingDirectory());
            String targetProgramPath = this.convertFromWslPathIfNeeded(programPath);
            Map $this$getLaunchArguments_u24lambda_u240 = map = MapsKt.createMapBuilder();
            boolean bl = false;
            $this$getLaunchArguments_u24lambda_u240.put("python", pythonPath);
            $this$getLaunchArguments_u24lambda_u240.put("program", targetProgramPath);
            String string2 = ((PythonDapRunConfiguration)profile).getOptions().getScriptParameters();
            if (string2 != null) {
                String string3;
                String it = string3 = string2;
                boolean bl2 = false;
                string2 = !StringsKt.isBlank((CharSequence)it) ? string3 : null;
                if (string2 != null) {
                    it = string2;
                    boolean bl3 = false;
                    List list = ProgramParametersConfigurator.expandMacrosAndParseParameters((String)it);
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"expandMacrosAndParseParameters(...)");
                    List expandedArgs = list;
                    $this$getLaunchArguments_u24lambda_u240.put("args", expandedArgs);
                }
            }
            $this$getLaunchArguments_u24lambda_u240.put("cwd", targetWorkingDirectory);
            $this$getLaunchArguments_u24lambda_u240.put("stopOnEntry", ((PythonDapRunConfiguration)profile).getOptions().getStopOnEntry());
            $this$getLaunchArguments_u24lambda_u240.put("transport", transport);
            Map map2 = ((PythonDapRunConfiguration)profile).getOptions().getEnvVariables().getEnvs();
            Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"getEnvs(...)");
            if (!map2.isEmpty()) {
                $this$getLaunchArguments_u24lambda_u240.put("env", ((PythonDapRunConfiguration)profile).getOptions().getEnvVariables().getEnvs());
            }
            Map args = MapsKt.build((Map)map);
            launchRequestArguments = new LaunchRequestArguments((DebugAdapterId)PythonDapAdapter.INSTANCE, DapStartRequest.Launch, args);
        } else if (runProfile instanceof PythonDapAttachConfiguration) {
            Map map;
            Map $this$getLaunchArguments_u24lambda_u241 = map = MapsKt.createMapBuilder();
            boolean bl = false;
            $this$getLaunchArguments_u24lambda_u241.put("remoteAddress", ((PythonDapAttachConfiguration)profile).getRemoteAddress());
            $this$getLaunchArguments_u24lambda_u241.put("remoteRoot", ((PythonDapAttachConfiguration)profile).getRemoteRoot());
            Object[] objectArray = new Pair[]{TuplesKt.to((Object)"localRoot", (Object)project.getBasePath()), TuplesKt.to((Object)"remoteRoot", (Object)((PythonDapAttachConfiguration)profile).getRemoteRoot())};
            Map pathMapping = MapsKt.mapOf((Pair[])objectArray);
            objectArray = new Map[]{pathMapping};
            $this$getLaunchArguments_u24lambda_u241.put("pathMappings", objectArray);
            Map args = MapsKt.build((Map)map);
            launchRequestArguments = new LaunchRequestArguments((DebugAdapterId)PythonDapAdapter.INSTANCE, DapStartRequest.Attach, args);
        } else {
            throw new IllegalArgumentException("Unsupported Run Configuration: " + profile);
        }
        return launchRequestArguments;
    }

    private final Path getProgramPath(Project project, String programPath, String workingDirectory) {
        Path path;
        String expandedPath = ProgramParametersUtil.expandPathAndMacros((String)programPath, null, (Project)project);
        String string = ScriptFileUtil.getLocalFilePath((String)expandedPath);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLocalFilePath(...)");
        String appFilePath = string;
        Path path2 = Paths.get(appFilePath, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(...)");
        Path file = path2;
        if (!file.isAbsolute() && workingDirectory != null) {
            String string2 = workingDirectory;
            String[] stringArray = new String[]{appFilePath};
            Path path3 = Paths.get(string2, Arrays.copyOf(stringArray, stringArray.length));
            path = path3;
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"get(...)");
        } else {
            path = file;
        }
        return path;
    }

    private final String convertFromWslPathIfNeeded(String path) {
        String string;
        if (this.isRunningOnWsl(path)) {
            WslPath wslPath = WslPath.Companion.parseWindowsUncPath(path);
            string = wslPath != null ? wslPath.getLinuxPath() : null;
        } else {
            string = path;
        }
        return string;
    }

    private final boolean isRunningOnWsl(String path) {
        return path != null && WslPath.Companion.isWslUncPath(path);
    }
}

