/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.dap.run;

import com.intellij.execution.Executor;
import com.intellij.execution.configuration.EmptyRunProfileState;
import com.intellij.execution.configuration.EnvironmentVariablesData;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.LocatableConfigurationBase;
import com.intellij.execution.configurations.LocatableRunConfigurationOptions;
import com.intellij.execution.configurations.RefactoringListenerProvider;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.python.dap.PythonDapBundle;
import com.intellij.python.dap.run.PythonDapRunOptions;
import com.intellij.python.dap.run.editor.PythonDapRunConfigurationEditor;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.util.PathUtil;
import com.jetbrains.python.sdk.PySdkExtKt;
import com.jetbrains.python.sdk.PythonSdkUtil;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u000e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00020\u0011H\u0014J\b\u0010.\u001a\u00020\u0016H\u0016J\u000e\u0010/\u001a\b\u0012\u0004\u0012\u00020\u000000H\u0016J\b\u00101\u001a\u000202H\u0016J\u0014\u00103\u001a\u0004\u0018\u0001042\b\u00105\u001a\u0004\u0018\u000106H\u0016J\u0010\u00107\u001a\u0004\u0018\u00010\u0016*\u0004\u0018\u00010\u0016H\u0002R\u0011\u0010\u0012\u001a\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R(\u0010\u0017\u001a\u0004\u0018\u00010\u00162\b\u0010\u0015\u001a\u0004\u0018\u00010\u00168F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR(\u0010\u001d\u001a\u0004\u0018\u00010\u001c2\b\u0010\u0015\u001a\u0004\u0018\u00010\u001c8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R(\u0010\"\u001a\u0004\u0018\u00010\u00162\b\u0010\u0015\u001a\u0004\u0018\u00010\u00168F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b#\u0010\u0019\"\u0004\b$\u0010\u001bR(\u0010%\u001a\u0004\u0018\u00010\u00162\b\u0010\u0015\u001a\u0004\u0018\u00010\u00168F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b&\u0010\u0019\"\u0004\b'\u0010\u001bR$\u0010)\u001a\u00020(2\u0006\u0010\u0015\u001a\u00020(8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b*\u0010+\"\u0004\b,\u0010-\u00a8\u00068"}, d2={"Lcom/intellij/python/dap/run/PythonDapRunConfiguration;", "Lcom/intellij/execution/configurations/LocatableConfigurationBase;", "Lcom/intellij/python/dap/run/PythonDapRunOptions;", "Lcom/intellij/execution/configurations/RefactoringListenerProvider;", "project", "Lcom/intellij/openapi/project/Project;", "configurationFactory", "Lcom/intellij/execution/configurations/ConfigurationFactory;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/execution/configurations/ConfigurationFactory;)V", "getState", "Lcom/intellij/execution/configurations/RunProfileState;", "executor", "Lcom/intellij/execution/Executor;", "environment", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "getOptionsClass", "Ljava/lang/Class;", "options", "getOptions", "()Lcom/intellij/python/dap/run/PythonDapRunOptions;", "value", "", "programPath", "getProgramPath", "()Ljava/lang/String;", "setProgramPath", "(Ljava/lang/String;)V", "Lcom/intellij/openapi/projectRoots/Sdk;", "sdk", "getSdk", "()Lcom/intellij/openapi/projectRoots/Sdk;", "setSdk", "(Lcom/intellij/openapi/projectRoots/Sdk;)V", "scriptParameters", "getScriptParameters", "setScriptParameters", "workingDirectory", "getWorkingDirectory", "setWorkingDirectory", "Lcom/intellij/execution/configuration/EnvironmentVariablesData;", "envVariables", "getEnvVariables", "()Lcom/intellij/execution/configuration/EnvironmentVariablesData;", "setEnvVariables", "(Lcom/intellij/execution/configuration/EnvironmentVariablesData;)V", "suggestedName", "getConfigurationEditor", "Lcom/intellij/openapi/options/SettingsEditor;", "checkConfiguration", "", "getRefactoringElementListener", "Lcom/intellij/refactoring/listeners/RefactoringElementListener;", "element", "Lcom/intellij/psi/PsiElement;", "toSystemDependentNameAndTrim", "intellij.python.dap"})
@SourceDebugExtension(value={"SMAP\nPythonDapRunConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PythonDapRunConfiguration.kt\ncom/intellij/python/dap/run/PythonDapRunConfiguration\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,95:1\n1#2:96\n*E\n"})
public final class PythonDapRunConfiguration
extends LocatableConfigurationBase<PythonDapRunOptions>
implements RefactoringListenerProvider {
    public PythonDapRunConfiguration(@NotNull Project project, @NotNull ConfigurationFactory configurationFactory) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)configurationFactory, (String)"configurationFactory");
        super(project, configurationFactory);
    }

    @NotNull
    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment environment) {
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        RunProfileState runProfileState = EmptyRunProfileState.INSTANCE;
        Intrinsics.checkNotNullExpressionValue((Object)runProfileState, (String)"INSTANCE");
        return runProfileState;
    }

    @NotNull
    protected Class<PythonDapRunOptions> getOptionsClass() {
        return PythonDapRunOptions.class;
    }

    @NotNull
    public final PythonDapRunOptions getOptions() {
        LocatableRunConfigurationOptions locatableRunConfigurationOptions = super.getOptions();
        Intrinsics.checkNotNull((Object)locatableRunConfigurationOptions, (String)"null cannot be cast to non-null type com.intellij.python.dap.run.PythonDapRunOptions");
        return (PythonDapRunOptions)locatableRunConfigurationOptions;
    }

    @Nullable
    public final String getProgramPath() {
        return this.toSystemDependentNameAndTrim(this.getOptions().getProgram());
    }

    public final void setProgramPath(@Nullable String value) {
        this.getOptions().setProgram(PathUtil.toSystemIndependentName((String)StringUtil.nullize((String)value)));
    }

    @Nullable
    public final Sdk getSdk() {
        if (this.getOptions().getSdk() == null) {
            Project project = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            return PySdkExtKt.getPythonSdk((Project)project);
        }
        return this.getOptions().getSdk();
    }

    public final void setSdk(@Nullable Sdk value) {
        this.getOptions().setSdk(value);
    }

    @Nullable
    public final String getScriptParameters() {
        return this.getOptions().getScriptParameters();
    }

    public final void setScriptParameters(@Nullable String value) {
        this.getOptions().setScriptParameters(StringUtil.nullize((String)value));
    }

    @Nullable
    public final String getWorkingDirectory() {
        return this.toSystemDependentNameAndTrim(this.getOptions().getWorkingDirectory());
    }

    public final void setWorkingDirectory(@Nullable String value) {
        this.getOptions().setWorkingDirectory(PathUtil.toSystemIndependentName((String)StringUtil.nullize((String)value)));
    }

    @NotNull
    public final EnvironmentVariablesData getEnvVariables() {
        return this.getOptions().getEnvVariables();
    }

    public final void setEnvVariables(@NotNull EnvironmentVariablesData value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.getOptions().setEnvVariables(value);
    }

    @NotNull
    public String suggestedName() {
        String string;
        block3: {
            block2: {
                string = this.getOptions().getProgram();
                if (string == null) break block2;
                String it = string;
                boolean bl = false;
                String string2 = PathUtil.getFileName((String)it);
                string = string2;
                if (string2 != null) break block3;
            }
            string = "";
        }
        return string;
    }

    @NotNull
    public SettingsEditor<PythonDapRunConfiguration> getConfigurationEditor() {
        return new PythonDapRunConfigurationEditor(this);
    }

    public void checkConfiguration() throws RuntimeConfigurationException {
        block8: {
            Path workingDir;
            block7: {
                String string = this.getWorkingDirectory();
                if (string != null) {
                    String it = string;
                    boolean bl = false;
                    v1 = Paths.get(it, new String[0]);
                } else {
                    v1 = workingDir = null;
                }
                if (workingDir == null || !workingDir.isAbsolute()) break block7;
                LinkOption[] linkOptionArray = new LinkOption[]{};
                if (Files.isDirectory(workingDir, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) break block8;
            }
            Object[] objectArray = new Object[]{workingDir};
            throw new RuntimeConfigurationError(PythonDapBundle.message("pythonDap.run.configuration.incorrect.workingDirectory.text", objectArray));
        }
        CharSequence charSequence = this.getProgramPath();
        if (charSequence == null || charSequence.length() == 0) {
            throw new RuntimeConfigurationError(PythonDapBundle.message("pythonDap.run.configuration.error.incorrect.file.path.text", new Object[0]));
        }
        if (PythonSdkUtil.isRemote((Sdk)this.getSdk())) {
            throw new RuntimeConfigurationError(PythonDapBundle.message("pythonDap.run.configuration.remoteSdk.notSupported.error", new Object[0]));
        }
    }

    @Nullable
    public RefactoringElementListener getRefactoringElementListener(@Nullable PsiElement element) {
        return null;
    }

    private final String toSystemDependentNameAndTrim(String $this$toSystemDependentNameAndTrim) {
        String string = PathUtil.toSystemDependentName((String)$this$toSystemDependentNameAndTrim);
        if (string == null) {
            string = "";
        }
        return StringUtil.nullize((String)((Object)StringsKt.trim((CharSequence)string)).toString());
    }
}

