/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.dap.run.editor;

import com.intellij.execution.configuration.EnvironmentVariablesData;
import com.intellij.execution.ui.CommonProgramParametersPanel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.python.dap.PythonDapBundle;
import com.intellij.python.dap.run.PythonDapRunConfiguration;
import com.intellij.python.dap.run.editor.PythonDapInterpreterOptionsPanel;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.ui.components.fields.ExtendableTextField;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.util.PathUtil;
import com.jetbrains.python.sdk.PySdkExtKt;
import com.jetbrains.python.sdk.PySdkListCellRenderer;
import com.jetbrains.python.sdk.PythonSdkUtil;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.ListCellRenderer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010(\u001a\u00020)H\u0014J\u0010\u0010*\u001a\u00020+2\u0006\u0010\u0003\u001a\u00020\u0002H\u0014J\u0010\u0010,\u001a\u00020+2\u0006\u0010\u0003\u001a\u00020\u0002H\u0014J\u0012\u0010-\u001a\u00020+2\b\u0010.\u001a\u0004\u0018\u00010/H\u0002J\u0012\u00100\u001a\u00020+2\b\u0010.\u001a\u0004\u0018\u00010/H\u0002J\n\u00101\u001a\u0004\u0018\u00010/H\u0002J\u0010\u00102\u001a\u00020\u00142\u0006\u00103\u001a\u000204H\u0002J\u0010\u00105\u001a\u00020\u00142\u0006\u00103\u001a\u000204H\u0002R\u000e\u0010\u0003\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\u000eX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\u0014X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\u00020\u0014X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u0016\"\u0004\b\u001b\u0010\u0018R\u001a\u0010\u001c\u001a\u00020\u001dX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R(\u0010#\u001a\u0004\u0018\u00010\b2\b\u0010\"\u001a\u0004\u0018\u00010\b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'\u00a8\u00066"}, d2={"Lcom/intellij/python/dap/run/editor/PythonDapRunConfigurationEditor;", "Lcom/intellij/openapi/options/SettingsEditor;", "Lcom/intellij/python/dap/run/PythonDapRunConfiguration;", "configuration", "<init>", "(Lcom/intellij/python/dap/run/PythonDapRunConfiguration;)V", "myPythonSdks", "", "Lcom/intellij/openapi/projectRoots/Sdk;", "getMyPythonSdks", "()Ljava/util/List;", "setMyPythonSdks", "(Ljava/util/List;)V", "scriptParameters", "Lcom/intellij/ui/RawCommandLineEditor;", "getScriptParameters", "()Lcom/intellij/ui/RawCommandLineEditor;", "setScriptParameters", "(Lcom/intellij/ui/RawCommandLineEditor;)V", "scriptPath", "Lcom/intellij/openapi/ui/TextFieldWithBrowseButton;", "getScriptPath", "()Lcom/intellij/openapi/ui/TextFieldWithBrowseButton;", "setScriptPath", "(Lcom/intellij/openapi/ui/TextFieldWithBrowseButton;)V", "workingDirectory", "getWorkingDirectory", "setWorkingDirectory", "interpreterOptionsForm", "Lcom/intellij/python/dap/run/editor/PythonDapInterpreterOptionsPanel;", "getInterpreterOptionsForm", "()Lcom/intellij/python/dap/run/editor/PythonDapInterpreterOptionsPanel;", "setInterpreterOptionsForm", "(Lcom/intellij/python/dap/run/editor/PythonDapInterpreterOptionsPanel;)V", "value", "selectedSdk", "getSelectedSdk", "()Lcom/intellij/openapi/projectRoots/Sdk;", "setSelectedSdk", "(Lcom/intellij/openapi/projectRoots/Sdk;)V", "createEditor", "Ljavax/swing/JComponent;", "resetEditorFrom", "", "applyEditorTo", "updateDefaultInterpreter", "module", "Lcom/intellij/openapi/module/Module;", "setModule", "getModule", "createWorkingDirectory", "project", "Lcom/intellij/openapi/project/Project;", "createPathToFile", "intellij.python.dap"})
public final class PythonDapRunConfigurationEditor
extends SettingsEditor<PythonDapRunConfiguration> {
    @NotNull
    private final PythonDapRunConfiguration configuration;
    @NotNull
    private List<Sdk> myPythonSdks;
    public RawCommandLineEditor scriptParameters;
    public TextFieldWithBrowseButton scriptPath;
    public TextFieldWithBrowseButton workingDirectory;
    @NotNull
    private PythonDapInterpreterOptionsPanel interpreterOptionsForm;

    public PythonDapRunConfigurationEditor(@NotNull PythonDapRunConfiguration configuration) {
        Intrinsics.checkNotNullParameter((Object)((Object)configuration), (String)"configuration");
        this.configuration = configuration;
        this.myPythonSdks = new ArrayList(PythonSdkUtil.getAllSdks());
        this.myPythonSdks.add(0, null);
        this.interpreterOptionsForm = new PythonDapInterpreterOptionsPanel(CollectionsKt.toList((Iterable)this.myPythonSdks));
        Project project = this.configuration.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Module[] modules = ModuleManager.Companion.getInstance(project).getModules();
        this.setModule(modules[0]);
    }

    @NotNull
    public final List<Sdk> getMyPythonSdks() {
        return this.myPythonSdks;
    }

    public final void setMyPythonSdks(@NotNull List<Sdk> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.myPythonSdks = list;
    }

    @NotNull
    public final RawCommandLineEditor getScriptParameters() {
        RawCommandLineEditor rawCommandLineEditor = this.scriptParameters;
        if (rawCommandLineEditor != null) {
            return rawCommandLineEditor;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"scriptParameters");
        return null;
    }

    public final void setScriptParameters(@NotNull RawCommandLineEditor rawCommandLineEditor) {
        Intrinsics.checkNotNullParameter((Object)rawCommandLineEditor, (String)"<set-?>");
        this.scriptParameters = rawCommandLineEditor;
    }

    @NotNull
    public final TextFieldWithBrowseButton getScriptPath() {
        TextFieldWithBrowseButton textFieldWithBrowseButton = this.scriptPath;
        if (textFieldWithBrowseButton != null) {
            return textFieldWithBrowseButton;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"scriptPath");
        return null;
    }

    public final void setScriptPath(@NotNull TextFieldWithBrowseButton textFieldWithBrowseButton) {
        Intrinsics.checkNotNullParameter((Object)textFieldWithBrowseButton, (String)"<set-?>");
        this.scriptPath = textFieldWithBrowseButton;
    }

    @NotNull
    public final TextFieldWithBrowseButton getWorkingDirectory() {
        TextFieldWithBrowseButton textFieldWithBrowseButton = this.workingDirectory;
        if (textFieldWithBrowseButton != null) {
            return textFieldWithBrowseButton;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"workingDirectory");
        return null;
    }

    public final void setWorkingDirectory(@NotNull TextFieldWithBrowseButton textFieldWithBrowseButton) {
        Intrinsics.checkNotNullParameter((Object)textFieldWithBrowseButton, (String)"<set-?>");
        this.workingDirectory = textFieldWithBrowseButton;
    }

    @NotNull
    public final PythonDapInterpreterOptionsPanel getInterpreterOptionsForm() {
        return this.interpreterOptionsForm;
    }

    public final void setInterpreterOptionsForm(@NotNull PythonDapInterpreterOptionsPanel pythonDapInterpreterOptionsPanel) {
        Intrinsics.checkNotNullParameter((Object)pythonDapInterpreterOptionsPanel, (String)"<set-?>");
        this.interpreterOptionsForm = pythonDapInterpreterOptionsPanel;
    }

    @Nullable
    public final Sdk getSelectedSdk() {
        Sdk selectedSdk = (Sdk)this.interpreterOptionsForm.getInterpreterComboBox().getSelectedItem();
        if (selectedSdk == null) {
            Project project = this.configuration.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            return PySdkExtKt.getPythonSdk((Project)project);
        }
        return selectedSdk;
    }

    public final void setSelectedSdk(@Nullable Sdk value) {
        this.interpreterOptionsForm.getInterpreterComboBox().setSelectedItem(value);
        this.updateDefaultInterpreter(this.getModule());
    }

    @NotNull
    protected JComponent createEditor() {
        return (JComponent)BuilderKt.panel(arg_0 -> PythonDapRunConfigurationEditor.createEditor$lambda$0(this, arg_0));
    }

    protected void resetEditorFrom(@NotNull PythonDapRunConfiguration configuration) {
        Intrinsics.checkNotNullParameter((Object)((Object)configuration), (String)"configuration");
        String string = configuration.getWorkingDirectory();
        if (string == null && (string = configuration.getProject().getBasePath()) == null) {
            string = "";
        }
        String basePath = string;
        this.getWorkingDirectory().setText(PathUtil.toSystemDependentName((String)basePath));
        this.setSelectedSdk(configuration.getSdk());
        this.getScriptPath().setText(PathUtil.toSystemDependentName((String)configuration.getProgramPath()));
        RawCommandLineEditor rawCommandLineEditor = this.getScriptParameters();
        String string2 = configuration.getScriptParameters();
        if (string2 == null) {
            string2 = "";
        }
        rawCommandLineEditor.setText(string2);
        this.interpreterOptionsForm.envsComponent.setEnvData(configuration.getEnvVariables());
    }

    protected void applyEditorTo(@NotNull PythonDapRunConfiguration configuration) {
        Intrinsics.checkNotNullParameter((Object)((Object)configuration), (String)"configuration");
        String string = this.getWorkingDirectory().getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        configuration.setWorkingDirectory(PathUtil.toSystemIndependentName((String)((Object)StringsKt.trim((CharSequence)string)).toString()));
        configuration.setSdk(this.getSelectedSdk());
        String string2 = this.getScriptPath().getText();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
        configuration.setProgramPath(PathUtil.toSystemIndependentName((String)((Object)StringsKt.trim((CharSequence)string2)).toString()));
        String string3 = this.getScriptParameters().getText();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getText(...)");
        configuration.setScriptParameters(((Object)StringsKt.trim((CharSequence)string3)).toString());
        EnvironmentVariablesData environmentVariablesData = this.interpreterOptionsForm.envsComponent.getEnvData();
        Intrinsics.checkNotNullExpressionValue((Object)environmentVariablesData, (String)"getEnvData(...)");
        configuration.setEnvVariables(environmentVariablesData);
    }

    private final void updateDefaultInterpreter(Module module) {
        PySdkListCellRenderer pySdkListCellRenderer;
        Module module2 = module;
        Sdk moduleSdk = module2 == null ? null : ModuleRootManager.getInstance((Module)module2).getSdk();
        JComboBox<Sdk> jComboBox = this.interpreterOptionsForm.getInterpreterComboBox();
        if (moduleSdk == null) {
            pySdkListCellRenderer = new PySdkListCellRenderer(null, null, 3, null);
        } else {
            Object[] objectArray = new Object[]{moduleSdk.getName()};
            String string = PythonDapBundle.message("pythonDap.run.configuration.interpreter.project.default.0", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            pySdkListCellRenderer = new PySdkListCellRenderer(string, moduleSdk);
        }
        jComboBox.setRenderer((ListCellRenderer)pySdkListCellRenderer);
    }

    private final void setModule(Module module) {
        this.updateDefaultInterpreter(module);
    }

    private final Module getModule() {
        Project project = this.configuration.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Module[] modules = ModuleManager.Companion.getInstance(project).getModules();
        if (modules.length == 1) {
            return modules[0];
        }
        return null;
    }

    private final TextFieldWithBrowseButton createWorkingDirectory(Project project) {
        TextFieldWithBrowseButton workingDir = new TextFieldWithBrowseButton();
        FileChooserDescriptor descriptor = FileChooserDescriptorFactory.singleDir();
        workingDir.addBrowseFolderListener(project, descriptor, TextComponentAccessor.TEXT_FIELD_WHOLE_TEXT);
        FileChooserFactory.getInstance().installFileCompletion(workingDir.getTextField(), descriptor, false, (Disposable)this);
        return workingDir;
    }

    private final TextFieldWithBrowseButton createPathToFile(Project project) {
        FileChooserDescriptor descriptor = FileChooserDescriptorFactory.singleFile();
        TextFieldWithBrowseButton pathToFile = new TextFieldWithBrowseButton();
        pathToFile.addBrowseFolderListener(project, descriptor, TextComponentAccessor.TEXT_FIELD_WHOLE_TEXT);
        return pathToFile;
    }

    private static final Unit createEditor$lambda$0(PythonDapRunConfigurationEditor this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        String string = PythonDapBundle.message("pythonDap.run.configuration.fileScript.label", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$panel.row(string, arg_0 -> PythonDapRunConfigurationEditor.createEditor$lambda$0$0(this$0, arg_0));
        Panel.row$default((Panel)$this$panel, null, arg_0 -> PythonDapRunConfigurationEditor.createEditor$lambda$0$1(this$0, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$panel, null, arg_0 -> PythonDapRunConfigurationEditor.createEditor$lambda$0$2(this$0, arg_0), (int)1, null);
        String string2 = PythonDapBundle.message("pythonDap.run.configuration.workingDir.label", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        $this$panel.row(string2, arg_0 -> PythonDapRunConfigurationEditor.createEditor$lambda$0$3(this$0, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit createEditor$lambda$0$0(PythonDapRunConfigurationEditor this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Project project = this$0.configuration.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        this$0.setScriptPath(this$0.createPathToFile(project));
        $this$row.cell((JComponent)this$0.getScriptPath()).align((Align)AlignX.FILL.INSTANCE);
        return Unit.INSTANCE;
    }

    private static final Unit createEditor$lambda$0$1(PythonDapRunConfigurationEditor this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        this$0.setScriptParameters(new RawCommandLineEditor());
        this$0.getScriptParameters().getEditorField().getEmptyText().setText(PythonDapBundle.message("pythonDap.run.configuration.scriptParams.label", new Object[0]));
        CommonProgramParametersPanel.addMacroSupport((ExtendableTextField)((ExtendableTextField)this$0.getScriptParameters().getEditorField()));
        $this$row.cell((JComponent)this$0.getScriptParameters()).align(Align.FILL);
        return Unit.INSTANCE;
    }

    private static final Unit createEditor$lambda$0$2(PythonDapRunConfigurationEditor this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.cell((JComponent)this$0.interpreterOptionsForm.getPanel()).align((Align)AlignX.FILL.INSTANCE);
        return Unit.INSTANCE;
    }

    private static final Unit createEditor$lambda$0$3(PythonDapRunConfigurationEditor this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Project project = this$0.configuration.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        this$0.setWorkingDirectory(this$0.createWorkingDirectory(project));
        $this$row.cell((JComponent)this$0.getWorkingDirectory()).align(Align.FILL);
        return Unit.INSTANCE;
    }
}

