/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.postgres.psi;

import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTrigger;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbRoutine;
import com.intellij.database.psi.DbTable;
import com.intellij.database.psi.DbTrigger;
import com.intellij.database.symbols.DasSymbol;
import com.intellij.database.types.DasType;
import com.intellij.database.types.DasTypeSystemBase;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.database.util.DbUtil;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.dialects.ReservedEntity;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.dialects.postgres.PgDialectBase;
import com.intellij.sql.dialects.postgres.psi.PgCreateTriggerStatementImpl;
import com.intellij.sql.dialects.postgres.psi.PgOuterCodeBlockElementType;
import com.intellij.sql.dialects.postgres.psi.PgPsiUtil;
import com.intellij.sql.dialects.postgres.psi.PgRoutineDefinition;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import com.intellij.sql.psi.SqlReferenceElementType;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlReturnsClause;
import com.intellij.sql.psi.SqlScopeProcessor;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.impl.SqlCreateFunctionStatementImpl;
import com.intellij.sql.psi.impl.SqlCreateTriggerStatementWithFakeTables;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlPsiElementFactory;
import com.intellij.sql.psi.impl.SqlScopeProcessorBase;
import com.intellij.sql.psi.impl.SqlTableTypeBase;
import com.intellij.sql.psi.stubs.SqlNamedElementStub;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PgCreateFunctionStatementImpl
extends SqlCreateFunctionStatementImpl
implements PgRoutineDefinition {
    public PgCreateFunctionStatementImpl(@NotNull ASTNode node) {
        if (node == null) {
            PgCreateFunctionStatementImpl.$$$reportNull$$$0(0);
        }
        super(node);
    }

    public PgCreateFunctionStatementImpl(SqlNamedElementStub<?> stub) {
        super(stub);
    }

    @NotNull
    public JBIterable<SqlStatement> getBody() {
        JBIterable jBIterable = JBIterable.of((Object)PgPsiUtil.getPgBody(this));
        if (jBIterable == null) {
            PgCreateFunctionStatementImpl.$$$reportNull$$$0(1);
        }
        return jBIterable;
    }

    public boolean processImplicitContextDeclarations(SqlScopeProcessor processor, ResolveState state, PsiElement lastParent, PsiElement place) {
        SqlReferenceExpression ref;
        if (!SqlImplUtil.isProcessingOneOf((SqlScopeProcessor)processor, (ObjectKind[])new ObjectKind[]{ObjectKind.TABLE, ObjectKind.COLUMN})) {
            return true;
        }
        boolean inBody = lastParent.getParent() == this && PsiUtilCore.getElementType((PsiElement)lastParent) instanceof PgOuterCodeBlockElementType;
        SqlReturnsClause returnArgument = this.getReturnArgument();
        if (inBody && returnArgument != null && SqlImplUtil.getSqlDialectSafe((PsiElement)this).getTypeSystem().isTriggerFunctionType(returnArgument.getDasType()) && !this.processTriggerDeclarations(processor, state, place)) {
            return false;
        }
        if (inBody && (ref = (SqlReferenceExpression)ObjectUtils.tryCast((Object)this.getNameElement(), SqlReferenceExpression.class)) != null && !SqlImplUtil.processQualifier((SqlReferenceExpression)ref, (SqlScopeProcessor)processor, (ResolveState)state, (PsiElement)place)) {
            return false;
        }
        return super.processImplicitContextDeclarations(processor, state, lastParent, place);
    }

    private boolean processTriggerDeclarations(SqlScopeProcessor processor, ResolveState state, PsiElement place) {
        SqlCreateTriggerStatementWithFakeTables.FakeTablesHandler handler = this.getFakeHandler();
        if (handler != null && (handler.getProvider() instanceof PgCreateTriggerStatementImpl ? !((PgCreateTriggerStatementImpl)handler.getProvider()).processDeclarations(processor, state, handler.getProvider().getLastChild(), place) : !handler.processSimple(processor, state))) {
            return false;
        }
        SqlScopeProcessorBase sqlProcessor = (SqlScopeProcessorBase)ObjectUtils.tryCast((Object)processor, SqlScopeProcessorBase.class);
        if (sqlProcessor != null) {
            PgDialectBase dialect = (PgDialectBase)sqlProcessor.getDialect();
            if (handler == null) {
                if (!sqlProcessor.executeTarget((DasSymbol)dialect.getNewTableAlias(), (DasType)SqlTableTypeBase.EMPTY_TABLE, null, state)) {
                    return false;
                }
                if (!sqlProcessor.executeTarget((DasSymbol)dialect.getOldTableAlias(), (DasType)SqlTableTypeBase.EMPTY_TABLE, null, state)) {
                    return false;
                }
            }
            DasTypeSystemBase typeSystem = dialect.getTypeSystem();
            for (ReservedEntity entity : dialect.getTriggerStringImplicits().values()) {
                if (sqlProcessor.executeTarget((DasSymbol)entity, typeSystem.getStringType(), null, state)) continue;
                return false;
            }
            if (!sqlProcessor.executeTarget((DasSymbol)dialect.getTriggerNArgsColumn(), typeSystem.getIntType(), null, state) || !sqlProcessor.executeTarget((DasSymbol)dialect.getTriggerArgVColumn(), (DasType)typeSystem.getAnyArrayType(), null, state)) {
                return false;
            }
        }
        return true;
    }

    @Nullable
    private SqlCreateTriggerStatementWithFakeTables.FakeTablesHandler getFakeHandler() {
        return (SqlCreateTriggerStatementWithFakeTables.FakeTablesHandler)CachedValuesManager.getCachedValue((PsiElement)this, () -> CachedValueProvider.Result.create((Object)this.findOrCreateHandler(), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
    }

    @Nullable
    private SqlCreateTriggerStatementWithFakeTables.FakeTablesHandler findOrCreateHandler() {
        DbTable table;
        PgCreateTriggerStatementImpl sqlTrigger = this.findSqlTrigger();
        if (sqlTrigger != null) {
            return sqlTrigger.getHandler();
        }
        DbTrigger trigger = this.findDbTrigger();
        DbTable dbTable = table = trigger == null ? null : trigger.getTable();
        if (table == null) {
            return null;
        }
        return PgCreateTriggerStatementImpl.createHandler((PsiElement)this, (PsiElement)table);
    }

    @Nullable
    private DbTrigger findDbTrigger() {
        SqlReferenceExpression ref = (SqlReferenceExpression)ObjectUtils.tryCast((Object)this.getNameElement(), SqlReferenceExpression.class);
        if (ref == null) {
            return null;
        }
        SqlReferenceExpression unboundedRef = SqlPsiElementFactory.createReferenceFromText((String)ref.getText(), (SqlLanguageDialect)SqlImplUtil.getSqlDialectSafe((PsiElement)ref), (SqlReferenceElementType)ref.getReferenceElementType(), (PsiElement)this);
        if (unboundedRef == null) {
            return null;
        }
        for (ResolveResult result : unboundedRef.multiResolve(false)) {
            DbDataSource dataSource;
            DasTrigger trigger;
            DasObject routine;
            PsiElement resolved = result.getElement();
            if (!(resolved instanceof DbRoutine) || (routine = DbUtil.getDasObject((Object)resolved)) == null || (trigger = (DasTrigger)(dataSource = ((DbRoutine)resolved).getDataSource()).getDelegate().getModel().traverser().filter(DasTrigger.class).filter(o -> DbSqlUtilCore.referencesTarget((DasObject)o, (DasObject)routine, (ObjectKind)ObjectKind.ROUTINE)).first()) == null) continue;
            return (DbTrigger)dataSource.findElement((DasObject)trigger);
        }
        return null;
    }

    @Nullable
    private PgCreateTriggerStatementImpl findSqlTrigger() {
        PgCreateTriggerStatementImpl statement = null;
        SqlFile file = (SqlFile)ObjectUtils.tryCast((Object)this.getContainingFile(), SqlFile.class);
        if (file != null) {
            SqlCreateFunctionStatementImpl target = (SqlCreateFunctionStatementImpl)CompletionUtil.getOriginalOrSelf((PsiElement)this);
            statement = (PgCreateTriggerStatementImpl)PsiTreeUtil.getParentOfType((PsiElement)target, PgCreateTriggerStatementImpl.class);
            if (statement != null) {
                return statement;
            }
            for (SqlElement element : file.getDdl()) {
                SqlFunctionCallExpression call;
                SqlReferenceExpression ref;
                PgCreateTriggerStatementImpl trigger = (PgCreateTriggerStatementImpl)((Object)ObjectUtils.tryCast((Object)element, PgCreateTriggerStatementImpl.class));
                if (trigger == null || (ref = (call = (SqlFunctionCallExpression)ObjectUtils.tryCast((Object)trigger.getTriggerProcedure(), SqlFunctionCallExpression.class)) == null ? null : call.getNameElement()) == null || !ref.getReference().isReferenceTo((PsiElement)target)) continue;
                statement = trigger;
                break;
            }
        }
        return statement;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/postgres/psi/PgCreateFunctionStatementImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/postgres/psi/PgCreateFunctionStatementImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getBody";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

