/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.tslint.service;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.intellij.javascript.nodejs.execution.NodeTargetRun;
import com.intellij.javascript.nodejs.library.yarn.pnp.YarnPnpNodePackage;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.lang.javascript.linter.AutodetectLinterPackage;
import com.intellij.lang.javascript.linter.ExtendedLinterState;
import com.intellij.lang.javascript.linter.LinterLanguageServiceClient;
import com.intellij.lang.javascript.linter.tslint.TsLintBundle;
import com.intellij.lang.javascript.linter.tslint.TslintUtil;
import com.intellij.lang.javascript.linter.tslint.config.TsLintConfiguration;
import com.intellij.lang.javascript.linter.tslint.config.TsLintState;
import com.intellij.lang.javascript.linter.tslint.execution.TsLintOutputJsonParser;
import com.intellij.lang.javascript.linter.tslint.execution.TsLinterError;
import com.intellij.lang.javascript.service.JSLanguageServiceBase;
import com.intellij.lang.javascript.service.JSLanguageServiceQueue;
import com.intellij.lang.javascript.service.JSLanguageServiceQueueImpl;
import com.intellij.lang.javascript.service.JSLanguageServiceUtil;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceAnswer;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceCommand;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceInitialState;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceNodeStdProtocolBase;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceObject;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceProtocol;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceSimpleCommand;
import com.intellij.lang.javascript.service.protocol.LocalFilePath;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.SemVer;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Deferred;
import kotlinx.coroutines.future.FutureKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 $2\u00020\u0001:\u0006\u001f !\"#$B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ8\u0010\f\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e\u0018\u00010\r2\u0006\u0010\u0010\u001a\u00020\u00072\b\u0010\u0011\u001a\u0004\u0018\u00010\u00072\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0015J$\u0010\u0016\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e\u0018\u00010\r2\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u0015JN\u0010\u0017\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e\u0018\u00010\r2\u0006\u0010\u0010\u001a\u00020\u00072\b\u0010\u0011\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0014\u001a\u00020\u00152\u001c\u0010\u0018\u001a\u0018\u0012\u0006\u0012\u0004\u0018\u00010\u001a\u0012\u0006\u0012\u0004\u0018\u00010\u001a\u0012\u0004\u0012\u00020\u001b0\u0019H\u0002J\u000e\u0010\u001c\u001a\u00020\u001dH\u0094@\u00a2\u0006\u0002\u0010\u001eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/intellij/lang/javascript/linter/tslint/service/TsLintLanguageService;", "Lcom/intellij/lang/javascript/service/JSLanguageServiceBase;", "project", "Lcom/intellij/openapi/project/Project;", "nodePackage", "Lcom/intellij/javascript/nodejs/util/NodePackage;", "myWorkingDirectory", "Lcom/intellij/openapi/vfs/VirtualFile;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/javascript/nodejs/util/NodePackage;Lcom/intellij/openapi/vfs/VirtualFile;)V", "getNodePackage", "()Lcom/intellij/javascript/nodejs/util/NodePackage;", "highlight", "Ljava/util/concurrent/CompletableFuture;", "", "Lcom/intellij/lang/javascript/linter/tslint/execution/TsLinterError;", "virtualFile", "config", "content", "", "state", "Lcom/intellij/lang/javascript/linter/tslint/config/TsLintState;", "highlightAndFix", "createHighlightFuture", "commandProvider", "Ljava/util/function/BiFunction;", "Lcom/intellij/lang/javascript/service/protocol/LocalFilePath;", "Lcom/intellij/lang/javascript/linter/tslint/service/TsLintLanguageService$BaseCommand;", "createLanguageServiceQueue", "Lcom/intellij/lang/javascript/service/JSLanguageServiceQueue;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "BaseCommand", "GetErrorsCommand", "FixErrorsCommand", "Protocol", "InitialState", "Companion", "intellij.tslint"})
public final class TsLintLanguageService
extends JSLanguageServiceBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final NodePackage nodePackage;
    @NotNull
    private final VirtualFile myWorkingDirectory;
    @NotNull
    private static final Logger LOG;

    public TsLintLanguageService(@NotNull Project project, @NotNull NodePackage nodePackage, @NotNull VirtualFile myWorkingDirectory) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)nodePackage, (String)"nodePackage");
        Intrinsics.checkNotNullParameter((Object)myWorkingDirectory, (String)"myWorkingDirectory");
        super(project);
        this.nodePackage = nodePackage;
        this.myWorkingDirectory = myWorkingDirectory;
    }

    @NotNull
    public final NodePackage getNodePackage() {
        return this.nodePackage;
    }

    @Nullable
    public final CompletableFuture<List<TsLinterError>> highlight(@NotNull VirtualFile virtualFile, @Nullable VirtualFile config, @Nullable String content, @NotNull TsLintState state) {
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return this.createHighlightFuture(virtualFile, config, state, (arg_0, arg_1) -> TsLintLanguageService.highlight$lambda$0(content, arg_0, arg_1));
    }

    @Nullable
    public final CompletableFuture<List<TsLinterError>> highlightAndFix(@NotNull VirtualFile virtualFile, @NotNull TsLintState state) {
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        VirtualFile config = TslintUtil.getConfig(state, this.myProject, virtualFile);
        return this.createHighlightFuture(virtualFile, config, state, TsLintLanguageService::highlightAndFix$lambda$0);
    }

    private final CompletableFuture<List<TsLinterError>> createHighlightFuture(VirtualFile virtualFile, VirtualFile config, TsLintState state, BiFunction<LocalFilePath, LocalFilePath, BaseCommand> commandProvider) {
        String configFilePath = JSLanguageServiceUtil.normalizePathDoNotFollowSymlinks((VirtualFile)config);
        if (configFilePath == null) {
            if (state.getNodePackageRef() == AutodetectLinterPackage.INSTANCE) {
                return CompletableFuture.completedFuture(ContainerUtil.emptyList());
            }
            return CompletableFuture.completedFuture(CollectionsKt.listOf((Object)((Object)TsLinterError.createGlobalError(TsLintBundle.message("tslint.inspection.message.config.file.was.not.found", new Object[0])))));
        }
        String path = JSLanguageServiceUtil.normalizePathDoNotFollowSymlinks((VirtualFile)virtualFile);
        if (path == null) {
            return null;
        }
        BaseCommand baseCommand = commandProvider.apply(LocalFilePath.Companion.createNotNull(path), LocalFilePath.Companion.createNotNull(configFilePath));
        Intrinsics.checkNotNullExpressionValue((Object)baseCommand, (String)"apply(...)");
        BaseCommand command = baseCommand;
        return FutureKt.asCompletableFuture((Deferred)BuildersKt.async$default((CoroutineScope)this.getCs(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super List<? extends TsLinterError>>, Object>(this, command, path, null){
            Object L$0;
            int label;
            final /* synthetic */ TsLintLanguageService this$0;
            final /* synthetic */ BaseCommand $command;
            final /* synthetic */ String $path;
            {
                this.this$0 = $receiver;
                this.$command = $command;
                this.$path = $path;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        v0 = TsLintLanguageService.access$getProcess(this.this$0, (Continuation)this);
                        if (v0 == var4_2) {
                            return var4_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        if ((process = (JSLanguageServiceQueue)v0) == null) {
                            return CollectionsKt.listOf((Object)TsLinterError.createGlobalError(JSLanguageServiceUtil.getLanguageServiceCreationError((LinterLanguageServiceClient)((LinterLanguageServiceClient)this.this$0))));
                        }
                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)process);
                        this.label = 2;
                        v1 = process.execute((JSLanguageServiceCommand)this.$command, (Continuation)this);
                        if (v1 == var4_2) {
                            return var4_2;
                        }
                        ** GOTO lbl25
                    }
                    case 2: {
                        process = (JSLanguageServiceQueue)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl25:
                        // 2 sources

                        if ((v2 = (JSLanguageServiceQueue.CommandResult)v1) == null || (v2 = v2.getAnswer()) == null) {
                            return CollectionsKt.emptyList();
                        }
                        answer = v2;
                        v3 = JSLanguageServiceUtil.getGson((JSLanguageServiceBase)this.this$0);
                        Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"getGson(...)");
                        v4 = com.intellij.lang.javascript.linter.tslint.service.TsLintLanguageService$Companion.access$parseResults(TsLintLanguageService.Companion, (JSLanguageServiceAnswer)answer, this.$path, v3);
                        if (v4 == null) {
                            v4 = CollectionsKt.emptyList();
                        }
                        return v4;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super List<TsLinterError>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null));
    }

    @Nullable
    protected Object createLanguageServiceQueue(@NotNull Continuation<? super JSLanguageServiceQueue> $completion) {
        return new JSLanguageServiceQueueImpl(this.myProject, (JSLanguageServiceProtocol)new Protocol(this.nodePackage, this.myWorkingDirectory, this.myProject), null, (JSLanguageServiceQueue.ServiceInfoReporter)this.myDefaultReporter, false, 16, null);
    }

    private static final BaseCommand highlight$lambda$0(String $content, LocalFilePath filePath, LocalFilePath configPath) {
        String string = $content;
        if (string == null) {
            string = "";
        }
        return new GetErrorsCommand(filePath, configPath, string);
    }

    private static final BaseCommand highlightAndFix$lambda$0(LocalFilePath filePath, LocalFilePath configPath) {
        return new FixErrorsCommand(filePath, configPath);
    }

    public static final /* synthetic */ Object access$getProcess(TsLintLanguageService $this, Continuation $completion) {
        return $this.getProcess($completion);
    }

    static {
        Logger logger = Logger.getInstance(TsLintLanguageService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\b\"\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u001d\b\u0004\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u000f\u001a\u00020\u0003H\u0016R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\n\"\u0004\b\u000e\u0010\f\u00a8\u0006\u0010"}, d2={"Lcom/intellij/lang/javascript/linter/tslint/service/TsLintLanguageService$BaseCommand;", "Lcom/intellij/lang/javascript/service/protocol/JSLanguageServiceCommand;", "Lcom/intellij/lang/javascript/service/protocol/JSLanguageServiceSimpleCommand;", "Lcom/intellij/lang/javascript/service/protocol/JSLanguageServiceObject;", "filePath", "Lcom/intellij/lang/javascript/service/protocol/LocalFilePath;", "configPath", "<init>", "(Lcom/intellij/lang/javascript/service/protocol/LocalFilePath;Lcom/intellij/lang/javascript/service/protocol/LocalFilePath;)V", "getFilePath", "()Lcom/intellij/lang/javascript/service/protocol/LocalFilePath;", "setFilePath", "(Lcom/intellij/lang/javascript/service/protocol/LocalFilePath;)V", "getConfigPath", "setConfigPath", "toSerializableObject", "intellij.tslint"})
    private static abstract class BaseCommand
    implements JSLanguageServiceCommand,
    JSLanguageServiceSimpleCommand,
    JSLanguageServiceObject {
        @Nullable
        private LocalFilePath filePath;
        @Nullable
        private LocalFilePath configPath;

        protected BaseCommand(@Nullable LocalFilePath filePath, @Nullable LocalFilePath configPath) {
            this.filePath = filePath;
            this.configPath = configPath;
        }

        @Nullable
        public final LocalFilePath getFilePath() {
            return this.filePath;
        }

        public final void setFilePath(@Nullable LocalFilePath localFilePath) {
            this.filePath = localFilePath;
        }

        @Nullable
        public final LocalFilePath getConfigPath() {
            return this.configPath;
        }

        public final void setConfigPath(@Nullable LocalFilePath localFilePath) {
            this.configPath = localFilePath;
        }

        @NotNull
        public JSLanguageServiceObject toSerializableObject() {
            return this;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/lang/javascript/linter/tslint/service/TsLintLanguageService$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "parseResults", "", "Lcom/intellij/lang/javascript/linter/tslint/execution/TsLinterError;", "answer", "Lcom/intellij/lang/javascript/service/protocol/JSLanguageServiceAnswer;", "path", "", "gson", "Lcom/google/gson/Gson;", "parseBody", "Lcom/google/gson/JsonElement;", "element", "Lcom/google/gson/JsonObject;", "intellij.tslint"})
    public static final class Companion {
        private Companion() {
        }

        private final List<TsLinterError> parseResults(JSLanguageServiceAnswer answer, String path, Gson gson) {
            JsonObject element = answer.getElement();
            JsonElement error = element.get("error");
            if (error != null) {
                return CollectionsKt.listOf((Object)((Object)TsLinterError.createGlobalError(error.getAsString())));
            }
            JsonElement body = this.parseBody(element);
            if (body == null) {
                return null;
            }
            String version = element.get("version").getAsString();
            SemVer tsLintVersion = SemVer.parseFromText((String)version);
            boolean isZeroBased = TsLintOutputJsonParser.isVersionZeroBased(tsLintVersion);
            TsLintOutputJsonParser parser = new TsLintOutputJsonParser(path, body, isZeroBased, gson);
            return new ArrayList(parser.getErrors());
        }

        private final JsonElement parseBody(JsonObject element) {
            JsonElement body = element.get("body");
            if (body == null) {
                return null;
            }
            if (body.isJsonPrimitive() && body.getAsJsonPrimitive().isString()) {
                String string = StringUtil.unquoteString((String)body.getAsJsonPrimitive().getAsString());
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"unquoteString(...)");
                String bodyContent = string;
                if (!StringsKt.isBlank((CharSequence)bodyContent)) {
                    try {
                        return JsonParser.parseString((String)bodyContent);
                    }
                    catch (JsonParseException e) {
                        Logger logger = LOG;
                        String string2 = "Problem parsing body: '%s'\n%s";
                        Object[] objectArray = new Object[]{body, e.getMessage()};
                        String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
                        logger.info(string3, (Throwable)e);
                    }
                }
            } else {
                Logger logger = LOG;
                String string = "Error body type, should be a string with json inside. Body:'%s'";
                Object[] objectArray = new Object[]{body.getAsString()};
                String string4 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(...)");
                logger.info(string4);
            }
            return null;
        }

        public static final /* synthetic */ List access$parseResults(Companion $this, JSLanguageServiceAnswer answer, String path, Gson gson) {
            return $this.parseResults(answer, path, gson);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u001b\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/intellij/lang/javascript/linter/tslint/service/TsLintLanguageService$FixErrorsCommand;", "Lcom/intellij/lang/javascript/linter/tslint/service/TsLintLanguageService$BaseCommand;", "filePath", "Lcom/intellij/lang/javascript/service/protocol/LocalFilePath;", "configPath", "<init>", "(Lcom/intellij/lang/javascript/service/protocol/LocalFilePath;Lcom/intellij/lang/javascript/service/protocol/LocalFilePath;)V", "command", "", "getCommand", "()Ljava/lang/String;", "intellij.tslint"})
    private static final class FixErrorsCommand
    extends BaseCommand {
        public FixErrorsCommand(@Nullable LocalFilePath filePath, @Nullable LocalFilePath configPath) {
            super(filePath, configPath);
        }

        @NotNull
        public String getCommand() {
            return "FixErrors";
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\b\u0002\u0018\u00002\u00020\u0001B%\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b\u0007\u0010\bR\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\n\u00a8\u0006\u000f"}, d2={"Lcom/intellij/lang/javascript/linter/tslint/service/TsLintLanguageService$GetErrorsCommand;", "Lcom/intellij/lang/javascript/linter/tslint/service/TsLintLanguageService$BaseCommand;", "filePath", "Lcom/intellij/lang/javascript/service/protocol/LocalFilePath;", "configPath", "content", "", "<init>", "(Lcom/intellij/lang/javascript/service/protocol/LocalFilePath;Lcom/intellij/lang/javascript/service/protocol/LocalFilePath;Ljava/lang/String;)V", "getContent", "()Ljava/lang/String;", "setContent", "(Ljava/lang/String;)V", "command", "getCommand", "intellij.tslint"})
    private static final class GetErrorsCommand
    extends BaseCommand {
        @Nullable
        private String content;

        public GetErrorsCommand(@Nullable LocalFilePath filePath, @Nullable LocalFilePath configPath, @Nullable String content) {
            super(filePath, configPath);
            this.content = content;
        }

        @Nullable
        public final String getContent() {
            return this.content;
        }

        public final void setContent(@Nullable String string) {
            this.content = string;
        }

        @NotNull
        public String getCommand() {
            return "GetErrors";
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001c\u0010\n\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0004\b\f\u0010\tR\u001c\u0010\r\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u0007\"\u0004\b\u000f\u0010\t\u00a8\u0006\u0010"}, d2={"Lcom/intellij/lang/javascript/linter/tslint/service/TsLintLanguageService$InitialState;", "Lcom/intellij/lang/javascript/service/protocol/JSLanguageServiceInitialState;", "<init>", "()V", "tslintPackagePath", "Lcom/intellij/lang/javascript/service/protocol/LocalFilePath;", "getTslintPackagePath", "()Lcom/intellij/lang/javascript/service/protocol/LocalFilePath;", "setTslintPackagePath", "(Lcom/intellij/lang/javascript/service/protocol/LocalFilePath;)V", "packageJsonPath", "getPackageJsonPath", "setPackageJsonPath", "additionalRootDirectory", "getAdditionalRootDirectory", "setAdditionalRootDirectory", "intellij.tslint"})
    private static final class InitialState
    extends JSLanguageServiceInitialState {
        @Nullable
        private LocalFilePath tslintPackagePath;
        @Nullable
        private LocalFilePath packageJsonPath;
        @Nullable
        private LocalFilePath additionalRootDirectory;

        @Nullable
        public final LocalFilePath getTslintPackagePath() {
            return this.tslintPackagePath;
        }

        public final void setTslintPackagePath(@Nullable LocalFilePath localFilePath) {
            this.tslintPackagePath = localFilePath;
        }

        @Nullable
        public final LocalFilePath getPackageJsonPath() {
            return this.packageJsonPath;
        }

        public final void setPackageJsonPath(@Nullable LocalFilePath localFilePath) {
            this.packageJsonPath = localFilePath;
        }

        @Nullable
        public final LocalFilePath getAdditionalRootDirectory() {
            return this.additionalRootDirectory;
        }

        public final void setAdditionalRootDirectory(@Nullable LocalFilePath localFilePath) {
            this.additionalRootDirectory = localFilePath;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u000e\u001a\u00020\u000fH\u0014J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\u0004\u0018\u00010\u000b8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0014"}, d2={"Lcom/intellij/lang/javascript/linter/tslint/service/TsLintLanguageService$Protocol;", "Lcom/intellij/lang/javascript/service/protocol/JSLanguageServiceNodeStdProtocolBase;", "myNodePackage", "Lcom/intellij/javascript/nodejs/util/NodePackage;", "myWorkingDirectory", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/javascript/nodejs/util/NodePackage;Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/openapi/project/Project;)V", "workingDirectory", "", "getWorkingDirectory", "()Ljava/lang/String;", "createState", "Lcom/intellij/lang/javascript/service/protocol/JSLanguageServiceInitialState;", "addNodeProcessAdditionalArguments", "", "targetRun", "Lcom/intellij/javascript/nodejs/execution/NodeTargetRun;", "intellij.tslint"})
    @SourceDebugExtension(value={"SMAP\nTsLintLanguageService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TsLintLanguageService.kt\ncom/intellij/lang/javascript/linter/tslint/service/TsLintLanguageService$Protocol\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,208:1\n1#2:209\n*E\n"})
    private static final class Protocol
    extends JSLanguageServiceNodeStdProtocolBase {
        @NotNull
        private final NodePackage myNodePackage;
        @NotNull
        private final VirtualFile myWorkingDirectory;

        public Protocol(@NotNull NodePackage myNodePackage, @NotNull VirtualFile myWorkingDirectory, @NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)myNodePackage, (String)"myNodePackage");
            Intrinsics.checkNotNullParameter((Object)myWorkingDirectory, (String)"myWorkingDirectory");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            super("tslint", project, null, 4, null);
            this.myNodePackage = myNodePackage;
            this.myWorkingDirectory = myWorkingDirectory;
        }

        @Nullable
        protected String getWorkingDirectory() {
            return JSLanguageServiceUtil.normalizePathDoNotFollowSymlinks((VirtualFile)this.myWorkingDirectory);
        }

        @NotNull
        protected JSLanguageServiceInitialState createState() {
            InitialState result = new InitialState();
            ExtendedLinterState extendedLinterState = TsLintConfiguration.getInstance(this.myProject).getExtendedState();
            Intrinsics.checkNotNullExpressionValue((Object)extendedLinterState, (String)"getExtendedState(...)");
            ExtendedLinterState extendedState = extendedLinterState;
            if (this.myNodePackage instanceof YarnPnpNodePackage) {
                String string = ((YarnPnpNodePackage)this.myNodePackage).getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"<get-name>(...)");
                result.setTslintPackagePath(LocalFilePath.Companion.createNotNull(string));
                String packageJsonPath = ((YarnPnpNodePackage)this.myNodePackage).getPackageJsonPath(this.myProject);
                if (packageJsonPath == null) {
                    boolean bl = false;
                    String string2 = "Cannot find package.json path for " + this.myNodePackage;
                    throw new IllegalStateException(string2.toString());
                }
                String string3 = FileUtil.toSystemDependentName((String)packageJsonPath);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toSystemDependentName(...)");
                result.setPackageJsonPath(LocalFilePath.Companion.createNotNull(string3));
            } else {
                result.setTslintPackagePath(LocalFilePath.Companion.createNotNull(this.myNodePackage.getSystemDependentPath()));
            }
            result.setAdditionalRootDirectory(LocalFilePath.Companion.create(((TsLintState)extendedState.getState()).getRulesDirectory()));
            result.pluginName = "tslint";
            File file = JSLanguageServiceUtil.getPluginDirectory(((Object)((Object)this)).getClass(), (String)"js/languageService/tslint-plugin-provider.js");
            Intrinsics.checkNotNull((Object)file);
            String string = file.getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
            result.pluginPath = LocalFilePath.Companion.createNotNull(string);
            return result;
        }

        protected void addNodeProcessAdditionalArguments(@NotNull NodeTargetRun targetRun) {
            Intrinsics.checkNotNullParameter((Object)targetRun, (String)"targetRun");
            super.addNodeProcessAdditionalArguments(targetRun);
            File file = JSLanguageServiceUtil.getPluginDirectory(((Object)((Object)this)).getClass(), (String)"js");
            Intrinsics.checkNotNull((Object)file);
            String string = file.getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
            targetRun.path(string);
        }
    }
}

