/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.heap.view.models;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.treeStructure.treetable.TreeTableCellRenderer;
import com.intellij.ui.treeStructure.treetable.TreeTableModel;
import com.intellij.util.ui.ColumnInfo;
import com.jetbrains.nodejs.NodeJSBundle;
import com.jetbrains.nodejs.run.profile.cpu.view.TreeTableModelWithCustomRenderer;
import com.jetbrains.nodejs.run.profile.heap.V8CachingReader;
import com.jetbrains.nodejs.run.profile.heap.data.V8HeapEdge;
import com.jetbrains.nodejs.run.profile.heap.data.V8HeapEntry;
import com.jetbrains.nodejs.run.profile.heap.view.renderers.DirectTreeTableRenderer;
import com.jetbrains.nodejs.run.profile.heap.view.renderers.RightAlignedRenderer;
import com.jetbrains.nodejs.run.profile.heap.view.renderers.SizeRenderer;
import javax.swing.JTree;
import javax.swing.event.TreeModelListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class V8HeapContainmentTreeTableModel
implements TreeTableModelWithCustomRenderer {
    private final ColumnInfo[] myColumns;
    private final NamedEntry myRoot;
    @NotNull
    protected final V8CachingReader myReader;
    private ColoredTreeCellRenderer myRenderer;

    public V8HeapContainmentTreeTableModel(Project project, @NotNull V8CachingReader reader) {
        if (reader == null) {
            V8HeapContainmentTreeTableModel.$$$reportNull$$$0(0);
        }
        this.myReader = reader;
        this.myRoot = new NamedEntry(reader.getNode(0L), reader.getString(0L), "", -1L);
        this.myRenderer = new DirectTreeTableRenderer(project, this.myReader);
        this.myColumns = new ColumnInfo[4];
        this.fillColumns(this.myColumns, this.myReader);
    }

    private void fillColumns(ColumnInfo[] columns, final V8CachingReader reader) {
        columns[0] = new ColumnInfo<NamedEntry, NamedEntry>(NodeJSBundle.message("profile.heap.containment_table.column.object.name", new Object[0])){

            @Nullable
            public NamedEntry valueOf(NamedEntry entry) {
                return entry;
            }

            public TableCellRenderer getCustomizedRenderer(NamedEntry o, TableCellRenderer renderer) {
                if (renderer instanceof TreeTableCellRenderer) {
                    ((TreeTableCellRenderer)renderer).setCellRenderer((TreeCellRenderer)V8HeapContainmentTreeTableModel.this.myRenderer);
                }
                return super.getCustomizedRenderer((Object)o, renderer);
            }
        };
        final RightAlignedRenderer alignedRenderer = new RightAlignedRenderer();
        columns[1] = new ColumnInfo<NamedEntry, String>(this, NodeJSBundle.message("profile.heap.containment_table.column.distance.name", new Object[0])){

            @NotNull
            public String valueOf(NamedEntry entry) {
                int distance = reader.getDistance((int)entry.getEntry().getId());
                String string = distance >= 100000000 ? "-" : String.valueOf(distance);
                if (string == null) {
                    2.$$$reportNull$$$0(0);
                }
                return string;
            }

            public TableCellRenderer getCustomizedRenderer(NamedEntry o, TableCellRenderer renderer) {
                return alignedRenderer;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/run/profile/heap/view/models/V8HeapContainmentTreeTableModel$2", "valueOf"));
            }
        };
        final SizeRenderer sizeRenderer = new SizeRenderer(reader.getRetainedSize(0));
        columns[2] = new ColumnInfo<NamedEntry, Object>(this, NodeJSBundle.message("profile.heap.containment_table.column.shallow_size.name", new Object[0])){

            @NotNull
            public Object valueOf(NamedEntry entry) {
                Long l = entry.getEntry().getSize();
                if (l == null) {
                    3.$$$reportNull$$$0(0);
                }
                return l;
            }

            public TableCellRenderer getCustomizedRenderer(NamedEntry o, TableCellRenderer renderer) {
                return sizeRenderer;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/run/profile/heap/view/models/V8HeapContainmentTreeTableModel$3", "valueOf"));
            }
        };
        columns[3] = new ColumnInfo<NamedEntry, Object>(this, NodeJSBundle.message("profile.heap.containment_table.column.retained_size.name", new Object[0])){

            @NotNull
            public Object valueOf(NamedEntry entry) {
                Long l = reader.getRetainedSize((int)entry.getEntry().getId());
                if (l == null) {
                    4.$$$reportNull$$$0(0);
                }
                return l;
            }

            public TableCellRenderer getCustomizedRenderer(NamedEntry o, TableCellRenderer renderer) {
                return sizeRenderer;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/run/profile/heap/view/models/V8HeapContainmentTreeTableModel$4", "valueOf"));
            }
        };
    }

    public void setNodeRenderer(ColoredTreeCellRenderer renderer) {
        this.myRenderer = renderer;
    }

    @Override
    public TableCellRenderer getCustomizedRenderer(int column, Object o, TableCellRenderer renderer) {
        return this.myColumns[column].getCustomizedRenderer(o, renderer);
    }

    public int getColumnCount() {
        return this.myColumns.length;
    }

    public String getColumnName(int column) {
        return this.myColumns[column].getName();
    }

    public Class getColumnClass(int column) {
        return column == 0 ? TreeTableModel.class : String.class;
    }

    public Object getValueAt(Object node, int column) {
        return this.myColumns[column].valueOf(node);
    }

    public boolean isCellEditable(Object node, int column) {
        return false;
    }

    public void setValueAt(Object aValue, Object node, int column) {
    }

    public void setTree(JTree tree) {
    }

    public Object getRoot() {
        return this.myRoot;
    }

    public Object getChild(Object parent, int index) {
        if (parent instanceof NamedEntry) {
            Pair<V8HeapEntry, V8HeapEdge> pair = this.myReader.getChild(((NamedEntry)parent).getEntry(), index);
            V8HeapEdge edge = (V8HeapEdge)pair.getSecond();
            return new NamedEntry((V8HeapEntry)pair.getFirst(), this.myReader.getString(((V8HeapEntry)pair.getFirst()).getNameId()), edge.getPresentation(this.myReader), edge.getFileOffset());
        }
        return null;
    }

    public int getChildCount(Object parent) {
        if (parent instanceof NamedEntry) {
            return this.myReader.getChildren(((NamedEntry)parent).getEntry()).size();
        }
        return 0;
    }

    public boolean isLeaf(Object node) {
        return this.getChildCount(node) == 0;
    }

    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    public int getIndexOfChild(Object parent, Object child) {
        if (parent instanceof NamedEntry && child instanceof NamedEntry) {
            return this.myReader.getChildIndex(((NamedEntry)parent).getEntry(), ((NamedEntry)child).getLinkOffset());
        }
        return 0;
    }

    public void addTreeModelListener(TreeModelListener l) {
    }

    public void removeTreeModelListener(TreeModelListener l) {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "com/jetbrains/nodejs/run/profile/heap/view/models/V8HeapContainmentTreeTableModel", "<init>"));
    }

    public static class NamedEntry {
        private final V8HeapEntry myEntry;
        @NotNull
        @Nls
        private final String myLinkPresentation;
        private final long myLinkOffset;
        @Nls
        private final String myName;
        private final boolean myLinkHidden;
        private final boolean myIsProperty;
        private boolean myDoNotShowLink;

        public static NamedEntry createWithoutLink(long nodeId, V8CachingReader reader) {
            NamedEntry entry = NamedEntry.create(nodeId, reader);
            entry.setDoNotShowLink(true);
            return entry;
        }

        public static NamedEntry create(long nodeId, V8CachingReader reader) {
            V8HeapEntry node = reader.getNode(nodeId);
            return new NamedEntry(node, reader.getString(node.getNameId()), "", -1L);
        }

        public static NamedEntry create(@NotNull V8HeapEdge edge, V8CachingReader reader) {
            if (edge == null) {
                NamedEntry.$$$reportNull$$$0(0);
            }
            V8HeapEntry entry = reader.getNode(edge.getToIndex());
            return new NamedEntry(entry, reader.getString(entry.getNameId()), edge.getPresentation(reader), edge.getFileOffset());
        }

        public NamedEntry(V8HeapEntry entry, @Nls String name, @NotNull @Nls String linkPresentation, long offset) {
            if (linkPresentation == null) {
                NamedEntry.$$$reportNull$$$0(1);
            }
            this.myEntry = entry;
            this.myName = name;
            this.myLinkOffset = offset;
            this.myLinkHidden = linkPresentation.startsWith("{") && linkPresentation.endsWith("}");
            boolean bl = this.myIsProperty = linkPresentation.startsWith(".") || linkPresentation.startsWith("[\"") && linkPresentation.endsWith("\"]") || linkPresentation.startsWith("[") && linkPresentation.endsWith("]");
            this.myLinkPresentation = this.myLinkHidden ? linkPresentation.substring(1, linkPresentation.length() - 1) : (this.myIsProperty ? (linkPresentation.startsWith(".") ? linkPresentation.substring(1) : (linkPresentation.startsWith("[\"") ? linkPresentation.substring(2, linkPresentation.length() - 2) : linkPresentation)) : linkPresentation);
        }

        protected NamedEntry(@NotNull NamedEntry entry) {
            if (entry == null) {
                NamedEntry.$$$reportNull$$$0(2);
            }
            this.myEntry = entry.getEntry();
            this.myLinkPresentation = entry.getLinkPresentation();
            this.myLinkOffset = entry.getLinkOffset();
            this.myName = entry.getName();
            this.myLinkHidden = entry.isLinkHidden();
            this.myIsProperty = entry.isProperty();
        }

        public boolean isDoNotShowLink() {
            return this.myDoNotShowLink;
        }

        public void setDoNotShowLink(boolean doNotShowLink) {
            this.myDoNotShowLink = doNotShowLink;
        }

        public long getLinkOffset() {
            return this.myLinkOffset;
        }

        public V8HeapEntry getEntry() {
            return this.myEntry;
        }

        public String toString() {
            return this.myLinkPresentation + " :: " + this.myName + " @" + this.myEntry.getSnapshotObjectId();
        }

        @NotNull
        @Nls
        public String getLinkPresentation() {
            String string = this.myLinkPresentation;
            if (string == null) {
                NamedEntry.$$$reportNull$$$0(3);
            }
            return string;
        }

        public boolean isLinkHidden() {
            return this.myLinkHidden;
        }

        public boolean isProperty() {
            return this.myIsProperty;
        }

        @Nls
        public String getName() {
            return this.myName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NamedEntry entry = (NamedEntry)o;
            if (this.myLinkOffset != entry.myLinkOffset) {
                return false;
            }
            return !(this.myEntry != null ? !this.myEntry.equals(entry.myEntry) : entry.myEntry != null);
        }

        public int hashCode() {
            int result = this.myEntry != null ? this.myEntry.hashCode() : 0;
            result = 31 * result + Long.hashCode(this.myLinkOffset);
            return result;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "edge";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "linkPresentation";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "entry";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/nodejs/run/profile/heap/view/models/V8HeapContainmentTreeTableModel$NamedEntry";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/nodejs/run/profile/heap/view/models/V8HeapContainmentTreeTableModel$NamedEntry";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLinkPresentation";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "create";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }
}

