/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.recentFiles.frontend;

import com.intellij.ide.actions.OpenInRightSplitAction;
import com.intellij.ide.lightEdit.LightEdit;
import com.intellij.ide.lightEdit.LightEditFeatureUsagesUtil;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.UISettingsState;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.fileEditor.impl.FileEditorOpenOptions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.impl.ToolWindowManagerImpl;
import com.intellij.platform.recentFiles.frontend.RecentFilesNavigator;
import com.intellij.platform.recentFiles.frontend.SwitcherKt;
import com.intellij.platform.recentFiles.frontend.SwitcherToolWindow;
import com.intellij.platform.recentFiles.frontend.SwitcherVirtualFile;
import com.intellij.toolWindow.ToolWindowEventSource;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a \u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a\u0018\u0010\b\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a&\u0010\t\u001a\u00020\u00012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a\u0018\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u00a8\u0006\u0011"}, d2={"openToolWindow", "", "window", "Lcom/intellij/platform/recentFiles/frontend/SwitcherToolWindow;", "isSpeedSearchPopupActive", "", "project", "Lcom/intellij/openapi/project/Project;", "closeToolWindow", "openEditorForFile", "values", "", "Lcom/intellij/platform/recentFiles/frontend/SwitcherVirtualFile;", "defaultMode", "Lcom/intellij/openapi/fileEditor/impl/FileEditorManagerImpl$OpenMode;", "closeEditorForFile", "selectedFile", "intellij.platform.recentFiles.frontend"})
@SourceDebugExtension(value={"SMAP\nswitcherNavigation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 switcherNavigation.kt\ncom/intellij/platform/recentFiles/frontend/SwitcherNavigationKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,108:1\n1#2:109\n*E\n"})
public final class SwitcherNavigationKt {
    public static final void openToolWindow(@NotNull SwitcherToolWindow window, boolean isSpeedSearchPopupActive, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)window, (String)"window");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ToolWindowManager toolWindowManager = ToolWindowManager.Companion.getInstance(project);
        ToolWindowManagerImpl manager = toolWindowManager instanceof ToolWindowManagerImpl ? (ToolWindowManagerImpl)toolWindowManager : null;
        ToolWindowEventSource source = isSpeedSearchPopupActive ? ToolWindowEventSource.SwitcherSearch : ToolWindowEventSource.Switcher;
        ToolWindowManagerImpl toolWindowManagerImpl = manager;
        if (toolWindowManagerImpl != null) {
            toolWindowManagerImpl.activateToolWindow(window.getId(), null, true, source);
        } else {
            window.getWindow().activate(null, true);
        }
    }

    public static final void closeToolWindow(@NotNull SwitcherToolWindow window, @NotNull Project project) {
        ToolWindowManagerImpl manager;
        Intrinsics.checkNotNullParameter((Object)window, (String)"window");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ToolWindowManager toolWindowManager = ToolWindowManager.Companion.getInstance(project);
        ToolWindowManagerImpl toolWindowManagerImpl = manager = toolWindowManager instanceof ToolWindowManagerImpl ? (ToolWindowManagerImpl)toolWindowManager : null;
        if (toolWindowManagerImpl != null) {
            ToolWindowManagerImpl.hideToolWindow$default((ToolWindowManagerImpl)toolWindowManagerImpl, (String)window.getId(), (boolean)false, (boolean)false, (boolean)false, (ToolWindowEventSource)ToolWindowEventSource.CloseFromSwitcher, (int)10, null);
        } else {
            window.getWindow().hide();
        }
    }

    public static final void openEditorForFile(@NotNull List<SwitcherVirtualFile> values, @NotNull FileEditorManagerImpl.OpenMode defaultMode, @NotNull Project project) {
        Intrinsics.checkNotNullParameter(values, (String)"values");
        Intrinsics.checkNotNullParameter((Object)defaultMode, (String)"defaultMode");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        IdeFocusManager.getInstance((Project)project).doWhenFocusSettlesDown(() -> SwitcherNavigationKt.openEditorForFile$lambda$0(project, values, defaultMode), ModalityState.current());
    }

    public static final boolean closeEditorForFile(@NotNull SwitcherVirtualFile selectedFile, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)selectedFile, (String)"selectedFile");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        VirtualFile virtualFile = selectedFile.getVirtualFile();
        if (virtualFile == null) {
            return true;
        }
        VirtualFile virtualFile2 = virtualFile;
        FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)project);
        Intrinsics.checkNotNull((Object)fileEditorManager, (String)"null cannot be cast to non-null type com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl");
        FileEditorManagerImpl fileEditorManager2 = (FileEditorManagerImpl)fileEditorManager;
        EditorWindow maybePreservedItemWindow = selectedFile.getEditorWindow();
        EditorWindow window = SwitcherKt.findAppropriateWindow(maybePreservedItemWindow);
        if (window == null) {
            fileEditorManager2.closeFile(virtualFile2, false, false);
        } else {
            fileEditorManager2.closeFile(virtualFile2, window);
        }
        return fileEditorManager2.getAllEditors(virtualFile2).length == 0;
    }

    private static final void openEditorForFile$lambda$0(Project $project, List $values, FileEditorManagerImpl.OpenMode $defaultMode) {
        FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)$project);
        Intrinsics.checkNotNull((Object)fileEditorManager, (String)"null cannot be cast to non-null type com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl");
        FileEditorManagerImpl manager = (FileEditorManagerImpl)fileEditorManager;
        EditorWindow splitWindow = null;
        for (SwitcherVirtualFile value : $values) {
            FileEditorManagerImpl.OpenMode mode;
            VirtualFile virtualFile;
            Object object = value.getVirtualFile();
            if (object == null) continue;
            VirtualFile it = virtualFile = object;
            boolean bl = false;
            object = it.isValid() ? virtualFile : null;
            if (object == null) {
                continue;
            }
            VirtualFile file = object;
            FileEditorManagerImpl.OpenMode openMode = (FileEditorManagerImpl.OpenMode)RecentFilesNavigator.EP_NAME.computeSafeIfAny(arg_0 -> SwitcherNavigationKt.openEditorForFile$lambda$0$1($project, file, arg_0));
            if (openMode == null) {
                openMode = $defaultMode;
            }
            if ((mode = openMode) == FileEditorManagerImpl.OpenMode.RIGHT_SPLIT) {
                if (splitWindow == null) {
                    splitWindow = OpenInRightSplitAction.Companion.openInRightSplit($project, file, null, true);
                    continue;
                }
                manager.openFile(file, splitWindow, FileEditorOpenOptions.withRequestFocus$default((FileEditorOpenOptions)new FileEditorOpenOptions(false, false, false, false, false, 0, false, null, false, false, false, null, 4095, null), (boolean)false, (int)1, null));
                continue;
            }
            if (mode == FileEditorManagerImpl.OpenMode.NEW_WINDOW) {
                manager.openFileInNewWindow(file, true);
                continue;
            }
            if (value.getEditorWindow() != null) {
                EditorWindow editorWindow = SwitcherKt.findAppropriateWindow(value.getEditorWindow());
                if (editorWindow == null) continue;
                manager.openFileImpl2(editorWindow, file, new FileEditorOpenOptions(false, false, false, true, false, 0, false, null, false, false, false, null, 4087, null));
                continue;
            }
            UISettingsState settings = UISettings.Companion.getInstance().getState();
            boolean oldValue = settings.getReuseNotModifiedTabs();
            settings.setReuseNotModifiedTabs(false);
            manager.openFile(file, null, new FileEditorOpenOptions(false, true, false, true, false, 0, false, null, false, false, false, null, 4085, null));
            if (LightEdit.owns((Project)$project)) {
                LightEditFeatureUsagesUtil.logFileOpen((Project)$project, (LightEditFeatureUsagesUtil.OpenPlace)LightEditFeatureUsagesUtil.OpenPlace.RecentFiles);
            }
            if (!oldValue) continue;
            settings.setReuseNotModifiedTabs(true);
        }
    }

    private static final FileEditorManagerImpl.OpenMode openEditorForFile$lambda$0$1(Project $project, VirtualFile $file, RecentFilesNavigator it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getEditorOpenOptions($project, $file);
    }
}

