/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.api;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.bouncycastle.bcpg.PublicKeyUtils;
import org.bouncycastle.bcpg.PublicSubkeyPacket;
import org.bouncycastle.bcpg.S2K;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyPair;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureGenerator;
import org.bouncycastle.openpgp.PGPSignatureSubpacketGenerator;
import org.bouncycastle.openpgp.api.AbstractOpenPGPKeySignatureGenerator;
import org.bouncycastle.openpgp.api.KeyPairGeneratorCallback;
import org.bouncycastle.openpgp.api.OpenPGPImplementation;
import org.bouncycastle.openpgp.api.OpenPGPKey;
import org.bouncycastle.openpgp.api.SignatureParameters;
import org.bouncycastle.openpgp.api.SignatureSubpacketsFunction;
import org.bouncycastle.openpgp.api.Utils;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.openpgp.operator.PBESecretKeyEncryptor;
import org.bouncycastle.openpgp.operator.PBESecretKeyEncryptorFactory;
import org.bouncycastle.openpgp.operator.PGPDigestCalculatorProvider;
import org.bouncycastle.openpgp.operator.PGPKeyPairGenerator;
import org.bouncycastle.openpgp.operator.PGPKeyPairGeneratorProvider;
import org.bouncycastle.util.Arrays;

public class OpenPGPKeyGenerator
extends AbstractOpenPGPKeySignatureGenerator {
    private static final long SECONDS_PER_MINUTE = 60L;
    private static final long SECONDS_PER_HOUR = 3600L;
    private static final long SECONDS_PER_DAY = 86400L;
    private static final long SECONDS_PER_YEAR = 31536000L;
    private final int keyVersion;
    private final OpenPGPImplementation implementationProvider;
    private final Configuration configuration;

    public OpenPGPKeyGenerator(OpenPGPImplementation openPGPImplementation, boolean bl, Date date) throws PGPException {
        this(openPGPImplementation, 6, bl, date);
    }

    public OpenPGPKeyGenerator(OpenPGPImplementation openPGPImplementation, int n, boolean bl, Date date) throws PGPException {
        this(openPGPImplementation, n, openPGPImplementation.pgpKeyPairGeneratorProvider(), openPGPImplementation.pgpDigestCalculatorProvider(), openPGPImplementation.pbeSecretKeyEncryptorFactory(bl), openPGPImplementation.keyFingerPrintCalculator(), date);
    }

    public OpenPGPKeyGenerator(OpenPGPImplementation openPGPImplementation, int n, PGPKeyPairGeneratorProvider pGPKeyPairGeneratorProvider, PGPDigestCalculatorProvider pGPDigestCalculatorProvider, PBESecretKeyEncryptorFactory pBESecretKeyEncryptorFactory, KeyFingerPrintCalculator keyFingerPrintCalculator, Date date) {
        if (n != 4 && n != 5 && n != 6) {
            throw new IllegalArgumentException("Generating keys of version " + n + " is not supported.");
        }
        this.implementationProvider = openPGPImplementation;
        this.keyVersion = n;
        this.configuration = new Configuration(date, pGPKeyPairGeneratorProvider, pGPDigestCalculatorProvider, pBESecretKeyEncryptorFactory, keyFingerPrintCalculator);
    }

    public WithPrimaryKey classicKey(String string) throws PGPException {
        WithPrimaryKey withPrimaryKey = this.withPrimaryKey().addSigningSubkey().addEncryptionSubkey();
        if (string != null) {
            withPrimaryKey.addUserId(string);
        }
        return withPrimaryKey;
    }

    public WithPrimaryKey ed25519x25519Key(String string) throws PGPException {
        WithPrimaryKey withPrimaryKey = this.withPrimaryKey(new KeyPairGeneratorCallback(){

            @Override
            public PGPKeyPair generateFrom(PGPKeyPairGenerator pGPKeyPairGenerator) throws PGPException {
                return pGPKeyPairGenerator.generateEd25519KeyPair();
            }
        }).addSigningSubkey(new KeyPairGeneratorCallback(){

            @Override
            public PGPKeyPair generateFrom(PGPKeyPairGenerator pGPKeyPairGenerator) throws PGPException {
                return pGPKeyPairGenerator.generateEd25519KeyPair();
            }
        }).addEncryptionSubkey(new KeyPairGeneratorCallback(){

            @Override
            public PGPKeyPair generateFrom(PGPKeyPairGenerator pGPKeyPairGenerator) throws PGPException {
                return pGPKeyPairGenerator.generateX25519KeyPair();
            }
        });
        if (string != null) {
            withPrimaryKey.addUserId(string);
        }
        return withPrimaryKey;
    }

    public WithPrimaryKey ed448x448Key(String string) throws PGPException {
        WithPrimaryKey withPrimaryKey = this.withPrimaryKey(new KeyPairGeneratorCallback(){

            @Override
            public PGPKeyPair generateFrom(PGPKeyPairGenerator pGPKeyPairGenerator) throws PGPException {
                return pGPKeyPairGenerator.generateEd448KeyPair();
            }
        }).addSigningSubkey(new KeyPairGeneratorCallback(){

            @Override
            public PGPKeyPair generateFrom(PGPKeyPairGenerator pGPKeyPairGenerator) throws PGPException {
                return pGPKeyPairGenerator.generateEd448KeyPair();
            }
        }).addEncryptionSubkey(new KeyPairGeneratorCallback(){

            @Override
            public PGPKeyPair generateFrom(PGPKeyPairGenerator pGPKeyPairGenerator) throws PGPException {
                return pGPKeyPairGenerator.generateX448KeyPair();
            }
        });
        if (string != null) {
            withPrimaryKey.addUserId(string);
        }
        return withPrimaryKey;
    }

    public WithPrimaryKey signOnlyKey() throws PGPException {
        return this.withPrimaryKey(KeyPairGeneratorCallback.primaryKey(), SignatureParameters.Callback.Util.modifyHashedSubpackets(new SignatureSubpacketsFunction(){

            @Override
            public PGPSignatureSubpacketGenerator apply(PGPSignatureSubpacketGenerator pGPSignatureSubpacketGenerator) {
                pGPSignatureSubpacketGenerator.removePacketsOfType(27);
                pGPSignatureSubpacketGenerator.setKeyFlags(true, 3);
                return pGPSignatureSubpacketGenerator;
            }
        }));
    }

    public WithPrimaryKey withPrimaryKey() throws PGPException {
        return this.withPrimaryKey(KeyPairGeneratorCallback.primaryKey());
    }

    public WithPrimaryKey withPrimaryKey(KeyPairGeneratorCallback keyPairGeneratorCallback) throws PGPException {
        return this.withPrimaryKey(keyPairGeneratorCallback, null);
    }

    public WithPrimaryKey withPrimaryKey(KeyPairGeneratorCallback keyPairGeneratorCallback, SignatureParameters.Callback callback) throws PGPException {
        PGPKeyPair pGPKeyPair = keyPairGeneratorCallback.generateFrom(this.configuration.kpGenProvider.get(this.keyVersion, this.configuration.keyCreationTime));
        if (pGPKeyPair.getPublicKey().getPublicKeyPacket() instanceof PublicSubkeyPacket) {
            throw new IllegalArgumentException("Primary key MUST NOT consist of subkey packet.");
        }
        if (!PublicKeyUtils.isSigningAlgorithm(pGPKeyPair.getPublicKey().getAlgorithm())) {
            throw new PGPException("Primary key MUST use signing-capable algorithm.");
        }
        SignatureParameters signatureParameters = Utils.applySignatureParameters(callback, SignatureParameters.directKeySignature(this.implementationProvider.policy()));
        if (signatureParameters != null) {
            PGPSignatureGenerator pGPSignatureGenerator = Utils.getPgpSignatureGenerator(this.implementationProvider, pGPKeyPair.getPublicKey(), pGPKeyPair.getPrivateKey(), signatureParameters, this.configuration.keyCreationTime, new Utils.HashedSubpacketsOperation(){

                @Override
                public void operate(PGPSignatureSubpacketGenerator pGPSignatureSubpacketGenerator) throws PGPException {
                    pGPSignatureSubpacketGenerator = OpenPGPKeyGenerator.this.directKeySignatureSubpackets.apply(pGPSignatureSubpacketGenerator);
                    pGPSignatureSubpacketGenerator.setKeyFlags(true, 1);
                    pGPSignatureSubpacketGenerator.setKeyExpirationTime(false, 157680000L);
                }
            });
            pGPKeyPair = new PGPKeyPair(Utils.injectCertification(pGPKeyPair.getPublicKey(), pGPSignatureGenerator), pGPKeyPair.getPrivateKey());
        }
        return new WithPrimaryKey(this.implementationProvider, this.configuration, pGPKeyPair);
    }

    private static class Configuration {
        final Date keyCreationTime;
        final PGPKeyPairGeneratorProvider kpGenProvider;
        final PGPDigestCalculatorProvider digestCalculatorProvider;
        final PBESecretKeyEncryptorFactory keyEncryptorBuilderProvider;
        final KeyFingerPrintCalculator keyFingerprintCalculator;

        public Configuration(Date date, PGPKeyPairGeneratorProvider pGPKeyPairGeneratorProvider, PGPDigestCalculatorProvider pGPDigestCalculatorProvider, PBESecretKeyEncryptorFactory pBESecretKeyEncryptorFactory, KeyFingerPrintCalculator keyFingerPrintCalculator) {
            this.keyCreationTime = new Date(date.getTime() / 1000L * 1000L);
            this.kpGenProvider = pGPKeyPairGeneratorProvider;
            this.digestCalculatorProvider = pGPDigestCalculatorProvider;
            this.keyEncryptorBuilderProvider = pBESecretKeyEncryptorFactory;
            this.keyFingerprintCalculator = keyFingerPrintCalculator;
        }
    }

    public class WithPrimaryKey {
        private final OpenPGPImplementation implementation;
        private final Configuration configuration;
        private PGPKeyPair primaryKey;
        private final List<PGPKeyPair> subkeys = new ArrayList<PGPKeyPair>();

        private WithPrimaryKey(OpenPGPImplementation openPGPImplementation, Configuration configuration, PGPKeyPair pGPKeyPair) {
            this.implementation = openPGPImplementation;
            this.configuration = configuration;
            this.primaryKey = pGPKeyPair;
        }

        public WithPrimaryKey addUserId(String string) throws PGPException {
            return this.addUserId(string, null);
        }

        public WithPrimaryKey addUserId(String string, SignatureParameters.Callback callback) throws PGPException {
            if (string == null || string.trim().length() == 0) {
                throw new IllegalArgumentException("User-ID cannot be null or empty.");
            }
            SignatureParameters signatureParameters = Utils.applySignatureParameters(callback, SignatureParameters.certification(this.implementation.policy()));
            if (signatureParameters != null) {
                PGPSignatureGenerator pGPSignatureGenerator = Utils.getPgpSignatureGenerator(this.implementation, this.primaryKey.getPublicKey(), this.primaryKey.getPrivateKey(), signatureParameters, this.configuration.keyCreationTime, null);
                this.primaryKey = new PGPKeyPair(Utils.injectCertification(string, this.primaryKey.getPublicKey(), pGPSignatureGenerator), this.primaryKey.getPrivateKey());
            }
            return this;
        }

        public WithPrimaryKey addEncryptionSubkey() throws PGPException {
            return this.addEncryptionSubkey(KeyPairGeneratorCallback.encryptionKey());
        }

        public WithPrimaryKey addEncryptionSubkey(KeyPairGeneratorCallback keyPairGeneratorCallback) throws PGPException {
            return this.addEncryptionSubkey(keyPairGeneratorCallback, null);
        }

        public WithPrimaryKey addEncryptionSubkey(KeyPairGeneratorCallback keyPairGeneratorCallback, SignatureParameters.Callback callback) throws PGPException {
            PGPKeyPairGenerator pGPKeyPairGenerator = this.configuration.kpGenProvider.get(OpenPGPKeyGenerator.this.keyVersion, this.configuration.keyCreationTime);
            PGPKeyPair pGPKeyPair = keyPairGeneratorCallback.generateFrom(pGPKeyPairGenerator);
            pGPKeyPair = pGPKeyPair.asSubkey(this.implementation.keyFingerPrintCalculator());
            return this.addEncryptionSubkey(pGPKeyPair, callback);
        }

        public WithPrimaryKey addEncryptionSubkey(PGPKeyPair pGPKeyPair, SignatureParameters.Callback callback) throws PGPException {
            if (!(pGPKeyPair.getPublicKey().getPublicKeyPacket() instanceof PublicSubkeyPacket)) {
                throw new IllegalArgumentException("Encryption subkey MUST NOT consist of a primary key packet.");
            }
            if (!pGPKeyPair.getPublicKey().isEncryptionKey()) {
                throw new PGPException("Encryption key MUST use encryption-capable algorithm.");
            }
            pGPKeyPair = this.updateSubkey(pGPKeyPair, callback, new Utils.HashedSubpacketsOperation(){

                @Override
                public void operate(PGPSignatureSubpacketGenerator pGPSignatureSubpacketGenerator) throws PGPException {
                    pGPSignatureSubpacketGenerator = OpenPGPKeyGenerator.this.encryptionSubkeySubpackets.apply(pGPSignatureSubpacketGenerator);
                }
            });
            this.subkeys.add(pGPKeyPair);
            return this;
        }

        public WithPrimaryKey addSigningSubkey() throws PGPException {
            return this.addSigningSubkey(KeyPairGeneratorCallback.signingKey());
        }

        public WithPrimaryKey addSigningSubkey(KeyPairGeneratorCallback keyPairGeneratorCallback) throws PGPException {
            return this.addSigningSubkey(keyPairGeneratorCallback, null, null);
        }

        public WithPrimaryKey addSigningSubkey(KeyPairGeneratorCallback keyPairGeneratorCallback, SignatureParameters.Callback callback, SignatureParameters.Callback callback2) throws PGPException {
            PGPKeyPair pGPKeyPair = keyPairGeneratorCallback.generateFrom(this.configuration.kpGenProvider.get(OpenPGPKeyGenerator.this.keyVersion, this.configuration.keyCreationTime));
            pGPKeyPair = pGPKeyPair.asSubkey(this.configuration.keyFingerprintCalculator);
            return this.addSigningSubkey(pGPKeyPair, callback, callback2);
        }

        public WithPrimaryKey addSigningSubkey(PGPKeyPair pGPKeyPair, SignatureParameters.Callback callback, SignatureParameters.Callback callback2) throws PGPException {
            if (!(pGPKeyPair.getPublicKey().getPublicKeyPacket() instanceof PublicSubkeyPacket)) {
                throw new IllegalArgumentException("Signing subkey MUST NOT consist of primary key packet.");
            }
            if (!PublicKeyUtils.isSigningAlgorithm(pGPKeyPair.getPublicKey().getAlgorithm())) {
                throw new PGPException("Signing key MUST use signing-capable algorithm.");
            }
            SignatureParameters signatureParameters = Utils.applySignatureParameters(callback2, SignatureParameters.primaryKeyBinding(this.implementation.policy()));
            final PGPSignature pGPSignature = Utils.getBackSignature(pGPKeyPair, signatureParameters, this.primaryKey.getPublicKey(), this.implementation, this.configuration.keyCreationTime);
            pGPKeyPair = this.updateSubkey(pGPKeyPair, callback, new Utils.HashedSubpacketsOperation(){

                @Override
                public void operate(PGPSignatureSubpacketGenerator pGPSignatureSubpacketGenerator) throws PGPException {
                    pGPSignatureSubpacketGenerator = OpenPGPKeyGenerator.this.signingSubkeySubpackets.apply(pGPSignatureSubpacketGenerator);
                    Utils.addEmbeddedSiganture(pGPSignature, pGPSignatureSubpacketGenerator);
                }
            });
            this.subkeys.add(pGPKeyPair);
            return this;
        }

        public OpenPGPKey build() throws PGPException {
            return this.build(null);
        }

        public OpenPGPKey build(char[] cArray) throws PGPException {
            PBESecretKeyEncryptor pBESecretKeyEncryptor = this.configuration.keyEncryptorBuilderProvider.build(cArray, this.primaryKey.getPublicKey().getPublicKeyPacket());
            PGPSecretKey pGPSecretKey = new PGPSecretKey(this.primaryKey.getPrivateKey(), this.primaryKey.getPublicKey(), this.configuration.digestCalculatorProvider.get(2), true, pBESecretKeyEncryptor);
            this.sanitizeKeyEncryptor(pBESecretKeyEncryptor);
            ArrayList<PGPSecretKey> arrayList = new ArrayList<PGPSecretKey>();
            arrayList.add(pGPSecretKey);
            for (PGPKeyPair pGPKeyPair : this.subkeys) {
                PBESecretKeyEncryptor pBESecretKeyEncryptor2 = this.configuration.keyEncryptorBuilderProvider.build(cArray, pGPKeyPair.getPublicKey().getPublicKeyPacket());
                PGPSecretKey pGPSecretKey2 = new PGPSecretKey(pGPKeyPair.getPrivateKey(), pGPKeyPair.getPublicKey(), this.configuration.digestCalculatorProvider.get(2), false, pBESecretKeyEncryptor2);
                this.sanitizeKeyEncryptor(pBESecretKeyEncryptor2);
                arrayList.add(pGPSecretKey2);
            }
            if (cArray != null) {
                Arrays.fill(cArray, '\u0000');
            }
            PGPSecretKeyRing pGPSecretKeyRing = new PGPSecretKeyRing(arrayList);
            return new OpenPGPKey(pGPSecretKeyRing, this.implementation);
        }

        protected void sanitizeKeyEncryptor(PBESecretKeyEncryptor pBESecretKeyEncryptor) {
            if (pBESecretKeyEncryptor == null) {
                return;
            }
            S2K s2K = pBESecretKeyEncryptor.getS2K();
            if (s2K.getType() == 0 || s2K.getType() == 1) {
                throw new IllegalArgumentException("S2K specifiers SIMPLE and SALTED are not allowed for secret key encryption.");
            }
            if (s2K.getType() == 4 && pBESecretKeyEncryptor.getAeadAlgorithm() == 0) {
                throw new IllegalArgumentException("Argon2 MUST be used with AEAD.");
            }
        }

        private PGPKeyPair updateSubkey(PGPKeyPair pGPKeyPair, SignatureParameters.Callback callback, Utils.HashedSubpacketsOperation hashedSubpacketsOperation) throws PGPException {
            SignatureParameters signatureParameters = Utils.applySignatureParameters(callback, SignatureParameters.subkeyBinding(this.implementation.policy()).setSignatureCreationTime(this.configuration.keyCreationTime));
            if (signatureParameters != null) {
                PGPSignatureGenerator pGPSignatureGenerator = Utils.getPgpSignatureGenerator(this.implementation, this.primaryKey.getPublicKey(), this.primaryKey.getPrivateKey(), signatureParameters, signatureParameters.getSignatureCreationTime(), hashedSubpacketsOperation);
                PGPPublicKey pGPPublicKey = Utils.injectCertification(pGPKeyPair.getPublicKey(), pGPSignatureGenerator, this.primaryKey.getPublicKey());
                pGPKeyPair = new PGPKeyPair(pGPPublicKey, pGPKeyPair.getPrivateKey());
            }
            return pGPKeyPair;
        }
    }
}

