/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.execution.serviceView;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.platform.ide.productMode.IdeProductMode;
import java.lang.invoke.MethodHandles;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\n\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\u001a\b\u0010\u0000\u001a\u00020\u0001H\u0007\u001a\b\u0010\u0002\u001a\u00020\u0001H\u0002\u001a\b\u0010\u0003\u001a\u00020\u0001H\u0002\u001a\b\u0010\u0004\u001a\u00020\u0001H\u0007\u001a\b\u0010\u0005\u001a\u00020\u0001H\u0007\u001a\b\u0010\u0006\u001a\u00020\u0001H\u0002\u001a\b\u0010\u0007\u001a\u00020\u0001H\u0007\u00a8\u0006\b"}, d2={"shouldEnableServicesViewInCurrentEnvironment", "", "isBackendAndMonolithRegistryEnabled", "isFrontendAndSplitRegistryEnabled", "isNewFrontendServiceViewEnabled", "isOldMonolithServiceViewEnabled", "isSplitDebuggerEnabledInTestsCopyPaste", "isShowLuxedRunToolwindowInServicesView", "intellij.platform.execution.serviceView"})
@SourceDebugExtension(value={"SMAP\nserviceViewImplementationChooser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 serviceViewImplementationChooser.kt\ncom/intellij/platform/execution/serviceView/ServiceViewImplementationChooserKt\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,58:1\n57#2:59\n35#2,2:60\n*S KotlinDebug\n*F\n+ 1 serviceViewImplementationChooser.kt\ncom/intellij/platform/execution/serviceView/ServiceViewImplementationChooserKt\n*L\n19#1:59\n19#1:60,2\n*E\n"})
public final class ServiceViewImplementationChooserKt {
    @ApiStatus.Internal
    public static final boolean shouldEnableServicesViewInCurrentEnvironment() {
        boolean isServicesEnabled = ServiceViewImplementationChooserKt.isFrontendAndSplitRegistryEnabled() ? true : (ServiceViewImplementationChooserKt.isBackendAndMonolithRegistryEnabled() ? true : IdeProductMode.Companion.isMonolith());
        boolean $i$f$fileLogger = false;
        boolean $i$f$currentClassLogger = false;
        Class<?> clazz$iv$iv = MethodHandles.lookup().lookupClass();
        Logger logger = Logger.getInstance(clazz$iv$iv);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.debug("Services implementation is " + (isServicesEnabled ? "enabled" : "disabled") + " in current environment. Is frontend: " + IdeProductMode.Companion.isFrontend() + ", is monolith: " + IdeProductMode.Companion.isMonolith() + ", is backend: " + IdeProductMode.Companion.isBackend() + ".");
        return isServicesEnabled;
    }

    private static final boolean isBackendAndMonolithRegistryEnabled() {
        return IdeProductMode.Companion.isBackend() && ServiceViewImplementationChooserKt.isOldMonolithServiceViewEnabled();
    }

    private static final boolean isFrontendAndSplitRegistryEnabled() {
        return IdeProductMode.Companion.isFrontend() && ServiceViewImplementationChooserKt.isNewFrontendServiceViewEnabled();
    }

    @ApiStatus.Internal
    public static final boolean isNewFrontendServiceViewEnabled() {
        if (ServiceViewImplementationChooserKt.isSplitDebuggerEnabledInTestsCopyPaste()) {
            return true;
        }
        return Registry.Companion.is("services.view.split.enabled");
    }

    @ApiStatus.Internal
    public static final boolean isOldMonolithServiceViewEnabled() {
        if (ServiceViewImplementationChooserKt.isSplitDebuggerEnabledInTestsCopyPaste()) {
            return false;
        }
        return Registry.Companion.is("services.view.monolith.enabled");
    }

    private static final boolean isSplitDebuggerEnabledInTestsCopyPaste() {
        String testProperty;
        String string = testProperty = System.getProperty("xdebugger.toolwindow.split.for.tests");
        return string != null ? Boolean.parseBoolean(string) : false;
    }

    @ApiStatus.Internal
    public static final boolean isShowLuxedRunToolwindowInServicesView() {
        return Registry.Companion.is("services.view.split.run.luxing.enabled", true);
    }
}

