/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.animation.core;

import androidx.collection.IntList;
import androidx.collection.IntObjectMap;
import androidx.collection.MutableIntList;
import androidx.collection.MutableIntObjectMap;
import androidx.compose.animation.core.AnimationVector;
import androidx.compose.animation.core.AnimationVectorsKt;
import androidx.compose.animation.core.ArcMode;
import androidx.compose.animation.core.ArcSpline;
import androidx.compose.animation.core.Easing;
import androidx.compose.animation.core.EasingKt;
import androidx.compose.animation.core.VectorizedAnimationSpecKt;
import androidx.compose.animation.core.VectorizedDurationBasedAnimationSpec;
import androidx.compose.animation.core.VectorizedKeyframeSpecElementInfo;
import androidx.compose.runtime.internal.StabilityInferred;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u0014\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0007\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003BE\b\u0000\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0011B;\b\u0016\u0012\u001e\u0010\u0006\u001a\u001a\u0012\u0004\u0012\u00020\n\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\r0\u00130\u0012\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\u0010\u0010\u0014J%\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00028\u00002\u0006\u0010)\u001a\u00028\u00002\u0006\u0010*\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010+J-\u0010,\u001a\u00028\u00002\u0006\u0010-\u001a\u00020.2\u0006\u0010(\u001a\u00028\u00002\u0006\u0010)\u001a\u00028\u00002\u0006\u0010*\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010/J-\u00100\u001a\u00028\u00002\u0006\u0010-\u001a\u00020.2\u0006\u0010(\u001a\u00028\u00002\u0006\u0010)\u001a\u00028\u00002\u0006\u0010*\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010/J\u0010\u00101\u001a\u0002022\u0006\u00103\u001a\u00020\nH\u0002J \u00104\u001a\u0002022\u0006\u00105\u001a\u00020\n2\u0006\u00103\u001a\u00020\n2\u0006\u00106\u001a\u000207H\u0002J\u0010\u00108\u001a\u00020\n2\u0006\u00103\u001a\u00020\nH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u000b\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0016R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0018R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u001d\u001a\u0004\u0018\u00018\u0000X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u001eR\u0012\u0010\u001f\u001a\u0004\u0018\u00018\u0000X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u001eR\u0012\u0010 \u001a\u0004\u0018\u00018\u0000X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u001eR\u0012\u0010!\u001a\u0004\u0018\u00018\u0000X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u001eR\u000e\u0010\"\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020%X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Landroidx/compose/animation/core/VectorizedKeyframesSpec;", "V", "Landroidx/compose/animation/core/AnimationVector;", "Landroidx/compose/animation/core/VectorizedDurationBasedAnimationSpec;", "timestamps", "Landroidx/collection/IntList;", "keyframes", "Landroidx/collection/IntObjectMap;", "Landroidx/compose/animation/core/VectorizedKeyframeSpecElementInfo;", "durationMillis", "", "delayMillis", "defaultEasing", "Landroidx/compose/animation/core/Easing;", "initialArcMode", "Landroidx/compose/animation/core/ArcMode;", "<init>", "(Landroidx/collection/IntList;Landroidx/collection/IntObjectMap;IILandroidx/compose/animation/core/Easing;ILkotlin/jvm/internal/DefaultConstructorMarker;)V", "", "Lkotlin/Pair;", "(Ljava/util/Map;II)V", "getDurationMillis", "()I", "getDelayMillis", "I", "modes", "", "times", "", "valueVector", "Landroidx/compose/animation/core/AnimationVector;", "velocityVector", "lastInitialValue", "lastTargetValue", "posArray", "slopeArray", "arcSpline", "Landroidx/compose/animation/core/ArcSpline;", "init", "", "initialValue", "targetValue", "initialVelocity", "(Landroidx/compose/animation/core/AnimationVector;Landroidx/compose/animation/core/AnimationVector;Landroidx/compose/animation/core/AnimationVector;)V", "getValueFromNanos", "playTimeNanos", "", "(JLandroidx/compose/animation/core/AnimationVector;Landroidx/compose/animation/core/AnimationVector;Landroidx/compose/animation/core/AnimationVector;)Landroidx/compose/animation/core/AnimationVector;", "getVelocityFromNanos", "getEasedTime", "", "timeMillis", "getEasedTimeFromIndex", "index", "asFraction", "", "findEntryForTimeMillis", "animation-core"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nVectorizedAnimationSpec.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VectorizedAnimationSpec.kt\nandroidx/compose/animation/core/VectorizedKeyframesSpec\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 IntList.kt\nandroidx/collection/IntList\n+ 4 VectorConverters.kt\nandroidx/compose/animation/core/VectorConvertersKt\n*L\n1#1,1038:1\n216#2,2:1039\n216#2,2:1041\n65#3:1043\n65#3:1044\n65#3:1045\n70#3:1047\n71#4:1046\n*S KotlinDebug\n*F\n+ 1 VectorizedAnimationSpec.kt\nandroidx/compose/animation/core/VectorizedKeyframesSpec\n*L\n246#1:1039,2\n259#1:1041,2\n301#1:1043\n304#1:1044\n335#1:1045\n469#1:1047\n418#1:1046\n*E\n"})
public final class VectorizedKeyframesSpec<V extends AnimationVector>
implements VectorizedDurationBasedAnimationSpec<V> {
    @NotNull
    private final IntList timestamps;
    @NotNull
    private final IntObjectMap<VectorizedKeyframeSpecElementInfo<V>> keyframes;
    private final int durationMillis;
    private final int delayMillis;
    @NotNull
    private final Easing defaultEasing;
    private final int initialArcMode;
    @NotNull
    private int[] modes;
    @NotNull
    private float[] times;
    @Nullable
    private V valueVector;
    @Nullable
    private V velocityVector;
    @Nullable
    private V lastInitialValue;
    @Nullable
    private V lastTargetValue;
    @NotNull
    private float[] posArray;
    @NotNull
    private float[] slopeArray;
    @NotNull
    private ArcSpline arcSpline;
    public static final int $stable = 8;

    private VectorizedKeyframesSpec(IntList timestamps, IntObjectMap<VectorizedKeyframeSpecElementInfo<V>> keyframes, int durationMillis, int delayMillis, Easing defaultEasing, int initialArcMode) {
        Intrinsics.checkNotNullParameter((Object)timestamps, (String)"timestamps");
        Intrinsics.checkNotNullParameter(keyframes, (String)"keyframes");
        Intrinsics.checkNotNullParameter((Object)defaultEasing, (String)"defaultEasing");
        this.timestamps = timestamps;
        this.keyframes = keyframes;
        this.durationMillis = durationMillis;
        this.delayMillis = delayMillis;
        this.defaultEasing = defaultEasing;
        this.initialArcMode = initialArcMode;
        this.modes = VectorizedAnimationSpecKt.access$getEmptyIntArray$p();
        this.times = VectorizedAnimationSpecKt.access$getEmptyFloatArray$p();
        this.posArray = VectorizedAnimationSpecKt.access$getEmptyFloatArray$p();
        this.slopeArray = VectorizedAnimationSpecKt.access$getEmptyFloatArray$p();
        this.arcSpline = VectorizedAnimationSpecKt.access$getEmptyArcSpline$p();
    }

    @Override
    public int getDurationMillis() {
        return this.durationMillis;
    }

    @Override
    public int getDelayMillis() {
        return this.delayMillis;
    }

    public VectorizedKeyframesSpec(@NotNull Map<Integer, ? extends Pair<? extends V, ? extends Easing>> keyframes, int durationMillis, int delayMillis) {
        Map.Entry<Integer, Pair<Pair<Pair<Pair<Pair<Pair<Pair<Pair<V, Easing>, Easing>, Easing>, Easing>, Easing>, Easing>, Easing>, Easing>> entry;
        Map.Entry<Integer, Pair<Pair<Pair<Pair<Pair<Pair<Pair<Pair<V, Easing>, Easing>, Easing>, Easing>, Easing>, Easing>, Easing>, Easing>> element$iv;
        Intrinsics.checkNotNullParameter(keyframes, (String)"keyframes");
        VectorizedKeyframesSpec<V> vectorizedKeyframesSpec = this;
        boolean bl = false;
        MutableIntList times = new MutableIntList(keyframes.size() + 2);
        Map<Integer, Pair<Pair<V, Easing>, Easing>> $this$forEach$iv = keyframes;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<Integer, Pair<V, Easing>>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            entry = element$iv = iterator2.next();
            boolean bl2 = false;
            int t = ((Number)entry.getKey()).intValue();
            times.add(t);
        }
        if (!keyframes.containsKey(0)) {
            times.add(0, 0);
        }
        if (!keyframes.containsKey(durationMillis)) {
            times.add(durationMillis);
        }
        times.sort();
        IntList intList = times;
        boolean bl3 = false;
        MutableIntObjectMap timeToInfoMap = new MutableIntObjectMap(0, 1, null);
        $this$forEach$iv = keyframes;
        $i$f$forEach = false;
        iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            entry = element$iv = iterator2.next();
            boolean bl4 = false;
            int time = ((Number)entry.getKey()).intValue();
            Pair<? extends Pair<? extends V, ? extends Easing>, Easing> valueEasing = entry.getValue();
            timeToInfoMap.set(time, new VectorizedKeyframeSpecElementInfo((AnimationVector)valueEasing.getFirst(), (Easing)valueEasing.getSecond(), ArcMode.Companion.getArcLinear--9T-Mq4(), null));
        }
        MutableIntObjectMap mutableIntObjectMap = timeToInfoMap;
        vectorizedKeyframesSpec(intList, mutableIntObjectMap, durationMillis, delayMillis, EasingKt.getLinearEasing(), ArcMode.Companion.getArcLinear--9T-Mq4(), null);
    }

    public /* synthetic */ VectorizedKeyframesSpec(Map map, int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 4) != 0) {
            n2 = 0;
        }
        this(map, n, n2);
    }

    private final void init(V initialValue, V targetValue2, V initialVelocity) {
        int n;
        Object object;
        boolean requiresArcSpline;
        boolean bl = requiresArcSpline = this.arcSpline != VectorizedAnimationSpecKt.access$getEmptyArcSpline$p();
        if (this.valueVector == null) {
            this.valueVector = AnimationVectorsKt.newInstance(initialValue);
            this.velocityVector = AnimationVectorsKt.newInstance(initialVelocity);
            int n2 = 0;
            Object this_$iv = this.timestamps;
            int $i$f$getSize = 0;
            int n3 = ((IntList)this_$iv)._size;
            this_$iv = new float[n3];
            object = this;
            while (n2 < n3) {
                $i$f$getSize = n2++;
                this_$iv[$i$f$getSize] = (float)this.timestamps.get($i$f$getSize) / (float)1000L;
            }
            ((VectorizedKeyframesSpec)object).times = (float[])this_$iv;
            this_$iv = this.timestamps;
            $i$f$getSize = 0;
            n3 = ((IntList)this_$iv)._size;
            int[] nArray = new int[n3];
            object = this;
            for (n2 = 0; n2 < n3; ++n2) {
                int mode;
                n = n2;
                VectorizedKeyframeSpecElementInfo<V> vectorizedKeyframeSpecElementInfo = this.keyframes.get(this.timestamps.get(n));
                int n4 = mode = vectorizedKeyframeSpecElementInfo != null ? vectorizedKeyframeSpecElementInfo.getArcMode--9T-Mq4() : this.initialArcMode;
                if (!ArcMode.equals-impl0(mode, ArcMode.Companion.getArcLinear--9T-Mq4())) {
                    requiresArcSpline = true;
                }
                nArray[n] = mode;
            }
            ((VectorizedKeyframesSpec)object).modes = nArray;
        }
        if (!requiresArcSpline) {
            return;
        }
        if (this.arcSpline == VectorizedAnimationSpecKt.access$getEmptyArcSpline$p() || !Intrinsics.areEqual(this.lastInitialValue, initialValue) || !Intrinsics.areEqual(this.lastTargetValue, targetValue2)) {
            this.lastInitialValue = initialValue;
            this.lastTargetValue = targetValue2;
            int dimensionCount = ((AnimationVector)initialValue).getSize$animation_core() % 2 + ((AnimationVector)initialValue).getSize$animation_core();
            this.posArray = new float[dimensionCount];
            this.slopeArray = new float[dimensionCount];
            IntList this_$iv = this.timestamps;
            boolean $i$f$getSize = false;
            n = this_$iv._size;
            float[][] fArrayArray = new float[n][];
            for (int i = 0; i < n; ++i) {
                float[] fArray;
                int n5;
                Object object2;
                int n6;
                int n7 = i;
                int timestamp = this.timestamps.get(n7);
                VectorizedKeyframeSpecElementInfo<V> info = this.keyframes.get(timestamp);
                if (timestamp == 0 && info == null) {
                    int n8 = 0;
                    float[] fArray2 = new float[dimensionCount];
                    n6 = n7;
                    object = fArrayArray;
                    while (n8 < dimensionCount) {
                        int n9 = n8++;
                        fArray2[n9] = ((AnimationVector)initialValue).get$animation_core(n9);
                    }
                    object2 = object;
                    n5 = n6;
                    fArray = fArray2;
                } else if (timestamp == this.getDurationMillis() && info == null) {
                    int n10 = 0;
                    float[] fArray3 = new float[dimensionCount];
                    object = fArrayArray;
                    while (n10 < dimensionCount) {
                        int n11 = n10++;
                        fArray3[n11] = ((AnimationVector)targetValue2).get$animation_core(n11);
                    }
                    object2 = object;
                    n5 = n6;
                    fArray = fArray3;
                } else {
                    VectorizedKeyframeSpecElementInfo<V> vectorizedKeyframeSpecElementInfo = info;
                    Intrinsics.checkNotNull(vectorizedKeyframeSpecElementInfo);
                    V vectorValue = vectorizedKeyframeSpecElementInfo.getVectorValue();
                    int n12 = 0;
                    float[] fArray4 = new float[dimensionCount];
                    object = fArrayArray;
                    while (n12 < dimensionCount) {
                        int n13 = n12++;
                        fArray4[n13] = ((AnimationVector)vectorValue).get$animation_core(n13);
                    }
                    object2 = object;
                    n5 = n6;
                    fArray = fArray4;
                }
                object2[n5] = fArray;
            }
            float[][] values = fArrayArray;
            this.arcSpline = new ArcSpline(this.modes, this.times, values);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public V getValueFromNanos(long playTimeNanos, @NotNull V initialValue, @NotNull V targetValue2, @NotNull V initialVelocity) {
        int timestampEnd;
        VectorizedKeyframeSpecElementInfo<V> endKeyframe;
        VectorizedKeyframeSpecElementInfo<V> vectorizedKeyframeSpecElementInfo;
        VectorizedKeyframeSpecElementInfo<V> startValue;
        Intrinsics.checkNotNullParameter(initialValue, (String)"initialValue");
        Intrinsics.checkNotNullParameter(targetValue2, (String)"targetValue");
        Intrinsics.checkNotNullParameter(initialVelocity, (String)"initialVelocity");
        long playTimeMillis = playTimeNanos / 1000000L;
        int clampedPlayTime = (int)VectorizedAnimationSpecKt.clampPlayTime(this, playTimeMillis);
        VectorizedKeyframeSpecElementInfo<V> keyframe = this.keyframes.get(clampedPlayTime);
        if (keyframe != null) {
            return keyframe.getVectorValue();
        }
        if (clampedPlayTime >= this.getDurationMillis()) {
            return targetValue2;
        }
        if (clampedPlayTime <= 0) {
            return initialValue;
        }
        this.init(initialValue, targetValue2, initialVelocity);
        V v = this.valueVector;
        Intrinsics.checkNotNull(v);
        V valueVector = v;
        if (this.arcSpline != VectorizedAnimationSpecKt.access$getEmptyArcSpline$p()) {
            float easedTime = this.getEasedTime(clampedPlayTime);
            float[] posArray = this.posArray;
            this.arcSpline.getPos(easedTime, posArray);
            int n = posArray.length;
            for (int i = 0; i < n; ++i) {
                ((AnimationVector)valueVector).set$animation_core(i, posArray[i]);
            }
            return valueVector;
        }
        int index2 = this.findEntryForTimeMillis(clampedPlayTime);
        float easedTime = this.getEasedTimeFromIndex(index2, clampedPlayTime, true);
        int timestampStart = this.timestamps.get(index2);
        VectorizedKeyframeSpecElementInfo<V> startKeyframe = this.keyframes.get(timestampStart);
        VectorizedKeyframeSpecElementInfo<V> vectorizedKeyframeSpecElementInfo2 = startKeyframe;
        if (vectorizedKeyframeSpecElementInfo2 == null || (vectorizedKeyframeSpecElementInfo2 = vectorizedKeyframeSpecElementInfo2.getVectorValue()) == null) {
            vectorizedKeyframeSpecElementInfo2 = startValue = initialValue;
        }
        if ((vectorizedKeyframeSpecElementInfo = (endKeyframe = this.keyframes.get(timestampEnd = this.timestamps.get(index2 + 1)))) == null || (vectorizedKeyframeSpecElementInfo = vectorizedKeyframeSpecElementInfo.getVectorValue()) == null) {
            vectorizedKeyframeSpecElementInfo = targetValue2;
        }
        VectorizedKeyframeSpecElementInfo<V> endValue = vectorizedKeyframeSpecElementInfo;
        int n = ((AnimationVector)valueVector).getSize$animation_core();
        for (int i = 0; i < n; ++i) {
            void stop$iv;
            void start$iv;
            float f = ((AnimationVector)((Object)startValue)).get$animation_core(i);
            float f2 = ((AnimationVector)((Object)endValue)).get$animation_core(i);
            float fraction$iv = easedTime;
            boolean $i$f$lerp = false;
            ((AnimationVector)valueVector).set$animation_core(i, (float)(start$iv * (1.0f - fraction$iv) + stop$iv * fraction$iv));
        }
        return valueVector;
    }

    @Override
    @NotNull
    public V getVelocityFromNanos(long playTimeNanos, @NotNull V initialValue, @NotNull V targetValue2, @NotNull V initialVelocity) {
        Intrinsics.checkNotNullParameter(initialValue, (String)"initialValue");
        Intrinsics.checkNotNullParameter(targetValue2, (String)"targetValue");
        Intrinsics.checkNotNullParameter(initialVelocity, (String)"initialVelocity");
        long playTimeMillis = playTimeNanos / 1000000L;
        long clampedPlayTime = VectorizedAnimationSpecKt.clampPlayTime(this, playTimeMillis);
        if (clampedPlayTime < 0L) {
            return initialVelocity;
        }
        this.init(initialValue, targetValue2, initialVelocity);
        V v = this.velocityVector;
        Intrinsics.checkNotNull(v);
        V velocityVector = v;
        if (this.arcSpline != VectorizedAnimationSpecKt.access$getEmptyArcSpline$p()) {
            float easedTime = this.getEasedTime((int)clampedPlayTime);
            float[] slopeArray = this.slopeArray;
            this.arcSpline.getSlope(easedTime, slopeArray);
            int n = slopeArray.length;
            for (int i = 0; i < n; ++i) {
                ((AnimationVector)velocityVector).set$animation_core(i, slopeArray[i]);
            }
            return velocityVector;
        }
        V startNum = VectorizedAnimationSpecKt.getValueFromMillis(this, clampedPlayTime - 1L, initialValue, targetValue2, initialVelocity);
        V endNum = VectorizedAnimationSpecKt.getValueFromMillis(this, clampedPlayTime, initialValue, targetValue2, initialVelocity);
        int n = ((AnimationVector)startNum).getSize$animation_core();
        for (int i = 0; i < n; ++i) {
            ((AnimationVector)velocityVector).set$animation_core(i, (((AnimationVector)startNum).get$animation_core(i) - ((AnimationVector)endNum).get$animation_core(i)) * 1000.0f);
        }
        return velocityVector;
    }

    private final float getEasedTime(int timeMillis) {
        int index2 = this.findEntryForTimeMillis(timeMillis);
        return this.getEasedTimeFromIndex(index2, timeMillis, false);
    }

    private final float getEasedTimeFromIndex(int index2, int timeMillis, boolean asFraction) {
        IntList this_$iv = this.timestamps;
        boolean $i$f$getLastIndex = false;
        if (index2 >= this_$iv._size - 1) {
            return (float)timeMillis / (float)1000L;
        }
        int timeMin = this.timestamps.get(index2);
        int timeMax = this.timestamps.get(index2 + 1);
        if (timeMillis == timeMin) {
            return (float)timeMin / (float)1000L;
        }
        int timeRange = timeMax - timeMin;
        VectorizedKeyframeSpecElementInfo<V> vectorizedKeyframeSpecElementInfo = this.keyframes.get(timeMin);
        if (vectorizedKeyframeSpecElementInfo == null || (vectorizedKeyframeSpecElementInfo = vectorizedKeyframeSpecElementInfo.getEasing()) == null) {
            vectorizedKeyframeSpecElementInfo = this.defaultEasing;
        }
        VectorizedKeyframeSpecElementInfo<V> easing = vectorizedKeyframeSpecElementInfo;
        float rawFraction = (float)(timeMillis - timeMin) / (float)timeRange;
        float easedFraction = easing.transform(rawFraction);
        if (asFraction) {
            return easedFraction;
        }
        return ((float)timeRange * easedFraction + (float)timeMin) / (float)1000L;
    }

    private final int findEntryForTimeMillis(int timeMillis) {
        int index2 = IntList.binarySearch$default(this.timestamps, timeMillis, 0, 0, 6, null);
        return index2 < -1 ? -(index2 + 2) : index2;
    }

    public /* synthetic */ VectorizedKeyframesSpec(IntList timestamps, IntObjectMap keyframes, int durationMillis, int delayMillis, Easing defaultEasing, int initialArcMode, DefaultConstructorMarker $constructor_marker) {
        this(timestamps, keyframes, durationMillis, delayMillis, defaultEasing, initialArcMode);
    }
}

