/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.text.input.internal.undo;

import androidx.compose.foundation.internal.InlineClassHelperKt;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.runtime.saveable.Saver;
import androidx.compose.runtime.saveable.SaverScope;
import androidx.compose.runtime.snapshots.SnapshotStateList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\b\b\u0001\u0018\u0000 \u001e*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0001\u001eB1\u0012\u000e\b\u0002\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0013\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0019J\u000b\u0010\u001a\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u001bJ\u000b\u0010\u001c\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u001bJ\u0006\u0010\u001d\u001a\u00020\u0017R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000e8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u000e8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0010R\u0011\u0010\u0013\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001f"}, d2={"Landroidx/compose/foundation/text/input/internal/undo/UndoManager;", "T", "", "initialUndoStack", "", "initialRedoStack", "capacity", "", "<init>", "(Ljava/util/List;Ljava/util/List;I)V", "undoStack", "Landroidx/compose/runtime/snapshots/SnapshotStateList;", "redoStack", "canUndo", "", "getCanUndo$foundation", "()Z", "canRedo", "getCanRedo$foundation", "size", "getSize", "()I", "record", "", "undoableAction", "(Ljava/lang/Object;)V", "undo", "()Ljava/lang/Object;", "redo", "clearHistory", "Companion", "foundation"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nUndoManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UndoManager.kt\nandroidx/compose/foundation/text/input/internal/undo/UndoManager\n+ 2 InlineClassHelper.kt\nandroidx/compose/foundation/internal/InlineClassHelperKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,161:1\n97#2,4:162\n97#2,4:166\n51#2,4:171\n51#2,4:175\n1#3:170\n*S KotlinDebug\n*F\n+ 1 UndoManager.kt\nandroidx/compose/foundation/text/input/internal/undo/UndoManager\n*L\n42#1:162,4\n43#1:166,4\n77#1:171,4\n95#1:175,4\n*E\n"})
public final class UndoManager<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int capacity;
    @NotNull
    private SnapshotStateList<T> undoStack;
    @NotNull
    private SnapshotStateList<T> redoStack;
    public static final int $stable = 8;

    /*
     * WARNING - void declaration
     */
    public UndoManager(@NotNull List<? extends T> initialUndoStack, @NotNull List<? extends T> initialRedoStack, int capacity) {
        void $this$redoStack_u24lambda_u243;
        SnapshotStateList $this$undoStack_u24lambda_u242;
        SnapshotStateList snapshotStateList;
        Intrinsics.checkNotNullParameter(initialUndoStack, (String)"initialUndoStack");
        Intrinsics.checkNotNullParameter(initialRedoStack, (String)"initialRedoStack");
        this.capacity = capacity;
        boolean value$iv = this.capacity >= 0;
        boolean $i$f$requirePrecondition = false;
        if (!value$iv) {
            boolean bl = false;
            InlineClassHelperKt.throwIllegalArgumentException("Capacity must be a positive integer");
        }
        value$iv = initialRedoStack.size() + initialUndoStack.size() <= this.capacity;
        $i$f$requirePrecondition = false;
        if (!value$iv) {
            boolean bl = false;
            InlineClassHelperKt.throwIllegalArgumentException("Initial list of undo and redo operations have a size greater than the given capacity.");
        }
        SnapshotStateList $i$f$requirePrecondition2 = snapshotStateList = new SnapshotStateList();
        UndoManager undoManager = this;
        boolean bl = false;
        $this$undoStack_u24lambda_u242.addAll((Collection)initialUndoStack);
        undoManager.undoStack = snapshotStateList;
        $this$undoStack_u24lambda_u242 = snapshotStateList = new SnapshotStateList();
        undoManager = this;
        boolean bl2 = false;
        $this$redoStack_u24lambda_u243.addAll((Collection)initialRedoStack);
        undoManager.redoStack = snapshotStateList;
    }

    public /* synthetic */ UndoManager(List list, List list2, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n2 & 2) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        if ((n2 & 4) != 0) {
            n = 100;
        }
        this(list, list2, n);
    }

    public final boolean getCanUndo$foundation() {
        return !((Collection)this.undoStack).isEmpty();
    }

    public final boolean getCanRedo$foundation() {
        return !((Collection)this.redoStack).isEmpty();
    }

    public final int getSize() {
        return this.undoStack.size() + this.redoStack.size();
    }

    public final void record(T undoableAction) {
        this.redoStack.clear();
        while (this.getSize() > this.capacity - 1) {
            CollectionsKt.removeFirst((List)((List)this.undoStack));
        }
        this.undoStack.add(undoableAction);
    }

    public final T undo() {
        boolean value$iv = this.getCanUndo$foundation();
        boolean $i$f$checkPrecondition = false;
        if (!value$iv) {
            boolean bl = false;
            InlineClassHelperKt.throwIllegalStateException("It's an error to call undo while there is nothing to undo. Please first check `canUndo` value before calling the `undo` function.");
        }
        Object topOperation = CollectionsKt.removeLast((List)((List)this.undoStack));
        this.redoStack.add(topOperation);
        return (T)topOperation;
    }

    public final T redo() {
        boolean value$iv = this.getCanRedo$foundation();
        boolean $i$f$checkPrecondition = false;
        if (!value$iv) {
            boolean bl = false;
            InlineClassHelperKt.throwIllegalStateException("It's an error to call redo while there is nothing to redo. Please first check `canRedo` value before calling the `redo` function.");
        }
        Object topOperation = CollectionsKt.removeLast((List)((List)this.redoStack));
        this.undoStack.add(topOperation);
        return (T)topOperation;
    }

    public final void clearHistory() {
        this.undoStack.clear();
        this.redoStack.clear();
    }

    public UndoManager() {
        this(null, null, 0, 7, null);
    }

    public static final /* synthetic */ int access$getCapacity$p(UndoManager $this) {
        return $this.capacity;
    }

    public static final /* synthetic */ SnapshotStateList access$getUndoStack$p(UndoManager $this) {
        return $this.undoStack;
    }

    public static final /* synthetic */ SnapshotStateList access$getRedoStack$p(UndoManager $this) {
        return $this.redoStack;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J7\u0010\u0004\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00070\u0006\u0012\u0004\u0012\u00020\u00010\u0005\"\u0006\b\u0001\u0010\u0007\u0018\u00012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u0002H\u0007\u0012\u0004\u0012\u00020\u00010\u0005H\u0086\b\u00a8\u0006\t"}, d2={"Landroidx/compose/foundation/text/input/internal/undo/UndoManager$Companion;", "", "<init>", "()V", "createSaver", "Landroidx/compose/runtime/saveable/Saver;", "Landroidx/compose/foundation/text/input/internal/undo/UndoManager;", "T", "itemSaver", "foundation"})
    public static final class Companion {
        private Companion() {
        }

        public final /* synthetic */ <T> Saver<UndoManager<T>, Object> createSaver(Saver<T, Object> itemSaver) {
            Intrinsics.checkNotNullParameter(itemSaver, (String)"itemSaver");
            boolean $i$f$createSaver = false;
            Intrinsics.needClassReification();
            return new Saver<UndoManager<T>, Object>(itemSaver){
                final /* synthetic */ Saver<T, Object> $itemSaver;
                {
                    this.$itemSaver = $itemSaver;
                }

                public Object save(SaverScope $this$save, UndoManager<T> value) {
                    E it;
                    E item$iv;
                    int index$iv;
                    List list;
                    Intrinsics.checkNotNullParameter((Object)$this$save, (String)"<this>");
                    Intrinsics.checkNotNullParameter(value, (String)"value");
                    Saver<T, Object> saver = this.$itemSaver;
                    List $this$save_u24lambda_u244 = list = CollectionsKt.createListBuilder();
                    boolean bl = false;
                    $this$save_u24lambda_u244.add(UndoManager.access$getCapacity$p(value));
                    $this$save_u24lambda_u244.add(UndoManager.access$getUndoStack$p(value).size());
                    $this$save_u24lambda_u244.add(UndoManager.access$getRedoStack$p(value).size());
                    List $this$fastForEach$iv = (List)UndoManager.access$getUndoStack$p(value);
                    boolean $i$f$fastForEach = false;
                    int n = ((Collection)$this$fastForEach$iv).size();
                    for (index$iv = 0; index$iv < n; ++index$iv) {
                        it = item$iv = $this$fastForEach$iv.get(index$iv);
                        boolean bl2 = false;
                        Saver<T, Object> $this$save_u24lambda_u244_u24lambda_u241_u24lambda_u240 = saver;
                        boolean bl3 = false;
                        $this$save_u24lambda_u244.add($this$save_u24lambda_u244_u24lambda_u241_u24lambda_u240.save($this$save, it));
                    }
                    $this$fastForEach$iv = (List)UndoManager.access$getRedoStack$p(value);
                    $i$f$fastForEach = false;
                    n = ((Collection)$this$fastForEach$iv).size();
                    for (index$iv = 0; index$iv < n; ++index$iv) {
                        it = item$iv = $this$fastForEach$iv.get(index$iv);
                        boolean bl4 = false;
                        Saver<T, Object> $this$save_u24lambda_u244_u24lambda_u243_u24lambda_u242 = saver;
                        boolean bl5 = false;
                        $this$save_u24lambda_u244.add($this$save_u24lambda_u244_u24lambda_u243_u24lambda_u242.save($this$save, it));
                    }
                    return CollectionsKt.build((List)list);
                }

                public UndoManager<T> restore(Object value) {
                    List list;
                    List list2;
                    Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                    List list3 = list2 = (List)value;
                    int capacity = ((Number)list3.get(0)).intValue();
                    int undoSize = ((Number)list3.get(1)).intValue();
                    int redoSize = ((Number)list3.get(2)).intValue();
                    int i = 0;
                    Saver<T, Object> saver = this.$itemSaver;
                    Object object = CollectionsKt.createListBuilder();
                    List $this$restore_u24lambda_u245 = object;
                    boolean bl = false;
                    for (i = 3; i < undoSize + 3; ++i) {
                        T t = saver.restore(list2.get(i));
                        Intrinsics.checkNotNull(t);
                        $this$restore_u24lambda_u245.add(t);
                    }
                    List undoStackItems = CollectionsKt.build((List)object);
                    object = this.$itemSaver;
                    List $this$restore_u24lambda_u246 = list = CollectionsKt.createListBuilder();
                    boolean bl2 = false;
                    while (i < undoSize + redoSize + 3) {
                        Original Original = object.restore(list2.get(i));
                        Intrinsics.checkNotNull(Original);
                        $this$restore_u24lambda_u246.add(Original);
                        ++i;
                    }
                    List redoStackItems = CollectionsKt.build((List)list);
                    return new UndoManager<T>(undoStackItems, redoStackItems, capacity);
                }
            };
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

