/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.text.selection;

import androidx.collection.LongIntMap;
import androidx.collection.LongObjectMap;
import androidx.collection.LongObjectMapKt;
import androidx.collection.MutableLongObjectMap;
import androidx.compose.foundation.internal.InlineClassHelperKt;
import androidx.compose.foundation.text.selection.CrossStatus;
import androidx.compose.foundation.text.selection.SelectableInfo;
import androidx.compose.foundation.text.selection.Selection;
import androidx.compose.foundation.text.selection.SelectionLayout;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\t\n\u0000\b\u0002\u0018\u00002\u00020\u0001B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\b\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001c\u0010+\u001a\u00020,2\u0012\u0010-\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020,0.H\u0016J\u0012\u0010/\u001a\u00020\u000b2\b\u00100\u001a\u0004\u0018\u00010\u0001H\u0016J\u0010\u00101\u001a\u00020\u000b2\u0006\u00100\u001a\u00020\u0000H\u0002J\u0016\u00102\u001a\b\u0012\u0004\u0012\u00020\r032\u0006\u00104\u001a\u00020\rH\u0016J2\u00105\u001a\u00020,*\b\u0012\u0004\u0012\u00020\r062\u0006\u00104\u001a\u00020\r2\u0006\u00107\u001a\u00020\u00062\u0006\u00108\u001a\u00020\b2\u0006\u00109\u001a\u00020\bH\u0002J\b\u0010:\u001a\u00020;H\u0016J\u0018\u0010<\u001a\u00020\b2\u0006\u0010=\u001a\u00020\b2\u0006\u0010>\u001a\u00020\u000bH\u0002J\u0018\u0010?\u001a\u00020\b2\u0006\u0010=\u001a\u00020\b2\u0006\u0010@\u001a\u00020\u000bH\u0002J\u0010\u0010A\u001a\u00020\b2\u0006\u0010B\u001a\u00020CH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\t\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0015R\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0017R\u0016\u0010\f\u001a\u0004\u0018\u00010\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0015R\u0014\u0010\u001c\u001a\u00020\u001d8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u0014\u0010 \u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u0014\u0010#\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010\"R\u0014\u0010%\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010\"R\u0014\u0010'\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010\"R\u0014\u0010)\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010\"\u00a8\u0006D"}, d2={"Landroidx/compose/foundation/text/selection/MultiSelectionLayout;", "Landroidx/compose/foundation/text/selection/SelectionLayout;", "selectableIdToInfoListIndex", "Landroidx/collection/LongIntMap;", "infoList", "", "Landroidx/compose/foundation/text/selection/SelectableInfo;", "startSlot", "", "endSlot", "isStartHandle", "", "previousSelection", "Landroidx/compose/foundation/text/selection/Selection;", "<init>", "(Landroidx/collection/LongIntMap;Ljava/util/List;IIZLandroidx/compose/foundation/text/selection/Selection;)V", "getSelectableIdToInfoListIndex", "()Landroidx/collection/LongIntMap;", "getInfoList", "()Ljava/util/List;", "getStartSlot", "()I", "getEndSlot", "()Z", "getPreviousSelection", "()Landroidx/compose/foundation/text/selection/Selection;", "size", "getSize", "crossStatus", "Landroidx/compose/foundation/text/selection/CrossStatus;", "getCrossStatus", "()Landroidx/compose/foundation/text/selection/CrossStatus;", "startInfo", "getStartInfo", "()Landroidx/compose/foundation/text/selection/SelectableInfo;", "endInfo", "getEndInfo", "currentInfo", "getCurrentInfo", "firstInfo", "getFirstInfo", "lastInfo", "getLastInfo", "forEachMiddleInfo", "", "block", "Lkotlin/Function1;", "shouldRecomputeSelection", "other", "shouldAnyInfoRecomputeSelection", "createSubSelections", "Landroidx/collection/LongObjectMap;", "selection", "createAndPutSubSelection", "Landroidx/collection/MutableLongObjectMap;", "info", "minOffset", "maxOffset", "toString", "", "startOrEndSlotToIndex", "slot", "isStartSlot", "slotToIndex", "isMinimumSlot", "getInfoListIndexBySelectableId", "id", "", "foundation"})
@SourceDebugExtension(value={"SMAP\nSelectionLayout.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SelectionLayout.kt\nandroidx/compose/foundation/text/selection/MultiSelectionLayout\n+ 2 InlineClassHelper.kt\nandroidx/compose/foundation/internal/InlineClassHelperKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 ListUtils.kt\nandroidx/compose/ui/util/ListUtilsKt\n*L\n1#1,739:1\n51#2,4:740\n51#2,4:744\n51#2,4:749\n1#3:748\n71#4,5:753\n*S KotlinDebug\n*F\n+ 1 SelectionLayout.kt\nandroidx/compose/foundation/text/selection/MultiSelectionLayout\n*L\n147#1:740,4\n224#1:744,4\n264#1:749,4\n281#1:753,5\n*E\n"})
final class MultiSelectionLayout
implements SelectionLayout {
    @NotNull
    private final LongIntMap selectableIdToInfoListIndex;
    @NotNull
    private final List<SelectableInfo> infoList;
    private final int startSlot;
    private final int endSlot;
    private final boolean isStartHandle;
    @Nullable
    private final Selection previousSelection;

    public MultiSelectionLayout(@NotNull LongIntMap selectableIdToInfoListIndex, @NotNull List<SelectableInfo> infoList, int startSlot, int endSlot, boolean isStartHandle, @Nullable Selection previousSelection) {
        Intrinsics.checkNotNullParameter((Object)selectableIdToInfoListIndex, (String)"selectableIdToInfoListIndex");
        Intrinsics.checkNotNullParameter(infoList, (String)"infoList");
        this.selectableIdToInfoListIndex = selectableIdToInfoListIndex;
        this.infoList = infoList;
        this.startSlot = startSlot;
        this.endSlot = endSlot;
        this.isStartHandle = isStartHandle;
        this.previousSelection = previousSelection;
        boolean value$iv = this.infoList.size() > 1;
        boolean $i$f$checkPrecondition = false;
        if (!value$iv) {
            boolean bl = false;
            InlineClassHelperKt.throwIllegalStateException("MultiSelectionLayout requires an infoList size greater than 1, was " + this.infoList.size() + ".");
        }
    }

    @NotNull
    public final LongIntMap getSelectableIdToInfoListIndex() {
        return this.selectableIdToInfoListIndex;
    }

    @NotNull
    public final List<SelectableInfo> getInfoList() {
        return this.infoList;
    }

    @Override
    public int getStartSlot() {
        return this.startSlot;
    }

    @Override
    public int getEndSlot() {
        return this.endSlot;
    }

    @Override
    public boolean isStartHandle() {
        return this.isStartHandle;
    }

    @Override
    @Nullable
    public Selection getPreviousSelection() {
        return this.previousSelection;
    }

    @Override
    public int getSize() {
        return this.infoList.size();
    }

    @Override
    @NotNull
    public CrossStatus getCrossStatus() {
        return this.getStartSlot() < this.getEndSlot() ? CrossStatus.NOT_CROSSED : (this.getStartSlot() > this.getEndSlot() ? CrossStatus.CROSSED : this.infoList.get(this.getStartSlot() / 2).getRawCrossStatus());
    }

    @Override
    @NotNull
    public SelectableInfo getStartInfo() {
        return this.infoList.get(this.startOrEndSlotToIndex(this.getStartSlot(), true));
    }

    @Override
    @NotNull
    public SelectableInfo getEndInfo() {
        return this.infoList.get(this.startOrEndSlotToIndex(this.getEndSlot(), false));
    }

    @Override
    @NotNull
    public SelectableInfo getCurrentInfo() {
        return this.isStartHandle() ? this.getStartInfo() : this.getEndInfo();
    }

    @Override
    @NotNull
    public SelectableInfo getFirstInfo() {
        return this.getCrossStatus() == CrossStatus.CROSSED ? this.getEndInfo() : this.getStartInfo();
    }

    @Override
    @NotNull
    public SelectableInfo getLastInfo() {
        return this.getCrossStatus() == CrossStatus.CROSSED ? this.getStartInfo() : this.getEndInfo();
    }

    @Override
    public void forEachMiddleInfo(@NotNull Function1<? super SelectableInfo, Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        int minIndex = this.getInfoListIndexBySelectableId(this.getFirstInfo().getSelectableId());
        int maxIndex = this.getInfoListIndexBySelectableId(this.getLastInfo().getSelectableId());
        if (minIndex + 1 >= maxIndex) {
            return;
        }
        for (int i = minIndex + 1; i < maxIndex; ++i) {
            block.invoke((Object)this.infoList.get(i));
        }
    }

    @Override
    public boolean shouldRecomputeSelection(@Nullable SelectionLayout other) {
        return this.getPreviousSelection() == null || other == null || !(other instanceof MultiSelectionLayout) || this.isStartHandle() != ((MultiSelectionLayout)other).isStartHandle() || this.getStartSlot() != ((MultiSelectionLayout)other).getStartSlot() || this.getEndSlot() != ((MultiSelectionLayout)other).getEndSlot() || this.shouldAnyInfoRecomputeSelection((MultiSelectionLayout)other);
    }

    private final boolean shouldAnyInfoRecomputeSelection(MultiSelectionLayout other) {
        if (this.getSize() != other.getSize()) {
            return true;
        }
        int n = ((Collection)this.infoList).size();
        for (int i = 0; i < n; ++i) {
            SelectableInfo otherInfo;
            SelectableInfo thisInfo = this.infoList.get(i);
            if (!thisInfo.shouldRecomputeSelection(otherInfo = other.infoList.get(i))) continue;
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public LongObjectMap<Selection> createSubSelections(@NotNull Selection selection) {
        LongObjectMap longObjectMap;
        Intrinsics.checkNotNullParameter((Object)selection, (String)"selection");
        if (selection.getStart().getSelectableId() == selection.getEnd().getSelectableId()) {
            boolean value$iv = selection.getHandlesCrossed() && selection.getStart().getOffset() >= selection.getEnd().getOffset() || !selection.getHandlesCrossed() && selection.getStart().getOffset() <= selection.getEnd().getOffset();
            boolean $i$f$checkPrecondition = false;
            if (!value$iv) {
                boolean bl = false;
                InlineClassHelperKt.throwIllegalStateException("unexpectedly miss-crossed selection: " + selection);
            }
            longObjectMap = LongObjectMapKt.longObjectMapOf(selection.getStart().getSelectableId(), selection);
        } else {
            MutableLongObjectMap<Selection> mutableLongObjectMap;
            MutableLongObjectMap<Selection> $this$createSubSelections_u24lambda_u245 = mutableLongObjectMap = LongObjectMapKt.mutableLongObjectMapOf();
            boolean bl = false;
            Selection $this$createSubSelections_u24lambda_u245_u24lambda_u242 = selection;
            boolean bl2 = false;
            Selection.AnchorInfo minAnchor = $this$createSubSelections_u24lambda_u245_u24lambda_u242.getHandlesCrossed() ? $this$createSubSelections_u24lambda_u245_u24lambda_u242.getEnd() : $this$createSubSelections_u24lambda_u245_u24lambda_u242.getStart();
            this.createAndPutSubSelection($this$createSubSelections_u24lambda_u245, selection, this.getFirstInfo(), minAnchor.getOffset(), this.getFirstInfo().getTextLength());
            this.forEachMiddleInfo((Function1<? super SelectableInfo, Unit>)((Function1)arg_0 -> MultiSelectionLayout.createSubSelections$lambda$5$lambda$3(this, $this$createSubSelections_u24lambda_u245, selection, arg_0)));
            Selection $this$createSubSelections_u24lambda_u245_u24lambda_u244 = selection;
            boolean bl3 = false;
            Selection.AnchorInfo maxAnchor = $this$createSubSelections_u24lambda_u245_u24lambda_u244.getHandlesCrossed() ? $this$createSubSelections_u24lambda_u245_u24lambda_u244.getStart() : $this$createSubSelections_u24lambda_u245_u24lambda_u244.getEnd();
            this.createAndPutSubSelection($this$createSubSelections_u24lambda_u245, selection, this.getLastInfo(), 0, maxAnchor.getOffset());
            longObjectMap = mutableLongObjectMap;
        }
        return longObjectMap;
    }

    private final void createAndPutSubSelection(MutableLongObjectMap<Selection> $this$createAndPutSubSelection, Selection selection, SelectableInfo info, int minOffset, int maxOffset) {
        Selection subSelection = selection.getHandlesCrossed() ? info.makeSingleLayoutSelection(maxOffset, minOffset) : info.makeSingleLayoutSelection(minOffset, maxOffset);
        boolean value$iv = minOffset <= maxOffset;
        boolean $i$f$checkPrecondition = false;
        if (!value$iv) {
            boolean bl = false;
            InlineClassHelperKt.throwIllegalStateException("minOffset should be less than or equal to maxOffset: " + subSelection);
        }
        $this$createAndPutSubSelection.put(info.getSelectableId(), subSelection);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public String toString() {
        void $this$fastForEachIndexed$iv;
        void $this$toString_u24lambda_u248;
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder = new StringBuilder();
        CrossStatus crossStatus = this.getCrossStatus();
        float f = (float)(this.getEndSlot() + 1) / (float)2;
        float f2 = (float)(this.getStartSlot() + 1) / (float)2;
        boolean bl = this.isStartHandle();
        boolean bl2 = false;
        $this$toString_u24lambda_u248.append("[\n\t");
        boolean first = false;
        first = true;
        List<SelectableInfo> list = this.infoList;
        boolean $i$f$fastForEachIndexed = false;
        int n = ((Collection)$this$fastForEachIndexed$iv).size();
        for (int index$iv = 0; index$iv < n; ++index$iv) {
            void info;
            Object item$iv = $this$fastForEachIndexed$iv.get(index$iv);
            SelectableInfo selectableInfo = (SelectableInfo)item$iv;
            int index2 = index$iv;
            boolean bl3 = false;
            if (first) {
                first = false;
            } else {
                $this$toString_u24lambda_u248.append(",\n\t");
            }
            $this$toString_u24lambda_u248.append(index2 + 1 + " -> " + (SelectableInfo)info);
        }
        $this$toString_u24lambda_u248.append("\n]");
        Unit unit = Unit.INSTANCE;
        return "MultiSelectionLayout(isStartHandle=" + bl + ", startPosition=" + f2 + ", endPosition=" + f + ", crossed=" + crossStatus + ", infos=" + stringBuilder.toString() + ")";
    }

    private final int startOrEndSlotToIndex(int slot, boolean isStartSlot) {
        boolean bl;
        switch (WhenMappings.$EnumSwitchMapping$0[this.getCrossStatus().ordinal()]) {
            case 1: {
                bl = true;
                break;
            }
            case 2: {
                bl = isStartSlot;
                break;
            }
            case 3: {
                if (!isStartSlot) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return this.slotToIndex(slot, bl);
    }

    private final int slotToIndex(int slot, boolean isMinimumSlot) {
        int slotAdjustment = isMinimumSlot ? 0 : 1;
        return (slot - slotAdjustment) / 2;
    }

    private final int getInfoListIndexBySelectableId(long id) {
        int n;
        try {
            n = this.selectableIdToInfoListIndex.get(id);
        }
        catch (NoSuchElementException e) {
            throw new IllegalStateException("Invalid selectableId: " + id, e);
        }
        return n;
    }

    private static final Unit createSubSelections$lambda$5$lambda$3(MultiSelectionLayout this$0, MutableLongObjectMap $this_apply, Selection $selection, SelectableInfo info) {
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        this$0.createAndPutSubSelection($this_apply, $selection, info, 0, info.getTextLength());
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[CrossStatus.values().length];
            try {
                nArray[CrossStatus.COLLAPSED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CrossStatus.NOT_CROSSED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CrossStatus.CROSSED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

