/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.django.model.modelApi.templates;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbAware;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.django.codeInsight.DjangoSettingsPy;
import com.jetbrains.django.model.modelApi.templates.DjangoTemplateEngineKey;
import com.jetbrains.django.model.modelApi.templates.PyTemplateEngineSettings;
import com.jetbrains.python.psi.PyDictLiteralExpression;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyKeyValueExpression;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyEvaluator;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public final class DjangoTemplateEngineCompletionContributor
extends CompletionContributor
implements DumbAware {
    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result) {
        PsiElement position;
        if (parameters == null) {
            DjangoTemplateEngineCompletionContributor.$$$reportNull$$$0(0);
        }
        if (result == null) {
            DjangoTemplateEngineCompletionContributor.$$$reportNull$$$0(1);
        }
        if ((position = parameters.getOriginalPosition()) == null) {
            return;
        }
        PyStringLiteralExpression expression = (PyStringLiteralExpression)PyUtil.as((Object)position.getParent(), PyStringLiteralExpression.class);
        if (expression == null) {
            return;
        }
        PyFile file = (PyFile)PyUtil.as((Object)parameters.getOriginalFile(), PyFile.class);
        if (file == null) {
            return;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)position);
        if (module == null) {
            return;
        }
        Optional<PyDictLiteralExpression> optDict = DjangoSettingsPy.getTemplateDicts((Module)module).stream().filter(o -> PsiTreeUtil.isAncestor((PsiElement)o, (PsiElement)expression, (boolean)false)).findFirst();
        if (optDict.isEmpty()) {
            return;
        }
        PyDictLiteralExpression templateDict = optDict.get();
        PsiElement psiElement = expression.getParent();
        if (psiElement instanceof PyKeyValueExpression) {
            PyKeyValueExpression keyValue = (PyKeyValueExpression)psiElement;
            DjangoTemplateEngineCompletionContributor.fillDictKeys(templateDict, keyValue, DjangoTemplateEngineKey.names(), PyTemplateEngineSettings.OPTIONS_KEYS, result);
        }
    }

    private static void fillDictKeys(@NotNull PyDictLiteralExpression templateDict, @NotNull PyKeyValueExpression keyValue, @NotNull Set<String> firstLevelKeywords, @NotNull Set<String> optionLevelKeywords, @NotNull CompletionResultSet completionResultSet) {
        PyDictLiteralExpression dict;
        if (templateDict == null) {
            DjangoTemplateEngineCompletionContributor.$$$reportNull$$$0(2);
        }
        if (keyValue == null) {
            DjangoTemplateEngineCompletionContributor.$$$reportNull$$$0(3);
        }
        if (firstLevelKeywords == null) {
            DjangoTemplateEngineCompletionContributor.$$$reportNull$$$0(4);
        }
        if (optionLevelKeywords == null) {
            DjangoTemplateEngineCompletionContributor.$$$reportNull$$$0(5);
        }
        if (completionResultSet == null) {
            DjangoTemplateEngineCompletionContributor.$$$reportNull$$$0(6);
        }
        if ((dict = (PyDictLiteralExpression)PyUtil.as((Object)keyValue.getParent(), PyDictLiteralExpression.class)) == null) {
            return;
        }
        if (dict.equals((Object)templateDict)) {
            DjangoTemplateEngineCompletionContributor.fillUnused(firstLevelKeywords, completionResultSet, dict.getElements());
            return;
        }
        PyKeyValueExpression options = (PyKeyValueExpression)PyUtil.as((Object)dict.getParent(), PyKeyValueExpression.class);
        if (options == null || !"OPTIONS".equals(PyEvaluator.evaluate((PyExpression)options.getKey(), String.class))) {
            return;
        }
        if (options.getParent().equals((Object)templateDict)) {
            DjangoTemplateEngineCompletionContributor.fillUnused(optionLevelKeywords, completionResultSet, dict.getElements());
        }
    }

    private static void fillUnused(Set<String> allKeywords, CompletionResultSet set, PyKeyValueExpression ... elements) {
        Set usedKeywords = Arrays.stream(elements).map(o -> (String)PyEvaluator.evaluate((PyExpression)o.getKey(), String.class)).collect(Collectors.toSet());
        HashSet<String> resultKeywords = new HashSet<String>(allKeywords);
        resultKeywords.removeAll(usedKeywords);
        set.addAllElements((Iterable)resultKeywords.stream().map(LookupElementBuilder::create).collect(Collectors.toList()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateDict";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyValue";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "firstLevelKeywords";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "optionLevelKeywords";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "completionResultSet";
                break;
            }
        }
        objectArray2[1] = "com/intellij/python/django/model/modelApi/templates/DjangoTemplateEngineCompletionContributor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "fillCompletionVariants";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "fillDictKeys";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

