/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.terminal;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.terminal.ui.TerminalWidget;
import com.jediterm.terminal.TtyConnector;
import com.jetbrains.rd.platform.util.ReenterabilityKt;
import com.jetbrains.rdserver.terminal.BackendTerminalManager;
import com.jetbrains.rdserver.terminal.BackendTtyConnector;
import com.pty4j.PtyProcess;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.terminal.LocalTerminalDirectRunner;
import org.jetbrains.plugins.terminal.LocalTerminalTtyConnector;
import org.jetbrains.plugins.terminal.ShellStartupOptions;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/rdserver/terminal/BackendTerminalRunner;", "Lorg/jetbrains/plugins/terminal/LocalTerminalDirectRunner;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "createShellTerminalWidget", "Lcom/intellij/terminal/ui/TerminalWidget;", "parent", "Lcom/intellij/openapi/Disposable;", "startupOptions", "Lorg/jetbrains/plugins/terminal/ShellStartupOptions;", "createTtyConnector", "Lcom/jediterm/terminal/TtyConnector;", "process", "Lcom/pty4j/PtyProcess;", "intellij.terminal.backend.split"})
public class BackendTerminalRunner
extends LocalTerminalDirectRunner {
    public BackendTerminalRunner(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
    }

    @NotNull
    protected TerminalWidget createShellTerminalWidget(@NotNull Disposable parent, @NotNull ShellStartupOptions startupOptions) {
        TerminalWidget terminalWidget;
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)startupOptions, (String)"startupOptions");
        TerminalWidget terminalWidget2 = super.createShellTerminalWidget(parent, startupOptions);
        Intrinsics.checkNotNullExpressionValue((Object)terminalWidget2, (String)"createShellTerminalWidget(...)");
        TerminalWidget $this$createShellTerminalWidget_u24lambda_u240 = terminalWidget = terminalWidget2;
        boolean bl = false;
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        BackendTerminalManager backendTerminalManager = BackendTerminalManager.Companion.getInstance(project);
        ReenterabilityKt.noReenter((Object)backendTerminalManager.getTerminalCreationInProcess(), () -> BackendTerminalRunner.createShellTerminalWidget$lambda$0$0(this, $this$createShellTerminalWidget_u24lambda_u240));
        return terminalWidget;
    }

    @NotNull
    public TtyConnector createTtyConnector(@NotNull PtyProcess process) {
        Intrinsics.checkNotNullParameter((Object)process, (String)"process");
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return (TtyConnector)new BackendTtyConnector(project, (TtyConnector)new LocalTerminalTtyConnector(process, this.myDefaultCharset, this.getHolder(process)));
    }

    private static final Unit createShellTerminalWidget$lambda$0$0(BackendTerminalRunner this$0, TerminalWidget $this_apply) {
        Project project = this$0.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        BackendTerminalManager.Companion.bindTerminal$default(BackendTerminalManager.Companion, project, $this_apply, null, 4, null);
        return Unit.INSTANCE;
    }
}

