/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.database.actions.util.SettingsUtilsKt;
import com.intellij.database.console.JdbcConsole;
import com.intellij.database.console.session.PerProjectFileAttributes;
import com.intellij.database.dataSource.srcStorage.DbSrcUtilsCore;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.database.util.DbImplUtil;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseToggleNotebookModeAction
extends ToggleAction {
    private static final String NOTEBOOK_SETTING_ID_KEY = "database.notebook.setting.id";
    private static final PerProjectFileAttributes ourFileAttributes = new PerProjectFileAttributes("database.notebook.mode", 1);

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            DatabaseToggleNotebookModeAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            DatabaseToggleNotebookModeAction.$$$reportNull$$$0(1);
        }
        JdbcConsole console = DatabaseToggleNotebookModeAction.getConsole(e);
        e.getPresentation().setEnabledAndVisible(console != null);
        super.update(e);
    }

    public boolean isSelected(@NotNull AnActionEvent e) {
        JdbcConsole console;
        if (e == null) {
            DatabaseToggleNotebookModeAction.$$$reportNull$$$0(2);
        }
        return (console = DatabaseToggleNotebookModeAction.getConsole(e)) != null && console.isNotebookMode();
    }

    public void setSelected(@NotNull AnActionEvent e, boolean state) {
        JdbcConsole console;
        if (e == null) {
            DatabaseToggleNotebookModeAction.$$$reportNull$$$0(3);
        }
        if ((console = DatabaseToggleNotebookModeAction.getConsole(e)) == null) {
            return;
        }
        console.setNotebookMode(state, true);
    }

    public static void setNotebookMode(@NotNull Project project, @NotNull JdbcConsole console, boolean state) {
        if (project == null) {
            DatabaseToggleNotebookModeAction.$$$reportNull$$$0(4);
        }
        if (console == null) {
            DatabaseToggleNotebookModeAction.$$$reportNull$$$0(5);
        }
        DaemonCodeAnalyzer.getInstance((Project)project).restart(console.getFile(), (Object)"DatabaseToggleNotebookModeAction.setNotebookMode");
        SettingsUtilsKt.saveSettingValue(NOTEBOOK_SETTING_ID_KEY, ourFileAttributes, project, console.getVirtualFile(), state);
    }

    public static void setNotebookMode(@NotNull Project project, @NotNull VirtualFile file, boolean state) {
        if (project == null) {
            DatabaseToggleNotebookModeAction.$$$reportNull$$$0(6);
        }
        if (file == null) {
            DatabaseToggleNotebookModeAction.$$$reportNull$$$0(7);
        }
        SettingsUtilsKt.saveSettingValue(NOTEBOOK_SETTING_ID_KEY, ourFileAttributes, project, file, state);
    }

    public static boolean isNotebookMode(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            DatabaseToggleNotebookModeAction.$$$reportNull$$$0(8);
        }
        if (file == null) {
            DatabaseToggleNotebookModeAction.$$$reportNull$$$0(9);
        }
        return SettingsUtilsKt.isSettingEnabled(NOTEBOOK_SETTING_ID_KEY, ourFileAttributes, project, file, DatabaseSettings.getSettings().notebookMode);
    }

    public static boolean isAvailable(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            DatabaseToggleNotebookModeAction.$$$reportNull$$$0(10);
        }
        if (file == null) {
            DatabaseToggleNotebookModeAction.$$$reportNull$$$0(11);
        }
        return !DbSrcUtilsCore.isDbSrcFile((VirtualFile)file) && DbImplUtil.isScriptFile((Project)project, (VirtualFile)file);
    }

    public static void forgetSavedState() {
        PropertiesComponent.getInstance().setValue(NOTEBOOK_SETTING_ID_KEY, null);
    }

    @Nullable
    private static JdbcConsole getConsole(@NotNull AnActionEvent e) {
        JdbcConsole console;
        if (e == null) {
            DatabaseToggleNotebookModeAction.$$$reportNull$$$0(12);
        }
        return (console = JdbcConsole.findConsole(e)) == null ? null : (DatabaseToggleNotebookModeAction.isAvailable(console.getProject(), console.getVirtualFile()) ? console : null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/actions/DatabaseToggleNotebookModeAction";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "console";
                break;
            }
            case 7: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/actions/DatabaseToggleNotebookModeAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isSelected";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setSelected";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setNotebookMode";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isNotebookMode";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getConsole";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12 -> new IllegalArgumentException(string);
        };
    }
}

