/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.console.migration.ConsolesMigrationUtilsKt;
import com.intellij.database.dataSource.DdlMappingsManager;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.datagrid.CoreGrid;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridPomTarget;
import com.intellij.database.datagrid.DataGridUtilCore;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbGridGotoRelatedProvider;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.DbTargetUtil;
import com.intellij.database.util.DbeTierUtil;
import com.intellij.database.view.DatabaseContextFun;
import com.intellij.database.view.DatabaseNodeWrappingService;
import com.intellij.database.view.DbNavigationUtils;
import com.intellij.database.view.structure.DvTreeNodeRank;
import com.intellij.database.view.structure.DvTreeNodeRankFun;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.ImaginaryEditor;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.actions.AlignedIconWithTextAction;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlPsiFacade;
import com.intellij.util.ObjectUtils;
import com.intellij.util.OpenSourceUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.UIUtil;
import java.awt.event.MouseEvent;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OpenEditorAction
extends DumbAwareAction {
    public OpenEditorAction() {
        this.setInjectedContext(true);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            OpenEditorAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            OpenEditorAction.$$$reportNull$$$0(1);
        }
        boolean enabled = (project = e.getProject()) != null && this.isEnabled(e) && this.getNavigatables(project, e, false).filter(Navigatable::canNavigate).isNotEmpty();
        e.getPresentation().setEnabled(enabled);
        e.getPresentation().setVisible(enabled || e.isFromActionToolbar());
    }

    protected boolean isEnabled(@NotNull AnActionEvent e) {
        boolean mouseSelection;
        if (e == null) {
            OpenEditorAction.$$$reportNull$$$0(2);
        }
        if (mouseSelection = this.isMouseSelection(e)) {
            return false;
        }
        Editor editor2 = (Editor)e.getData(CommonDataKeys.EDITOR);
        return editor2 == null || editor2 instanceof ImaginaryEditor;
    }

    protected boolean isMouseSelection(@NotNull AnActionEvent e) {
        if (e == null) {
            OpenEditorAction.$$$reportNull$$$0(3);
        }
        return e.getInputEvent() instanceof MouseEvent && UIUtil.isToggleListSelectionEvent((MouseEvent)((MouseEvent)e.getInputEvent()));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            OpenEditorAction.$$$reportNull$$$0(4);
        }
        if ((project = e.getProject()) == null) {
            return;
        }
        OpenSourceUtil.navigate((boolean)true, (boolean)true, this.getNavigatables(project, e, true));
    }

    @NotNull
    protected abstract JBIterable<? extends Navigatable> getNavigatables(@NotNull Project var1, @NotNull AnActionEvent var2, boolean var3);

    @NotNull
    private static JBIterable<PsiElement> getPsiElements(@NotNull AnActionEvent e) {
        Object[] array;
        if (e == null) {
            OpenEditorAction.$$$reportNull$$$0(5);
        }
        JBIterable jBIterable = (array = (PsiElement[])e.getData(PlatformCoreDataKeys.PSI_ELEMENT_ARRAY)) == null ? JBIterable.of((Object)((PsiElement)e.getData(CommonDataKeys.PSI_ELEMENT))) : JBIterable.of((Object[])array);
        if (jBIterable == null) {
            OpenEditorAction.$$$reportNull$$$0(6);
        }
        return jBIterable;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/actions/OpenEditorAction";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/actions/OpenEditorAction";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getPsiElements";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isEnabled";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isMouseSelection";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getPsiElements";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5 -> new IllegalArgumentException(string);
        };
    }

    static class OpenDDLGridAction
    extends AlignedIconWithTextAction
    implements DumbAware {
        OpenDDLGridAction() {
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                OpenDDLGridAction.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                OpenDDLGridAction.$$$reportNull$$$0(1);
            }
            PsiElement element = (PsiElement)e.getData(CommonDataKeys.PSI_ELEMENT);
            boolean enabled = e.getData(DatabaseDataKeys.DATA_GRID_KEY) != null && DbGridGotoRelatedProvider.getTargetElement(element) != null;
            e.getPresentation().setEnabledAndVisible(enabled);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            DbElement target;
            if (e == null) {
                OpenDDLGridAction.$$$reportNull$$$0(2);
            }
            if ((target = DbGridGotoRelatedProvider.getTargetElement((PsiElement)e.getData(CommonDataKeys.PSI_ELEMENT))) == null) {
                return;
            }
            EditorWindow editorWindow = (EditorWindow)e.getData(EditorWindow.DATA_KEY);
            if (editorWindow != null) {
                FileEditorManagerEx.getInstanceEx((Project)target.getProject()).setCurrentWindow(editorWindow);
            }
            DbNavigationUtils.navigateToSource(target, true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/actions/OpenEditorAction$OpenDDLGridAction";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/actions/OpenEditorAction$OpenDDLGridAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }

    static class OpenFilesAction
    extends OpenEditorAction {
        OpenFilesAction() {
        }

        @NotNull
        protected JBIterable<Navigatable> getNavigatables(@NotNull Project project, @NotNull AnActionEvent e, boolean forInvoke) {
            if (project == null) {
                OpenFilesAction.$$$reportNull$$$0(0);
            }
            if (e == null) {
                OpenFilesAction.$$$reportNull$$$0(1);
            }
            JBIterable jBIterable = OpenEditorAction.getPsiElements(e).filterMap(n -> {
                DbDataSource mapped;
                DbDataSource o = (DbDataSource)ObjectUtils.tryCast((Object)DbNavigationUtils.extractDbElementFromPsi(n), DbDataSource.class);
                LocalDataSource lds = DbImplUtil.getMaybeLocalDataSource((DasDataSource)o);
                DbDataSource dbDataSource = mapped = lds == null ? null : (DbDataSource)DdlMappingsManager.getInstance((Project)project).findByDataSourceId(lds.getUniqueId()).filterMap(m -> DbPsiFacade.getInstance((Project)project).findDataSource(m.getDdlDataSourceId())).first();
                if (mapped == null && lds != null) {
                    return null;
                }
                if (mapped != null) {
                    o = mapped;
                }
                if (o == null) {
                    return null;
                }
                return DbNavigationUtils.createToDataSourceFileNavigatable((DbElement)o);
            });
            if (jBIterable == null) {
                OpenFilesAction.$$$reportNull$$$0(2);
            }
            return jBIterable;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/actions/OpenEditorAction$OpenFilesAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/actions/OpenEditorAction$OpenFilesAction";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNavigatables";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getNavigatables";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    static class OpenDDLAction
    extends OpenEditorAction {
        OpenDDLAction() {
        }

        @NotNull
        protected JBIterable<Navigatable> getNavigatables(@NotNull Project project, @NotNull AnActionEvent e, boolean forInvoke) {
            if (project == null) {
                OpenDDLAction.$$$reportNull$$$0(0);
            }
            if (e == null) {
                OpenDDLAction.$$$reportNull$$$0(1);
            }
            JBIterable jBIterable = OpenEditorAction.getPsiElements(e).filterMap(n -> {
                DbElement o = DbNavigationUtils.extractDbElementFromPsi(n);
                if (o == null) {
                    return null;
                }
                if (DbSqlUtil.isSqlElement((DbElement)o)) {
                    return o;
                }
                if (!DbNavigationUtils.canNavigateToSource(o)) {
                    return null;
                }
                VirtualFile file = DbTargetUtil.getContainingFile((DbElement)o, (boolean)forInvoke);
                if (file == null) {
                    return null;
                }
                if (!forInvoke) {
                    return new OpenFileDescriptor(project, file);
                }
                return DbNavigationUtils.createToSourceNavigatable(o);
            });
            if (jBIterable == null) {
                OpenDDLAction.$$$reportNull$$$0(2);
            }
            return jBIterable;
        }

        public boolean displayTextInToolbar() {
            return true;
        }

        public boolean useSmallerFontForTextInToolbar() {
            return true;
        }

        @Override
        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                OpenDDLAction.$$$reportNull$$$0(3);
            }
            super.update(e);
            if (e.getPlace().equals("DatabaseViewToolbar")) {
                e.getPresentation().setText(DatabaseBundle.message((String)"action.Jdbc.OpenEditor.Grid.DDL.text", (Object[])new Object[0]));
                e.getPresentation().setIcon(null);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/actions/OpenEditorAction$OpenDDLAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/actions/OpenEditorAction$OpenDDLAction";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNavigatables";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getNavigatables";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    static class OpenConsoleAction
    extends OpenEditorAction {
        OpenConsoleAction() {
        }

        @Override
        protected boolean isEnabled(@NotNull AnActionEvent e) {
            if (e == null) {
                OpenConsoleAction.$$$reportNull$$$0(0);
            }
            return !this.isMouseSelection(e);
        }

        @NotNull
        protected JBIterable<Navigatable> getNavigatables(@NotNull Project project, @NotNull AnActionEvent e, boolean forInvoke) {
            if (project == null) {
                OpenConsoleAction.$$$reportNull$$$0(1);
            }
            if (e == null) {
                OpenConsoleAction.$$$reportNull$$$0(2);
            }
            JBIterable jBIterable = OpenEditorAction.getPsiElements(e).filterMap(o -> {
                if (e.getData(CommonDataKeys.EDITOR) != null) {
                    return null;
                }
                DbElement element = DbNavigationUtils.extractDbElementFromPsi(o);
                if (element != null && DbNavigationUtils.canNavigateToDataSourceFile(element)) {
                    return DbNavigationUtils.createToDataSourceFileNavigatable(element);
                }
                return null;
            });
            if (jBIterable == null) {
                OpenConsoleAction.$$$reportNull$$$0(3);
            }
            return jBIterable;
        }

        @Override
        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                OpenConsoleAction.$$$reportNull$$$0(4);
            }
            super.update(e);
            e.getPresentation().setText(ConsolesMigrationUtilsKt.resolveConsolesMigrationDependentString(DatabaseBundle.message((String)"action.Jdbc.OpenEditor.Console.text", (Object[])new Object[0]), DatabaseBundle.message((String)"action.Jdbc.OpenEditor.Console.text.file", (Object[])new Object[0])));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/actions/OpenEditorAction$OpenConsoleAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/actions/OpenEditorAction$OpenConsoleAction";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNavigatables";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "isEnabled";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getNavigatables";
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }

    static class OpenFamilyAction
    extends OpenEditorAction {
        OpenFamilyAction() {
        }

        @Override
        @NotNull
        protected JBIterable<? extends Navigatable> getNavigatables(@NotNull Project project, @NotNull AnActionEvent e, boolean forInvoke) {
            if (project == null) {
                OpenFamilyAction.$$$reportNull$$$0(0);
            }
            if (e == null) {
                OpenFamilyAction.$$$reportNull$$$0(1);
            }
            DataContext context = e.getDataContext();
            JBIterable jBIterable = OpenFamilyAction.collectSelectedFamilyWrappers(context, project).filter(navigatable -> navigatable.canNavigate());
            if (jBIterable == null) {
                OpenFamilyAction.$$$reportNull$$$0(2);
            }
            return jBIterable;
        }

        private static JBIterable<? extends DatabaseNodeWrappingService.NodeWrapper> collectSelectedFamilyWrappers(@NotNull DataContext context, @NotNull Project project) {
            if (context == null) {
                OpenFamilyAction.$$$reportNull$$$0(3);
            }
            if (project == null) {
                OpenFamilyAction.$$$reportNull$$$0(4);
            }
            if (DatabaseContextFun.fromDatabaseTree(context)) {
                return OpenFamilyAction.collectSelectedFamilyWrappersFromTree(context, project);
            }
            return OpenFamilyAction.collectSelectedFamilyWrappersFromDbWrapper(context);
        }

        private static JBIterable<? extends DatabaseNodeWrappingService.NodeWrapper> collectSelectedFamilyWrappersFromTree(@NotNull DataContext context, @NotNull Project project) {
            Set<DvTreeNodeRank> ranks;
            if (context == null) {
                OpenFamilyAction.$$$reportNull$$$0(5);
            }
            if (project == null) {
                OpenFamilyAction.$$$reportNull$$$0(6);
            }
            if (!(ranks = DatabaseContextFun.getSelectedTreeNodeRanks(context)).contains(DvTreeNodeRank.TL_FAMILY)) {
                return JBIterable.empty();
            }
            DatabaseNodeWrappingService wrappingService = (DatabaseNodeWrappingService)project.getService(DatabaseNodeWrappingService.class);
            return DatabaseContextFun.getSelectedNodes(context).filter(node -> DvTreeNodeRankFun.getTreeNodeRank((BasicNode)node) == DvTreeNodeRank.TL_FAMILY).filterMap(node -> wrappingService.wrap((BasicNode)node)).filter(DatabaseNodeWrappingService.NodeWrapper.class);
        }

        private static JBIterable<? extends DatabaseNodeWrappingService.NodeWrapper> collectSelectedFamilyWrappersFromDbWrapper(@NotNull DataContext context) {
            if (context == null) {
                OpenFamilyAction.$$$reportNull$$$0(7);
            }
            return JBIterable.of((Object[])((Navigatable[])context.getData(CommonDataKeys.NAVIGATABLE_ARRAY))).filter(DatabaseNodeWrappingService.NodeWrapper.class).filter(nw -> DvTreeNodeRankFun.getTreeNodeRank((BasicNode)nw.getNode()) == DvTreeNodeRank.TL_FAMILY);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/actions/OpenEditorAction$OpenFamilyAction";
                    break;
                }
                case 3: 
                case 5: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/actions/OpenEditorAction$OpenFamilyAction";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNavigatables";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getNavigatables";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "collectSelectedFamilyWrappers";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "collectSelectedFamilyWrappersFromTree";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "collectSelectedFamilyWrappersFromDbWrapper";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    static class OpenDataAction
    extends OpenEditorAction {
        OpenDataAction() {
        }

        @Override
        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                OpenDataAction.$$$reportNull$$$0(0);
            }
            super.update(e);
            boolean goTo = "EditorPopup".equals(e.getPlace());
            String text = DatabaseBundle.message((String)(goTo ? "action.Jdbc.OpenEditor.Data.GoTo.text" : "action.Jdbc.OpenEditor.Data.text"), (Object[])new Object[0]);
            e.getPresentation().setText(text);
            DbeTierUtil.adjustPaidTier(e);
        }

        @Override
        protected boolean isEnabled(@NotNull AnActionEvent e) {
            if (e == null) {
                OpenDataAction.$$$reportNull$$$0(1);
            }
            return !this.isMouseSelection(e);
        }

        @NotNull
        protected JBIterable<Navigatable> getNavigatables(@NotNull Project project, @NotNull AnActionEvent e, boolean forInvoke) {
            if (project == null) {
                OpenDataAction.$$$reportNull$$$0(2);
            }
            if (e == null) {
                OpenDataAction.$$$reportNull$$$0(3);
            }
            JBIterable jBIterable = OpenEditorAction.getPsiElements(e).filterMap(o -> {
                DasObject table;
                DataGrid grid;
                DbElement element = OpenDataAction.getDbElement(o);
                DataGrid dataGrid = grid = element == null ? null : DataGridPomTarget.unwrapDataGrid((PsiElement)o);
                if (grid != null && (table = DataGridUtilCore.getDatabaseTable((CoreGrid)grid)) != null && DasUtil.isAncestor((DasObject)table, (DasObject)element, (boolean)false)) {
                    return null;
                }
                if (element == null || !DbNavigationUtils.canNavigateToData(element)) {
                    return null;
                }
                return DbNavigationUtils.createToDataNavigatable(element);
            });
            if (jBIterable == null) {
                OpenDataAction.$$$reportNull$$$0(4);
            }
            return jBIterable;
        }

        @Nullable
        private static DbElement getDbElement(PsiElement o) {
            DbElement element = DbNavigationUtils.extractDbElementFromPsi(o);
            if (element != null) {
                return element;
            }
            SqlDefinition def = (SqlDefinition)ObjectUtils.tryCast((Object)o, SqlDefinition.class);
            if (def != null) {
                return (DbElement)SqlPsiFacade.getInstance((Project)def.getProject()).findRelatedDbElements((PsiElement)def, false).first();
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/actions/OpenEditorAction$OpenDataAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/actions/OpenEditorAction$OpenDataAction";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNavigatables";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "isEnabled";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getNavigatables";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4 -> new IllegalStateException(string);
            };
        }
    }
}

